/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNet;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.util.collections.ArrayIterator;
import java.util.Arrays;
import java.util.IdentityHashMap;

public class ImmutableNetLayout
extends ImmutableNet {
    final int[] equivPortsN;
    final int[] equivPortsP;
    final int[] equivPortsA;
    private final IdentityHashMap<NodeProtoId, NodeProtoInfo> nodeProtoInfos = new IdentityHashMap();
    private final IdentityHashMap<PortProtoId, Void> isolatedPorts = new IdentityHashMap();
    final int[] netMap;
    private static final int[] EQUIV_PORTS_1 = new int[]{0};

    public ImmutableNetLayout(CellTree cellTree) {
        super(cellTree);
        NodeProtoInfo npi;
        ImmutableNodeInst n2;
        int nodeIndex;
        int nodeBase = this.numExports;
        for (ImmutableNodeInst n3 : this.cellRevision.nodes) {
            NodeProtoInfo npi2 = this.nodeProtoInfos.get(n3.protoId);
            if (npi2 == null) {
                PrimitiveNode pn;
                npi2 = new NodeProtoInfo(cellTree, n3.protoId);
                this.nodeProtoInfos.put(n3.protoId, npi2);
                if (n3.protoId instanceof PrimitiveNodeId && (pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n3.protoId)).getTechnology() == this.schemTech) {
                    for (PrimitivePort pp : ArrayIterator.i2i(pn.getPrimitivePorts())) {
                        if (!pp.isIsolated()) continue;
                        this.isolatedPorts.put(pp.getId(), null);
                    }
                }
            }
            nodeBase += npi2.numPorts;
        }
        this.netMap = ImmutableNetLayout.initMap(nodeBase);
        this.connectExports();
        this.connectArcs();
        this.equivPortsN = this.computePortsN();
        this.equivPortsP = this.computePortsP();
        this.equivPortsA = this.computePortsA();
        int[] drawnMap = ImmutableNetLayout.initMap(this.numExports + this.numDrawns);
        for (int exportIndex = 0; exportIndex < this.numExports; ++exportIndex) {
            ImmutableNetLayout.connectMap(drawnMap, exportIndex, this.numExports + this.drawns[exportIndex]);
        }
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            n2 = this.nodes.get(nodeIndex);
            npi = this.nodeProtoInfos.get(n2.protoId);
            if (npi.numPorts == 1) continue;
            this.connectInternals(drawnMap, this.numExports, this.ni_pi[nodeIndex], npi.equivPortsN);
        }
        this.checkEquivPorts(this.equivPortsN, drawnMap);
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            n2 = this.nodes.get(nodeIndex);
            npi = this.nodeProtoInfos.get(n2.protoId);
            if (npi.numPorts == 1 || npi.equivPortsP == npi.equivPortsN) continue;
            this.connectInternals(drawnMap, this.numExports, this.ni_pi[nodeIndex], npi.equivPortsP);
        }
        this.checkEquivPorts(this.equivPortsP, drawnMap);
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            n2 = this.nodes.get(nodeIndex);
            npi = this.nodeProtoInfos.get(n2.protoId);
            if (npi.numPorts == 1 || npi.equivPortsA == npi.equivPortsP) continue;
            this.connectInternals(drawnMap, this.numExports, this.ni_pi[nodeIndex], npi.equivPortsA);
        }
        this.checkEquivPorts(this.equivPortsA, drawnMap);
    }

    private void checkEquivPorts(int[] equivPorts, int[] drawnMap) {
        ImmutableNetLayout.closureMap(drawnMap);
        assert (equivPorts.length == this.numExports);
        for (int exportIndex = 0; exportIndex < equivPorts.length; ++exportIndex) {
            assert (equivPorts[exportIndex] == drawnMap[exportIndex]);
        }
    }

    private int[] computePortsN() {
        for (ImmutableNodeInst n2 : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n2.protoId);
            if (npi.numPorts == 1) continue;
            this.connectInternals(n2, npi.equivPortsN);
        }
        return this.equivMap(null);
    }

    private int[] computePortsP() {
        PrimitiveNodeId schemResistor = this.schemTech != null ? this.schemTech.resistorNode.getId() : null;
        boolean changed = false;
        for (ImmutableNodeInst n2 : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n2.protoId);
            if (npi.equivPortsP == npi.equivPortsN || n2.protoId == schemResistor && n2.techBits != 0 || !this.connectInternals(n2, npi.equivPortsP)) continue;
            changed = true;
        }
        return changed ? this.equivMap(this.equivPortsN) : this.equivPortsN;
    }

    private int[] computePortsA() {
        PrimitiveNodeId schemResistor = this.schemTech != null ? this.schemTech.resistorNode.getId() : null;
        boolean changed = false;
        for (ImmutableNodeInst n2 : this.cellRevision.nodes) {
            NodeProtoInfo npi = this.nodeProtoInfos.get(n2.protoId);
            if (npi.equivPortsA == npi.equivPortsP && (n2.protoId != schemResistor || n2.techBits == 0) || !this.connectInternals(n2, npi.equivPortsA)) continue;
            changed = true;
        }
        return changed ? this.equivMap(this.equivPortsP) : this.equivPortsP;
    }

    private boolean connectInternals(ImmutableNodeInst n2, int[] equivPorts) {
        boolean changed = false;
        int nodeBase = this.ni_pi[this.nodeIndexByNodeId(n2.nodeId)];
        for (int i2 = 1; i2 < equivPorts.length; ++i2) {
            int eq = equivPorts[i2];
            if (eq == i2 || !ImmutableNetLayout.connectMap(this.netMap, nodeBase + i2, nodeBase + eq)) continue;
            changed = true;
        }
        return changed;
    }

    public int[] getNetMap(Netlist.ShortResistors shortResistors) {
        int[] map = ImmutableNetLayout.initMap(this.numDrawns);
        for (int nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            ImmutableNodeInst n2 = this.nodes.get(nodeIndex);
            NodeProtoInfo npi = this.nodeProtoInfos.get(n2.protoId);
            if (npi.numPorts == 1) continue;
            this.connectInternals(map, 0, this.ni_pi[nodeIndex], switch (shortResistors) {
                case Netlist.ShortResistors.NO -> npi.equivPortsN;
                case Netlist.ShortResistors.PARASITIC -> npi.equivPortsP;
                case Netlist.ShortResistors.ALL -> npi.equivPortsA;
                default -> throw new AssertionError();
            });
        }
        ImmutableNetLayout.closureMap(map);
        return map;
    }

    private boolean connectInternals(int[] map, int drawnsStart, int nodeBase, int[] equivPorts) {
        boolean changed = false;
        for (int i2 = 1; i2 < equivPorts.length; ++i2) {
            int eq = equivPorts[i2];
            if (eq == i2 || !ImmutableNetLayout.connectMap(map, drawnsStart + this.drawns[nodeBase + i2], drawnsStart + this.drawns[nodeBase + eq])) continue;
            changed = true;
        }
        return changed;
    }

    private void connectExports() {
        for (int exportIndex = 0; exportIndex < this.cellRevision.exports.size(); ++exportIndex) {
            ImmutableExport e2 = this.cellRevision.exports.get(exportIndex);
            ImmutableNetLayout.connectMap(this.netMap, exportIndex, this.mapIndex(e2.originalNodeId, e2.originalPortId));
        }
    }

    private void connectArcs() {
        for (ImmutableArcInst a2 : this.cellRevision.arcs) {
            ArcProto ap = this.techPool.getArcProto(a2.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC || !this.isolatedPorts.isEmpty() && (this.isolatedPorts.containsKey(a2.tailPortId) || this.isolatedPorts.containsKey(a2.headPortId)) || (a2.tailPortId == this.busPinPortId || a2.headPortId == this.busPinPortId) && ap != this.busArc) continue;
            ImmutableNetLayout.connectMap(this.netMap, this.mapIndex(a2.tailNodeId, a2.tailPortId), this.mapIndex(a2.headNodeId, a2.headPortId));
        }
    }

    private int mapIndex(int nodeId, PortProtoId portId) {
        NodeProtoInfo npi = this.nodeProtoInfos.get(portId.parentId);
        return this.ni_pi[this.nodeIndexByNodeId(nodeId)] + npi.portIndexByChron[portId.chronIndex];
    }

    private int[] equivMap(int[] oldMap) {
        ImmutableNetLayout.closureMap(this.netMap);
        if (oldMap != null && oldMap.length == this.numExports) {
            boolean eq = true;
            for (int i2 = 0; i2 < this.numExports; ++i2) {
                if (this.netMap[i2] == oldMap[i2]) continue;
                eq = false;
                break;
            }
            if (eq) {
                return oldMap;
            }
        }
        int[] map = new int[this.numExports];
        System.arraycopy(this.netMap, 0, map, 0, this.numExports);
        return map;
    }

    private static class NodeProtoInfo {
        final int numPorts;
        final int[] equivPortsN;
        final int[] equivPortsP;
        final int[] equivPortsA;
        final int[] portIndexByChron;
        final EquivPorts subNet;

        private NodeProtoInfo(CellTree cellTree, NodeProtoId nodeProtoId) {
            if (nodeProtoId instanceof CellId) {
                CellUsage cu = cellTree.top.cellRevision.d.cellId.getUsageIn((CellId)nodeProtoId);
                CellTree subTree = cellTree.subTrees[cu.indexInParent];
                this.subNet = subTree.getEquivPorts();
                this.numPorts = this.subNet.numExports;
                this.equivPortsN = this.subNet.equivPortsN;
                this.equivPortsP = this.subNet.equivPortsP;
                this.equivPortsA = this.subNet.equivPortsA;
                this.portIndexByChron = subTree.top.cellRevision.exportIndex;
            } else {
                PrimitivePort pp;
                int portIndex;
                this.subNet = null;
                PrimitiveNode pn = cellTree.techPool.getPrimitiveNode((PrimitiveNodeId)nodeProtoId);
                this.numPorts = pn.getNumPorts();
                int maxChronId = -1;
                for (portIndex = 0; portIndex < pn.getNumPorts(); ++portIndex) {
                    pp = pn.getPort(portIndex);
                    maxChronId = Math.max(maxChronId, pp.getId().chronIndex);
                }
                this.portIndexByChron = new int[maxChronId + 1];
                Arrays.fill(this.portIndexByChron, -1);
                portIndex = 0;
                while (portIndex < pn.getNumPorts()) {
                    pp = pn.getPort(portIndex);
                    this.portIndexByChron[pp.getId().chronIndex] = portIndex++;
                }
                if (pn.getNumPorts() == 1) {
                    this.equivPortsA = EQUIV_PORTS_1;
                    this.equivPortsP = EQUIV_PORTS_1;
                    this.equivPortsN = this.equivPortsP;
                } else {
                    this.equivPortsN = ImmutableNet.initMap(pn.getNumPorts());
                    for (int i2 = 0; i2 < pn.getNumPorts(); ++i2) {
                        for (int j2 = i2 + 1; j2 < pn.getNumPorts(); ++j2) {
                            if (pn.getPort(i2).getTopology() != pn.getPort(j2).getTopology()) continue;
                            ImmutableNet.connectMap(this.equivPortsN, i2, j2);
                        }
                    }
                    ImmutableNet.closureMap(this.equivPortsN);
                    PrimitiveNode.Function fun = pn.getFunction();
                    if (fun == PrimitiveNode.Function.RESIST) {
                        assert (this.equivPortsN.length == 2);
                        this.equivPortsA = new int[]{0, 0};
                        this.equivPortsP = this.equivPortsA;
                    } else if (fun.isComplexResistor()) {
                        this.equivPortsP = this.equivPortsN;
                        this.equivPortsA = new int[]{0, 0};
                    } else {
                        this.equivPortsA = this.equivPortsN;
                        this.equivPortsP = this.equivPortsN;
                    }
                }
            }
        }
    }
}

