/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import java.io.PrintStream;

public class ImmutableNet {
    private static boolean DEBUG = false;
    final CellTree cellTree;
    final TechPool techPool;
    final Schematics schemTech;
    final PrimitivePortId busPinPortId;
    final ArcProto busArc;
    final CellBackup cellBackup;
    final CellRevision cellRevision;
    final CellId cellId;
    final ImmutableExport.Iterable exports;
    final ImmutableNodeInst.Iterable nodes;
    final ImmutableArcInst.Iterable arcs;
    final int numExports;
    final int numNodes;
    final int numArcs;
    final int[] ni_pi;
    final int arcsOffset;
    final int[] drawns;
    public final int numDrawns;
    public final int numExportedDrawns;
    public final int numConnectedDrawns;

    public ImmutableNet(CellTree cellTree) {
        ImmutableNodeInst n2;
        int nodeIndex;
        this.cellTree = cellTree;
        this.techPool = cellTree.techPool;
        Generic genericTech = this.techPool.getGeneric();
        Artwork artworkTech = this.techPool.getArtwork();
        this.schemTech = this.techPool.getSchematics();
        PrimitiveNode invisiblePinNode = genericTech != null ? genericTech.invisiblePinNode : null;
        PrimitiveNode simProbeNode = genericTech != null ? genericTech.simProbeNode : null;
        PrimitiveNode pinNode = artworkTech != null ? artworkTech.pinNode : null;
        this.busPinPortId = this.schemTech != null ? this.schemTech.busPinNode.getPort(0).getId() : null;
        this.busArc = this.schemTech != null ? this.schemTech.bus_arc : null;
        this.cellBackup = cellTree.top;
        this.cellRevision = this.cellBackup.cellRevision;
        this.exports = this.cellRevision.exports;
        this.nodes = this.cellRevision.nodes;
        this.arcs = this.cellRevision.arcs;
        this.numExports = this.cellRevision.exports.size();
        this.numNodes = this.cellRevision.nodes.size();
        this.numArcs = this.cellRevision.arcs.size();
        this.cellId = this.cellRevision.d.cellId;
        this.ni_pi = new int[this.numNodes];
        int offset = this.numExports;
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            n2 = this.nodes.get(nodeIndex);
            this.ni_pi[nodeIndex] = offset;
            offset += this.getNumPorts(n2.protoId);
        }
        this.arcsOffset = offset;
        this.drawns = ImmutableNet.initMap(this.arcsOffset + this.numArcs);
        for (int exportIndex = 0; exportIndex < this.cellRevision.exports.size(); ++exportIndex) {
            ImmutableExport e2 = this.cellRevision.exports.get(exportIndex);
            if (this.isIsolated(e2.originalPortId)) continue;
            ImmutableNet.connectMap(this.drawns, exportIndex, this.mapIndex(e2.originalNodeId, e2.originalPortId));
            if (!DEBUG) continue;
            System.err.println("Connect export " + exportIndex + " " + this.mapIndex(e2.originalNodeId, e2.originalPortId));
        }
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a2 = this.cellRevision.arcs.get(arcIndex);
            ArcProto ap = this.techPool.getArcProto(a2.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC) continue;
            if (!(this.isIsolated(a2.tailPortId) || a2.tailPortId == this.busPinPortId && ap != this.busArc)) {
                ImmutableNet.connectMap(this.drawns, this.arcsOffset + arcIndex, this.mapIndex(a2.tailNodeId, a2.tailPortId));
                if (DEBUG) {
                    System.err.println("Connect tail " + (this.arcsOffset + arcIndex) + " " + this.mapIndex(a2.tailNodeId, a2.tailPortId));
                }
            }
            if (this.isIsolated(a2.headPortId) || a2.headPortId == this.busPinPortId && ap != this.busArc) continue;
            ImmutableNet.connectMap(this.drawns, this.arcsOffset + arcIndex, this.mapIndex(a2.headNodeId, a2.headPortId));
            if (!DEBUG) continue;
            System.err.println("Connect head " + (this.arcsOffset + arcIndex) + " " + this.mapIndex(a2.headNodeId, a2.headPortId));
        }
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            PrimitiveNode pn;
            n2 = this.cellRevision.nodes.get(nodeIndex);
            if (!(n2.protoId instanceof PrimitiveNodeId) || (pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId)).getNumPorts() <= 1) continue;
            int mapOffset = this.ni_pi[nodeIndex];
            for (int i2 = 1; i2 < pn.getNumPorts(); ++i2) {
                PrimitivePort ppi = pn.getPort(i2);
                for (int j2 = 0; j2 < i2; ++j2) {
                    PrimitivePort ppj = pn.getPort(j2);
                    if (ppi.getTopology() != ppj.getTopology()) continue;
                    assert (!ppi.isIsolated() && !ppj.isIsolated());
                    ImmutableNet.connectMap(this.drawns, mapOffset + i2, mapOffset + j2);
                    if (!DEBUG) continue;
                    System.err.println("Connect topology " + (mapOffset + i2) + " " + (mapOffset + j2));
                }
            }
        }
        if (DEBUG) {
            this.printDrawns(System.err, "before closure");
        }
        ImmutableNet.closureMap(this.drawns);
        if (DEBUG) {
            this.printDrawns(System.err, "after closure");
        }
        int curDrawn = 0;
        for (int exportIndex = 0; exportIndex < this.cellRevision.exports.size(); ++exportIndex) {
            if (!this.addDrawn(exportIndex, curDrawn)) continue;
            ++curDrawn;
        }
        this.numExportedDrawns = curDrawn;
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a3 = this.cellRevision.arcs.get(arcIndex);
            ArcProto ap = this.techPool.getArcProto(a3.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC) {
                this.nullDrawn(this.arcsOffset + arcIndex);
                continue;
            }
            if (!this.addDrawn(this.arcsOffset + arcIndex, curDrawn)) continue;
            ++curDrawn;
        }
        this.numConnectedDrawns = curDrawn;
        for (int nodeIndex2 = 0; nodeIndex2 < this.numNodes; ++nodeIndex2) {
            int numPortInsts;
            int mapOffset;
            ImmutableNodeInst n3;
            block26: {
                n3 = this.cellRevision.nodes.get(nodeIndex2);
                mapOffset = this.ni_pi[nodeIndex2];
                if (n3.protoId instanceof CellId) {
                    if (!this.isIconOfParent(n3)) {
                        numPortInsts = this.getNumPorts(n3.protoId);
                        for (int portIndex = 0; portIndex < numPortInsts; ++portIndex) {
                            if (!this.addDrawn(mapOffset + portIndex, curDrawn)) continue;
                            ++curDrawn;
                        }
                        continue;
                    }
                } else {
                    PrimitiveNode pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n3.protoId);
                    if ((pn.getFunction() != PrimitiveNode.Function.ART || pn == simProbeNode) && pn != pinNode && pn != invisiblePinNode) {
                        int numPortInsts2 = this.getNumPorts(n3.protoId);
                        for (int portIndex = 0; portIndex < numPortInsts2; ++portIndex) {
                            if (pn.getPort(portIndex).isIsolated()) {
                                this.nullDrawn(mapOffset + portIndex);
                                continue;
                            }
                            if (!this.addDrawn(mapOffset + portIndex, curDrawn)) continue;
                            ++curDrawn;
                        }
                    }
                }
                break block26;
                continue;
            }
            numPortInsts = this.getNumPorts(n3.protoId);
            for (int portIndex = 0; portIndex < numPortInsts; ++portIndex) {
                this.addDrawn(mapOffset + portIndex, -1);
            }
        }
        this.numDrawns = curDrawn;
        for (int i3 = 0; i3 < this.drawns.length; ++i3) {
            int d2 = this.drawns[i3];
            assert (d2 < 0);
            this.drawns[i3] = -2 - d2;
        }
        if (DEBUG) {
            this.printDrawns(System.err, "at the end");
        }
    }

    public void printDrawns(PrintStream out, String msg) {
        out.println("Drawns of " + String.valueOf(this.cellId) + " " + msg);
        for (int exportIndex = 0; exportIndex < this.numExports; ++exportIndex) {
            ImmutableExport e2 = this.exports.get(exportIndex);
            out.println("Export " + String.valueOf(e2.name) + " " + this.getDrawn(e2.exportId) + " " + this.drawns[exportIndex]);
        }
        for (int nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            ImmutableNodeInst n2 = this.nodes.get(nodeIndex);
            int mapOffset = this.ni_pi[nodeIndex];
            int numPortInsts = this.getNumPorts(n2.protoId);
            for (int portIndex = 0; portIndex < numPortInsts; ++portIndex) {
                if (n2.protoId instanceof CellId) {
                    ImmutableExport e3 = this.getSubTree((CellId)((CellId)n2.protoId)).top.cellRevision.exports.get(portIndex);
                    out.println("PortInst " + String.valueOf(n2.name) + " " + String.valueOf(e3.exportId.parentId) + ":" + String.valueOf(e3.name) + " " + this.getDrawn(n2, e3.exportId) + " " + this.drawns[mapOffset + portIndex]);
                    continue;
                }
                PrimitivePort p = this.techPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId).getPort(portIndex);
                out.println("PortInst " + String.valueOf(n2.name) + " " + String.valueOf(n2.protoId) + ":" + p.getName() + " " + this.getDrawn(n2, p.getId()) + " " + this.drawns[mapOffset + portIndex]);
            }
        }
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a2 = this.arcs.get(arcIndex);
            out.println("Arc " + String.valueOf(a2.name) + " " + this.getDrawn(a2) + " " + this.drawns[this.arcsOffset + arcIndex]);
        }
    }

    public int getDrawn(ExportId exportId) {
        assert (exportId.parentId == this.cellId);
        int exportIndex = this.cellRevision.getExportIndexByExportId(exportId);
        assert (this.exports.get((int)exportIndex).exportId == exportId);
        return this.drawns[exportIndex];
    }

    public int getDrawn(ImmutableNodeInst n2, PortProtoId portId) {
        int nodeIndex = this.nodeIndexByNodeId(n2.nodeId);
        assert (this.nodes.get(nodeIndex) == n2);
        return this.drawns[this.mapIndex(n2.nodeId, portId)];
    }

    public int getDrawn(ImmutableArcInst a2) {
        int arcIndex = this.arcIndexByArcId(a2.arcId);
        assert (this.arcs.get(arcIndex) == a2);
        return this.drawns[this.arcsOffset + arcIndex];
    }

    private void nullDrawn(int mapIndex) {
        assert (this.drawns[mapIndex] == mapIndex);
        this.drawns[mapIndex] = -1;
    }

    private boolean addDrawn(int mapIndex, int drawn) {
        if (this.drawns[mapIndex] < 0) {
            return false;
        }
        int baseIndex = this.drawns[mapIndex];
        int baseDrawn = this.drawns[baseIndex];
        if (baseDrawn < 0) {
            this.drawns[mapIndex] = baseDrawn;
            return false;
        }
        this.drawns[mapIndex] = this.drawns[baseIndex] = -2 - drawn;
        return true;
    }

    private int mapIndex(int nodeId, PortProtoId portId) {
        return this.ni_pi[this.nodeIndexByNodeId(nodeId)] + this.getPortIndex(portId);
    }

    int nodeIndexByNodeId(int nodeId) {
        return this.cellRevision.getNodeIndexByNodeId(nodeId);
    }

    int arcIndexByArcId(int arcId) {
        return this.cellRevision.getArcIndexByArcId(arcId);
    }

    int getNumPorts(NodeProtoId nodeProtoId) {
        if (nodeProtoId instanceof CellId) {
            return this.getSubTree((CellId)((CellId)nodeProtoId)).top.cellRevision.exports.size();
        }
        return this.techPool.getPrimitiveNode((PrimitiveNodeId)nodeProtoId).getNumPorts();
    }

    int getPortIndex(PortProtoId portId) {
        if (portId instanceof ExportId) {
            return this.getSubTree((CellId)((CellId)portId.parentId)).top.cellRevision.getExportIndexByExportId((ExportId)portId);
        }
        return this.techPool.getPrimitivePort((PrimitivePortId)portId).getPortIndex();
    }

    boolean isIconOfParent(ImmutableNodeInst n2) {
        if (!(n2.protoId instanceof CellId)) {
            return false;
        }
        CellBackup subCell = this.getSubTree((CellId)((CellId)n2.protoId)).top;
        CellId subCellId = subCell.cellRevision.d.cellId;
        return subCellId.isIcon() && this.cellId.isSchematic() && subCellId.libId == this.cellId.libId && subCell.cellRevision.d.groupName.equals(this.cellRevision.d.groupName);
    }

    private CellTree getSubTree(CellId cellId) {
        CellUsage cu = this.cellTree.top.cellRevision.d.cellId.getUsageIn(cellId);
        return this.cellTree.subTrees[cu.indexInParent];
    }

    private boolean isIsolated(PortProtoId portId) {
        return portId instanceof PrimitivePortId && this.techPool.getPrimitivePort((PrimitivePortId)portId).isIsolated();
    }

    static int[] initMap(int size) {
        int[] map = new int[size];
        for (int i2 = 0; i2 < map.length; ++i2) {
            map[i2] = i2;
        }
        return map;
    }

    static boolean connectMap(int[] map, int a1, int a2) {
        int k2;
        int m1 = a1;
        while (map[m1] != m1) {
            m1 = map[m1];
        }
        int m2 = a2;
        while (map[m2] != m2) {
            m2 = map[m2];
        }
        boolean changed = m1 != m2;
        int m3 = m1 < m2 ? m1 : m2;
        while (true) {
            k2 = map[a1];
            map[a1] = m3;
            if (a1 == k2) break;
            a1 = k2;
        }
        while (true) {
            k2 = map[a2];
            map[a2] = m3;
            if (a2 == k2) break;
            a2 = k2;
        }
        return changed;
    }

    static void closureMap(int[] map) {
        for (int i2 = 0; i2 < map.length; ++i2) {
            map[i2] = map[map[i2]];
        }
    }
}

