/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.memory.ObjSize;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class CellRevisionJ
extends CellRevision {
    private static final int BIN_SORT_THRESHOLD = 32;
    private volatile SoftReference<int[]> connectionsRef = new SoftReference<Object>(null);
    private volatile SoftReference<ImmutableExport[]> exportIndexByOriginalPortRef = new SoftReference<Object>(null);
    private static final Comparator<ImmutableExport> BY_ORIGINAL_PORT = new Comparator<ImmutableExport>(){

        @Override
        public int compare(ImmutableExport e1, ImmutableExport e2) {
            int result = e1.originalNodeId - e2.originalNodeId;
            if (result != 0) {
                return result;
            }
            result = e1.originalPortId.getChronIndex() - e2.originalPortId.getChronIndex();
            if (result != 0) {
                return result;
            }
            return e1.exportId.chronIndex - e2.exportId.chronIndex;
        }
    };

    protected CellRevisionJ(ImmutableCell d2, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        super(d2, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
    }

    protected CellRevisionJ(ImmutableCell d2) {
        this(d2, CellRevision.getProvider().createNodeList(ImmutableNodeInst.NULL_ARRAY, null), CellRevision.getProvider().createArcList(ImmutableArcInst.NULL_ARRAY, null), NULL_INT_ARRAY, CellRevision.getProvider().createExportList(ImmutableExport.NULL_ARRAY, null), NULL_INT_ARRAY, CellRevision.makeTechUsages(d2.techId), NULL_CELL_USAGE_INFO_ARRAY, EMPTY_BITSET, 0, EMPTY_BITSET);
        if (d2.techId == null) {
            throw new NullPointerException("techId");
        }
    }

    @Override
    protected CellRevision lowLevelWith(ImmutableCell d2, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        CellRevisionJ newCellRevision = new CellRevisionJ(d2, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
        if (this.nodes == nodes) {
            if (this.arcs == arcs) {
                assert (this.arcIndex == arcIndex);
                newCellRevision.connectionsRef = this.connectionsRef;
            }
            if (this.exports == exports) {
                assert (this.exportIndex == exportIndex);
                assert (this.definedExports == definedExports && this.definedExportsLength == definedExportsLength && this.deletedExports == deletedExports);
                newCellRevision.exportIndexByOriginalPortRef = this.exportIndexByOriginalPortRef;
            }
        }
        return newCellRevision;
    }

    @Override
    public boolean hasConnectionsOnNode(ImmutableNodeInst n2) {
        int chronIndex;
        if (this.getNodeById(n2.nodeId) != n2) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        int i2 = this.searchConnectionByPort(connections, n2.nodeId, chronIndex = 0);
        if (i2 >= connections.length) {
            return false;
        }
        int con = connections[i2];
        ImmutableArcInst a2 = this.arcs.get(con >>> 1);
        boolean end = (con & 1) != 0;
        int nodeId = end ? a2.headNodeId : a2.tailNodeId;
        return nodeId == n2.nodeId;
    }

    @Override
    public int getNumConnectionsOnNode(ImmutableNodeInst n2) {
        int i2;
        int j2;
        if (this.getNodeById(n2.nodeId) != n2) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        int myNodeId = n2.nodeId;
        for (j2 = i2 = this.searchConnectionByPort(connections, myNodeId, 0); j2 < connections.length; ++j2) {
            int nodeId;
            int con = connections[j2];
            ImmutableArcInst a2 = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n3 = nodeId = end ? a2.headNodeId : a2.tailNodeId;
            if (nodeId != myNodeId) break;
        }
        return j2 - i2;
    }

    @Override
    public List<ImmutableArcInst> getConnectionsOnNode(BitSet headEnds, ImmutableNodeInst n2) {
        int i2;
        if (this.getNodeById(n2.nodeId) != n2) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        List<ImmutableArcInst> result = null;
        if (headEnds != null) {
            headEnds.clear();
        }
        int myNodeId = n2.nodeId;
        int chronIndex = 0;
        for (int j2 = i2 = this.searchConnectionByPort(connections, myNodeId, chronIndex); j2 < connections.length; ++j2) {
            int nodeId;
            int con = connections[j2];
            ImmutableArcInst a2 = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n3 = nodeId = end ? a2.headNodeId : a2.tailNodeId;
            if (nodeId != myNodeId) break;
            if (result == null) {
                result = new ArrayList<ImmutableArcInst>();
            }
            if (headEnds != null && end) {
                headEnds.set(((ArrayList)result).size());
            }
            ((ArrayList)result).add(a2);
        }
        return result != null ? result : Collections.emptyList();
    }

    @Override
    public boolean hasConnectionsOnPort(ImmutableNodeInst n2, PortProtoId portId) {
        int nodeId;
        int chronIndex;
        if (this.getNodeById(n2.nodeId) != n2 || portId.parentId != n2.protoId) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        int i2 = this.searchConnectionByPort(connections, n2.nodeId, chronIndex = portId.chronIndex);
        if (i2 >= connections.length) {
            return false;
        }
        int con = connections[i2];
        ImmutableArcInst a2 = this.arcs.get(con >>> 1);
        boolean end = (con & 1) != 0;
        int n3 = nodeId = end ? a2.headNodeId : a2.tailNodeId;
        if (nodeId != n2.nodeId) {
            return false;
        }
        return portId == null || portId == (end ? a2.headPortId : a2.tailPortId);
    }

    @Override
    public int getNumConnectionsOnPort(ImmutableNodeInst n2, PortProtoId portId) {
        int i2;
        int j2;
        if (this.getNodeById(n2.nodeId) != n2 || portId.parentId != n2.protoId) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        int myNodeId = n2.nodeId;
        int myChronIndex = portId.chronIndex;
        for (j2 = i2 = this.searchConnectionByPort(connections, myNodeId, myChronIndex); j2 < connections.length; ++j2) {
            int chronIndex;
            int nodeId;
            int con = connections[j2];
            ImmutableArcInst a2 = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n3 = nodeId = end ? a2.headNodeId : a2.tailNodeId;
            if (nodeId != myNodeId) break;
            int n4 = chronIndex = end ? a2.headPortId.chronIndex : a2.tailPortId.chronIndex;
            if (chronIndex != myChronIndex) break;
        }
        return j2 - i2;
    }

    @Override
    public List<ImmutableArcInst> getConnectionsOnPort(BitSet headEnds, ImmutableNodeInst n2, PortProtoId portId) {
        int i2;
        if (this.getNodeById(n2.nodeId) != n2 || portId.parentId != n2.protoId) {
            throw new IllegalArgumentException();
        }
        int[] connections = this.getConnections();
        List<ImmutableArcInst> result = null;
        if (headEnds != null) {
            headEnds.clear();
        }
        int myNodeId = n2.nodeId;
        assert (portId.parentId == n2.protoId);
        int chronIndex = portId.chronIndex;
        for (int j2 = i2 = this.searchConnectionByPort(connections, myNodeId, chronIndex); j2 < connections.length; ++j2) {
            PortProtoId endProtoId;
            int nodeId;
            int con = connections[j2];
            ImmutableArcInst a2 = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int n3 = nodeId = end ? a2.headNodeId : a2.tailNodeId;
            if (nodeId != myNodeId) break;
            PortProtoId portProtoId = endProtoId = end ? a2.headPortId : a2.tailPortId;
            if (endProtoId.getChronIndex() != chronIndex) break;
            if (result == null) {
                result = new ArrayList<ImmutableArcInst>();
            }
            if (headEnds != null && end) {
                headEnds.set(((ArrayList)result).size());
            }
            ((ArrayList)result).add(a2);
        }
        return result != null ? result : Collections.emptyList();
    }

    private int searchConnectionByPort(int[] connections, int nodeId, int chronIndex) {
        int low = 0;
        int high = connections.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int con = connections[mid];
            ImmutableArcInst a2 = this.arcs.get(con >>> 1);
            boolean end = (con & 1) != 0;
            int endNodeId = end ? a2.headNodeId : a2.tailNodeId;
            int cmp = endNodeId - nodeId;
            if (cmp == 0) {
                PortProtoId portId = end ? a2.headPortId : a2.tailPortId;
                cmp = portId.getChronIndex() - chronIndex;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    private int[] getConnections() {
        int[] connections = this.connectionsRef.get();
        return connections != null ? connections : this.makeConnections();
    }

    private int[] makeConnections() {
        int nodeId;
        int[] connections = new int[this.arcs.size() * 2];
        int[] connectionsByNodeId = new int[this.getMaxNodeId() + 1];
        for (ImmutableArcInst a2 : this.arcs) {
            int n2 = a2.headNodeId;
            connectionsByNodeId[n2] = connectionsByNodeId[n2] + 1;
            int n3 = a2.tailNodeId;
            connectionsByNodeId[n3] = connectionsByNodeId[n3] + 1;
        }
        int sum = 0;
        for (nodeId = 0; nodeId < connectionsByNodeId.length; ++nodeId) {
            int start = sum;
            sum += connectionsByNodeId[nodeId];
            connectionsByNodeId[nodeId] = start;
        }
        for (int i2 = 0; i2 < this.arcs.size(); ++i2) {
            ImmutableArcInst a3 = this.arcs.get(i2);
            int n4 = a3.tailNodeId;
            int n5 = connectionsByNodeId[n4];
            connectionsByNodeId[n4] = n5 + 1;
            connections[n5] = i2 * 2;
            int n6 = a3.headNodeId;
            int n7 = connectionsByNodeId[n6];
            connectionsByNodeId[n6] = n7 + 1;
            connections[n7] = i2 * 2 + 1;
        }
        sum = 0;
        for (nodeId = 0; nodeId < connectionsByNodeId.length; ++nodeId) {
            sum = connectionsByNodeId[nodeId];
            int start = sum;
            if (sum - 1 <= start) continue;
            this.sortConnections(connections, start, sum - 1);
        }
        this.connectionsRef = new SoftReference<int[]>(connections);
        return connections;
    }

    private void sortConnections(int[] connections, int l2, int r) {
        while (r - l2 > 32) {
            int x = connections[l2 + r >>> 1];
            ImmutableArcInst ax = this.arcs.get(x >>> 1);
            boolean endx = (x & 1) != 0;
            PortProtoId portIdX = endx ? ax.headPortId : ax.tailPortId;
            int chronIndexX = portIdX.getChronIndex();
            int i2 = l2;
            int j2 = r;
            while (true) {
                PortProtoId portId;
                int con = connections[i2];
                ImmutableArcInst a2 = this.arcs.get(con >>> 1);
                boolean end = (con & 1) != 0;
                PortProtoId portProtoId = portId = end ? a2.headPortId : a2.tailPortId;
                if (portId.getChronIndex() <= chronIndexX && (portId.getChronIndex() != chronIndexX || con < x)) {
                    ++i2;
                    continue;
                }
                while (true) {
                    con = connections[j2];
                    a2 = this.arcs.get(con >>> 1);
                    end = (con & 1) != 0;
                    PortProtoId portProtoId2 = portId = end ? a2.headPortId : a2.tailPortId;
                    if (chronIndexX > portId.getChronIndex() || chronIndexX == portId.getChronIndex() && x >= con) break;
                    --j2;
                }
                if (i2 <= j2) {
                    int w = connections[i2];
                    connections[i2] = connections[j2];
                    connections[j2] = w;
                    ++i2;
                    --j2;
                }
                if (i2 > j2) break;
            }
            if (j2 - l2 < r - i2) {
                this.sortConnections(connections, l2, j2);
                l2 = i2;
                continue;
            }
            this.sortConnections(connections, i2, r);
            r = j2;
        }
        this.binarySort(connections, l2, r + 1);
    }

    private void binarySort(int[] connections, int lo, int hi) {
        PortProtoId portIdS;
        ImmutableArcInst aS;
        int conS;
        assert (lo <= hi);
        int start = lo + 1;
        if (start >= hi) {
            return;
        }
        int conL = connections[lo];
        ImmutableArcInst aL = this.arcs.get(conL >>> 1);
        PortProtoId portIdL = (conL & 1) != 0 ? aL.headPortId : aL.tailPortId;
        while (true) {
            conS = connections[start];
            aS = this.arcs.get(conS >>> 1);
            portIdS = (conS & 1) != 0 ? aS.headPortId : aS.tailPortId;
            int cmp = portIdS.chronIndex - portIdL.chronIndex;
            if (cmp < 0 || cmp == 0 && conS < conL) break;
            if (++start >= hi) {
                return;
            }
            conL = conS;
            aL = aS;
            portIdL = portIdS;
        }
        while (true) {
            assert (start < hi);
            int left = lo;
            int right = start;
            assert (left <= right);
            while (left < right) {
                int mid = left + right >>> 1;
                int conM = connections[mid];
                ImmutableArcInst aM = this.arcs.get(conM >>> 1);
                PortProtoId portIdM = (conM & 1) != 0 ? aM.headPortId : aM.tailPortId;
                int cmp = portIdS.chronIndex - portIdM.chronIndex;
                if (cmp == 0) {
                    cmp = conS - conM;
                }
                if (cmp < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            assert (left == right);
            int n2 = start - left;
            switch (n2) {
                case 2: {
                    connections[left + 2] = connections[left + 1];
                }
                case 1: {
                    connections[left + 1] = connections[left];
                    break;
                }
                default: {
                    System.arraycopy(connections, left, connections, left + 1, n2);
                }
            }
            connections[left] = conS;
            if (++start >= hi) {
                return;
            }
            conS = connections[start];
            aS = this.arcs.get(conS >>> 1);
            portIdS = (conS & 1) != 0 ? aS.headPortId : aS.tailPortId;
        }
    }

    private int compareConnections(int con1, int con2) {
        boolean end2;
        int nodeId2;
        ImmutableArcInst a1 = this.arcs.get(con1 >>> 1);
        ImmutableArcInst a2 = this.arcs.get(con2 >>> 1);
        boolean end1 = (con1 & 1) != 0;
        int nodeId1 = end1 ? a1.headNodeId : a1.tailNodeId;
        int cmp = nodeId1 - (nodeId2 = (end2 = (con2 & 1) != 0) ? a2.headNodeId : a2.tailNodeId);
        if (cmp != 0) {
            return cmp;
        }
        PortProtoId portId1 = end1 ? a1.headPortId : a1.tailPortId;
        PortProtoId portId2 = end2 ? a2.headPortId : a2.tailPortId;
        cmp = portId1.getChronIndex() - portId2.getChronIndex();
        if (cmp != 0) {
            return cmp;
        }
        return con1 - con2;
    }

    @Override
    public boolean hasExportsOnNode(ImmutableNodeInst originalNode) {
        if (this.getNodeById(originalNode.nodeId) != originalNode) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        int startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNode.nodeId, 0);
        if (startIndex >= exportIndexByOriginalPort.length) {
            return false;
        }
        ImmutableExport e2 = exportIndexByOriginalPort[startIndex];
        return e2.originalNodeId == originalNode.nodeId;
    }

    @Override
    public int getNumExportsOnNode(ImmutableNodeInst originalNode) {
        int startIndex;
        int j2;
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        for (j2 = startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, 0); j2 < exportIndexByOriginalPort.length; ++j2) {
            ImmutableExport e2 = exportIndexByOriginalPort[j2];
            if (e2.originalNodeId != originalNodeId) break;
        }
        return j2 - startIndex;
    }

    @Override
    public Iterator<ImmutableExport> getExportsOnNode(ImmutableNodeInst originalNode) {
        int startIndex;
        int j2;
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        for (j2 = startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, 0); j2 < exportIndexByOriginalPort.length; ++j2) {
            ImmutableExport e2 = exportIndexByOriginalPort[j2];
            if (e2.originalNodeId != originalNodeId) break;
        }
        return ArrayIterator.iterator(exportIndexByOriginalPort, startIndex, j2);
    }

    @Override
    public boolean hasExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode || portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        int startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, portId.chronIndex);
        if (startIndex >= exportIndexByOriginalPort.length) {
            return false;
        }
        ImmutableExport e2 = exportIndexByOriginalPort[startIndex];
        return e2.originalNodeId == originalNodeId && e2.originalPortId == portId;
    }

    @Override
    public int getNumExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        int startIndex;
        int j2;
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode || portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        for (j2 = startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, portId.chronIndex); j2 < exportIndexByOriginalPort.length; ++j2) {
            ImmutableExport e2 = exportIndexByOriginalPort[j2];
            if (e2.originalNodeId != originalNodeId || e2.originalPortId != portId) break;
        }
        return j2 - startIndex;
    }

    @Override
    public Iterator<ImmutableExport> getExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        int startIndex;
        int j2;
        int originalNodeId = originalNode.nodeId;
        if (this.getNodeById(originalNodeId) != originalNode || portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        ImmutableExport[] exportIndexByOriginalPort = this.getExportIndexByOriginalPort();
        for (j2 = startIndex = CellRevisionJ.searchExportByOriginalPort(exportIndexByOriginalPort, originalNodeId, portId.chronIndex); j2 < exportIndexByOriginalPort.length; ++j2) {
            ImmutableExport e2 = exportIndexByOriginalPort[j2];
            if (e2.originalNodeId != originalNodeId || e2.originalPortId != portId) break;
        }
        return ArrayIterator.iterator(exportIndexByOriginalPort, startIndex, j2);
    }

    private static int searchExportByOriginalPort(ImmutableExport[] exportIndexByOriginalPort, int originalNodeId, int originalChronIndex) {
        int low = 0;
        int high = exportIndexByOriginalPort.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            ImmutableExport e2 = exportIndexByOriginalPort[mid];
            int cmp = e2.originalNodeId - originalNodeId;
            if (cmp == 0) {
                int n2 = cmp = e2.originalPortId.getChronIndex() >= originalChronIndex ? 1 : -1;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    private ImmutableExport[] getExportIndexByOriginalPort() {
        ImmutableExport[] exportIndexByOriginalPort = this.exportIndexByOriginalPortRef.get();
        return exportIndexByOriginalPort != null ? exportIndexByOriginalPort : this.makeExportIndexByOriginalPort();
    }

    private ImmutableExport[] makeExportIndexByOriginalPort() {
        ImmutableExport[] exportIndexByOriginalPort = this.exports.toArray();
        Arrays.sort(exportIndexByOriginalPort, BY_ORIGINAL_PORT);
        this.exportIndexByOriginalPortRef = new SoftReference<ImmutableExport[]>(exportIndexByOriginalPort);
        return exportIndexByOriginalPort;
    }

    @Override
    public long getConnectivityMemorySize(ObjSize objSize, boolean restore) {
        ImmutableExport[] exportIndexByOriginalPort;
        int[] connections;
        long s = 0L;
        int[] nArray = connections = restore ? this.getConnections() : this.connectionsRef.get();
        if (connections != null) {
            s += objSize.sizeOf(connections);
        }
        ImmutableExport[] immutableExportArray = exportIndexByOriginalPort = restore ? this.getExportIndexByOriginalPort() : this.exportIndexByOriginalPortRef.get();
        if (exportIndexByOriginalPort != null) {
            s += objSize.sizeOf(exportIndexByOriginalPort);
        }
        return s;
    }

    @Override
    public void check() {
        ImmutableExport[] exportIndexByOriginalPort;
        super.check();
        int[] connections = this.connectionsRef.get();
        if (connections != null) {
            assert (connections.length == this.arcs.size() * 2);
            for (int i2 = 1; i2 < connections.length; ++i2) {
                assert (this.compareConnections(connections[i2 - 1], connections[i2]) < 0);
            }
        }
        if ((exportIndexByOriginalPort = this.exportIndexByOriginalPortRef.get()) != null) {
            assert (exportIndexByOriginalPort.length == this.exports.size());
            ImmutableExport prevE = null;
            for (ImmutableExport e2 : exportIndexByOriginalPort) {
                if (prevE != null) assert (BY_ORIGINAL_PORT.compare(prevE, e2) < 0);
                assert (e2 == this.getExport(e2.exportId));
                prevE = e2;
            }
        }
        if (connections != null && exportIndexByOriginalPort != null) {
            this.checkConnectivity();
        }
    }
}

