/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.Link;
import com.sun.electric.database.MyClass;
import com.sun.electric.database.MyField;
import com.sun.electric.database.MyObject;
import com.sun.electric.database.MyString;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class AnalyzeHeap {
    private static final boolean REFERENCES = true;
    ArrayList<MyObject> objs = new ArrayList();

    private AnalyzeHeap() {
    }

    public static void analyze(String fileName) {
        AnalyzeHeap dumpHeap = new AnalyzeHeap();
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            dumpHeap.read(in);
            in.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        System.out.println(dumpHeap.objs.size() - 1 + " objects");
        dumpHeap.garbageCollect();
        dumpHeap.dump("heapdump.txt");
        dumpHeap.makePaths();
        dumpHeap.dump("heapdump2.txt");
    }

    private void read(DataInputStream in) throws IOException {
        int classH;
        int length;
        int h2;
        int numObjs = in.readInt();
        this.objs.clear();
        while (this.objs.size() <= numObjs) {
            this.objs.add(null);
        }
        ArrayList<String> staticFields = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        while ((h2 = in.readInt()) != 0) {
            String className = in.readUTF();
            byte mode = in.readByte();
            int staticLength = in.readInt();
            staticFields.clear();
            fields.clear();
            for (int i2 = 0; i2 < staticLength; ++i2) {
                staticFields.add(in.readUTF());
            }
            length = in.readInt();
            for (int i3 = 0; i3 < length; ++i3) {
                fields.add(in.readUTF());
            }
            MyClass cls = new MyClass(className, mode, staticFields, fields);
            this.objs.set(h2, cls);
        }
        while ((h2 = in.readInt()) != 0) {
            MyString s = new MyString(in.readUTF());
            this.objs.set(h2, s);
        }
        for (h2 = 1; h2 < this.objs.size(); ++h2) {
            MyObject obj = this.objs.get(h2);
            if (obj != null) continue;
            this.objs.set(h2, new MyObject());
        }
        h2 = 1;
        while ((classH = in.readInt()) != 0) {
            MyObject obj = this.objs.get(h2);
            MyClass cls = (MyClass)this.objs.get(classH);
            obj.id = h2;
            obj.setClass(cls);
            switch (cls.mode) {
                case 2: {
                    length = in.readInt();
                    for (int i4 = 0; i4 < length; ++i4) {
                        int elem = in.readInt();
                        new Link(obj, MyField.getElem(i4), this.objs.get(elem));
                    }
                    break;
                }
                case 3: {
                    int i5;
                    int mapLength = in.readInt();
                    for (i5 = 0; i5 < mapLength; ++i5) {
                        int key = in.readInt();
                        new Link(obj, MyField.getKey(i5), this.objs.get(key));
                        int value = in.readInt();
                        new Link(obj, MyField.getElem(i5), this.objs.get(value));
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    int value;
                    int i5;
                    obj.pathLink = new Link(null, ((MyClass)obj).classField, obj);
                    for (i5 = 0; i5 < cls.fields.length; ++i5) {
                        value = in.readInt();
                        new Link(obj, cls.fields[i5], this.objs.get(value));
                    }
                    cls = (MyClass)this.objs.get(h2);
                    for (i5 = 0; i5 < cls.staticFields.length; ++i5) {
                        value = in.readInt();
                        new Link(obj, cls.staticFields[i5], this.objs.get(value));
                    }
                    break;
                }
                case 0: {
                    int value;
                    int i5;
                    for (i5 = 0; i5 < cls.fields.length; ++i5) {
                        value = in.readInt();
                        new Link(obj, cls.fields[i5], this.objs.get(value));
                    }
                    break;
                }
            }
            ++h2;
        }
    }

    private void garbageCollect(MyObject obj, HashSet<MyObject> visited) {
        if (obj == null || visited.contains(obj)) {
            return;
        }
        visited.add(obj);
        for (Link l2 : obj.linksFrom) {
            this.garbageCollect(l2.to, visited);
        }
    }

    private void garbageCollect() {
        HashSet<MyObject> visited = new HashSet<MyObject>();
        for (int h2 = 1; h2 < this.objs.size(); ++h2) {
            MyObject obj = this.objs.get(h2);
            if (!(obj instanceof MyClass)) continue;
            this.garbageCollect(obj, visited);
        }
        int collected = 0;
        int remained = 0;
        for (int h3 = 1; h3 < this.objs.size(); ++h3) {
            MyObject obj = this.objs.get(h3);
            if (obj == null) continue;
            if (!visited.contains(obj)) {
                this.objs.set(h3, null);
                ++collected;
            }
            Iterator<Link> it = obj.linksTo.iterator();
            while (it.hasNext()) {
                Link l2 = it.next();
                if (l2.from == null || visited.contains(l2.from)) continue;
                it.remove();
            }
            ++remained;
        }
        System.out.println(collected + " objects collected  " + remained + " remained");
    }

    private void makePaths() {
        int named;
        int k2;
        for (k2 = 0; k2 < 100 && (named = this.stepPath(true, false, false)) != 0; ++k2) {
        }
        for (k2 = 0; k2 < 100 && (named = this.stepPath(true, true, false)) != 0; ++k2) {
        }
        this.countUnnamed();
        int singleRefered = 0;
        for (int h2 = 0; h2 < this.objs.size(); ++h2) {
            MyObject obj = this.objs.get(h2);
            if (obj == null || !obj.isSingleOwned()) continue;
            if (obj.linksTo.size() == 0) {
                System.out.println(String.valueOf(obj) + " has no access");
                continue;
            }
            ++singleRefered;
            Link pathLink = obj.linksTo.get(0);
            assert (obj.pathLink == null || obj.pathLink == pathLink);
            obj.pathLink = pathLink;
        }
        System.out.println(singleRefered + " single-refered");
        this.countUnnamed();
    }

    private int stepPath(boolean doMaps, boolean trackReferents, boolean verbose) {
        HashSet<MyObject> named = new HashSet<MyObject>();
        for (int h2 = 1; h2 < this.objs.size(); ++h2) {
            MyObject obj = this.objs.get(h2);
            if (obj == null || obj.pathLink == null || named.contains(obj)) continue;
            boolean doAll = doMaps || obj.cls.mode != 3 && obj.cls.mode != 2;
            for (Link l2 : obj.linksFrom) {
                if (l2.to == null || l2.to.pathLink != null || !trackReferents && l2.field.referent) continue;
                boolean single = l2.to.isSingleOwned();
                if (!doAll && !single) continue;
                l2.to.pathLink = l2;
                named.add(l2.to);
                if (!verbose || single) continue;
                System.out.println(l2.to.toString());
            }
        }
        System.out.println(named.size() + " named");
        return named.size();
    }

    private void countUnnamed() {
        int unnamed = 0;
        for (int h2 = 0; h2 < this.objs.size(); ++h2) {
            MyObject obj = this.objs.get(h2);
            if (obj == null || obj.pathLink != null) continue;
            ++unnamed;
        }
        System.out.println(unnamed + " unnamed");
    }

    private void dump(String dumpName) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(dumpName)));
            for (int h2 = 0; h2 < this.objs.size(); ++h2) {
                MyObject obj = this.objs.get(h2);
                if (obj == null) continue;
                out.println(obj.toString());
                for (Link l2 : obj.linksFrom) {
                    if (l2.to == null) continue;
                    out.println("\t" + l2.field.name + "\t" + (l2.to != null ? l2.to.toString() : "null"));
                }
                out.println("\t-");
                for (Link l2 : obj.linksTo) {
                    if (l2 == obj.pathLink) continue;
                    out.println("\t" + (String)(l2.from != null ? l2.from.path() + "." : "") + l2.field.name);
                }
                out.println();
            }
            out.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

