/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.awt;

import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.texture.TextureData;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class AWTTextureData
extends TextureData {
    private BufferedImage imageForLazyCustomConversion;
    private boolean expectingEXTABGR;
    private boolean expectingGL12;
    private static final ColorModel rgbaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
    private static final ColorModel rgbColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);

    public AWTTextureData(GLProfile gLProfile, int n2, int n3, boolean bl, BufferedImage bufferedImage) {
        super(gLProfile);
        this.internalFormat = n2 == 0 ? (bufferedImage.getColorModel().hasAlpha() ? 6408 : 6407) : n2;
        this.createFromImage(gLProfile, bufferedImage);
        this.mipmap = bl;
        if (this.buffer != null) {
            this.estimatedMemorySize = AWTTextureData.estimatedMemorySize(this.buffer);
        } else if (this.imageForLazyCustomConversion != null) {
            this.estimatedMemorySize = AWTTextureData.estimatedMemorySize(this.wrapImageDataBuffer(this.imageForLazyCustomConversion));
        }
    }

    private void validatePixelAttributes() {
        if (!(this.imageForLazyCustomConversion == null || this.expectingEXTABGR && this.haveEXTABGR || this.expectingGL12 && this.haveGL12)) {
            this.revertPixelAttributes();
        }
    }

    @Override
    public GLPixelBuffer.GLPixelAttributes getPixelAttributes() {
        this.validatePixelAttributes();
        return super.getPixelAttributes();
    }

    @Override
    public int getPixelFormat() {
        this.validatePixelAttributes();
        return super.getPixelFormat();
    }

    @Override
    public int getPixelType() {
        this.validatePixelAttributes();
        return super.getPixelType();
    }

    @Override
    public Buffer getBuffer() {
        if (!(this.imageForLazyCustomConversion == null || this.expectingEXTABGR && this.haveEXTABGR || this.expectingGL12 && this.haveGL12)) {
            this.revertPixelAttributes();
            this.createFromCustom(this.imageForLazyCustomConversion);
        }
        return this.buffer;
    }

    private void createFromImage(GLProfile gLProfile, BufferedImage bufferedImage) {
        int n2;
        this.pixelAttributes = GLPixelBuffer.GLPixelAttributes.UNDEF;
        this.mustFlipVertically = true;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            n2 = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            n2 = ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride();
        } else if (sampleModel instanceof ComponentSampleModel) {
            n2 = ((ComponentSampleModel)sampleModel).getScanlineStride();
        } else {
            this.setupLazyCustomConversion(bufferedImage);
            return;
        }
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        if (gLProfile.isGL2GL3()) {
            switch (bufferedImage.getType()) {
                case 1: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(32993, 33639);
                    this.rowLength = n2;
                    this.alignment = 4;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 3: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(32993, 33639);
                    this.rowLength = n2;
                    this.alignment = 4;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 4: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6408, 33639);
                    this.rowLength = n2;
                    this.alignment = 4;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 5: {
                    if (n2 % 3 == 0) {
                        this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(32992, 5121);
                        this.rowLength = n2 / 3;
                        this.alignment = 1;
                        break;
                    }
                    this.setupLazyCustomConversion(bufferedImage);
                    return;
                }
                case 7: {
                    if (n2 % 4 != 0 || gLProfile.isGL2()) {
                        // empty if block
                    }
                    this.setupLazyCustomConversion(bufferedImage);
                    return;
                }
                case 8: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6407, 33635);
                    this.rowLength = n2;
                    this.alignment = 2;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 9: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(32993, 33638);
                    this.rowLength = n2;
                    this.alignment = 2;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 10: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6409, 5121);
                    this.rowLength = n2;
                    this.alignment = 1;
                    break;
                }
                case 11: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6409, 5123);
                    this.rowLength = n2;
                    this.alignment = 2;
                    break;
                }
                default: {
                    ColorModel colorModel = bufferedImage.getColorModel();
                    if (colorModel.equals(rgbColorModel)) {
                        this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6407, 5121);
                        this.rowLength = n2 / 3;
                        this.alignment = 1;
                        break;
                    }
                    if (colorModel.equals(rgbaColorModel)) {
                        this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6408, 5121);
                        this.rowLength = n2 / 4;
                        this.alignment = 4;
                        break;
                    }
                    this.setupLazyCustomConversion(bufferedImage);
                    return;
                }
            }
        } else {
            switch (bufferedImage.getType()) {
                case 1: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6407, 5121);
                    this.rowLength = n2;
                    this.alignment = 3;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 3: {
                    throw new GLException("INT_ARGB_PRE n.a.");
                }
                case 4: {
                    throw new GLException("INT_BGR n.a.");
                }
                case 5: {
                    throw new GLException("INT_BGR n.a.");
                }
                case 7: {
                    throw new GLException("INT_BGR n.a.");
                }
                case 8: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6407, 33635);
                    this.rowLength = n2;
                    this.alignment = 2;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 9: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6408, 32820);
                    this.rowLength = n2;
                    this.alignment = 2;
                    this.expectingGL12 = true;
                    this.setupLazyCustomConversion(bufferedImage);
                    break;
                }
                case 10: {
                    this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6409, 5121);
                    this.rowLength = n2;
                    this.alignment = 1;
                    break;
                }
                case 11: {
                    throw new GLException("USHORT_GRAY n.a.");
                }
                default: {
                    ColorModel colorModel = bufferedImage.getColorModel();
                    if (colorModel.equals(rgbColorModel)) {
                        this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6407, 5121);
                        this.rowLength = n2 / 3;
                        this.alignment = 1;
                        break;
                    }
                    if (colorModel.equals(rgbaColorModel)) {
                        this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(6408, 5121);
                        this.rowLength = n2 / 4;
                        this.alignment = 4;
                        break;
                    }
                    this.setupLazyCustomConversion(bufferedImage);
                    return;
                }
            }
        }
        this.createNIOBufferFromImage(bufferedImage);
    }

    private void setupLazyCustomConversion(BufferedImage bufferedImage) {
        this.imageForLazyCustomConversion = bufferedImage;
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        int n2 = this.pixelAttributes.format;
        int n3 = this.pixelAttributes.type;
        if (n2 == 0) {
            n2 = bl ? 6408 : 6407;
        }
        this.alignment = 1;
        this.rowLength = this.width;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte || this.isPackedInt(bufferedImage)) {
            if (n3 == 0) {
                n3 = 5121;
            }
        } else {
            if (dataBuffer instanceof DataBufferDouble) {
                throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
            }
            if (dataBuffer instanceof DataBufferFloat) {
                if (n3 == 0) {
                    n3 = 5126;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                if (n3 == 0) {
                    n3 = 5125;
                }
            } else if (dataBuffer instanceof DataBufferShort) {
                if (n3 == 0) {
                    n3 = 5122;
                }
            } else if (dataBuffer instanceof DataBufferUShort) {
                if (n3 == 0) {
                    n3 = 5123;
                }
            } else {
                throw new RuntimeException("Unexpected DataBuffer type?");
            }
        }
        this.pixelAttributes = new GLPixelBuffer.GLPixelAttributes(n2, n3);
    }

    private void createFromCustom(BufferedImage bufferedImage) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        ColorModel colorModel = null;
        int n4 = bufferedImage.getRaster().getDataBuffer().getDataType();
        if (this.isPackedInt(bufferedImage)) {
            n4 = 0;
        }
        colorModel = n4 == 0 ? (bl ? rgbaColorModel : rgbColorModel) : (bl ? new ComponentColorModel(ColorSpace.getInstance(1000), null, true, true, 3, n4) : new ComponentColorModel(ColorSpace.getInstance(1000), null, false, false, 1, n4));
        boolean bl2 = colorModel.isAlphaPremultiplied();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bl2, null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        this.createNIOBufferFromImage(bufferedImage2);
    }

    private boolean isPackedInt(BufferedImage bufferedImage) {
        int n2 = bufferedImage.getType();
        return n2 == 1 || n2 == 4 || n2 == 2 || n2 == 3;
    }

    private void revertPixelAttributes() {
        this.pixelAttributes = GLPixelBuffer.GLPixelAttributes.UNDEF;
        this.setupLazyCustomConversion(this.imageForLazyCustomConversion);
    }

    private void createNIOBufferFromImage(BufferedImage bufferedImage) {
        this.buffer = this.wrapImageDataBuffer(bufferedImage);
    }

    private Buffer wrapImageDataBuffer(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            return ByteBuffer.wrap(((DataBufferByte)dataBuffer).getData());
        }
        if (dataBuffer instanceof DataBufferDouble) {
            throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
        }
        if (dataBuffer instanceof DataBufferFloat) {
            return FloatBuffer.wrap(((DataBufferFloat)dataBuffer).getData());
        }
        if (dataBuffer instanceof DataBufferInt) {
            return IntBuffer.wrap(((DataBufferInt)dataBuffer).getData());
        }
        if (dataBuffer instanceof DataBufferShort) {
            return ShortBuffer.wrap(((DataBufferShort)dataBuffer).getData());
        }
        if (dataBuffer instanceof DataBufferUShort) {
            return ShortBuffer.wrap(((DataBufferUShort)dataBuffer).getData());
        }
        throw new RuntimeException("Unexpected DataBuffer type?");
    }
}

