/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;

public class TextureState {
    private final int target;
    private final int[] state = new int[]{0, 0, 0, 0, 0, 0};

    public static final int getTextureTargetQueryName(int n2) {
        int n3;
        switch (n2) {
            case 3553: {
                n3 = 32873;
                break;
            }
            case 34067: {
                n3 = 34068;
                break;
            }
            case 32879: {
                n3 = 32874;
                break;
            }
            case 3552: {
                n3 = 32872;
                break;
            }
            case 35864: {
                n3 = 35868;
                break;
            }
            case 35866: {
                n3 = 35869;
                break;
            }
            case 34037: {
                n3 = 34038;
                break;
            }
            case 35882: {
                n3 = 35884;
                break;
            }
            case 37120: {
                n3 = 37124;
                break;
            }
            case 37122: {
                n3 = 37125;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3;
    }

    private static final String toHexString(int n2) {
        return "0x" + Integer.toHexString(n2);
    }

    private static final int activeTexture(GL gL) {
        int[] nArray = new int[]{0};
        gL.glGetIntegerv(34016, nArray, 0);
        return nArray[0];
    }

    public TextureState(GL gL, int n2) throws GLException {
        this(gL, TextureState.activeTexture(gL), n2);
    }

    public TextureState(GL gL, int n2, int n3) throws GLException {
        this.target = n3;
        this.state[0] = n2;
        int n4 = TextureState.getTextureTargetQueryName(n3);
        if (0 == n4) {
            throw new GLException("Unsupported textureTarget " + TextureState.toHexString(n3));
        }
        gL.glGetIntegerv(n4, this.state, 1);
        gL.glGetTexParameteriv(this.target, 10240, this.state, 2);
        gL.glGetTexParameteriv(this.target, 10241, this.state, 3);
        gL.glGetTexParameteriv(this.target, 10242, this.state, 4);
        gL.glGetTexParameteriv(this.target, 10243, this.state, 5);
    }

    public final void restore(GL gL) {
        gL.glActiveTexture(this.state[0]);
        gL.glBindTexture(this.target, this.state[1]);
        gL.glTexParameteri(this.target, 10240, this.state[2]);
        gL.glTexParameteri(this.target, 10241, this.state[3]);
        gL.glTexParameteri(this.target, 10242, this.state[4]);
        gL.glTexParameteri(this.target, 10243, this.state[5]);
    }

    public final int getUnit() {
        return this.state[0];
    }

    public final int getTarget() {
        return this.target;
    }

    public final int getObject() {
        return this.state[1];
    }

    public final int getMagFilter() {
        return this.state[2];
    }

    public final int getMinFilter() {
        return this.state[3];
    }

    public final int getWrapS() {
        return this.state[4];
    }

    public final int getWrapT() {
        return this.state[5];
    }

    public final String toString() {
        return "TextureState[unit " + (this.state[0] - 33984) + ", target " + TextureState.toHexString(this.target) + ": obj " + TextureState.toHexString(this.state[1]) + ", filter[mag " + TextureState.toHexString(this.state[2]) + ", min " + TextureState.toHexString(this.state[3]) + "], : wrap[s " + TextureState.toHexString(this.state[4]) + ", t " + TextureState.toHexString(this.state[5]) + "]]";
    }
}

