/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.awt;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.TextureRenderer;
import com.jogamp.opengl.util.packrect.BackingStoreManager;
import com.jogamp.opengl.util.packrect.Rect;
import com.jogamp.opengl.util.packrect.RectVisitor;
import com.jogamp.opengl.util.packrect.RectanglePacker;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jogamp.opengl.Debug;

public class TextRenderer {
    private static final boolean DEBUG;
    private static final boolean DISABLE_GLYPH_CACHE = false;
    private static final boolean DRAW_BBOXES = false;
    static final int kSize = 256;
    private static final int CYCLES_PER_FLUSH = 100;
    private static final float MAX_VERTICAL_FRAGMENTATION = 0.7f;
    static final int kQuadsPerBuffer = 100;
    static final int kCoordsPerVertVerts = 3;
    static final int kCoordsPerVertTex = 2;
    static final int kVertsPerQuad = 4;
    static final int kTotalBufferSizeVerts = 400;
    static final int kTotalBufferSizeCoordsVerts = 1200;
    static final int kTotalBufferSizeCoordsTex = 800;
    static final int kTotalBufferSizeBytesVerts = 4800;
    static final int kTotalBufferSizeBytesTex = 3200;
    static final int kSizeInBytes_OneVertices_VertexData = 12;
    static final int kSizeInBytes_OneVertices_TexData = 8;
    private final Font font;
    private final boolean antialiased;
    private final boolean useFractionalMetrics;
    private boolean mipmap;
    private RectanglePacker packer;
    private boolean haveMaxSize;
    private final RenderDelegate renderDelegate;
    private TextureRenderer cachedBackingStore;
    private Graphics2D cachedGraphics;
    private FontRenderContext cachedFontRenderContext;
    private final Map<String, Rect> stringLocations = new HashMap<String, Rect>();
    private final GlyphProducer mGlyphProducer;
    private int numRenderCycles;
    private boolean inBeginEndPair;
    private boolean isOrthoMode;
    private int beginRenderingWidth;
    private int beginRenderingHeight;
    private boolean beginRenderingDepthTestDisabled;
    private boolean haveCachedColor;
    private float cachedR;
    private float cachedG;
    private float cachedB;
    private float cachedA;
    private Color cachedColor;
    private boolean needToResetColor;
    private Frame dbgFrame;
    private boolean debugged;
    Pipelined_QuadRenderer mPipelinedQuadRenderer;
    private boolean useVertexArrays = true;
    private boolean isExtensionAvailable_GL_VERSION_1_5;
    private boolean checkFor_isExtensionAvailable_GL_VERSION_1_5;
    private boolean smoothing = true;
    private final char[] singleUnicode = new char[1];

    public TextRenderer(Font font) {
        this(font, false, false, null, false);
    }

    public TextRenderer(Font font, boolean bl) {
        this(font, false, false, null, bl);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2) {
        this(font, bl, bl2, null, false);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2, RenderDelegate renderDelegate) {
        this(font, bl, bl2, renderDelegate, false);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2, RenderDelegate renderDelegate, boolean bl3) {
        this.font = font;
        this.antialiased = bl;
        this.useFractionalMetrics = bl2;
        this.mipmap = bl3;
        this.packer = new RectanglePacker(new Manager(), 256, 256);
        if (renderDelegate == null) {
            renderDelegate = new DefaultRenderDelegate();
        }
        this.renderDelegate = renderDelegate;
        this.mGlyphProducer = new GlyphProducer(font.getNumGlyphs());
    }

    public Rectangle2D getBounds(String string) {
        return this.getBounds((CharSequence)string);
    }

    public Rectangle2D getBounds(CharSequence charSequence) {
        Rect rect = this.stringLocations.get(charSequence);
        if (rect != null) {
            TextData textData = (TextData)rect.getUserData();
            return new Rectangle2D.Double(-textData.origin().x, -textData.origin().y, rect.w(), rect.h());
        }
        return this.normalize(this.renderDelegate.getBounds(charSequence, this.font, this.getFontRenderContext()));
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        if (this.cachedFontRenderContext == null) {
            this.cachedFontRenderContext = this.getGraphics2D().getFontRenderContext();
        }
        return this.cachedFontRenderContext;
    }

    public void beginRendering(int n2, int n3) throws GLException {
        this.beginRendering(n2, n3, true);
    }

    public void beginRendering(int n2, int n3, boolean bl) throws GLException {
        this.beginRendering(true, n2, n3, bl);
    }

    public void begin3DRendering() throws GLException {
        this.beginRendering(false, 0, 0, false);
    }

    public void setColor(Color color) throws GLException {
        boolean bl;
        boolean bl2 = bl = this.haveCachedColor && this.cachedColor != null && color.equals(this.cachedColor);
        if (!bl) {
            this.flushGlyphPipeline();
        }
        this.getBackingStore().setColor(color);
        this.haveCachedColor = true;
        this.cachedColor = color;
    }

    public void setColor(float f2, float f3, float f4, float f5) throws GLException {
        boolean bl;
        boolean bl2 = bl = this.haveCachedColor && this.cachedColor == null && f2 == this.cachedR && f3 == this.cachedG && f4 == this.cachedB && f5 == this.cachedA;
        if (!bl) {
            this.flushGlyphPipeline();
        }
        this.getBackingStore().setColor(f2, f3, f4, f5);
        this.haveCachedColor = true;
        this.cachedR = f2;
        this.cachedG = f3;
        this.cachedB = f4;
        this.cachedA = f5;
        this.cachedColor = null;
    }

    public void draw(CharSequence charSequence, int n2, int n3) throws GLException {
        this.draw3D(charSequence, (float)n2, (float)n3, 0.0f, 1.0f);
    }

    public void draw(String string, int n2, int n3) throws GLException {
        this.draw3D(string, (float)n2, (float)n3, 0.0f, 1.0f);
    }

    public void draw3D(CharSequence charSequence, float f2, float f3, float f4, float f5) {
        this.internal_draw3D(charSequence, f2, f3, f4, f5);
    }

    public void draw3D(String string, float f2, float f3, float f4, float f5) {
        this.internal_draw3D(string, f2, f3, f4, f5);
    }

    public float getCharWidth(char c2) {
        return this.mGlyphProducer.getGlyphPixelWidth(c2);
    }

    public void flush() {
        this.flushGlyphPipeline();
    }

    public void endRendering() throws GLException {
        this.endRendering(true);
    }

    public void end3DRendering() throws GLException {
        this.endRendering(false);
    }

    public void dispose() throws GLException {
        if (null != this.mPipelinedQuadRenderer) {
            this.mPipelinedQuadRenderer.dispose();
        }
        this.packer.dispose();
        this.packer = null;
        this.cachedBackingStore = null;
        this.cachedGraphics = null;
        this.cachedFontRenderContext = null;
        if (this.dbgFrame != null) {
            this.dbgFrame.dispose();
        }
    }

    private static Rectangle2D preNormalize(Rectangle2D rectangle2D) {
        int n2 = (int)Math.floor(rectangle2D.getMinX()) - 1;
        int n3 = (int)Math.floor(rectangle2D.getMinY()) - 1;
        int n4 = (int)Math.ceil(rectangle2D.getMaxX()) + 1;
        int n5 = (int)Math.ceil(rectangle2D.getMaxY()) + 1;
        return new Rectangle2D.Double(n2, n3, n4 - n2, n5 - n3);
    }

    private Rectangle2D normalize(Rectangle2D rectangle2D) {
        int n2 = (int)Math.max(1.0, 0.015 * (double)this.font.getSize());
        return new Rectangle2D.Double((int)Math.floor(rectangle2D.getMinX() - (double)n2), (int)Math.floor(rectangle2D.getMinY() - (double)n2), (int)Math.ceil(rectangle2D.getWidth() + (double)(2 * n2)), (int)Math.ceil(rectangle2D.getHeight()) + 2 * n2);
    }

    private TextureRenderer getBackingStore() {
        TextureRenderer textureRenderer = (TextureRenderer)this.packer.getBackingStore();
        if (textureRenderer != this.cachedBackingStore) {
            if (this.cachedGraphics != null) {
                this.cachedGraphics.dispose();
                this.cachedGraphics = null;
                this.cachedFontRenderContext = null;
            }
            this.cachedBackingStore = textureRenderer;
        }
        return this.cachedBackingStore;
    }

    private Graphics2D getGraphics2D() {
        TextureRenderer textureRenderer = this.getBackingStore();
        if (this.cachedGraphics == null) {
            this.cachedGraphics = textureRenderer.createGraphics();
            this.cachedGraphics.setComposite(AlphaComposite.Src);
            this.cachedGraphics.setColor(Color.WHITE);
            this.cachedGraphics.setFont(this.font);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialiased ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.useFractionalMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        return this.cachedGraphics;
    }

    private void beginRendering(boolean bl, int n2, int n3, boolean bl2) {
        GL2 gL2 = GLContext.getCurrentGL().getGL2();
        if (DEBUG && !this.debugged) {
            this.debug(gL2);
        }
        this.inBeginEndPair = true;
        this.isOrthoMode = bl;
        this.beginRenderingWidth = n2;
        this.beginRenderingHeight = n3;
        this.beginRenderingDepthTestDisabled = bl2;
        if (bl) {
            this.getBackingStore().beginOrthoRendering(n2, n3, bl2);
        } else {
            this.getBackingStore().begin3DRendering();
        }
        gL2.glPushClientAttrib(-1);
        if (!this.haveMaxSize) {
            int[] nArray = new int[1];
            gL2.glGetIntegerv(3379, nArray, 0);
            this.packer.setMaxSize(nArray[0], nArray[0]);
            this.haveMaxSize = true;
        }
        if (this.needToResetColor && this.haveCachedColor) {
            if (this.cachedColor == null) {
                this.getBackingStore().setColor(this.cachedR, this.cachedG, this.cachedB, this.cachedA);
            } else {
                this.getBackingStore().setColor(this.cachedColor);
            }
            this.needToResetColor = false;
        }
        if (this.mipmap && !this.getBackingStore().isUsingAutoMipmapGeneration()) {
            if (DEBUG) {
                System.err.println("Disabled mipmapping in TextRenderer");
            }
            this.mipmap = false;
        }
    }

    private void endRendering(boolean bl) throws GLException {
        this.flushGlyphPipeline();
        this.inBeginEndPair = false;
        GL2 gL2 = GLContext.getCurrentGL().getGL2();
        gL2.glPopClientAttrib();
        if (this.getUseVertexArrays() && this.is15Available(gL2)) {
            try {
                gL2.glBindBuffer(34962, 0);
            }
            catch (Exception exception) {
                this.isExtensionAvailable_GL_VERSION_1_5 = false;
            }
        }
        if (bl) {
            this.getBackingStore().endOrthoRendering();
        } else {
            this.getBackingStore().end3DRendering();
        }
        if (++this.numRenderCycles >= 100) {
            this.numRenderCycles = 0;
            if (DEBUG) {
                System.err.println("Clearing unused entries in endRendering()");
            }
            this.clearUnusedEntries();
        }
    }

    private void clearUnusedEntries() {
        final ArrayList arrayList = new ArrayList();
        this.packer.visit(new RectVisitor(){

            @Override
            public void visit(Rect rect) {
                TextData textData = (TextData)rect.getUserData();
                if (textData.used()) {
                    textData.clearUsed();
                } else {
                    arrayList.add(rect);
                }
            }
        });
        for (Rect rect : arrayList) {
            this.packer.remove(rect);
            this.stringLocations.remove(((TextData)rect.getUserData()).string());
            int n2 = ((TextData)rect.getUserData()).unicodeID;
            if (n2 <= 0) continue;
            this.mGlyphProducer.clearCacheEntry(n2);
        }
        float f2 = this.packer.verticalFragmentationRatio();
        if (!arrayList.isEmpty() && f2 > 0.7f) {
            if (DEBUG) {
                System.err.println("Compacting TextRenderer backing store due to vertical fragmentation " + f2);
            }
            this.packer.compact();
        }
        if (DEBUG) {
            this.getBackingStore().markDirty(0, 0, this.getBackingStore().getWidth(), this.getBackingStore().getHeight());
        }
    }

    private void internal_draw3D(CharSequence charSequence, float f2, float f3, float f4, float f5) {
        for (Glyph glyph : this.mGlyphProducer.getGlyphs(charSequence)) {
            float f6 = glyph.draw3D(f2, f3, f4, f5);
            f2 += f6 * f5;
        }
    }

    private void flushGlyphPipeline() {
        if (this.mPipelinedQuadRenderer != null) {
            this.mPipelinedQuadRenderer.draw();
        }
    }

    private void draw3D_ROBUST(CharSequence charSequence, float f2, float f3, float f4, float f5) {
        Rectangle2D rectangle2D;
        Object object;
        Object object2;
        String string = charSequence instanceof String ? (String)charSequence : charSequence.toString();
        Rect rect = this.stringLocations.get(string);
        if (rect == null) {
            object2 = this.getGraphics2D();
            object = TextRenderer.preNormalize(this.renderDelegate.getBounds(string, this.font, this.getFontRenderContext()));
            rectangle2D = this.normalize((Rectangle2D)object);
            Point point = new Point((int)(-rectangle2D.getMinX()), (int)(-rectangle2D.getMinY()));
            rect = new Rect(0, 0, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), new TextData(string, point, (Rectangle2D)object, -1));
            this.packer.add(rect);
            this.stringLocations.put(string, rect);
            object2 = this.getGraphics2D();
            int n2 = rect.x() + point.x;
            int n3 = rect.y() + point.y;
            ((Graphics2D)object2).setComposite(AlphaComposite.Clear);
            ((Graphics)object2).fillRect(rect.x(), rect.y(), rect.w(), rect.h());
            ((Graphics2D)object2).setComposite(AlphaComposite.Src);
            this.renderDelegate.draw((Graphics2D)object2, string, n2, n3);
            this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
        }
        object2 = this.getBackingStore();
        object = (TextData)rect.getUserData();
        ((TextData)object).markUsed();
        rectangle2D = ((TextData)object).origRect();
        ((TextureRenderer)object2).draw3DRect(f2 - f5 * (float)((TextData)object).origOriginX(), f3 - f5 * ((float)rectangle2D.getHeight() - (float)((TextData)object).origOriginY()), f4, rect.x() + (((TextData)object).origin().x - ((TextData)object).origOriginX()), ((TextureRenderer)object2).getHeight() - rect.y() - (int)rectangle2D.getHeight() - (((TextData)object).origin().y - ((TextData)object).origOriginY()), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), f5);
    }

    private void debug(GL gL) {
        this.dbgFrame = new Frame("TextRenderer Debug Output");
        GLCanvas gLCanvas = new GLCanvas(new GLCapabilities(gL.getGLProfile()));
        gLCanvas.setSharedContext(GLContext.getCurrent());
        gLCanvas.addGLEventListener(new DebugListener(gL, this.dbgFrame));
        this.dbgFrame.add(gLCanvas);
        final FPSAnimator fPSAnimator = new FPSAnimator(gLCanvas, 10);
        this.dbgFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new InterruptSource.Thread(null, new Runnable(){

                    @Override
                    public void run() {
                        fPSAnimator.stop();
                    }
                }).start();
            }
        });
        this.dbgFrame.setSize(256, 256);
        this.dbgFrame.setVisible(true);
        fPSAnimator.start();
        this.debugged = true;
    }

    public void setUseVertexArrays(boolean bl) {
        this.useVertexArrays = bl;
    }

    public final boolean getUseVertexArrays() {
        return this.useVertexArrays;
    }

    public void setSmoothing(boolean bl) {
        this.smoothing = bl;
        this.getBackingStore().setSmoothing(bl);
    }

    public boolean getSmoothing() {
        return this.smoothing;
    }

    private final boolean is15Available(GL gL) {
        if (!this.checkFor_isExtensionAvailable_GL_VERSION_1_5) {
            this.isExtensionAvailable_GL_VERSION_1_5 = gL.isExtensionAvailable("GL_VERSION_1_5");
            this.checkFor_isExtensionAvailable_GL_VERSION_1_5 = true;
        }
        return this.isExtensionAvailable_GL_VERSION_1_5;
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined("jogl.debug.TextRenderer", true);
    }

    class GlyphProducer {
        static final int undefined = -2;
        final FontRenderContext fontRenderContext = null;
        List<Glyph> glyphsOutput = new ArrayList<Glyph>();
        HashMap<String, GlyphVector> fullGlyphVectorCache = new HashMap();
        HashMap<Character, GlyphMetrics> glyphMetricsCache = new HashMap();
        int[] unicodes2Glyphs;
        Glyph[] glyphCache;
        CharSequenceIterator iter = new CharSequenceIterator();

        GlyphProducer(int n2) {
            this.unicodes2Glyphs = new int[512];
            this.glyphCache = new Glyph[n2];
            this.clearAllCacheEntries();
        }

        public List<Glyph> getGlyphs(CharSequence charSequence) {
            boolean bl;
            this.glyphsOutput.clear();
            GlyphVector glyphVector = this.fullGlyphVectorCache.get(charSequence.toString());
            if (glyphVector == null) {
                this.iter.initFromCharSequence(charSequence);
                glyphVector = TextRenderer.this.font.createGlyphVector(TextRenderer.this.getFontRenderContext(), this.iter);
                this.fullGlyphVectorCache.put(charSequence.toString(), glyphVector);
            }
            boolean bl2 = bl = glyphVector.getLayoutFlags() != 0;
            if (bl) {
                this.glyphsOutput.add(new Glyph(charSequence.toString(), false));
                return this.glyphsOutput;
            }
            int n2 = glyphVector.getNumGlyphs();
            int n3 = 0;
            while (n3 < n2) {
                Glyph glyph;
                Character c2 = CharacterCache.valueOf(charSequence.charAt(n3));
                GlyphMetrics glyphMetrics = this.glyphMetricsCache.get(c2);
                if (glyphMetrics == null) {
                    glyphMetrics = glyphVector.getGlyphMetrics(n3);
                    this.glyphMetricsCache.put(c2, glyphMetrics);
                }
                if ((glyph = this.getGlyph(charSequence, glyphMetrics, n3)) != null) {
                    this.glyphsOutput.add(glyph);
                    ++n3;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                while (n3 < n2 && this.getGlyph(charSequence, glyphVector.getGlyphMetrics(n3), n3) == null) {
                    stringBuilder.append(charSequence.charAt(n3++));
                }
                this.glyphsOutput.add(new Glyph(stringBuilder.toString(), n3 < n2));
            }
            return this.glyphsOutput;
        }

        public void clearCacheEntry(int n2) {
            int n3 = this.unicodes2Glyphs[n2];
            if (n3 != -2) {
                Glyph glyph = this.glyphCache[n3];
                if (glyph != null) {
                    glyph.clear();
                }
                this.glyphCache[n3] = null;
            }
            this.unicodes2Glyphs[n2] = -2;
        }

        public void clearAllCacheEntries() {
            for (int i2 = 0; i2 < this.unicodes2Glyphs.length; ++i2) {
                this.clearCacheEntry(i2);
            }
        }

        public void register(Glyph glyph) {
            this.unicodes2Glyphs[glyph.getUnicodeID()] = glyph.getGlyphCode();
            this.glyphCache[glyph.getGlyphCode()] = glyph;
        }

        public float getGlyphPixelWidth(char c2) {
            Glyph glyph = this.getGlyph(c2);
            if (glyph != null) {
                return glyph.getAdvance();
            }
            ((TextRenderer)TextRenderer.this).singleUnicode[0] = c2;
            if (null == this.fontRenderContext) {
                throw new InternalError("fontRenderContext never initialized!");
            }
            GlyphVector glyphVector = TextRenderer.this.font.createGlyphVector(this.fontRenderContext, TextRenderer.this.singleUnicode);
            return glyphVector.getGlyphMetrics(0).getAdvance();
        }

        private Glyph getGlyph(CharSequence charSequence, GlyphMetrics glyphMetrics, int n2) {
            char c2 = charSequence.charAt(n2);
            if (c2 >= this.unicodes2Glyphs.length) {
                return null;
            }
            int n3 = this.unicodes2Glyphs[c2];
            if (n3 != -2) {
                return this.glyphCache[n3];
            }
            ((TextRenderer)TextRenderer.this).singleUnicode[0] = c2;
            GlyphVector glyphVector = TextRenderer.this.font.createGlyphVector(TextRenderer.this.getFontRenderContext(), TextRenderer.this.singleUnicode);
            return this.getGlyph(c2, glyphVector, glyphMetrics);
        }

        private Glyph getGlyph(int n2) {
            if (n2 >= this.unicodes2Glyphs.length) {
                return null;
            }
            int n3 = this.unicodes2Glyphs[n2];
            if (n3 != -2) {
                return this.glyphCache[n3];
            }
            ((TextRenderer)TextRenderer.this).singleUnicode[0] = (char)n2;
            GlyphVector glyphVector = TextRenderer.this.font.createGlyphVector(TextRenderer.this.getFontRenderContext(), TextRenderer.this.singleUnicode);
            return this.getGlyph(n2, glyphVector, glyphVector.getGlyphMetrics(0));
        }

        private Glyph getGlyph(int n2, GlyphVector glyphVector, GlyphMetrics glyphMetrics) {
            int n3 = glyphVector.getGlyphCode(0);
            if (n3 >= this.glyphCache.length) {
                return null;
            }
            Glyph glyph = new Glyph(n2, n3, glyphMetrics.getAdvance(), glyphVector, this);
            this.register(glyph);
            return glyph;
        }
    }

    public static interface RenderDelegate {
        public boolean intensityOnly();

        public Rectangle2D getBounds(String var1, Font var2, FontRenderContext var3);

        public Rectangle2D getBounds(CharSequence var1, Font var2, FontRenderContext var3);

        public Rectangle2D getBounds(GlyphVector var1, FontRenderContext var2);

        public void draw(Graphics2D var1, String var2, int var3, int var4);

        public void drawGlyphVector(Graphics2D var1, GlyphVector var2, int var3, int var4);
    }

    class Manager
    implements BackingStoreManager {
        private Graphics2D g;

        Manager() {
        }

        @Override
        public Object allocateBackingStore(int n2, int n3) {
            TextureRenderer textureRenderer = TextRenderer.this.renderDelegate.intensityOnly() ? TextureRenderer.createAlphaOnlyRenderer(n2, n3, TextRenderer.this.mipmap) : new TextureRenderer(n2, n3, true, TextRenderer.this.mipmap);
            textureRenderer.setSmoothing(TextRenderer.this.smoothing);
            if (DEBUG) {
                System.err.println(" TextRenderer allocating backing store " + n2 + " x " + n3);
            }
            return textureRenderer;
        }

        @Override
        public void deleteBackingStore(Object object) {
            ((TextureRenderer)object).dispose();
        }

        @Override
        public boolean preExpand(Rect rect, int n2) {
            if (n2 == 0) {
                if (DEBUG) {
                    System.err.println("Clearing unused entries in preExpand(): attempt number " + n2);
                }
                if (TextRenderer.this.inBeginEndPair) {
                    TextRenderer.this.flush();
                }
                TextRenderer.this.clearUnusedEntries();
                return true;
            }
            return false;
        }

        @Override
        public boolean additionFailed(Rect rect, int n2) {
            TextRenderer.this.packer.clear();
            TextRenderer.this.stringLocations.clear();
            TextRenderer.this.mGlyphProducer.clearAllCacheEntries();
            if (DEBUG) {
                System.err.println(" *** Cleared all text because addition failed ***");
            }
            return n2 == 0;
        }

        @Override
        public boolean canCompact() {
            return true;
        }

        @Override
        public void beginMovement(Object object, Object object2) {
            Object object3;
            if (TextRenderer.this.inBeginEndPair) {
                TextRenderer.this.flush();
                object3 = GLContext.getCurrentGL().getGL2();
                object3.glPopClientAttrib();
                if (TextRenderer.this.getUseVertexArrays() && TextRenderer.this.is15Available((GL)object3)) {
                    try {
                        object3.glBindBuffer(34962, 0);
                    }
                    catch (Exception exception) {
                        TextRenderer.this.isExtensionAvailable_GL_VERSION_1_5 = false;
                    }
                }
                if (TextRenderer.this.isOrthoMode) {
                    ((TextureRenderer)object).endOrthoRendering();
                } else {
                    ((TextureRenderer)object).end3DRendering();
                }
            }
            object3 = (TextureRenderer)object2;
            this.g = ((TextureRenderer)object3).createGraphics();
        }

        @Override
        public void move(Object object, Rect rect, Object object2, Rect rect2) {
            TextureRenderer textureRenderer = (TextureRenderer)object;
            TextureRenderer textureRenderer2 = (TextureRenderer)object2;
            if (textureRenderer == textureRenderer2) {
                this.g.copyArea(rect.x(), rect.y(), rect.w(), rect.h(), rect2.x() - rect.x(), rect2.y() - rect.y());
            } else {
                Image image = textureRenderer.getImage();
                this.g.drawImage(image, rect2.x(), rect2.y(), rect2.x() + rect2.w(), rect2.y() + rect2.h(), rect.x(), rect.y(), rect.x() + rect.w(), rect.y() + rect.h(), null);
            }
        }

        @Override
        public void endMovement(Object object, Object object2) {
            this.g.dispose();
            TextureRenderer textureRenderer = (TextureRenderer)object2;
            textureRenderer.markDirty(0, 0, textureRenderer.getWidth(), textureRenderer.getHeight());
            if (TextRenderer.this.inBeginEndPair) {
                if (TextRenderer.this.isOrthoMode) {
                    ((TextureRenderer)object2).beginOrthoRendering(TextRenderer.this.beginRenderingWidth, TextRenderer.this.beginRenderingHeight, TextRenderer.this.beginRenderingDepthTestDisabled);
                } else {
                    ((TextureRenderer)object2).begin3DRendering();
                }
                GL2 gL2 = GLContext.getCurrentGL().getGL2();
                gL2.glPushClientAttrib(-1);
                if (TextRenderer.this.haveCachedColor) {
                    if (TextRenderer.this.cachedColor == null) {
                        ((TextureRenderer)object2).setColor(TextRenderer.this.cachedR, TextRenderer.this.cachedG, TextRenderer.this.cachedB, TextRenderer.this.cachedA);
                    } else {
                        ((TextureRenderer)object2).setColor(TextRenderer.this.cachedColor);
                    }
                }
            } else {
                TextRenderer.this.needToResetColor = true;
            }
        }
    }

    public static class DefaultRenderDelegate
    implements RenderDelegate {
        @Override
        public boolean intensityOnly() {
            return true;
        }

        @Override
        public Rectangle2D getBounds(CharSequence charSequence, Font font, FontRenderContext fontRenderContext) {
            return this.getBounds(font.createGlyphVector(fontRenderContext, new CharSequenceIterator(charSequence)), fontRenderContext);
        }

        @Override
        public Rectangle2D getBounds(String string, Font font, FontRenderContext fontRenderContext) {
            return this.getBounds(font.createGlyphVector(fontRenderContext, string), fontRenderContext);
        }

        @Override
        public Rectangle2D getBounds(GlyphVector glyphVector, FontRenderContext fontRenderContext) {
            return glyphVector.getVisualBounds();
        }

        @Override
        public void drawGlyphVector(Graphics2D graphics2D, GlyphVector glyphVector, int n2, int n3) {
            graphics2D.drawGlyphVector(glyphVector, n2, n3);
        }

        @Override
        public void draw(Graphics2D graphics2D, String string, int n2, int n3) {
            graphics2D.drawString(string, n2, n3);
        }
    }

    static class TextData {
        private final String str;
        int unicodeID;
        private final Point origin;
        private final Rectangle2D origRect;
        private boolean used;

        TextData(String string, Point point, Rectangle2D rectangle2D, int n2) {
            this.str = string;
            this.origin = point;
            this.origRect = rectangle2D;
            this.unicodeID = n2;
        }

        String string() {
            return this.str;
        }

        Point origin() {
            return this.origin;
        }

        int origOriginX() {
            return (int)(-this.origRect.getMinX());
        }

        int origOriginY() {
            return (int)(-this.origRect.getMinY());
        }

        Rectangle2D origRect() {
            return this.origRect;
        }

        boolean used() {
            return this.used;
        }

        void markUsed() {
            this.used = true;
        }

        void clearUsed() {
            this.used = false;
        }
    }

    class Pipelined_QuadRenderer {
        int mOutstandingGlyphsVerticesPipeline = 0;
        FloatBuffer mTexCoords;
        FloatBuffer mVertCoords;
        boolean usingVBOs;
        int mVBO_For_ResuableTileVertices;
        int mVBO_For_ResuableTileTexCoords;

        Pipelined_QuadRenderer() {
            GL2 gL2 = GLContext.getCurrentGL().getGL2();
            this.mVertCoords = Buffers.newDirectFloatBuffer(1200);
            this.mTexCoords = Buffers.newDirectFloatBuffer(800);
            boolean bl = this.usingVBOs = TextRenderer.this.getUseVertexArrays() && TextRenderer.this.is15Available(gL2);
            if (this.usingVBOs) {
                try {
                    int[] nArray = new int[2];
                    gL2.glGenBuffers(2, IntBuffer.wrap(nArray));
                    this.mVBO_For_ResuableTileVertices = nArray[0];
                    this.mVBO_For_ResuableTileTexCoords = nArray[1];
                    gL2.glBindBuffer(34962, this.mVBO_For_ResuableTileVertices);
                    gL2.glBufferData(34962, 4800L, null, 35040);
                    gL2.glBindBuffer(34962, this.mVBO_For_ResuableTileTexCoords);
                    gL2.glBufferData(34962, 3200L, null, 35040);
                }
                catch (Exception exception) {
                    TextRenderer.this.isExtensionAvailable_GL_VERSION_1_5 = false;
                    this.usingVBOs = false;
                }
            }
        }

        public void glTexCoord2f(float f2, float f3) {
            this.mTexCoords.put(f2);
            this.mTexCoords.put(f3);
        }

        public void glVertex3f(float f2, float f3, float f4) {
            this.mVertCoords.put(f2);
            this.mVertCoords.put(f3);
            this.mVertCoords.put(f4);
            ++this.mOutstandingGlyphsVerticesPipeline;
            if (this.mOutstandingGlyphsVerticesPipeline >= 400) {
                this.draw();
            }
        }

        private void draw() {
            if (TextRenderer.this.useVertexArrays) {
                this.drawVertexArrays();
            } else {
                this.drawIMMEDIATE();
            }
        }

        private void drawVertexArrays() {
            if (this.mOutstandingGlyphsVerticesPipeline > 0) {
                GL2 gL2 = GLContext.getCurrentGL().getGL2();
                TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
                textureRenderer.getTexture();
                this.mVertCoords.rewind();
                this.mTexCoords.rewind();
                gL2.glEnableClientState(32884);
                if (this.usingVBOs) {
                    gL2.glBindBuffer(34962, this.mVBO_For_ResuableTileVertices);
                    gL2.glBufferSubData(34962, 0L, this.mOutstandingGlyphsVerticesPipeline * 12, this.mVertCoords);
                    gL2.glVertexPointer(3, 5126, 0, 0L);
                } else {
                    gL2.glVertexPointer(3, 5126, 0, this.mVertCoords);
                }
                gL2.glEnableClientState(32888);
                if (this.usingVBOs) {
                    gL2.glBindBuffer(34962, this.mVBO_For_ResuableTileTexCoords);
                    gL2.glBufferSubData(34962, 0L, this.mOutstandingGlyphsVerticesPipeline * 8, this.mTexCoords);
                    gL2.glTexCoordPointer(2, 5126, 0, 0L);
                } else {
                    gL2.glTexCoordPointer(2, 5126, 0, this.mTexCoords);
                }
                gL2.glDrawArrays(7, 0, this.mOutstandingGlyphsVerticesPipeline);
                this.mVertCoords.rewind();
                this.mTexCoords.rewind();
                this.mOutstandingGlyphsVerticesPipeline = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawIMMEDIATE() {
            if (this.mOutstandingGlyphsVerticesPipeline > 0) {
                TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
                textureRenderer.getTexture();
                GL2 gL2 = GLContext.getCurrentGL().getGL2();
                gL2.glBegin(7);
                try {
                    int n2 = this.mOutstandingGlyphsVerticesPipeline / 4;
                    this.mVertCoords.rewind();
                    this.mTexCoords.rewind();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        gL2.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gL2.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gL2.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gL2.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gL2.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gL2.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                        gL2.glTexCoord2f(this.mTexCoords.get(), this.mTexCoords.get());
                        gL2.glVertex3f(this.mVertCoords.get(), this.mVertCoords.get(), this.mVertCoords.get());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    gL2.glEnd();
                    this.mVertCoords.rewind();
                    this.mTexCoords.rewind();
                    this.mOutstandingGlyphsVerticesPipeline = 0;
                }
            }
        }

        public void dispose() {
            GL2 gL2 = GLContext.getCurrentGL().getGL2();
            int[] nArray = new int[]{this.mVBO_For_ResuableTileVertices, this.mVBO_For_ResuableTileTexCoords};
            gL2.glDeleteBuffers(2, IntBuffer.wrap(nArray));
        }
    }

    class Glyph {
        private int unicodeID;
        private int glyphCode;
        private GlyphProducer producer;
        private float advance;
        private GlyphVector singleUnicodeGlyphVector;
        private Rect glyphRectForTextureMapping;
        private String str;
        private boolean needAdvance;

        public Glyph(int n2, int n3, float f2, GlyphVector glyphVector, GlyphProducer glyphProducer) {
            this.unicodeID = n2;
            this.glyphCode = n3;
            this.advance = f2;
            this.singleUnicodeGlyphVector = glyphVector;
            this.producer = glyphProducer;
        }

        public Glyph(String string, boolean bl) {
            this.str = string;
            this.needAdvance = bl;
        }

        public int getUnicodeID() {
            return this.unicodeID;
        }

        public int getGlyphCode() {
            return this.glyphCode;
        }

        public float getAdvance() {
            return this.advance;
        }

        public float draw3D(float f2, float f3, float f4, float f5) {
            if (this.str != null) {
                TextRenderer.this.draw3D_ROBUST(this.str, f2, f3, f4, f5);
                if (!this.needAdvance) {
                    return 0.0f;
                }
                GlyphVector glyphVector = TextRenderer.this.font.createGlyphVector(TextRenderer.this.getFontRenderContext(), this.str);
                float f6 = 0.0f;
                for (int i2 = 0; i2 < glyphVector.getNumGlyphs(); ++i2) {
                    f6 += glyphVector.getGlyphMetrics(i2).getAdvance();
                }
                return f6;
            }
            if (this.glyphRectForTextureMapping == null) {
                this.upload();
            }
            try {
                if (TextRenderer.this.mPipelinedQuadRenderer == null) {
                    TextRenderer.this.mPipelinedQuadRenderer = new Pipelined_QuadRenderer();
                }
                TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
                TextureCoords textureCoords = textureRenderer.getTexture().getImageTexCoords();
                float f7 = textureCoords.right();
                float f8 = textureCoords.bottom();
                Rect rect = this.glyphRectForTextureMapping;
                TextData textData = (TextData)rect.getUserData();
                textData.markUsed();
                Rectangle2D rectangle2D = textData.origRect();
                float f9 = f2 - f5 * (float)textData.origOriginX();
                float f10 = f3 - f5 * ((float)rectangle2D.getHeight() - (float)textData.origOriginY());
                int n2 = rect.x() + (textData.origin().x - textData.origOriginX());
                int n3 = textureRenderer.getHeight() - rect.y() - (int)rectangle2D.getHeight() - (textData.origin().y - textData.origOriginY());
                int n4 = (int)rectangle2D.getWidth();
                int n5 = (int)rectangle2D.getHeight();
                float f11 = f7 * (float)n2 / (float)textureRenderer.getWidth();
                float f12 = f8 * (1.0f - (float)n3 / (float)textureRenderer.getHeight());
                float f13 = f7 * (float)(n2 + n4) / (float)textureRenderer.getWidth();
                float f14 = f8 * (1.0f - (float)(n3 + n5) / (float)textureRenderer.getHeight());
                TextRenderer.this.mPipelinedQuadRenderer.glTexCoord2f(f11, f12);
                TextRenderer.this.mPipelinedQuadRenderer.glVertex3f(f9, f10, f4);
                TextRenderer.this.mPipelinedQuadRenderer.glTexCoord2f(f13, f12);
                TextRenderer.this.mPipelinedQuadRenderer.glVertex3f(f9 + (float)n4 * f5, f10, f4);
                TextRenderer.this.mPipelinedQuadRenderer.glTexCoord2f(f13, f14);
                TextRenderer.this.mPipelinedQuadRenderer.glVertex3f(f9 + (float)n4 * f5, f10 + (float)n5 * f5, f4);
                TextRenderer.this.mPipelinedQuadRenderer.glTexCoord2f(f11, f14);
                TextRenderer.this.mPipelinedQuadRenderer.glVertex3f(f9, f10 + (float)n5 * f5, f4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this.advance;
        }

        public void clear() {
            this.glyphRectForTextureMapping = null;
        }

        private void upload() {
            GlyphVector glyphVector = this.getGlyphVector();
            Rectangle2D rectangle2D = TextRenderer.preNormalize(TextRenderer.this.renderDelegate.getBounds(glyphVector, TextRenderer.this.getFontRenderContext()));
            Rectangle2D rectangle2D2 = TextRenderer.this.normalize(rectangle2D);
            Point point = new Point((int)(-rectangle2D2.getMinX()), (int)(-rectangle2D2.getMinY()));
            Rect rect = new Rect(0, 0, (int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight(), new TextData(null, point, rectangle2D, this.unicodeID));
            TextRenderer.this.packer.add(rect);
            this.glyphRectForTextureMapping = rect;
            Graphics2D graphics2D = TextRenderer.this.getGraphics2D();
            int n2 = rect.x() + point.x;
            int n3 = rect.y() + point.y;
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
            graphics2D.setComposite(AlphaComposite.Src);
            TextRenderer.this.renderDelegate.drawGlyphVector(graphics2D, glyphVector, n2, n3);
            TextRenderer.this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
            this.producer.register(this);
        }

        private GlyphVector getGlyphVector() {
            GlyphVector glyphVector = this.singleUnicodeGlyphVector;
            if (glyphVector != null) {
                this.singleUnicodeGlyphVector = null;
                return glyphVector;
            }
            ((TextRenderer)TextRenderer.this).singleUnicode[0] = (char)this.unicodeID;
            return TextRenderer.this.font.createGlyphVector(TextRenderer.this.getFontRenderContext(), TextRenderer.this.singleUnicode);
        }
    }

    class DebugListener
    implements GLEventListener {
        private GLU glu;
        private Frame frame;

        DebugListener(GL gL, Frame frame) {
            this.glu = GLU.createGLU(gL);
            this.frame = frame;
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = GLContext.getCurrentGL().getGL2();
            gL2.glClear(16640);
            if (TextRenderer.this.packer == null) {
                return;
            }
            TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
            final int n2 = textureRenderer.getWidth();
            final int n3 = textureRenderer.getHeight();
            textureRenderer.beginOrthoRendering(n2, n3);
            textureRenderer.drawOrthoRect(0, 0);
            textureRenderer.endOrthoRendering();
            if (this.frame.getWidth() != n2 || this.frame.getHeight() != n3) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DebugListener.this.frame.setSize(n2, n3);
                    }
                });
            }
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            TextRenderer.this.mPipelinedQuadRenderer.dispose();
            this.glu = null;
            this.frame = null;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n2, int n3, int n4, int n5) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }

    private static class CharacterCache {
        static final Character[] cache = new Character[128];

        private CharacterCache() {
        }

        public static Character valueOf(char c2) {
            if (c2 <= '\u007f') {
                return cache[c2];
            }
            return Character.valueOf(c2);
        }

        static {
            for (int i2 = 0; i2 < cache.length; ++i2) {
                CharacterCache.cache[i2] = Character.valueOf((char)i2);
            }
        }
    }

    private static class CharSequenceIterator
    implements CharacterIterator {
        CharSequence mSequence;
        int mLength;
        int mCurrentIndex;

        CharSequenceIterator() {
        }

        CharSequenceIterator(CharSequence charSequence) {
            this.initFromCharSequence(charSequence);
        }

        public void initFromCharSequence(CharSequence charSequence) {
            this.mSequence = charSequence;
            this.mLength = this.mSequence.length();
            this.mCurrentIndex = 0;
        }

        @Override
        public char last() {
            this.mCurrentIndex = Math.max(0, this.mLength - 1);
            return this.current();
        }

        @Override
        public char current() {
            if (this.mLength == 0 || this.mCurrentIndex >= this.mLength) {
                return '\uffff';
            }
            return this.mSequence.charAt(this.mCurrentIndex);
        }

        @Override
        public char next() {
            ++this.mCurrentIndex;
            return this.current();
        }

        @Override
        public char previous() {
            this.mCurrentIndex = Math.max(this.mCurrentIndex - 1, 0);
            return this.current();
        }

        @Override
        public char setIndex(int n2) {
            this.mCurrentIndex = n2;
            return this.current();
        }

        @Override
        public int getBeginIndex() {
            return 0;
        }

        @Override
        public int getEndIndex() {
            return this.mLength;
        }

        @Override
        public int getIndex() {
            return this.mCurrentIndex;
        }

        @Override
        public Object clone() {
            CharSequenceIterator charSequenceIterator = new CharSequenceIterator(this.mSequence);
            charSequenceIterator.mCurrentIndex = this.mCurrentIndex;
            return charSequenceIterator;
        }

        @Override
        public char first() {
            if (this.mLength == 0) {
                return '\uffff';
            }
            this.mCurrentIndex = 0;
            return this.current();
        }
    }
}

