/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLDrawableUtil;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.TileRenderer;
import jogamp.opengl.Debug;

public abstract class TileRendererBase {
    public static final int TR_IMAGE_WIDTH = 1;
    public static final int TR_IMAGE_HEIGHT = 2;
    public static final int TR_CURRENT_TILE_X_POS = 3;
    public static final int TR_CURRENT_TILE_Y_POS = 4;
    public static final int TR_CURRENT_TILE_WIDTH = 5;
    public static final int TR_CURRENT_TILE_HEIGHT = 6;
    static final boolean DEBUG = Debug.debug("TileRenderer");
    protected final Dimension imageSize = new Dimension(0, 0);
    protected final GLPixelStorageModes psm = new GLPixelStorageModes();
    protected GLPixelBuffer imageBuffer;
    protected GLPixelBuffer tileBuffer;
    protected boolean beginCalled = false;
    protected int currentTileXPos;
    protected int currentTileYPos;
    protected int currentTileWidth;
    protected int currentTileHeight;
    protected GLAutoDrawable glad;
    protected boolean gladRequiresPreSwap;
    protected boolean gladAutoSwapBufferMode = true;
    protected GLEventListener[] listeners;
    protected boolean[] listenersInit;
    protected GLEventListener glEventListenerPre = null;
    protected GLEventListener glEventListenerPost = null;
    private final GLEventListener tiledGLEL = new GLEventListener(){
        final TileRenderer tileRenderer;
        {
            this.tileRenderer = TileRendererBase.this instanceof TileRenderer ? (TileRenderer)TileRendererBase.this : null;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            if (null != TileRendererBase.this.glEventListenerPre) {
                TileRendererBase.this.glEventListenerPre.init(gLAutoDrawable);
            }
            int n2 = TileRendererBase.this.listenersInit.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                GLEventListener gLEventListener = TileRendererBase.this.listeners[i2];
                if (TileRendererBase.this.listenersInit[i2] || !(gLEventListener instanceof TileRendererListener)) continue;
                gLEventListener.init(gLAutoDrawable);
                TileRendererBase.this.listenersInit[i2] = true;
            }
            if (null != TileRendererBase.this.glEventListenerPost) {
                TileRendererBase.this.glEventListenerPost.init(gLAutoDrawable);
            }
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            if (null != TileRendererBase.this.glEventListenerPre) {
                TileRendererBase.this.glEventListenerPre.dispose(gLAutoDrawable);
            }
            int n2 = TileRendererBase.this.listenersInit.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                TileRendererBase.this.listeners[i2].dispose(gLAutoDrawable);
            }
            if (null != TileRendererBase.this.glEventListenerPost) {
                TileRendererBase.this.glEventListenerPost.dispose(gLAutoDrawable);
            }
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GLEventListener gLEventListener;
            int n2;
            if (null != TileRendererBase.this.glEventListenerPre) {
                TileRendererBase.this.glEventListenerPre.reshape(gLAutoDrawable, 0, 0, TileRendererBase.this.currentTileWidth, TileRendererBase.this.currentTileHeight);
                TileRendererBase.this.glEventListenerPre.display(gLAutoDrawable);
            }
            if (!TileRendererBase.this.isSetup()) {
                if (DEBUG) {
                    System.err.println("TileRenderer.glel.display: !setup: " + TileRendererBase.this);
                }
                return;
            }
            if (TileRendererBase.this.eot()) {
                if (DEBUG) {
                    System.err.println("TileRenderer.glel.display: EOT: " + TileRendererBase.this);
                }
                return;
            }
            GL gL = gLAutoDrawable.getGL();
            TileRendererBase.this.beginTile(gL);
            int n3 = TileRendererBase.this.listenersInit.length;
            for (n2 = 0; n2 < n3; ++n2) {
                gLEventListener = TileRendererBase.this.listeners[n2];
                if (!(gLEventListener instanceof TileRendererListener)) continue;
                TileRendererListener tileRendererListener = (TileRendererListener)((Object)gLEventListener);
                if (null == this.tileRenderer || 0 == this.tileRenderer.getCurrentTile()) {
                    tileRendererListener.startTileRendering(TileRendererBase.this);
                }
                tileRendererListener.reshapeTile(TileRendererBase.this, TileRendererBase.this.currentTileXPos, TileRendererBase.this.currentTileYPos, TileRendererBase.this.currentTileWidth, TileRendererBase.this.currentTileHeight, TileRendererBase.this.imageSize.getWidth(), TileRendererBase.this.imageSize.getHeight());
                gLEventListener.display(gLAutoDrawable);
            }
            if (TileRendererBase.this.gladRequiresPreSwap) {
                TileRendererBase.this.glad.swapBuffers();
                TileRendererBase.this.endTile(gL);
            } else {
                TileRendererBase.this.endTile(gL);
                TileRendererBase.this.glad.swapBuffers();
            }
            if (null == this.tileRenderer || this.tileRenderer.eot()) {
                for (n2 = 0; n2 < n3; ++n2) {
                    gLEventListener = TileRendererBase.this.listeners[n2];
                    if (!(gLEventListener instanceof TileRendererListener)) continue;
                    ((TileRendererListener)((Object)gLEventListener)).endTileRendering(TileRendererBase.this);
                }
            }
            if (null != TileRendererBase.this.glEventListenerPost) {
                TileRendererBase.this.glEventListenerPost.reshape(gLAutoDrawable, 0, 0, TileRendererBase.this.currentTileWidth, TileRendererBase.this.currentTileHeight);
                TileRendererBase.this.glEventListenerPost.display(gLAutoDrawable);
            }
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n2, int n3, int n4, int n5) {
        }
    };

    private final String hashStr(Object object) {
        int n2 = null != object ? object.hashCode() : 0;
        return "0x" + Integer.toHexString(n2);
    }

    protected StringBuilder tileDetails(StringBuilder stringBuilder) {
        return stringBuilder.append("cur " + this.currentTileXPos + "/" + this.currentTileYPos + " " + this.currentTileWidth + "x" + this.currentTileHeight + ", buffer " + this.hashStr(this.tileBuffer));
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        int n2 = null != this.listeners ? this.listeners.length : 0;
        stringBuilder.append("tile[");
        this.tileDetails(stringBuilder);
        stringBuilder.append("], image[size " + this.imageSize + ", buffer " + this.hashStr(this.imageBuffer) + "], glad[" + n2 + " listener, pre " + (null != this.glEventListenerPre) + ", post " + (null != this.glEventListenerPost) + ", preSwap " + this.gladRequiresPreSwap + "]");
        stringBuilder.append(", isSetup " + this.isSetup());
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return this.getClass().getSimpleName() + "[" + this.toString(stringBuilder).toString() + "]";
    }

    protected TileRendererBase() {
    }

    public abstract int getParam(int var1) throws IllegalArgumentException;

    public final void setTileBuffer(GLPixelBuffer gLPixelBuffer) {
        this.tileBuffer = gLPixelBuffer;
        if (DEBUG) {
            System.err.println("TileRenderer: tile-buffer " + this.tileBuffer);
        }
    }

    public final GLPixelBuffer getTileBuffer() {
        return this.tileBuffer;
    }

    public void setImageSize(int n2, int n3) {
        this.imageSize.set(n2, n3);
    }

    public final DimensionImmutable getImageSize() {
        return this.imageSize;
    }

    public final void setImageBuffer(GLPixelBuffer gLPixelBuffer) {
        this.imageBuffer = gLPixelBuffer;
        if (DEBUG) {
            System.err.println("TileRenderer: image-buffer " + this.imageBuffer);
        }
    }

    public final GLPixelBuffer getImageBuffer() {
        return this.imageBuffer;
    }

    final void validateGL(GL gL) throws GLException {
        if (this.imageBuffer != null && !gL.isGL2ES3()) {
            throw new GLException("Using image-buffer w/ inssufficient GL context: " + gL.getContext().getGLVersion() + ", " + gL.getGLProfile());
        }
    }

    public abstract boolean isSetup();

    public abstract boolean eot();

    public abstract void reset();

    public abstract void beginTile(GL var1) throws IllegalStateException, GLException;

    public abstract void endTile(GL var1) throws IllegalStateException, GLException;

    public final boolean reqPreSwapBuffers(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return GLDrawableUtil.swapBuffersBeforeRead(gLCapabilitiesImmutable);
    }

    public final void attachAutoDrawable(GLAutoDrawable gLAutoDrawable) throws IllegalStateException {
        if (null != this.glad) {
            throw new IllegalStateException("GLAutoDrawable already attached");
        }
        this.glad = gLAutoDrawable;
        int n2 = gLAutoDrawable.getGLEventListenerCount();
        this.listeners = new GLEventListener[n2];
        this.listenersInit = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            GLEventListener gLEventListener = gLAutoDrawable.getGLEventListener(0);
            this.listenersInit[i2] = gLAutoDrawable.getGLEventListenerInitState(gLEventListener);
            this.listeners[i2] = gLAutoDrawable.removeGLEventListener(gLEventListener);
            if (this.listeners[i2] instanceof TileRendererListener) {
                bl = true;
                ((TileRendererListener)((Object)this.listeners[i2])).addTileRendererNotify(this);
            } else {
                bl = false;
            }
            if (!DEBUG) continue;
            System.err.println("TileRenderer.attach[" + i2 + "]: isInit " + this.listenersInit[i2] + ", isTRN " + bl + ", " + this.listeners[i2].getClass().getName());
        }
        gLAutoDrawable.addGLEventListener(this.tiledGLEL);
        this.gladAutoSwapBufferMode = gLAutoDrawable.getAutoSwapBufferMode();
        this.gladRequiresPreSwap = this.reqPreSwapBuffers(gLAutoDrawable.getChosenGLCapabilities());
        gLAutoDrawable.setAutoSwapBufferMode(false);
        if (DEBUG) {
            System.err.println("TileRenderer: attached: " + gLAutoDrawable);
            System.err.println("TileRenderer: preSwap " + this.gladRequiresPreSwap + ", " + gLAutoDrawable.getChosenGLCapabilities() + ", cached " + this.listeners.length + " listener");
        }
    }

    public final GLAutoDrawable getAttachedDrawable() {
        return this.glad;
    }

    public final void detachAutoDrawable() {
        if (null != this.glad) {
            this.glad.removeGLEventListener(this.tiledGLEL);
            int n2 = this.listenersInit.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                GLEventListener gLEventListener = this.listeners[i2];
                if (gLEventListener instanceof TileRendererListener) {
                    ((TileRendererListener)((Object)gLEventListener)).removeTileRendererNotify(this);
                }
                this.glad.addGLEventListener(gLEventListener);
                this.glad.setGLEventListenerInitState(gLEventListener, this.listenersInit[i2]);
            }
            this.glad.setAutoSwapBufferMode(this.gladAutoSwapBufferMode);
            if (DEBUG) {
                System.err.println("TileRenderer: detached: " + this.glad);
                System.err.println("TileRenderer: " + this.glad.getChosenGLCapabilities());
            }
            this.listeners = null;
            this.listenersInit = null;
            this.glad = null;
        }
    }

    public final void setGLEventListener(GLEventListener gLEventListener, GLEventListener gLEventListener2) {
        this.glEventListenerPre = gLEventListener;
        this.glEventListenerPost = gLEventListener2;
    }

    public final void display() throws IllegalStateException {
        if (null == this.glad) {
            throw new IllegalStateException("No GLAutoDrawable attached");
        }
        this.glad.display();
    }

    public static interface TileRendererListener {
        public void addTileRendererNotify(TileRendererBase var1);

        public void removeTileRendererNotify(TileRendererBase var1);

        public void reshapeTile(TileRendererBase var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public void startTileRendering(TileRendererBase var1);

        public void endTileRendering(TileRendererBase var1);
    }
}

