/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.TileRendererBase;

public class TileRenderer
extends TileRendererBase {
    public static final int TR_IMAGE_CLIPPING_WIDTH = 7;
    public static final int TR_IMAGE_CLIPPING_HEIGHT = 8;
    public static final int TR_TILE_WIDTH = 9;
    public static final int TR_TILE_HEIGHT = 10;
    public static final int TR_TILE_BORDER = 11;
    public static final int TR_TILE_X_OFFSET = 12;
    public static final int TR_TILE_Y_OFFSET = 13;
    public static final int TR_ROWS = 14;
    public static final int TR_COLUMNS = 15;
    public static final int TR_CURRENT_TILE_NUM = 16;
    public static final int TR_CURRENT_ROW = 17;
    public static final int TR_CURRENT_COLUMN = 18;
    public static final int TR_ROW_ORDER = 19;
    public static final int TR_TOP_TO_BOTTOM = 20;
    public static final int TR_BOTTOM_TO_TOP = 21;
    private static final int DEFAULT_TILE_WIDTH = 256;
    private static final int DEFAULT_TILE_HEIGHT = 256;
    private static final int DEFAULT_TILE_BORDER = 0;
    private final Dimension tileSize = new Dimension(256, 256);
    private final Dimension tileSizeNB = new Dimension(256, 256);
    private boolean isInit = false;
    private Dimension imageClippingDim = null;
    private int tileBorder = 0;
    private int rowOrder = 21;
    private int rows;
    private int columns;
    private int currentTile = 0;
    private int currentRow;
    private int currentColumn;
    private int offsetX;
    private int offsetY;

    @Override
    protected StringBuilder tileDetails(StringBuilder stringBuilder) {
        stringBuilder.append("# " + this.currentTile + ": [" + this.currentColumn + "][" + this.currentRow + "] / " + this.columns + "x" + this.rows + ", ").append("rowOrder " + this.rowOrder + ", offset/size " + this.offsetX + "/" + this.offsetY + " " + this.tileSize.getWidth() + "x" + this.tileSize.getHeight() + " brd " + this.tileBorder + ", ");
        return super.tileDetails(stringBuilder);
    }

    @Override
    public final void setImageSize(int n2, int n3) {
        super.setImageSize(n2, n3);
        this.reset();
    }

    public final void clipImageSize(int n2, int n3) {
        if (null == this.imageClippingDim) {
            this.imageClippingDim = new Dimension(n2, n3);
        } else {
            this.imageClippingDim.set(n2, n3);
        }
        this.reset();
    }

    public final DimensionImmutable getClippedImageSize() {
        if (null != this.imageClippingDim) {
            return new Dimension(Math.min(this.imageClippingDim.getWidth(), this.imageSize.getWidth()), Math.min(this.imageClippingDim.getHeight(), this.imageSize.getHeight()));
        }
        return this.imageSize;
    }

    public final void setTileSize(int n2, int n3, int n4) {
        if (0 > n4) {
            throw new IllegalArgumentException("Tile border must be >= 0");
        }
        if (2 * n4 >= n2 || 2 * n4 >= n3) {
            throw new IllegalArgumentException("Tile size must be > 0x0 minus 2*border");
        }
        this.tileBorder = n4;
        this.tileSize.set(n2, n3);
        this.tileSizeNB.set(n2 - 2 * n4, n3 - 2 * n4);
        this.reset();
    }

    public void setTileOffset(int n2, int n3) {
        this.offsetX = n2;
        this.offsetY = n3;
    }

    @Override
    public final void reset() {
        DimensionImmutable dimensionImmutable = this.getClippedImageSize();
        this.columns = (dimensionImmutable.getWidth() + this.tileSizeNB.getWidth() - 1) / this.tileSizeNB.getWidth();
        this.rows = (dimensionImmutable.getHeight() + this.tileSizeNB.getHeight() - 1) / this.tileSizeNB.getHeight();
        this.currentRow = 0;
        this.currentColumn = 0;
        this.currentTile = 0;
        this.currentTileXPos = 0;
        this.currentTileYPos = 0;
        this.currentTileWidth = 0;
        this.currentTileHeight = 0;
        assert (this.columns >= 0);
        assert (this.rows >= 0);
        this.beginCalled = false;
        this.isInit = true;
    }

    final int getCurrentTile() {
        return this.currentTile;
    }

    @Override
    public final int getParam(int n2) {
        switch (n2) {
            case 1: {
                return this.imageSize.getWidth();
            }
            case 2: {
                return this.imageSize.getHeight();
            }
            case 3: {
                return this.currentTileXPos;
            }
            case 4: {
                return this.currentTileYPos;
            }
            case 5: {
                return this.currentTileWidth;
            }
            case 6: {
                return this.currentTileHeight;
            }
            case 7: {
                return null != this.imageClippingDim ? this.imageClippingDim.getWidth() : 0;
            }
            case 8: {
                return null != this.imageClippingDim ? this.imageClippingDim.getHeight() : 0;
            }
            case 9: {
                return this.tileSize.getWidth();
            }
            case 10: {
                return this.tileSize.getHeight();
            }
            case 11: {
                return this.tileBorder;
            }
            case 12: {
                return this.offsetX;
            }
            case 13: {
                return this.offsetY;
            }
            case 14: {
                return this.rows;
            }
            case 15: {
                return this.columns;
            }
            case 16: {
                return this.currentTile;
            }
            case 17: {
                return this.currentRow;
            }
            case 18: {
                return this.currentColumn;
            }
            case 19: {
                return this.rowOrder;
            }
        }
        throw new IllegalArgumentException("Invalid pname: " + n2);
    }

    public final void setRowOrder(int n2) {
        if (n2 != 20 && n2 != 21) {
            throw new IllegalArgumentException("Must pass TR_TOP_TO_BOTTOM or TR_BOTTOM_TO_TOP");
        }
        this.rowOrder = n2;
    }

    @Override
    public final boolean isSetup() {
        return 0 < this.imageSize.getWidth() && 0 < this.imageSize.getHeight();
    }

    @Override
    public final boolean eot() {
        if (!this.isInit) {
            this.reset();
        }
        return 0 > this.currentTile || 0 >= this.columns * this.rows;
    }

    @Override
    public final void beginTile(GL gL) throws IllegalStateException, GLException {
        if (!this.isSetup()) {
            throw new IllegalStateException("Image size has not been set: " + this);
        }
        if (this.eot()) {
            throw new IllegalStateException("EOT reached: " + this);
        }
        this.validateGL(gL);
        if (this.rowOrder == 21) {
            this.currentRow = this.currentTile / this.columns;
            this.currentColumn = this.currentTile % this.columns;
        } else {
            this.currentRow = this.rows - this.currentTile / this.columns - 1;
            this.currentColumn = this.currentTile % this.columns;
        }
        assert (this.currentRow < this.rows);
        assert (this.currentColumn < this.columns);
        int n2 = this.tileBorder;
        DimensionImmutable dimensionImmutable = this.getClippedImageSize();
        int n3 = this.currentRow < this.rows - 1 ? this.tileSize.getHeight() : dimensionImmutable.getHeight() - (this.rows - 1) * this.tileSizeNB.getHeight() + 2 * n2;
        int n4 = this.currentColumn < this.columns - 1 ? this.tileSize.getWidth() : dimensionImmutable.getWidth() - (this.columns - 1) * this.tileSizeNB.getWidth() + 2 * n2;
        this.currentTileXPos = this.currentColumn * this.tileSizeNB.getWidth() + this.offsetX;
        this.currentTileYPos = this.currentRow * this.tileSizeNB.getHeight() + this.offsetY;
        this.currentTileWidth = n4;
        this.currentTileHeight = n3;
        gL.glViewport(0, 0, n4, n3);
        if (DEBUG) {
            System.err.println("TileRenderer.begin: " + this.toString());
        }
        this.beginCalled = true;
    }

    @Override
    public void endTile(GL gL) throws IllegalStateException, GLException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes;
        int n7;
        GL2ES3 gL2ES3;
        if (!this.beginCalled) {
            throw new IllegalStateException("beginTile(..) has not been called");
        }
        this.validateGL(gL);
        gL.glFlush();
        this.psm.setPackAlignment(gL, 1);
        if (gL.isGL2ES3()) {
            gL2ES3 = gL.getGL2ES3();
            n7 = gL2ES3.getDefaultReadBuffer();
            gL2ES3.glReadBuffer(n7);
        } else {
            gL2ES3 = null;
            n7 = 0;
        }
        if (DEBUG) {
            System.err.println("TileRenderer.end.0: readBuffer 0x" + Integer.toHexString(n7) + ", " + this.toString());
        }
        int[] nArray = new int[1];
        if (this.tileBuffer != null) {
            gLPixelAttributes = this.tileBuffer.pixelAttributes;
            n6 = this.tileBorder;
            n5 = this.tileBorder;
            n4 = this.tileSizeNB.getWidth();
            n3 = this.tileSizeNB.getHeight();
            n2 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.pfmt.comp.bytesPerPixel(), n4, n3, 1, true);
            this.tileBuffer.clear();
            if (this.tileBuffer.requiresNewBuffer(gL, n4, n3, n2)) {
                throw new IndexOutOfBoundsException("Required " + n2 + " bytes of buffer, only had " + this.tileBuffer);
            }
            gL.glReadPixels(n6, n5, n4, n3, gLPixelAttributes.format, gLPixelAttributes.type, this.tileBuffer.buffer);
            gL.glFlush();
            this.tileBuffer.position(n2);
            this.tileBuffer.flip();
        }
        if (this.imageBuffer != null) {
            gLPixelAttributes = this.imageBuffer.pixelAttributes;
            n6 = this.tileBorder;
            n5 = this.tileBorder;
            n4 = this.currentTileWidth - 2 * this.tileBorder;
            n3 = this.currentTileHeight - 2 * this.tileBorder;
            n2 = this.imageSize.getWidth();
            this.psm.setPackRowLength(gL2ES3, n2);
            int n8 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.pfmt.comp.bytesPerPixel(), n4, n3, 1, true);
            int n9 = this.currentColumn * this.tileSizeNB.getWidth();
            int n10 = this.currentRow * this.tileSizeNB.getHeight();
            int n11 = (n9 + n10 * n2) * gLPixelAttributes.pfmt.comp.bytesPerPixel();
            int n12 = n11 + n8;
            this.imageBuffer.clear();
            if (this.imageBuffer.requiresNewBuffer(gL, n4, n3, n8)) {
                throw new IndexOutOfBoundsException("Required " + n12 + " bytes of buffer, only had " + this.imageBuffer);
            }
            this.imageBuffer.position(n11);
            gL.glReadPixels(n6, n5, n4, n3, gLPixelAttributes.format, gLPixelAttributes.type, this.imageBuffer.buffer);
            gL.glFlush();
            this.imageBuffer.position(n12);
            this.imageBuffer.flip();
        }
        this.psm.restore(gL);
        this.beginCalled = false;
        ++this.currentTile;
        if (this.currentTile >= this.rows * this.columns) {
            this.currentTile = -1;
        }
    }
}

