/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;

public class GLPixelBuffer {
    public static final GLPixelBufferProvider defaultProviderNoRowStride = new DefaultGLPixelBufferProvider(false);
    public static final GLPixelBufferProvider defaultProviderWithRowStride = new DefaultGLPixelBufferProvider(true);
    public final GLPixelAttributes pixelAttributes;
    public final int width;
    public final int height;
    public final int depth;
    public final boolean pack;
    public final int byteSize;
    public final Buffer buffer;
    public final int bufferElemSize;
    public final boolean allowRowStride;
    private boolean disposed = false;

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(this.pixelAttributes).append(", dim ").append(this.width).append("x").append(this.height).append("x").append(this.depth).append(", pack ").append(this.pack).append(", disposed ").append(this.disposed).append(", valid ").append(this.isValid()).append(", buffer[bytes ").append(this.byteSize).append(", elemSize ").append(this.bufferElemSize).append(", ").append(this.buffer).append("]");
        return stringBuilder;
    }

    public String toString() {
        return "GLPixelBuffer[" + this.toString(null).toString() + "]";
    }

    public GLPixelBuffer(GLPixelAttributes gLPixelAttributes, boolean bl, int n2, int n3, int n4, Buffer buffer, boolean bl2) {
        this.pixelAttributes = gLPixelAttributes;
        this.width = n2;
        this.height = n3;
        this.depth = n4;
        this.pack = bl;
        this.buffer = buffer;
        this.byteSize = Buffers.remainingBytes(buffer);
        this.bufferElemSize = Buffers.sizeOfBufferElem(buffer);
        this.allowRowStride = bl2;
    }

    public final boolean getAllowRowStride() {
        return this.allowRowStride;
    }

    public boolean isValid() {
        return !this.disposed && 0 < this.byteSize;
    }

    public Buffer rewind() {
        return this.buffer.rewind();
    }

    public int position() {
        return this.buffer.position() * this.bufferElemSize;
    }

    public Buffer position(int n2) {
        return this.buffer.position(n2 / this.bufferElemSize);
    }

    public int capacity() {
        return this.buffer.capacity() * this.bufferElemSize;
    }

    public int limit() {
        return this.buffer.limit() * this.bufferElemSize;
    }

    public Buffer flip() {
        return this.buffer.flip();
    }

    public Buffer clear() {
        return this.buffer.clear();
    }

    public boolean requiresNewBuffer(GL gL, int n2, int n3, int n4) {
        if (!this.isValid()) {
            return true;
        }
        if (0 >= n4) {
            int[] nArray = new int[]{0};
            n4 = GLBuffers.sizeof(gL, nArray, this.pixelAttributes.pfmt.comp.bytesPerPixel(), n2, n3, 1, true);
        }
        if (this.allowRowStride) {
            return this.byteSize < n4;
        }
        return this.byteSize < n4 || this.width != n2;
    }

    public void dispose() {
        this.disposed = true;
        this.buffer.clear();
    }

    public static class GLPixelAttributes {
        public static final GLPixelAttributes UNDEF = new GLPixelAttributes(null, PixelFormat.LUMINANCE, 0, 0, true, false);
        public final int format;
        public final int type;
        public final PixelFormat pfmt;

        public static final PixelFormat getPixelFormat(int n2, int n3) {
            PixelFormat pixelFormat = null;
            block0 : switch (n2) {
                case 6403: 
                case 6406: 
                case 6409: {
                    pixelFormat = PixelFormat.LUMINANCE;
                    break;
                }
                case 6407: {
                    switch (n3) {
                        case 33636: {
                            pixelFormat = PixelFormat.RGB565;
                            break;
                        }
                        case 33635: {
                            pixelFormat = PixelFormat.BGR565;
                            break;
                        }
                        case 5121: {
                            pixelFormat = PixelFormat.RGB888;
                        }
                    }
                    break;
                }
                case 6408: {
                    switch (n3) {
                        case 33638: {
                            pixelFormat = PixelFormat.RGBA5551;
                            break;
                        }
                        case 32820: {
                            pixelFormat = PixelFormat.ABGR1555;
                            break;
                        }
                        case 5121: 
                        case 33639: {
                            pixelFormat = PixelFormat.RGBA8888;
                            break;
                        }
                        case 32821: {
                            pixelFormat = PixelFormat.ABGR8888;
                        }
                    }
                    break;
                }
                case 32992: {
                    if (5121 != n3) break;
                    pixelFormat = PixelFormat.BGR888;
                    break;
                }
                case 32993: {
                    switch (n3) {
                        case 32821: {
                            pixelFormat = PixelFormat.ARGB8888;
                            break block0;
                        }
                        case 5121: 
                        case 33639: {
                            pixelFormat = PixelFormat.BGRA8888;
                        }
                    }
                }
            }
            return pixelFormat;
        }

        public static GLPixelAttributes convert(GL gL, int n2, boolean bl) {
            int n3;
            int n4;
            boolean bl2;
            boolean bl3 = bl2 = bl && gL.isGLES();
            if (1 == n2 && !bl2) {
                n4 = gL.isGL3ES3() ? 6403 : 6406;
                n3 = 5121;
            } else if (3 == n2 && !bl2) {
                n4 = 6407;
                n3 = 5121;
            } else if (4 == n2 || bl2) {
                GLContext gLContext = gL.getContext();
                int n5 = gLContext.getDefaultPixelDataFormat();
                int n6 = GLBuffers.componentCount(n5);
                if (n6 == n2 || 4 == n6) {
                    int n7 = gLContext.getDefaultPixelDataType();
                    PixelFormat pixelFormat = GLPixelAttributes.getPixelFormat(n5, n7);
                    if (null != pixelFormat) {
                        return new GLPixelAttributes(null, pixelFormat, n5, n7, bl, true);
                    }
                    if (GLContext.DEBUG) {
                        System.err.println("GLPixelAttributes.convert(" + gL.getGLProfile() + ", comps " + n2 + ", pack " + bl + "): GL-impl default unsupported: [fmt 0x" + Integer.toHexString(n5) + ", type 0x" + Integer.toHexString(n7) + "]: Using std RGBA+UBYTE");
                        Thread.dumpStack();
                    }
                }
                n4 = 6408;
                n3 = 5121;
            } else {
                return null;
            }
            return new GLPixelAttributes(n4, n3);
        }

        public static final GLPixelAttributes convert(GLProfile gLProfile, PixelFormat pixelFormat, boolean bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GLPixelAttributes.convert(gLProfile, pixelFormat, bl, nArray, nArray2);
            if (0 != nArray[0]) {
                return new GLPixelAttributes(null, pixelFormat, nArray[0], nArray2[0], true, true);
            }
            return null;
        }

        private static final int convert(GLProfile gLProfile, PixelFormat pixelFormat, boolean bl, int[] nArray, int[] nArray2) {
            boolean bl2 = bl && gLProfile.isGLES();
            int n2 = 0;
            int n3 = 5121;
            switch (pixelFormat) {
                case LUMINANCE: {
                    if (bl2) break;
                    if (gLProfile.isGL3ES3()) {
                        n2 = 6403;
                        break;
                    }
                    n2 = 6409;
                    break;
                }
                case RGB565: {
                    if (!gLProfile.isGL2GL3()) break;
                    n2 = 6407;
                    n3 = 33636;
                    break;
                }
                case BGR565: {
                    if (!gLProfile.isGL2GL3()) break;
                    n2 = 6407;
                    n3 = 33635;
                    break;
                }
                case RGBA5551: {
                    if (!gLProfile.isGL2GL3()) break;
                    n2 = 6408;
                    n3 = 33638;
                    break;
                }
                case ABGR1555: {
                    if (!gLProfile.isGL2GL3()) break;
                    n2 = 6408;
                    n3 = 32820;
                    break;
                }
                case RGB888: {
                    if (bl2) break;
                    n2 = 6407;
                    break;
                }
                case BGR888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n2 = 32992;
                    break;
                }
                case RGBx8888: 
                case RGBA8888: {
                    n2 = 6408;
                    break;
                }
                case ABGR8888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n2 = 6408;
                    n3 = 32821;
                    break;
                }
                case ARGB8888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n2 = 32993;
                    n3 = 32821;
                    break;
                }
                case BGRx8888: 
                case BGRA8888: {
                    if (!gLProfile.isGL2GL3()) break;
                    n2 = 32993;
                }
            }
            nArray[0] = n2;
            nArray2[0] = n3;
            return n2;
        }

        public final int hashCode() {
            int n2 = this.pfmt.hashCode();
            n2 = (n2 << 5) - n2 + this.format;
            return (n2 << 5) - n2 + this.type;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof GLPixelAttributes) {
                GLPixelAttributes gLPixelAttributes = (GLPixelAttributes)object;
                return this.format == gLPixelAttributes.format && this.type == gLPixelAttributes.type && this.pfmt.equals((Object)gLPixelAttributes.pfmt);
            }
            return false;
        }

        public GLPixelAttributes(int n2, int n3) throws GLException {
            this(null, null, n2, n3, true, true);
        }

        public GLPixelAttributes(GLProfile gLProfile, PixelFormat pixelFormat, boolean bl) throws GLException {
            this(gLProfile, pixelFormat, 0, 0, bl, true);
        }

        private GLPixelAttributes(GLProfile gLProfile, PixelFormat pixelFormat, int n2, int n3, boolean bl, boolean bl2) throws GLException {
            int n4;
            if (bl2 && (0 == n2 || 0 == n3)) {
                if (null == pixelFormat || null == gLProfile) {
                    throw new GLException("Zero format and/or type w/o pixFmt or glp: " + this);
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (0 == GLPixelAttributes.convert(gLProfile, pixelFormat, bl, nArray, nArray2)) {
                    throw new GLException("Could not find format and type for " + (Object)((Object)pixelFormat) + " and " + gLProfile + ", " + this);
                }
                this.format = nArray[0];
                this.type = nArray2[0];
                this.pfmt = pixelFormat;
            } else {
                this.format = n2;
                this.type = n3;
                PixelFormat pixelFormat2 = this.pfmt = null != pixelFormat ? pixelFormat : GLPixelAttributes.getPixelFormat(n2, n3);
                if (null == this.pfmt) {
                    throw new GLException("Could not find PixelFormat for format and/or type: " + this);
                }
            }
            if (bl2 && 0 == (n4 = GLBuffers.bytesPerPixel(this.format, this.type))) {
                throw new GLException("Zero bytesPerPixel: " + this);
            }
        }

        public String toString() {
            return "PixelAttributes[fmt 0x" + Integer.toHexString(this.format) + ", type 0x" + Integer.toHexString(this.type) + ", " + (Object)((Object)this.pfmt) + "]";
        }
    }

    public static class DefaultGLPixelBufferProvider
    implements GLPixelBufferProvider {
        private final boolean allowRowStride;

        public DefaultGLPixelBufferProvider(boolean bl) {
            this.allowRowStride = bl;
        }

        @Override
        public boolean getAllowRowStride() {
            return this.allowRowStride;
        }

        @Override
        public GLPixelAttributes getAttributes(GL gL, int n2, boolean bl) {
            GLPixelAttributes gLPixelAttributes = GLPixelAttributes.convert(gL, n2, bl);
            if (null == gLPixelAttributes) {
                throw new GLException("Unsupported componentCount " + n2 + ", contact maintainer to enhance");
            }
            return gLPixelAttributes;
        }

        @Override
        public PixelFormat.Composition getHostPixelComp(GLProfile gLProfile, int n2) {
            return null;
        }

        @Override
        public GLPixelBuffer allocate(GL gL, PixelFormat.Composition composition, GLPixelAttributes gLPixelAttributes, boolean bl, int n2, int n3, int n4, int n5) {
            if (n5 > 0) {
                return new GLPixelBuffer(gLPixelAttributes, bl, n2, n3, n4, Buffers.newDirectByteBuffer(n5), this.getAllowRowStride());
            }
            int[] nArray = new int[]{0};
            int n6 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.pfmt.comp.bytesPerPixel(), n2, n3, n4, bl);
            return new GLPixelBuffer(gLPixelAttributes, bl, n2, n3, n4, Buffers.newDirectByteBuffer(n6), this.getAllowRowStride());
        }
    }

    public static interface GLPixelBufferProvider {
        public boolean getAllowRowStride();

        public GLPixelAttributes getAttributes(GL var1, int var2, boolean var3);

        public PixelFormat.Composition getHostPixelComp(GLProfile var1, int var2);

        public GLPixelBuffer allocate(GL var1, PixelFormat.Composition var2, GLPixelAttributes var3, boolean var4, int var5, int var6, int var7, int var8);
    }

    public static interface SingletonGLPixelBufferProvider
    extends GLPixelBufferProvider {
        @Override
        public GLPixelBuffer allocate(GL var1, PixelFormat.Composition var2, GLPixelAttributes var3, boolean var4, int var5, int var6, int var7, int var8);

        public GLPixelBuffer getSingleBuffer(PixelFormat.Composition var1, GLPixelAttributes var2, boolean var3);

        public GLPixelBuffer initSingleton(GLProfile var1, int var2, boolean var3, int var4, int var5, int var6);

        public void dispose();
    }
}

