/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.fixedfunc.GLPointerFuncUtil;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.Debug;

public class GLArrayDataWrapper
implements GLArrayData {
    public static final boolean DEBUG = Debug.debug("GLArrayData");
    protected boolean alive;
    protected int index;
    protected int location;
    protected String name;
    protected int componentsPerElement;
    protected int componentType;
    protected Class<?> componentClazz;
    protected int componentByteSize;
    protected boolean normalized;
    protected int strideB;
    protected int strideL;
    protected Buffer buffer;
    protected int mappedElementCount;
    protected boolean isVertexAttribute;
    protected long vboOffset;
    protected int vboName;
    protected boolean vboEnabled;
    protected int vboUsage;
    protected int vboTarget;

    public static GLArrayDataWrapper createFixed(int n2, int n3, int n4, boolean bl, int n5, Buffer buffer, int n6, long l2, int n7, int n8) throws GLException {
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(null, n2, n3, n4, bl, n5, buffer, 0, false, n6, l2, n7, n8);
        return gLArrayDataWrapper;
    }

    public static GLArrayDataWrapper createFixed(int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, long l2, int n8, int n9) throws GLException {
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(null, n2, n3, n4, bl, n5, null, n6, false, n7, l2, n8, n9);
        return gLArrayDataWrapper;
    }

    public static GLArrayDataWrapper createGLSL(String string, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, long l2, int n6, int n7) throws GLException {
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(string, -1, n2, n3, bl, n4, buffer, 0, true, n5, l2, n6, n7);
        return gLArrayDataWrapper;
    }

    public static GLArrayDataWrapper createGLSL(String string, int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, int n8) throws GLException {
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(string, -1, n2, n3, bl, n4, null, n5, true, n6, l2, n7, n8);
        return gLArrayDataWrapper;
    }

    public final boolean validate(GLProfile gLProfile, boolean bl) {
        if (!this.alive) {
            if (bl) {
                throw new GLException("Instance !alive " + this);
            }
            return false;
        }
        if (this.isVertexAttribute() && !gLProfile.hasGLSL()) {
            if (bl) {
                throw new GLException("GLSL not supported on " + gLProfile + ", " + this);
            }
            return false;
        }
        return gLProfile.isValidArrayDataType(this.getIndex(), this.getComponentCount(), this.getComponentType(), this.isVertexAttribute(), bl);
    }

    @Override
    public void associate(Object object, boolean bl) {
    }

    @Override
    public final boolean isVertexAttribute() {
        return this.isVertexAttribute;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final int getLocation() {
        return this.location;
    }

    @Override
    public final int setLocation(int n2) {
        this.location = n2;
        return this.location;
    }

    @Override
    public final int setLocation(GL2ES2 gL2ES2, int n2) {
        this.location = gL2ES2.glGetAttribLocation(n2, this.name);
        return this.location;
    }

    @Override
    public final int setLocation(GL2ES2 gL2ES2, int n2, int n3) {
        this.location = n3;
        gL2ES2.glBindAttribLocation(n2, n3, this.name);
        return n3;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getVBOOffset() {
        return this.vboEnabled ? this.vboOffset : 0L;
    }

    @Override
    public final int getVBOName() {
        return this.vboEnabled ? this.vboName : 0;
    }

    @Override
    public final boolean isVBO() {
        return this.vboEnabled;
    }

    @Override
    public final int getVBOUsage() {
        return this.vboEnabled ? this.vboUsage : 0;
    }

    @Override
    public final int getVBOTarget() {
        return this.vboEnabled ? this.vboTarget : 0;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final int getComponentCount() {
        return this.componentsPerElement;
    }

    @Override
    public final int getComponentType() {
        return this.componentType;
    }

    @Override
    public final int getComponentSizeInBytes() {
        return this.componentByteSize;
    }

    @Override
    public final int getElementCount() {
        if (0 != this.mappedElementCount) {
            return this.mappedElementCount;
        }
        if (null != this.buffer) {
            int n2 = 0 == this.buffer.position() ? this.buffer.limit() : this.buffer.position();
            return n2 * this.componentByteSize / this.strideB;
        }
        return 0;
    }

    @Override
    public final int getSizeInBytes() {
        if (0 != this.mappedElementCount) {
            return this.mappedElementCount * this.componentsPerElement * this.componentByteSize;
        }
        if (null != this.buffer) {
            return this.buffer.position() == 0 ? this.buffer.limit() * this.componentByteSize : this.buffer.position() * this.componentByteSize;
        }
        return 0;
    }

    @Override
    public final boolean getNormalized() {
        return this.normalized;
    }

    @Override
    public final int getStride() {
        return this.strideB;
    }

    public final Class<?> getBufferClass() {
        return this.componentClazz;
    }

    @Override
    public void destroy(GL gL) {
        this.buffer = null;
        this.vboName = 0;
        this.vboEnabled = false;
        this.vboOffset = 0L;
        this.alive = false;
    }

    @Override
    public String toString() {
        return "GLArrayDataWrapper[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", dataType 0x" + Integer.toHexString(this.componentType) + ", bufferClazz " + this.componentClazz + ", elements " + this.getElementCount() + ", components " + this.componentsPerElement + ", stride " + this.strideB + "b " + this.strideL + "c, mappedElementCount " + this.mappedElementCount + ", buffer " + this.buffer + ", vboEnabled " + this.vboEnabled + ", vboName " + this.vboName + ", vboUsage 0x" + Integer.toHexString(this.vboUsage) + ", vboTarget 0x" + Integer.toHexString(this.vboTarget) + ", vboOffset " + this.vboOffset + ", alive " + this.alive + "]";
    }

    public static final Class<?> getBufferClass(int n2) {
        switch (n2) {
            case 5120: 
            case 5121: {
                return ByteBuffer.class;
            }
            case 5122: 
            case 5123: {
                return ShortBuffer.class;
            }
            case 5124: 
            case 5125: 
            case 5132: {
                return IntBuffer.class;
            }
            case 5126: {
                return FloatBuffer.class;
            }
        }
        throw new GLException("Given OpenGL data type not supported: " + n2);
    }

    @Override
    public void setName(String string) {
        this.location = -1;
        this.name = string;
    }

    public void setVBOEnabled(boolean bl) {
        this.vboEnabled = bl;
    }

    public void setVBOName(int n2) {
        this.vboName = n2;
        this.setVBOEnabled(0 != n2);
    }

    public void setVBOUsage(int n2) {
        this.vboUsage = n2;
    }

    public void setVBOTarget(int n2) {
        this.vboTarget = n2;
    }

    protected void init(String string, int n2, int n3, int n4, boolean bl, int n5, Buffer buffer, int n6, boolean bl2, int n7, long l2, int n8, int n9) throws GLException {
        if (0 < n6 && null != buffer) {
            throw new IllegalArgumentException("mappedElementCount:=" + n6 + " specified, but passing non null buffer");
        }
        this.isVertexAttribute = bl2;
        this.index = n2;
        this.location = -1;
        if (34963 != n9) {
            if (0 == n8 && 0 == n9 || 34962 == n9) {
                String string2 = this.name = null == string ? GLPointerFuncUtil.getPredefinedArrayIndexName(n2) : string;
                if (null == this.name) {
                    throw new GLException("Not a valid array buffer index: " + n2);
                }
            } else if (0 < n9) {
                throw new GLException("Invalid GPUBuffer target: 0x" + Integer.toHexString(n9));
            }
        }
        this.componentType = n4;
        this.componentClazz = GLArrayDataWrapper.getBufferClass(n4);
        this.normalized = GLBuffers.isGLTypeFixedPoint(n4) ? bl : false;
        this.componentByteSize = GLBuffers.sizeOfGLType(n4);
        if (0 > this.componentByteSize) {
            throw new GLException("Given componentType not supported: " + n4 + ":\n\t" + this);
        }
        if (0 >= n3) {
            throw new GLException("Invalid number of components: " + n3);
        }
        this.componentsPerElement = n3;
        if (0 < n5 && n5 < n3 * this.componentByteSize) {
            throw new GLException("stride (" + n5 + ") lower than component bytes, " + n3 + " * " + this.componentByteSize);
        }
        if (0 < n5 && n5 % this.componentByteSize != 0) {
            throw new GLException("stride (" + n5 + ") not a multiple of bpc " + this.componentByteSize);
        }
        this.buffer = buffer;
        this.mappedElementCount = n6;
        this.strideB = 0 == n5 ? n3 * this.componentByteSize : n5;
        this.strideL = this.strideB / this.componentByteSize;
        this.vboName = n7;
        this.vboEnabled = 0 != n7;
        this.vboOffset = l2;
        switch (n8) {
            case 0: 
            case 35040: 
            case 35044: 
            case 35048: {
                break;
            }
            default: {
                throw new GLException("invalid gpuBufferUsage: " + n8 + ":\n\t" + this);
            }
        }
        switch (n9) {
            case 0: 
            case 34962: 
            case 34963: {
                break;
            }
            default: {
                throw new GLException("invalid gpuBufferTarget: " + n9 + ":\n\t" + this);
            }
        }
        this.vboUsage = n8;
        this.vboTarget = n9;
        this.alive = true;
    }

    protected GLArrayDataWrapper() {
    }

    public GLArrayDataWrapper(GLArrayDataWrapper gLArrayDataWrapper) {
        this.alive = gLArrayDataWrapper.alive;
        this.index = gLArrayDataWrapper.index;
        this.location = gLArrayDataWrapper.location;
        this.name = gLArrayDataWrapper.name;
        this.componentsPerElement = gLArrayDataWrapper.componentsPerElement;
        this.componentType = gLArrayDataWrapper.componentType;
        this.componentClazz = gLArrayDataWrapper.componentClazz;
        this.componentByteSize = gLArrayDataWrapper.componentByteSize;
        this.normalized = gLArrayDataWrapper.normalized;
        this.strideB = gLArrayDataWrapper.strideB;
        this.strideL = gLArrayDataWrapper.strideL;
        this.buffer = null != gLArrayDataWrapper.buffer ? (gLArrayDataWrapper.buffer.position() == 0 ? Buffers.slice(gLArrayDataWrapper.buffer) : Buffers.slice(gLArrayDataWrapper.buffer, 0, gLArrayDataWrapper.buffer.limit())) : null;
        this.mappedElementCount = gLArrayDataWrapper.mappedElementCount;
        this.isVertexAttribute = gLArrayDataWrapper.isVertexAttribute;
        this.vboOffset = gLArrayDataWrapper.vboOffset;
        this.vboName = gLArrayDataWrapper.vboName;
        this.vboEnabled = gLArrayDataWrapper.vboEnabled;
        this.vboUsage = gLArrayDataWrapper.vboUsage;
        this.vboTarget = gLArrayDataWrapper.vboTarget;
    }
}

