/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class EGLClientPixmapHI {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] EGLClientPixmapHI_size = new int[]{16, 16, 16, 16, 16, 16, 16, 24, 24, 24};
    private static final int[] pData_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] iWidth_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 8, 8, 8};
    private static final int[] iHeight_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 12, 12, 12};
    private static final int[] iStride_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 16, 16, 16};

    public static int size() {
        return EGLClientPixmapHI_size[mdIdx];
    }

    public static EGLClientPixmapHI create() {
        return EGLClientPixmapHI.create(Buffers.newDirectByteBuffer(EGLClientPixmapHI.size()));
    }

    public static EGLClientPixmapHI create(ByteBuffer byteBuffer) {
        return new EGLClientPixmapHI(byteBuffer);
    }

    EGLClientPixmapHI(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[EGLClientPixmapHI.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public EGLClientPixmapHI setPData(long l2) {
        this.accessor.setLongAt(pData_offset[mdIdx], l2, this.md.pointerSizeInBytes());
        return this;
    }

    public long getPData() {
        return this.accessor.getLongAt(pData_offset[mdIdx], this.md.pointerSizeInBytes());
    }

    public EGLClientPixmapHI setIWidth(int n2) {
        this.accessor.setIntAt(iWidth_offset[mdIdx], n2);
        return this;
    }

    public int getIWidth() {
        return this.accessor.getIntAt(iWidth_offset[mdIdx]);
    }

    public EGLClientPixmapHI setIHeight(int n2) {
        this.accessor.setIntAt(iHeight_offset[mdIdx], n2);
        return this;
    }

    public int getIHeight() {
        return this.accessor.getIntAt(iHeight_offset[mdIdx]);
    }

    public EGLClientPixmapHI setIStride(int n2) {
        this.accessor.setIntAt(iStride_offset[mdIdx], n2);
        return this;
    }

    public int getIStride() {
        return this.accessor.getIntAt(iStride_offset[mdIdx]);
    }
}

