/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.math.FloatUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GLUniformData {
    private String name;
    private int location;
    private int rows;
    private int columns;
    private int count;
    private Object data;
    private boolean isMatrix;

    public GLUniformData(String string, int n2) {
        this.initScalar(string, 1, n2);
    }

    public GLUniformData(String string, float f2) {
        this.initScalar(string, 1, Float.valueOf(f2));
    }

    public GLUniformData(String string, int n2, IntBuffer intBuffer) {
        this.initBuffer(string, n2, intBuffer);
    }

    public GLUniformData(String string, int n2, FloatBuffer floatBuffer) {
        this.initBuffer(string, n2, floatBuffer);
    }

    private GLUniformData(int n2, String string) {
        this.initBuffer(string, n2, null);
    }

    public static GLUniformData creatEmptyVector(String string, int n2) {
        return new GLUniformData(n2, string);
    }

    public static GLUniformData creatEmptyMatrix(String string, int n2, int n3) {
        return new GLUniformData(string, n2, n3, null);
    }

    public GLUniformData(String string, int n2, int n3, FloatBuffer floatBuffer) {
        this.initBuffer(string, n2, n3, floatBuffer);
    }

    public GLUniformData setData(int n2) {
        this.initScalar(n2);
        return this;
    }

    public GLUniformData setData(float f2) {
        this.initScalar(Float.valueOf(f2));
        return this;
    }

    public GLUniformData setData(IntBuffer intBuffer) {
        this.initBuffer(intBuffer);
        return this;
    }

    public GLUniformData setData(FloatBuffer floatBuffer) {
        this.initBuffer(floatBuffer);
        return this;
    }

    public int intValue() {
        return (Integer)this.data;
    }

    public float floatValue() {
        return ((Float)this.data).floatValue();
    }

    public IntBuffer intBufferValue() {
        return (IntBuffer)this.data;
    }

    public FloatBuffer floatBufferValue() {
        return (FloatBuffer)this.data;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("GLUniformData[name ").append(this.name).append(", location ").append(this.location).append(", size ").append(this.rows).append("x").append(this.columns).append(", count ").append(this.count).append(", data ");
        if (this.isMatrix() && this.data instanceof FloatBuffer) {
            stringBuilder.append("\n");
            FloatBuffer floatBuffer = (FloatBuffer)this.getBuffer();
            for (int i2 = 0; i2 < this.count; ++i2) {
                FloatUtil.matrixToString(stringBuilder, i2 + ": ", "%10.5f", floatBuffer, i2 * this.rows * this.columns, this.rows, this.columns, false);
                stringBuilder.append(",\n");
            }
        } else if (this.isBuffer()) {
            Buffers.toString(stringBuilder, null, this.getBuffer());
        } else {
            stringBuilder.append(this.data);
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    private void initBuffer(String string, int n2, int n3, Buffer buffer) {
        if (2 > n2 || n2 > 4 || 2 > n3 || n3 > 4) {
            throw new GLException("rowsXcolumns must be within [2..4]X[2..4], is: " + n2 + "X" + n3);
        }
        this.name = string;
        this.rows = n2;
        this.columns = n3;
        this.isMatrix = true;
        this.location = -1;
        this.initBuffer(buffer);
    }

    private void initScalar(String string, int n2, Object object) {
        if (1 > n2 || n2 > 4) {
            throw new GLException("components must be within [1..4], is: " + n2);
        }
        this.name = string;
        this.columns = n2;
        this.rows = 1;
        this.isMatrix = false;
        this.location = -1;
        this.initScalar(object);
    }

    private void initBuffer(String string, int n2, Buffer buffer) {
        if (1 > n2 || n2 > 4) {
            throw new GLException("components must be within [1..4], is: " + n2);
        }
        this.name = string;
        this.columns = n2;
        this.rows = 1;
        this.isMatrix = false;
        this.location = -1;
        this.initBuffer(buffer);
    }

    private void initScalar(Object object) {
        if (object instanceof Buffer) {
            this.initBuffer((Buffer)object);
        } else if (null != object) {
            if (this.isMatrix) {
                throw new GLException("Atom type not allowed for matrix : " + this);
            }
            this.count = 1;
            this.data = object;
        } else {
            this.count = 0;
            this.data = object;
        }
    }

    private void initBuffer(Buffer buffer) {
        if (null != buffer) {
            int n2 = this.rows * this.columns;
            if (buffer.remaining() < n2 || 0 != buffer.remaining() % n2) {
                throw new GLException("remaining data buffer size invalid: buffer: " + buffer.toString() + "\n\t" + this);
            }
            this.count = buffer.remaining() / n2;
            this.data = buffer;
        } else {
            this.count = 0;
            this.data = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getLocation() {
        return this.location;
    }

    public int setLocation(int n2) {
        this.location = n2;
        return n2;
    }

    public int setLocation(GL2ES2 gL2ES2, int n2) {
        this.location = gL2ES2.glGetUniformLocation(n2, this.name);
        return this.location;
    }

    public Object getObject() {
        return this.data;
    }

    public Buffer getBuffer() {
        return this.data instanceof Buffer ? (Buffer)this.data : null;
    }

    public boolean isBuffer() {
        return this.data instanceof Buffer;
    }

    public boolean isMatrix() {
        return this.isMatrix;
    }

    public int count() {
        return this.count;
    }

    public int components() {
        return this.rows * this.columns;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }
}

