/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLImage2d;
import com.jogamp.opencl.gl.CLGLTexture;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.CLImageFormatImpl;
import java.nio.Buffer;

public class CLGLTexture2d<B extends Buffer>
extends CLGLImage2d<B>
implements CLGLTexture {
    public final int target;
    public final int mipMapLevel;

    public CLGLTexture2d(CLContext cLContext, B b2, CLImageFormat cLImageFormat, CLImage.CLImageInfoAccessor cLImageInfoAccessor, int n2, int n3, int n4, int n5, long l2, int n6, int n7) {
        super(cLContext, b2, cLImageFormat, cLImageInfoAccessor, n4, n5, l2, n6, n7);
        this.target = n2;
        this.mipMapLevel = n3;
    }

    static <B extends Buffer> CLGLTexture2d<B> createFromGLTexture2d(CLContext cLContext, B b2, int n2, int n3, int n4, int n5) {
        CLGLBuffer.checkBuffer(b2, n5);
        CL cL = CLGLTexture2d.getCL(cLContext);
        int[] nArray = new int[1];
        long l2 = cL.clCreateFromGLTexture2D(cLContext.ID, n5, n2, n4, n3, nArray, 0);
        CLException.checkForError(nArray[0], "can not create CLGLTexture2d from texture #" + n3 + ".");
        CLImage.CLImageInfoAccessor cLImageInfoAccessor = new CLImage.CLImageInfoAccessor(cL, l2);
        CLImageFormat cLImageFormat = CLGLTexture2d.createUninitializedImageFormat();
        cLImageInfoAccessor.getInfo(4368, CLImageFormatImpl.size(), cLImageFormat.getFormatImpl().getBuffer(), null);
        int n6 = (int)cLImageInfoAccessor.getLong(4372);
        int n7 = (int)cLImageInfoAccessor.getLong(4373);
        return new CLGLTexture2d<B>(cLContext, b2, cLImageFormat, cLImageInfoAccessor, n2, n4, n6, n7, l2, n3, n5);
    }

    @Override
    public int getTextureTarget() {
        return this.target;
    }

    @Override
    public int getMipMapLevel() {
        return this.mipMapLevel;
    }

    @Override
    public CLMemory.GLObjectType getGLObjectType() {
        return CLMemory.GLObjectType.GL_OBJECT_TEXTURE2D;
    }
}

