/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.impl.CLTLInfoAccessor;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;

public class CLSampler
extends CLObjectResource {
    private final CLSamplerInfoAccessor samplerInfo;
    private final CL binding;

    private CLSampler(CLContext cLContext, long l2, AddressingMode addressingMode, FilteringMode filteringMode, boolean bl) {
        super(cLContext, l2);
        this.binding = cLContext.getPlatform().getCLBinding();
        this.samplerInfo = new CLSamplerInfoAccessor();
    }

    static CLSampler create(CLContext cLContext, AddressingMode addressingMode, FilteringMode filteringMode, boolean bl) {
        int[] nArray = new int[1];
        CL cL = cLContext.getPlatform().getCLBinding();
        long l2 = cL.clCreateSampler(cLContext.ID, CLUtil.clBoolean(bl), addressingMode.MODE, filteringMode.MODE, nArray, 0);
        CLException.checkForError(nArray[0], "can not create sampler");
        return new CLSampler(cLContext, l2, addressingMode, filteringMode, bl);
    }

    public FilteringMode getFilteringMode() {
        int n2 = (int)this.samplerInfo.getLong(4436);
        return FilteringMode.valueOf(n2);
    }

    public AddressingMode getAddressingMode() {
        int n2 = (int)this.samplerInfo.getLong(4435);
        return AddressingMode.valueOf(n2);
    }

    public boolean hasNormalizedCoords() {
        return this.samplerInfo.getLong(4434) == 1L;
    }

    @Override
    public void release() {
        super.release();
        int n2 = this.binding.clReleaseSampler(this.ID);
        this.context.onSamplerReleased(this);
        if (n2 != 0) {
            throw CLException.newException(n2, "can not release " + this);
        }
    }

    private class CLSamplerInfoAccessor
    extends CLTLInfoAccessor {
        private CLSamplerInfoAccessor() {
        }

        @Override
        protected int getInfo(int n2, long l2, Buffer buffer, PointerBuffer pointerBuffer) {
            return CLSampler.this.binding.clGetSamplerInfo(CLSampler.this.ID, n2, l2, buffer, pointerBuffer);
        }
    }

    public static enum AddressingMode {
        REPEAT(4403),
        CLAMP_TO_EDGE(4401),
        CLAMP(4402),
        NONE(4400);

        public final int MODE;

        private AddressingMode(int n3) {
            this.MODE = n3;
        }

        public static AddressingMode valueOf(int n2) {
            switch (n2) {
                case 4403: {
                    return REPEAT;
                }
                case 4401: {
                    return CLAMP_TO_EDGE;
                }
                case 4402: {
                    return CLAMP;
                }
                case 4400: {
                    return NONE;
                }
            }
            return null;
        }
    }

    public static enum FilteringMode {
        NEAREST(4416),
        LINEAR(4417);

        public final int MODE;

        private FilteringMode(int n3) {
            this.MODE = n3;
        }

        public static FilteringMode valueOf(int n2) {
            switch (n2) {
                case 4416: {
                    return NEAREST;
                }
                case 4417: {
                    return LINEAR;
                }
            }
            return null;
        }
    }
}

