/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLProperty;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.impl.CLTLAccessorFactory;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.CLImpl11;
import com.jogamp.opencl.llb.impl.CLImpl12;
import com.jogamp.opencl.llb.impl.CLImpl20;
import com.jogamp.opencl.spi.CLAccessorFactory;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.spi.CLPlatformInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import com.jogamp.opencl.util.Filter;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class CLPlatform {
    public final long ID;
    public final CLVersion version;
    protected static CL cl;
    private static CLAccessorFactory defaultFactory;
    private final CLAccessorFactory factory;
    private Set<String> extensions;
    protected final CLPlatformInfoAccessor info;

    private CLPlatform(long l2) {
        this(l2, null);
    }

    protected CLPlatform(long l2, CLAccessorFactory cLAccessorFactory) {
        CLPlatform.initialize();
        this.ID = l2;
        this.factory = cLAccessorFactory == null ? defaultFactory : cLAccessorFactory;
        this.info = this.factory.createPlatformInfoAccessor(cl, l2);
        this.version = new CLVersion(this.getInfoString(2305));
    }

    public static boolean isAvailable() {
        return CLImpl11.isAvailable();
    }

    public static void initialize() throws JogampRuntimeException {
        CLPlatform.initialize(null);
    }

    static synchronized void initialize(CLAccessorFactory cLAccessorFactory) throws JogampRuntimeException {
        if (cl != null) {
            return;
        }
        if (defaultFactory == null) {
            defaultFactory = cLAccessorFactory == null ? new CLTLAccessorFactory() : cLAccessorFactory;
        }
        if (!CLImpl11.isAvailable()) {
            throw new JogampRuntimeException("JOCL is not available");
        }
        cl = new CLImpl11();
    }

    public static CLPlatform getDefault() {
        CLPlatform.initialize();
        return CLPlatform.latest(CLPlatform.listCLPlatforms());
    }

    public static CLPlatform getDefault(Filter<CLPlatform> ... filterArray) {
        CLPlatform[] cLPlatformArray = CLPlatform.listCLPlatforms(filterArray);
        if (cLPlatformArray.length > 0) {
            return CLPlatform.latest(cLPlatformArray);
        }
        return null;
    }

    private static CLPlatform latest(CLPlatform[] cLPlatformArray) {
        CLPlatform cLPlatform = cLPlatformArray[0];
        for (CLPlatform cLPlatform2 : cLPlatformArray) {
            if (cLPlatform2.version.compareTo(cLPlatform.version) <= 0) continue;
            cLPlatform = cLPlatform2;
        }
        return cLPlatform;
    }

    public static CLPlatform[] listCLPlatforms() {
        return CLPlatform.listCLPlatforms(null);
    }

    public static CLPlatform[] listCLPlatforms(Filter<CLPlatform> ... filterArray) {
        CLPlatform.initialize();
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        int n2 = cl.clGetPlatformIDs(0, null, intBuffer);
        CLException.checkForError(n2, "can not enumerate platforms");
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(intBuffer.get(0));
        n2 = cl.clGetPlatformIDs(pointerBuffer.capacity(), pointerBuffer, null);
        CLException.checkForError(n2, "can not enumerate platforms");
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < pointerBuffer.capacity(); ++i2) {
            CLPlatform cLPlatform = new CLPlatform(pointerBuffer.get(i2));
            CLPlatform.addIfAccepted(cLPlatform, arrayList, filterArray);
        }
        return arrayList.toArray(new CLPlatform[arrayList.size()]);
    }

    public static CL getLowLevelCLInterface() {
        CLPlatform.initialize();
        return cl;
    }

    public static CL getLowLevelCLInterfaceForDevice(long l2) {
        CLPlatform.initialize();
        CLInfoAccessor cLInfoAccessor = defaultFactory.createDeviceInfoAccessor(cl, l2);
        CLVersion cLVersion = new CLVersion(cLInfoAccessor.getString(4143));
        if (cLVersion.isEqual(CLVersion.CL_1_2)) {
            return new CLImpl12();
        }
        if (cLVersion.isEqual(CLVersion.CL_2_0)) {
            return new CLImpl20();
        }
        return cl;
    }

    public static void unloadCompiler() {
        CLPlatform.initialize();
        int n2 = cl.clUnloadCompiler();
        CLException.checkForError(n2, "error while sending unload compiler hint");
    }

    public CLDevice[] listCLDevices() {
        try {
            return this.listCLDevices(CLDevice.Type.ALL);
        }
        catch (CLException.CLInvalidDeviceTypeException cLInvalidDeviceTypeException) {
            return this.listCLDevices(CLDevice.Type.GPU);
        }
    }

    public CLDevice[] listCLDevices(CLDevice.Type ... typeArray) {
        CLPlatform.initialize();
        ArrayList<CLDevice> arrayList = new ArrayList<CLDevice>();
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            CLDevice.Type type = typeArray[i2];
            long[] lArray = this.info.getDeviceIDs(type.TYPE);
            for (int i3 = 0; i3 < lArray.length; ++i3) {
                arrayList.add(this.createDevice(lArray[i3]));
            }
        }
        return arrayList.toArray(new CLDevice[arrayList.size()]);
    }

    public CLDevice[] listCLDevices(Filter<CLDevice> ... filterArray) {
        CLPlatform.initialize();
        ArrayList arrayList = new ArrayList();
        long[] lArray = this.info.getDeviceIDs(0xFFFFFFFFL);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            CLDevice cLDevice = this.createDevice(lArray[i2]);
            CLPlatform.addIfAccepted(cLDevice, arrayList, filterArray);
        }
        return arrayList.toArray(new CLDevice[arrayList.size()]);
    }

    protected CLDevice createDevice(long l2) {
        return new CLDevice(this, l2);
    }

    private static <I> void addIfAccepted(I i2, List<I> list, Filter<I>[] filterArray) {
        if (filterArray == null) {
            list.add(i2);
        } else {
            boolean bl = true;
            for (Filter<I> filter : filterArray) {
                if (filter.accept(i2)) continue;
                bl = false;
                break;
            }
            if (bl) {
                list.add(i2);
            }
        }
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] cLDeviceArray) {
        return CLPlatform.findMaxFlopsDevice(cLDeviceArray, null);
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] cLDeviceArray, CLDevice.Type type) {
        CLPlatform.initialize();
        CLDevice cLDevice = null;
        int n2 = -1;
        for (int i2 = 0; i2 < cLDeviceArray.length; ++i2) {
            int n3;
            int n4;
            int n5;
            CLDevice cLDevice2 = cLDeviceArray[i2];
            if (type != null && !type.equals((Object)cLDevice2.getType()) || (n5 = (n4 = cLDevice2.getMaxComputeUnits()) * (n3 = cLDevice2.getMaxClockFrequency())) <= n2) continue;
            n2 = n5;
            cLDevice = cLDevice2;
        }
        return cLDevice;
    }

    public CLDevice getMaxFlopsDevice() {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices());
    }

    public CLDevice getMaxFlopsDevice(CLDevice.Type ... typeArray) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(typeArray));
    }

    public CLDevice getMaxFlopsDevice(Filter<CLDevice> ... filterArray) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(filterArray));
    }

    @CLProperty(value="CL_PLATFORM_NAME")
    public String getName() {
        return this.getInfoString(2306);
    }

    @CLProperty(value="CL_PLATFORM_VERSION")
    public CLVersion getVersion() {
        return this.version;
    }

    public String getSpecVersion() {
        return this.version.getSpecVersion();
    }

    public boolean isAtLeast(CLVersion cLVersion) {
        return this.version.isAtLeast(cLVersion);
    }

    public boolean isAtLeast(int n2, int n3) {
        return this.version.isAtLeast(n2, n3);
    }

    @CLProperty(value="CL_PLATFORM_PROFILE")
    public String getProfile() {
        return this.getInfoString(2304);
    }

    @CLProperty(value="CL_PLATFORM_VENDOR")
    public String getVendor() {
        return this.getInfoString(2307);
    }

    public boolean isVendorAMD() {
        return this.getVendor().contains("Advanced Micro Devices");
    }

    public boolean isVendorIntel() {
        return this.getVendor().contains("Intel");
    }

    @CLProperty(value="CL_PLATFORM_ICD_SUFFIX_KHR")
    public String getICDSuffix() {
        return this.getInfoString(2336);
    }

    public boolean isExtensionAvailable(String string) {
        return this.getExtensions().contains(string);
    }

    @CLProperty(value="CL_PLATFORM_EXTENSIONS")
    public synchronized Set<String> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashSet<String>();
            String string = this.getInfoString(2308);
            Scanner scanner = new Scanner(string);
            while (scanner.hasNext()) {
                this.extensions.add(scanner.next());
            }
            scanner.close();
            this.extensions = Collections.unmodifiableSet(this.extensions);
        }
        return this.extensions;
    }

    public Map<String, String> getProperties() {
        return CLUtil.obtainPlatformProperties(this);
    }

    public final String getInfoString(int n2) {
        return this.info.getString(n2);
    }

    final CLAccessorFactory getAccessorFactory() {
        return this.factory;
    }

    public final CLPlatformInfoAccessor getCLAccessor() {
        return this.info;
    }

    protected CL getCLBinding() {
        return cl;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name: " + this.getName() + ", vendor: " + this.getVendor() + ", profile: " + this.getProfile() + ", version: " + this.getVersion() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLPlatform cLPlatform = (CLPlatform)object;
        return this.ID == cLPlatform.ID;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 71 * n2 + (int)(this.ID ^ this.ID >>> 32);
        return n2;
    }
}

