/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class CLKernel
extends CLObjectResource
implements Cloneable {
    public final String name;
    public final int numArgs;
    private final CLProgram program;
    private final CL binding;
    private final ByteBuffer buffer;
    private int argIndex;
    private boolean force32BitArgs;

    CLKernel(CLProgram cLProgram, long l2) {
        this(cLProgram, null, l2);
    }

    CLKernel(CLProgram cLProgram, String string, long l2) {
        super(cLProgram.getContext(), l2);
        this.program = cLProgram;
        this.buffer = Buffers.newDirectByteBuffer((Platform.is32Bit() ? 4 : 8) * 3);
        this.binding = cLProgram.getPlatform().getCLBinding();
        if (string == null) {
            PointerBuffer pointerBuffer = PointerBuffer.wrap(this.buffer);
            int n2 = this.binding.clGetKernelInfo(this.ID, 4496, 0L, null, pointerBuffer);
            CLException.checkForError(n2, "error while asking for kernel function name");
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)pointerBuffer.get(0));
            n2 = this.binding.clGetKernelInfo(this.ID, 4496, byteBuffer.capacity(), byteBuffer, null);
            CLException.checkForError(n2, "error while asking for kernel function name");
            this.name = CLUtil.clString2JavaString(byteBuffer, byteBuffer.capacity());
        } else {
            this.name = string;
        }
        int n3 = this.binding.clGetKernelInfo(this.ID, 4497, this.buffer.capacity(), this.buffer, null);
        CLException.checkForError(n3, "error while asking for number of function arguments.");
        this.numArgs = this.buffer.getInt(0);
    }

    public CLKernel putArg(CLMemory<?> cLMemory) {
        this.setArg(this.argIndex, cLMemory);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(short s) {
        this.setArg(this.argIndex, s);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(int n2) {
        this.setArg(this.argIndex, n2);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(long l2) {
        this.setArg(this.argIndex, l2);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(float f2) {
        this.setArg(this.argIndex, f2);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(double d2) {
        this.setArg(this.argIndex, d2);
        ++this.argIndex;
        return this;
    }

    public CLKernel putNullArg(int n2) {
        this.setNullArg(this.argIndex, n2);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArgs(CLMemory<?> ... cLMemoryArray) {
        this.setArgs(this.argIndex, cLMemoryArray);
        this.argIndex += cLMemoryArray.length;
        return this;
    }

    public CLKernel rewind() {
        this.argIndex = 0;
        return this;
    }

    public int position() {
        return this.argIndex;
    }

    public CLKernel setArg(int n2, CLMemory<?> cLMemory) {
        this.setArgument(n2, Platform.is32Bit() ? 4 : 8, this.wrap(cLMemory.ID));
        return this;
    }

    public CLKernel setArg(int n2, short s) {
        this.setArgument(n2, 2, this.wrap(s));
        return this;
    }

    public CLKernel setArg(int n2, int n3) {
        this.setArgument(n2, 4, this.wrap(n3));
        return this;
    }

    public CLKernel setArg(int n2, long l2) {
        if (this.force32BitArgs) {
            this.setArgument(n2, 4, this.wrap((int)l2));
        } else {
            this.setArgument(n2, 8, this.wrap(l2));
        }
        return this;
    }

    public CLKernel setArg(int n2, float f2) {
        this.setArgument(n2, 4, this.wrap(f2));
        return this;
    }

    public CLKernel setArg(int n2, double d2) {
        if (this.force32BitArgs) {
            this.setArgument(n2, 4, this.wrap((float)d2));
        } else {
            this.setArgument(n2, 8, this.wrap(d2));
        }
        return this;
    }

    public CLKernel setNullArg(int n2, int n3) {
        this.setArgument(n2, n3, null);
        return this;
    }

    public CLKernel setArgs(CLMemory<?> ... cLMemoryArray) {
        this.setArgs(0, cLMemoryArray);
        return this;
    }

    public CLKernel setArgs(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("values array was empty or null.");
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (object instanceof CLMemory) {
                this.setArg(i2, (CLMemory)object);
                continue;
            }
            if (object instanceof Short) {
                this.setArg(i2, (Short)object);
                continue;
            }
            if (object instanceof Integer) {
                this.setArg(i2, (Integer)object);
                continue;
            }
            if (object instanceof Long) {
                this.setArg(i2, (Long)object);
                continue;
            }
            if (object instanceof Float) {
                this.setArg(i2, ((Float)object).floatValue());
                continue;
            }
            if (object instanceof Double) {
                this.setArg(i2, (Double)object);
                continue;
            }
            throw new IllegalArgumentException(object + " is not a valid argument.");
        }
        return this;
    }

    private void setArgs(int n2, CLMemory<?> ... cLMemoryArray) {
        for (int i2 = 0; i2 < cLMemoryArray.length; ++i2) {
            this.setArg(i2 + n2, cLMemoryArray[i2]);
        }
    }

    private void setArgument(int n2, int n3, Buffer buffer) {
        if (n2 >= this.numArgs || n2 < 0) {
            throw new IndexOutOfBoundsException("kernel " + this + " has " + this.numArgs + " arguments, can not set argument with index " + n2);
        }
        if (!this.program.isExecutable()) {
            throw new IllegalStateException("can not set program arguments for a not executable program. " + this.program);
        }
        int n4 = this.binding.clSetKernelArg(this.ID, n2, n3, buffer);
        if (n4 != 0) {
            throw CLException.newException(n4, "error setting arg " + n2 + " to value " + buffer + " of size " + n3 + " of " + this);
        }
    }

    public CLKernel setForce32BitArgs(boolean bl) {
        this.force32BitArgs = bl;
        return this;
    }

    public CLProgram getProgram() {
        return this.program;
    }

    public boolean isForce32BitArgsEnabled() {
        return this.force32BitArgs;
    }

    private Buffer wrap(float f2) {
        return this.buffer.putFloat(0, f2);
    }

    private Buffer wrap(double d2) {
        return this.buffer.putDouble(0, d2);
    }

    private Buffer wrap(short s) {
        return this.buffer.putShort(0, s);
    }

    private Buffer wrap(int n2) {
        return this.buffer.putInt(0, n2);
    }

    private Buffer wrap(long l2) {
        return this.buffer.putLong(0, l2);
    }

    public long getLocalMemorySize(CLDevice cLDevice) {
        return this.getWorkGroupInfo(cLDevice, 4530);
    }

    public long getWorkGroupSize(CLDevice cLDevice) {
        return this.getWorkGroupInfo(cLDevice, 4528);
    }

    public long[] getCompileWorkGroupSize(CLDevice cLDevice) {
        int n2 = this.binding.clGetKernelWorkGroupInfo(this.ID, cLDevice.ID, 4529, (Platform.is32Bit() ? 4 : 8) * 3, this.buffer, null);
        if (n2 != 0) {
            throw CLException.newException(n2, "error while asking for CL_KERNEL_COMPILE_WORK_GROUP_SIZE of " + this + " on " + cLDevice);
        }
        if (Platform.is32Bit()) {
            return new long[]{this.buffer.getInt(0), this.buffer.getInt(4), this.buffer.getInt(8)};
        }
        return new long[]{this.buffer.getLong(0), this.buffer.getLong(8), this.buffer.getLong(16)};
    }

    private long getWorkGroupInfo(CLDevice cLDevice, int n2) {
        int n3 = this.binding.clGetKernelWorkGroupInfo(this.ID, cLDevice.ID, n2, 8L, this.buffer, null);
        if (n3 != 0) {
            throw CLException.newException(n3, "error while asking for clGetKernelWorkGroupInfo of " + this + " on " + cLDevice);
        }
        return this.buffer.getLong(0);
    }

    @Override
    public void release() {
        super.release();
        int n2 = this.binding.clReleaseKernel(this.ID);
        this.program.onKernelReleased(this);
        if (n2 != 0) {
            throw CLException.newException(n2, "can not release " + this);
        }
    }

    @Override
    public String toString() {
        return "CLKernel [id: " + this.ID + " name: " + this.name + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLKernel cLKernel = (CLKernel)object;
        if (this.ID != cLKernel.ID) {
            return false;
        }
        return this.program.equals(cLKernel.program);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 43 * n2 + (int)(this.ID ^ this.ID >>> 32);
        n2 = 43 * n2 + (this.program != null ? this.program.hashCode() : 0);
        return n2;
    }

    public CLKernel clone() {
        return this.program.createCLKernel(this.name).setForce32BitArgs(this.force32BitArgs);
    }
}

