/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLEventListener;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.impl.CLTLInfoAccessor;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.CLEventCallback;
import java.nio.Buffer;

public class CLEvent
extends CLObjectResource {
    private final CLEventInfoAccessor eventInfo;
    private final CLEventProfilingInfoAccessor eventProfilingInfo;
    private final CL binding;

    CLEvent(CLContext cLContext, long l2) {
        super(cLContext, l2);
        this.binding = cLContext.getPlatform().getCLBinding();
        this.eventInfo = new CLEventInfoAccessor();
        this.eventProfilingInfo = new CLEventProfilingInfoAccessor();
    }

    public void registerCallback(CLEventListener cLEventListener) {
        this.registerCallback(cLEventListener, ExecutionStatus.COMPLETE);
    }

    private void registerCallback(final CLEventListener cLEventListener, ExecutionStatus executionStatus) {
        this.binding.clSetEventCallback(this.ID, executionStatus.STATUS, new CLEventCallback(){

            @Override
            public void eventStateChanged(long l2, int n2) {
                cLEventListener.eventStateChanged(CLEvent.this, n2);
            }
        });
    }

    @Override
    public void release() {
        super.release();
        int n2 = this.binding.clReleaseEvent(this.ID);
        CLException.checkForError(n2, "can not release event");
    }

    public ExecutionStatus getStatus() {
        return ExecutionStatus.valueOf(this.getStatusCode());
    }

    public boolean isComplete() {
        return ExecutionStatus.COMPLETE.equals((Object)this.getStatus());
    }

    public int getStatusCode() {
        return (int)this.eventInfo.getLong(4563);
    }

    public CommandType getType() {
        int n2 = (int)this.eventInfo.getLong(4561);
        return CommandType.valueOf(n2);
    }

    public long getProfilingInfo(ProfilingCommand profilingCommand) {
        return this.eventProfilingInfo.getLong(profilingCommand.COMMAND);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + " name: " + (Object)((Object)this.getType()) + " status: " + (Object)((Object)this.getStatus()) + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLEvent cLEvent = (CLEvent)object;
        if (!(this.context == cLEvent.context || this.context != null && this.context.equals(cLEvent.context))) {
            return false;
        }
        return this.ID == cLEvent.ID;
    }

    public int hashCode() {
        int n2 = 5;
        n2 = 13 * n2 + (this.context != null ? this.context.hashCode() : 0);
        n2 = 13 * n2 + (int)(this.ID ^ this.ID >>> 32);
        return n2;
    }

    private class CLEventInfoAccessor
    extends CLTLInfoAccessor {
        private CLEventInfoAccessor() {
        }

        @Override
        protected int getInfo(int n2, long l2, Buffer buffer, PointerBuffer pointerBuffer) {
            return CLEvent.this.binding.clGetEventInfo(CLEvent.this.ID, n2, l2, buffer, pointerBuffer);
        }
    }

    private class CLEventProfilingInfoAccessor
    extends CLTLInfoAccessor {
        private CLEventProfilingInfoAccessor() {
        }

        @Override
        protected int getInfo(int n2, long l2, Buffer buffer, PointerBuffer pointerBuffer) {
            return CLEvent.this.binding.clGetEventProfilingInfo(CLEvent.this.ID, n2, l2, buffer, pointerBuffer);
        }
    }

    public static enum ExecutionStatus {
        QUEUED(3),
        SUBMITTED(2),
        RUNNING(1),
        COMPLETE(0),
        ERROR(-1);

        public final int STATUS;

        private ExecutionStatus(int n3) {
            this.STATUS = n3;
        }

        public static ExecutionStatus valueOf(int n2) {
            switch (n2) {
                case 3: {
                    return QUEUED;
                }
                case 2: {
                    return SUBMITTED;
                }
                case 1: {
                    return RUNNING;
                }
                case 0: {
                    return COMPLETE;
                }
            }
            if (n2 < 0) {
                return ERROR;
            }
            return null;
        }
    }

    public static enum CommandType {
        NDRANGE_KERNEL(4592),
        TASK(4593),
        NATIVE_KERNEL(4594),
        READ_BUFFER(4595),
        WRITE_BUFFER(4596),
        COPY_BUFFER(4597),
        READ_IMAGE(4598),
        WRITE_IMAGE(4599),
        COPY_IMAGE(4600),
        COPY_BUFFER_TO_IMAGE(4602),
        COPY_IMAGE_TO_BUFFER(4601),
        MAP_BUFFER(4603),
        MAP_IMAGE(4604),
        UNMAP_MEM_OBJECT(4605),
        MARKER(4606),
        READ_BUFFER_RECT(4609),
        WRITE_BUFFER_RECT(4610),
        COPY_BUFFER_RECT(4611),
        USER(4612),
        ACQUIRE_GL_OBJECTS(4607),
        RELEASE_GL_OBJECTS(4608),
        GL_FENCE_SYNC_OBJECT_KHR(8205);

        public final int TYPE;

        private CommandType(int n3) {
            this.TYPE = n3;
        }

        public static CommandType valueOf(int n2) {
            CommandType[] commandTypeArray;
            for (CommandType commandType : commandTypeArray = CommandType.values()) {
                if (commandType.TYPE != n2) continue;
                return commandType;
            }
            return null;
        }
    }

    public static enum ProfilingCommand {
        QUEUED(4736),
        SUBMIT(4737),
        START(4738),
        END(4739);

        public final int COMMAND;

        private ProfilingCommand(int n3) {
            this.COMMAND = n3;
        }

        public static ProfilingCommand valueOf(int n2) {
            switch (n2) {
                case 4736: {
                    return QUEUED;
                }
                case 4737: {
                    return SUBMIT;
                }
                case 4738: {
                    return START;
                }
                case 4739: {
                    return END;
                }
            }
            return null;
        }
    }
}

