/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLObject;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProperty;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class CLDevice
extends CLObject {
    private Set<String> extensions;
    private final CLInfoAccessor deviceInfo;
    private final CLPlatform platform;

    protected CLDevice(CLPlatform cLPlatform, long l2) {
        super(l2);
        this.platform = cLPlatform;
        this.deviceInfo = cLPlatform.getAccessorFactory().createDeviceInfoAccessor(cLPlatform.getCLBinding(), l2);
    }

    protected CLDevice(CLContext cLContext, long l2) {
        super(cLContext, l2);
        this.platform = cLContext.getPlatform();
        this.deviceInfo = this.platform.getAccessorFactory().createDeviceInfoAccessor(this.platform.getCLBinding(), l2);
    }

    public CLCommandQueue createCommandQueue() {
        return this.createCommandQueue(0L);
    }

    public CLCommandQueue createCommandQueue(CLCommandQueue.Mode mode) {
        return this.createCommandQueue(mode.QUEUE_MODE);
    }

    public CLCommandQueue createCommandQueue(CLCommandQueue.Mode ... modeArray) {
        int n2 = 0;
        if (modeArray != null) {
            for (int i2 = 0; i2 < modeArray.length; ++i2) {
                n2 |= modeArray[i2].QUEUE_MODE;
            }
        }
        return this.createCommandQueue(n2);
    }

    public CLCommandQueue createCommandQueue(long l2) {
        if (this.context == null) {
            throw new IllegalStateException("this device is not associated with a context");
        }
        return this.context.createCommandQueue(this, l2);
    }

    void setContext(CLContext cLContext) {
        this.context = cLContext;
    }

    @Override
    public CLPlatform getPlatform() {
        return this.platform;
    }

    @CLProperty(value="CL_DEVICE_NAME")
    public String getName() {
        return this.deviceInfo.getString(4139);
    }

    @CLProperty(value="CL_DEVICE_PROFILE")
    public String getProfile() {
        return this.deviceInfo.getString(4142);
    }

    @CLProperty(value="CL_DEVICE_VENDOR")
    public String getVendor() {
        return this.deviceInfo.getString(4140);
    }

    @CLProperty(value="CL_DEVICE_VENDOR_ID")
    public long getVendorID() {
        return this.deviceInfo.getLong(4097);
    }

    @CLProperty(value="CL_DEVICE_VERSION")
    public CLVersion getVersion() {
        return new CLVersion(this.deviceInfo.getString(4143));
    }

    @CLProperty(value="CL_DEVICE_OPENCL_C_VERSION")
    public CLVersion getCVersion() {
        return new CLVersion(this.deviceInfo.getString(4157));
    }

    @CLProperty(value="CL_DRIVER_VERSION")
    public String getDriverVersion() {
        return this.deviceInfo.getString(4141);
    }

    @CLProperty(value="CL_DEVICE_TYPE")
    public Type getType() {
        return Type.valueOf((int)this.deviceInfo.getLong(4096));
    }

    @CLProperty(value="CL_DEVICE_ADDRESS_BITS")
    public int getAddressBits() {
        return (int)this.deviceInfo.getLong(4109);
    }

    @CLProperty(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT")
    public int getPreferredShortVectorWidth() {
        return (int)this.deviceInfo.getLong(4103);
    }

    @CLProperty(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR")
    public int getPreferredCharVectorWidth() {
        return (int)this.deviceInfo.getLong(4102);
    }

    @CLProperty(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT")
    public int getPreferredIntVectorWidth() {
        return (int)this.deviceInfo.getLong(4104);
    }

    @CLProperty(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG")
    public int getPreferredLongVectorWidth() {
        return (int)this.deviceInfo.getLong(4105);
    }

    @CLProperty(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT")
    public int getPreferredFloatVectorWidth() {
        return (int)this.deviceInfo.getLong(4106);
    }

    @CLProperty(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE")
    public int getPreferredDoubleVectorWidth() {
        return (int)this.deviceInfo.getLong(4107);
    }

    @CLProperty(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_CHAR")
    public int getNativeCharVectorWidth() {
        return (int)this.deviceInfo.getLong(4150);
    }

    @CLProperty(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_SHORT")
    public int getNativeShortVectorWidth() {
        return (int)this.deviceInfo.getLong(4151);
    }

    @CLProperty(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_INT")
    public int getNativeIntVectorWidth() {
        return (int)this.deviceInfo.getLong(4152);
    }

    @CLProperty(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_LONG")
    public int getNativeLongVectorWidth() {
        return (int)this.deviceInfo.getLong(4153);
    }

    @CLProperty(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_HALF")
    public int getNativeHalfVectorWidth() {
        return (int)this.deviceInfo.getLong(4156);
    }

    @CLProperty(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_FLOAT")
    public int getNativeFloatVectorWidth() {
        return (int)this.deviceInfo.getLong(4154);
    }

    @CLProperty(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_DOUBLE")
    public int getNativeDoubleVectorWidth() {
        return (int)this.deviceInfo.getLong(4155);
    }

    @CLProperty(value="CL_DEVICE_MAX_COMPUTE_UNITS")
    public int getMaxComputeUnits() {
        return (int)this.deviceInfo.getLong(4098);
    }

    @CLProperty(value="CL_DEVICE_MAX_WORK_GROUP_SIZE")
    public int getMaxWorkGroupSize() {
        return (int)this.deviceInfo.getLong(4100);
    }

    @CLProperty(value="CL_DEVICE_MAX_CLOCK_FREQUENCY")
    public int getMaxClockFrequency() {
        return (int)this.deviceInfo.getLong(4108);
    }

    @CLProperty(value="CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS")
    public int getMaxWorkItemDimensions() {
        return (int)this.deviceInfo.getLong(4099);
    }

    @CLProperty(value="CL_DEVICE_MAX_WORK_ITEM_SIZES")
    public int[] getMaxWorkItemSizes() {
        int n2 = this.getMaxWorkItemDimensions();
        return this.deviceInfo.getInts(4101, n2);
    }

    @CLProperty(value="CL_DEVICE_MAX_PARAMETER_SIZE")
    public long getMaxParameterSize() {
        return this.deviceInfo.getLong(4119);
    }

    @CLProperty(value="CL_DEVICE_MAX_MEM_ALLOC_SIZE")
    public long getMaxMemAllocSize() {
        return this.deviceInfo.getLong(4112);
    }

    @CLProperty(value="CL_DEVICE_MEM_BASE_ADDR_ALIGN")
    public long getMemBaseAddrAlign() {
        return this.deviceInfo.getUInt32Long(4121);
    }

    @CLProperty(value="CL_DEVICE_GLOBAL_MEM_SIZE")
    public long getGlobalMemSize() {
        return this.deviceInfo.getLong(4127);
    }

    @CLProperty(value="CL_DEVICE_LOCAL_MEM_SIZE")
    public long getLocalMemSize() {
        return this.deviceInfo.getLong(4131);
    }

    @CLProperty(value="CL_DEVICE_HOST_UNIFIED_MEMORY")
    public boolean isMemoryUnified() {
        return this.deviceInfo.getLong(4149) == 1L;
    }

    @CLProperty(value="CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE")
    public long getMaxConstantBufferSize() {
        return this.deviceInfo.getLong(4128);
    }

    @CLProperty(value="CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE")
    public long getGlobalMemCachelineSize() {
        return this.deviceInfo.getLong(4125);
    }

    @CLProperty(value="CL_DEVICE_GLOBAL_MEM_CACHE_SIZE")
    public long getGlobalMemCacheSize() {
        return this.deviceInfo.getLong(4126);
    }

    @CLProperty(value="CL_DEVICE_MAX_CONSTANT_ARGS")
    public long getMaxConstantArgs() {
        return this.deviceInfo.getLong(4129);
    }

    @CLProperty(value="CL_DEVICE_IMAGE_SUPPORT")
    public boolean isImageSupportAvailable() {
        return this.deviceInfo.getLong(4118) == 1L;
    }

    @CLProperty(value="CL_DEVICE_MAX_READ_IMAGE_ARGS")
    public int getMaxReadImageArgs() {
        return (int)this.deviceInfo.getLong(4110);
    }

    @CLProperty(value="CL_DEVICE_MAX_WRITE_IMAGE_ARGS")
    public int getMaxWriteImageArgs() {
        return (int)this.deviceInfo.getLong(4111);
    }

    @CLProperty(value="CL_DEVICE_IMAGE2D_MAX_WIDTH")
    public int getMaxImage2dWidth() {
        return (int)this.deviceInfo.getLong(4113);
    }

    @CLProperty(value="CL_DEVICE_IMAGE2D_MAX_HEIGHT")
    public int getMaxImage2dHeight() {
        return (int)this.deviceInfo.getLong(4114);
    }

    @CLProperty(value="CL_DEVICE_IMAGE3D_MAX_WIDTH")
    public int getMaxImage3dWidth() {
        return (int)this.deviceInfo.getLong(4115);
    }

    @CLProperty(value="CL_DEVICE_IMAGE3D_MAX_HEIGHT")
    public int getMaxImage3dHeight() {
        return (int)this.deviceInfo.getLong(4116);
    }

    @CLProperty(value="CL_DEVICE_IMAGE3D_MAX_DEPTH")
    public int getMaxImage3dDepth() {
        return (int)this.deviceInfo.getLong(4117);
    }

    @CLProperty(value="CL_DEVICE_MAX_SAMPLERS")
    public int getMaxSamplers() {
        return (int)this.deviceInfo.getLong(4120);
    }

    @CLProperty(value="CL_DEVICE_PROFILING_TIMER_RESOLUTION")
    public long getProfilingTimerResolution() {
        return this.deviceInfo.getLong(4133);
    }

    @CLProperty(value="CL_DEVICE_EXECUTION_CAPABILITIES")
    public EnumSet<Capabilities> getExecutionCapabilities() {
        return Capabilities.valuesOf((int)this.deviceInfo.getLong(4137));
    }

    @CLProperty(value="CL_DEVICE_HALF_FP_CONFIG")
    public EnumSet<FPConfig> getHalfFPConfig() {
        if (this.isHalfFPAvailable()) {
            return FPConfig.valuesOf((int)this.deviceInfo.getLong(4147));
        }
        return EnumSet.noneOf(FPConfig.class);
    }

    @CLProperty(value="CL_DEVICE_SINGLE_FP_CONFIG")
    public EnumSet<FPConfig> getSingleFPConfig() {
        return FPConfig.valuesOf((int)this.deviceInfo.getLong(4123));
    }

    @CLProperty(value="CL_DEVICE_DOUBLE_FP_CONFIG")
    public EnumSet<FPConfig> getDoubleFPConfig() {
        if (this.isDoubleFPAvailable()) {
            return FPConfig.valuesOf((int)this.deviceInfo.getLong(4146));
        }
        return EnumSet.noneOf(FPConfig.class);
    }

    @CLProperty(value="CL_DEVICE_LOCAL_MEM_TYPE")
    public LocalMemType getLocalMemType() {
        return LocalMemType.valueOf((int)this.deviceInfo.getLong(4130));
    }

    @CLProperty(value="CL_DEVICE_GLOBAL_MEM_CACHE_TYPE")
    public GlobalMemCacheType getGlobalMemCacheType() {
        return GlobalMemCacheType.valueOf((int)this.deviceInfo.getLong(4124));
    }

    @CLProperty(value="CL_DEVICE_QUEUE_PROPERTIES")
    public EnumSet<CLCommandQueue.Mode> getQueueProperties() {
        return CLCommandQueue.Mode.valuesOf((int)this.deviceInfo.getLong(4138));
    }

    @CLProperty(value="CL_DEVICE_AVAILABLE")
    public boolean isAvailable() {
        return this.deviceInfo.getLong(4135) == 1L;
    }

    @CLProperty(value="CL_DEVICE_COMPILER_AVAILABLE")
    public boolean isCompilerAvailable() {
        return this.deviceInfo.getLong(4136) == 1L;
    }

    @CLProperty(value="CL_DEVICE_ENDIAN_LITTLE")
    public boolean isLittleEndian() {
        return this.deviceInfo.getLong(4134) == 1L;
    }

    @CLProperty(value="CL_DEVICE_ERROR_CORRECTION_SUPPORT")
    public boolean isErrorCorrectionSupported() {
        return this.deviceInfo.getLong(4132) == 1L;
    }

    @CLProperty(value="cl_khr_fp16")
    public boolean isHalfFPAvailable() {
        return this.isExtensionAvailable("cl_khr_fp16");
    }

    @CLProperty(value="cl_khr_fp64")
    public boolean isDoubleFPAvailable() {
        return this.isExtensionAvailable("cl_khr_fp64");
    }

    @CLProperty(value="cl_khr_icd")
    public boolean isICDAvailable() {
        return this.isExtensionAvailable("cl_khr_icd");
    }

    @CLProperty(value="cl_khr_gl_sharing | cl_APPLE_gl_sharing")
    public boolean isGLMemorySharingSupported() {
        return this.isExtensionAvailable("cl_khr_gl_sharing") || this.isExtensionAvailable("cl_APPLE_gl_sharing");
    }

    public boolean isExtensionAvailable(String string) {
        return this.getExtensions().contains(string);
    }

    public ByteOrder getByteOrder() {
        if (this.isLittleEndian()) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        return ByteOrder.BIG_ENDIAN;
    }

    @CLProperty(value="CL_DEVICE_EXTENSIONS")
    public Set<String> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashSet<String>();
            String string = this.deviceInfo.getString(4144);
            Scanner scanner = new Scanner(string);
            while (scanner.hasNext()) {
                this.extensions.add(scanner.next());
            }
            this.extensions = Collections.unmodifiableSet(this.extensions);
        }
        return this.extensions;
    }

    public Map<String, String> getProperties() {
        return CLUtil.obtainDeviceProperties(this);
    }

    public final CLInfoAccessor getCLAccessor() {
        return this.deviceInfo;
    }

    @Override
    public String toString() {
        return "CLDevice [id: " + this.ID + " name: " + this.getName() + " type: " + (Object)((Object)this.getType()) + " profile: " + this.getProfile() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLDevice cLDevice = (CLDevice)object;
        return this.ID == cLDevice.ID;
    }

    public int hashCode() {
        int n2 = 3;
        n2 = 79 * n2 + (int)(this.ID ^ this.ID >>> 32);
        return n2;
    }

    public static enum Type {
        CPU(2L),
        GPU(4L),
        ACCELERATOR(8L),
        DEFAULT(1L),
        ALL(0xFFFFFFFFL);

        public final long TYPE;

        private Type(long l2) {
            this.TYPE = l2;
        }

        public static Type valueOf(long l2) {
            if (l2 == 0xFFFFFFFFL) {
                return ALL;
            }
            switch ((int)l2) {
                case 1: {
                    return DEFAULT;
                }
                case 2: {
                    return CPU;
                }
                case 4: {
                    return GPU;
                }
                case 8: {
                    return ACCELERATOR;
                }
            }
            return null;
        }
    }

    public static enum Capabilities {
        EXEC_KERNEL(1),
        EXEC_NATIVE_KERNEL(2);

        public final int CAPS;

        private Capabilities(int n3) {
            this.CAPS = n3;
        }

        public static Capabilities valueOf(int n2) {
            switch (n2) {
                case 1: {
                    return EXEC_KERNEL;
                }
                case 2: {
                    return EXEC_NATIVE_KERNEL;
                }
            }
            return null;
        }

        public static EnumSet<Capabilities> valuesOf(int n2) {
            if ((Capabilities.EXEC_KERNEL.CAPS & n2) != 0) {
                if ((Capabilities.EXEC_NATIVE_KERNEL.CAPS & n2) != 0) {
                    return EnumSet.of(EXEC_KERNEL, EXEC_NATIVE_KERNEL);
                }
                return EnumSet.of(EXEC_KERNEL);
            }
            if ((Capabilities.EXEC_NATIVE_KERNEL.CAPS & n2) != 0) {
                return EnumSet.of(EXEC_NATIVE_KERNEL);
            }
            return null;
        }
    }

    public static enum FPConfig {
        DENORM(1),
        INF_NAN(2),
        ROUND_TO_NEAREST(4),
        ROUND_TO_INF(16),
        ROUND_TO_ZERO(8),
        FMA(32);

        public final int CONFIG;

        private FPConfig(int n3) {
            this.CONFIG = n3;
        }

        public static EnumSet<FPConfig> valuesOf(int n2) {
            FPConfig[] fPConfigArray;
            ArrayList<FPConfig> arrayList = new ArrayList<FPConfig>();
            for (FPConfig fPConfig : fPConfigArray = FPConfig.values()) {
                if ((fPConfig.CONFIG & n2) == 0) continue;
                arrayList.add(fPConfig);
            }
            if (arrayList.isEmpty()) {
                return EnumSet.noneOf(FPConfig.class);
            }
            return EnumSet.copyOf(arrayList);
        }
    }

    public static enum LocalMemType {
        GLOBAL(2),
        LOCAL(1);

        public final int TYPE;

        private LocalMemType(int n3) {
            this.TYPE = n3;
        }

        public static LocalMemType valueOf(int n2) {
            if (n2 == 2) {
                return GLOBAL;
            }
            if (n2 == 1) {
                return LOCAL;
            }
            return null;
        }
    }

    public static enum GlobalMemCacheType {
        NONE(0),
        READ_ONLY(1),
        READ_WRITE(2);

        public final int TYPE;

        private GlobalMemCacheType(int n3) {
            this.TYPE = n3;
        }

        public static GlobalMemCacheType valueOf(int n2) {
            GlobalMemCacheType[] globalMemCacheTypeArray;
            for (GlobalMemCacheType globalMemCacheType : globalMemCacheTypeArray = GlobalMemCacheType.values()) {
                if (globalMemCacheType.TYPE != n2) continue;
                return globalMemCacheType;
            }
            return null;
        }
    }
}

