/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.CachedBufferFactory;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLEventList;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImage2d;
import com.jogamp.opencl.CLImage3d;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.gl.CLGLObject;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;

public class CLCommandQueue
extends CLObjectResource {
    private final CL cl;
    private final CLDevice device;
    private final long properties;
    private final IntBuffer pbA;
    private final PointerBuffer ibA;
    private final PointerBuffer ibB;
    private final PointerBuffer ibC;

    private CLCommandQueue(CLContext cLContext, long l2, CLDevice cLDevice, long l3) {
        super(cLContext, l2);
        this.device = cLDevice;
        this.properties = l3;
        this.cl = cLContext.getPlatform().getCLBinding();
        int n2 = PointerBuffer.ELEMENT_SIZE;
        CachedBufferFactory cachedBufferFactory = CachedBufferFactory.create(9 * n2 + 4, true);
        this.ibA = PointerBuffer.wrap(cachedBufferFactory.newDirectByteBuffer(3 * n2));
        this.ibB = PointerBuffer.wrap(cachedBufferFactory.newDirectByteBuffer(3 * n2));
        this.ibC = PointerBuffer.wrap(cachedBufferFactory.newDirectByteBuffer(3 * n2));
        this.pbA = cachedBufferFactory.newDirectIntBuffer(1);
    }

    static CLCommandQueue create(CLContext cLContext, CLDevice cLDevice, long l2) {
        int[] nArray = new int[1];
        CL cL = cLContext.getPlatform().getCLBinding();
        long l3 = cL.clCreateCommandQueue(cLContext.ID, cLDevice.ID, l2, nArray, 0);
        if (nArray[0] != 0) {
            throw CLException.newException(nArray[0], "can not create command queue on " + cLDevice + " with properties: " + Mode.valuesOf(l2));
        }
        return new CLCommandQueue(cLContext, l3, cLDevice, l2);
    }

    public CLCommandQueue putWriteBuffer(CLBuffer<?> cLBuffer, boolean bl) {
        return this.putWriteBuffer(cLBuffer, bl, null, null);
    }

    public CLCommandQueue putWriteBuffer(CLBuffer<?> cLBuffer, boolean bl, CLEventList cLEventList) {
        return this.putWriteBuffer(cLBuffer, bl, null, cLEventList);
    }

    public CLCommandQueue putWriteBuffer(CLBuffer<?> cLBuffer, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        int n2;
        PointerBuffer pointerBuffer = null;
        int n3 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n3 = cLEventList.size;
        }
        if ((n2 = this.cl.clEnqueueWriteBuffer(this.ID, cLBuffer.ID, CLUtil.clBoolean(bl), 0L, cLBuffer.getNIOSize(), cLBuffer.buffer, n3, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs)) != 0) {
            throw CLException.newException(n2, "can not enqueue write-buffer: " + cLBuffer + " with " + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReadBuffer(CLBuffer<?> cLBuffer, boolean bl) {
        this.putReadBuffer(cLBuffer, bl, null, null);
        return this;
    }

    public CLCommandQueue putReadBuffer(CLBuffer<?> cLBuffer, boolean bl, CLEventList cLEventList) {
        this.putReadBuffer(cLBuffer, bl, null, cLEventList);
        return this;
    }

    public CLCommandQueue putReadBuffer(CLBuffer<?> cLBuffer, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        int n2;
        PointerBuffer pointerBuffer = null;
        int n3 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n3 = cLEventList.size;
        }
        if ((n2 = this.cl.clEnqueueReadBuffer(this.ID, cLBuffer.ID, CLUtil.clBoolean(bl), 0L, cLBuffer.getNIOSize(), cLBuffer.buffer, n3, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs)) != 0) {
            throw CLException.newException(n2, "can not enqueue read-buffer: " + cLBuffer + " with " + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyBuffer(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2) {
        return this.putCopyBuffer(cLBuffer, cLBuffer2, 0, 0, cLBuffer.getCLSize(), null, null);
    }

    public CLCommandQueue putCopyBuffer(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, long l2) {
        return this.putCopyBuffer(cLBuffer, cLBuffer2, 0, 0, l2, null, null);
    }

    public CLCommandQueue putCopyBuffer(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n2, int n3, long l2, CLEventList cLEventList) {
        return this.putCopyBuffer(cLBuffer, cLBuffer2, n2, n3, l2, null, cLEventList);
    }

    public CLCommandQueue putCopyBuffer(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n2, int n3, long l2, CLEventList cLEventList, CLEventList cLEventList2) {
        int n4;
        PointerBuffer pointerBuffer = null;
        int n5 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n5 = cLEventList.size;
        }
        if ((n4 = this.cl.clEnqueueCopyBuffer(this.ID, cLBuffer.ID, cLBuffer2.ID, n2, n3, l2, n5, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs)) != 0) {
            throw CLException.newException(n4, "can not enqueue copy-buffer from " + cLBuffer + " to " + cLBuffer2 + " with srcOffset: " + n2 + " dstOffset: " + n3 + " bytesToCopy: " + l2 + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putWriteBufferRect(CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putWriteBufferRect(cLBuffer, n2, n3, n4, n5, n6, n7, 0L, 0L, 0L, 0L, bl, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putWriteBufferRect(CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, long l2, long l3, long l4, long l5, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putWriteBufferRect(cLBuffer, n2, n3, 0, n4, n5, 0, n6, n7, 1, 0L, 0L, 0L, 0L, bl, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putWriteBufferRect(CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putWriteBufferRect(cLBuffer, n2, n3, n4, n5, n6, n7, n8, n9, n10, 0L, 0L, 0L, 0L, bl, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putWriteBufferRect(CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2, long l3, long l4, long l5, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n11 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n11 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, n4);
        CLCommandQueue.copy2NIO(this.ibB, n5, n6, n7);
        CLCommandQueue.copy2NIO(this.ibC, n8, n9, n10);
        int n12 = this.cl.clEnqueueWriteBufferRect(this.ID, cLBuffer.ID, CLUtil.clBoolean(bl), this.ibA, this.ibB, this.ibC, l2, l3, l4, l5, (Buffer)cLBuffer.getBuffer(), n11, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n12 != 0) {
            throw CLException.newException(n12, this.bufferRectToString("write", cLBuffer, l2, l3, l4, l5, n2, n3, n4, n5, n6, n7, n8, n9, n10, cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReadBufferRect(CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putReadBufferRect(cLBuffer, n2, n3, n4, n5, n6, n7, 0L, 0L, 0L, 0L, bl, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putReadBufferRect(CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, long l2, long l3, long l4, long l5, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putReadBufferRect(cLBuffer, n2, n3, 0, n4, n5, 0, n6, n7, 1, 0L, 0L, 0L, 0L, bl, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putReadBufferRect(CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putReadBufferRect(cLBuffer, n2, n3, n4, n5, n6, n7, n8, n9, n10, 0L, 0L, 0L, 0L, bl, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putReadBufferRect(CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2, long l3, long l4, long l5, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n11 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n11 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, n4);
        CLCommandQueue.copy2NIO(this.ibB, n5, n6, n7);
        CLCommandQueue.copy2NIO(this.ibC, n8, n9, n10);
        int n12 = this.cl.clEnqueueReadBufferRect(this.ID, cLBuffer.ID, CLUtil.clBoolean(bl), this.ibA, this.ibB, this.ibC, l2, l3, l4, l5, (Buffer)cLBuffer.getBuffer(), n11, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n12 != 0) {
            throw CLException.newException(n12, this.bufferRectToString("read", cLBuffer, l2, l3, l4, l5, n2, n3, n4, n5, n6, n7, n8, n9, n10, cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyBufferRect(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n2, int n3, int n4, int n5, int n6, int n7, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putCopyBufferRect(cLBuffer, cLBuffer2, n2, n3, 0, n4, n5, 0, n6, n7, 1, 0L, 0L, 0L, 0L, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putCopyBufferRect(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n2, int n3, int n4, int n5, int n6, int n7, long l2, long l3, long l4, long l5, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putCopyBufferRect(cLBuffer, cLBuffer2, n2, n3, 0, n4, n5, 0, n6, n7, 1, l2, l3, l4, l5, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putCopyBufferRect(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putCopyBufferRect(cLBuffer, cLBuffer2, n2, n3, n4, n5, n6, n7, n8, n9, n10, 0L, 0L, 0L, 0L, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putCopyBufferRect(CLBuffer<?> cLBuffer, CLBuffer<?> cLBuffer2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2, long l3, long l4, long l5, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n11 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n11 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, n4);
        CLCommandQueue.copy2NIO(this.ibB, n5, n6, n7);
        CLCommandQueue.copy2NIO(this.ibC, n8, n9, n10);
        int n12 = this.cl.clEnqueueCopyBufferRect(this.ID, cLBuffer.ID, cLBuffer2.ID, this.ibA, this.ibB, this.ibC, l2, l3, l4, l5, n11, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n12 != 0) {
            throw CLException.newException(n12, "can not enqueue copy-buffer-rect from " + cLBuffer + " to " + cLBuffer2 + "\n with srcRowPitch: " + l2 + " srcSlicePitch: " + l3 + " destRowPitch: " + l4 + " destSlicePitch: " + l5 + "\n srcOrigin: " + this.toStr(n2, n3, n4) + " destOrigin: " + this.toStr(n5, n6, n7) + " range: " + this.toStr(n8, n9, n10) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> cLImage2d, boolean bl) {
        return this.putWriteImage(cLImage2d, 0, 0, 0, cLImage2d.width, cLImage2d.height, bl, null, null);
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> cLImage2d, boolean bl, CLEventList cLEventList) {
        return this.putWriteImage(cLImage2d, 0, 0, 0, cLImage2d.width, cLImage2d.height, bl, null, cLEventList);
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> cLImage2d, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putWriteImage(cLImage2d, 0, 0, 0, cLImage2d.width, cLImage2d.height, bl, cLEventList, cLEventList2);
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> cLImage2d, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return this.putWriteImage(cLImage2d, n2, n3, n4, n5, n6, bl, null, null);
    }

    public CLCommandQueue putWriteImage(CLImage2d<?> cLImage2d, int n2, int n3, int n4, int n5, int n6, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n7 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n7 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n3, n4, 0L);
        CLCommandQueue.copy2NIO(this.ibB, n5, n6, 1L);
        int n8 = this.cl.clEnqueueWriteImage(this.ID, cLImage2d.ID, CLUtil.clBoolean(bl), this.ibA, this.ibB, n2, 0L, cLImage2d.buffer, n7, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n8 != 0) {
            throw CLException.newException(n8, "can not enqueue write-image " + cLImage2d + " with inputRowPitch: " + n2 + " origin: " + this.toStr(n3, n4) + " range: " + this.toStr(n5, n6) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> cLImage3d, boolean bl) {
        return this.putWriteImage(cLImage3d, 0, 0, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, bl, null, null);
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> cLImage3d, boolean bl, CLEventList cLEventList) {
        return this.putWriteImage(cLImage3d, 0, 0, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, bl, null, cLEventList);
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> cLImage3d, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putWriteImage(cLImage3d, 0, 0, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, bl, cLEventList, cLEventList2);
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> cLImage3d, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        return this.putWriteImage(cLImage3d, n2, n3, n4, n5, n6, n7, n8, n9, bl, null, null);
    }

    public CLCommandQueue putWriteImage(CLImage3d<?> cLImage3d, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n10 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n10 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n4, n5, n6);
        CLCommandQueue.copy2NIO(this.ibB, n7, n8, n9);
        int n11 = this.cl.clEnqueueWriteImage(this.ID, cLImage3d.ID, CLUtil.clBoolean(bl), this.ibA, this.ibB, n2, n3, cLImage3d.buffer, n10, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n11 != 0) {
            throw CLException.newException(n11, "can not enqueue write-image " + cLImage3d + " with inputRowPitch: " + n2 + " inputSlicePitch: " + n3 + " origin: " + this.toStr(n4, n5, n6) + " range: " + this.toStr(n7, n8, n9) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReadImage(CLImage2d<?> cLImage2d, boolean bl) {
        return this.putReadImage(cLImage2d, 0, 0, 0, cLImage2d.width, cLImage2d.height, bl, null, null);
    }

    public CLCommandQueue putReadImage(CLImage2d<?> cLImage2d, boolean bl, CLEventList cLEventList) {
        return this.putReadImage(cLImage2d, 0, 0, 0, cLImage2d.width, cLImage2d.height, bl, null, cLEventList);
    }

    public CLCommandQueue putReadImage(CLImage2d<?> cLImage2d, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putReadImage(cLImage2d, 0, 0, 0, cLImage2d.width, cLImage2d.height, bl, cLEventList, cLEventList2);
    }

    public CLCommandQueue putReadImage(CLImage2d<?> cLImage2d, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return this.putReadImage(cLImage2d, n2, n3, n4, n5, n6, bl, null, null);
    }

    public CLCommandQueue putReadImage(CLImage2d<?> cLImage2d, int n2, int n3, int n4, int n5, int n6, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n7 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n7 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n3, n4, 0L);
        CLCommandQueue.copy2NIO(this.ibB, n5, n6, 1L);
        int n8 = this.cl.clEnqueueReadImage(this.ID, cLImage2d.ID, CLUtil.clBoolean(bl), this.ibA, this.ibB, n2, 0L, cLImage2d.buffer, n7, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n8 != 0) {
            throw CLException.newException(n8, "can not enqueue read-image " + cLImage2d + " with inputRowPitch: " + n2 + " origin: " + this.toStr(n3, n4) + " range: " + this.toStr(n5, n6) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReadImage(CLImage3d<?> cLImage3d, boolean bl) {
        return this.putReadImage(cLImage3d, 0, 0, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, bl, null, null);
    }

    public CLCommandQueue putReadImage(CLImage3d<?> cLImage3d, boolean bl, CLEventList cLEventList) {
        return this.putReadImage(cLImage3d, 0, 0, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, bl, null, cLEventList);
    }

    public CLCommandQueue putReadImage(CLImage3d<?> cLImage3d, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putReadImage(cLImage3d, 0, 0, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, bl, cLEventList, cLEventList2);
    }

    public CLCommandQueue putReadImage(CLImage3d<?> cLImage3d, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        return this.putReadImage(cLImage3d, n2, n3, n4, n5, n6, n7, n8, n9, bl, null, null);
    }

    public CLCommandQueue putReadImage(CLImage3d<?> cLImage3d, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n10 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n10 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n4, n5, n6);
        CLCommandQueue.copy2NIO(this.ibB, n7, n8, n9);
        int n11 = this.cl.clEnqueueReadImage(this.ID, cLImage3d.ID, CLUtil.clBoolean(bl), this.ibA, this.ibB, n2, n3, cLImage3d.buffer, n10, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n11 != 0) {
            throw CLException.newException(n11, "can not enqueue read-image " + cLImage3d + " with inputRowPitch: " + n2 + " inputSlicePitch: " + n3 + " origin: " + this.toStr(n4, n5, n6) + " range: " + this.toStr(n7, n8, n9) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> cLImage2d, CLImage2d<?> cLImage2d2) {
        return this.putCopyImage(cLImage2d, cLImage2d2, null);
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> cLImage2d, CLImage2d<?> cLImage2d2, CLEventList cLEventList) {
        return this.putCopyImage(cLImage2d, cLImage2d2, 0, 0, 0, 0, cLImage2d.width, cLImage2d.height, null, cLEventList);
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> cLImage2d, CLImage2d<?> cLImage2d2, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putCopyImage(cLImage2d, cLImage2d2, 0, 0, 0, 0, cLImage2d.width, cLImage2d.height, cLEventList, cLEventList2);
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> cLImage2d, CLImage2d<?> cLImage2d2, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.putCopyImage(cLImage2d, cLImage2d2, n2, n3, n4, n5, n6, n7, null, null);
    }

    public CLCommandQueue putCopyImage(CLImage2d<?> cLImage2d, CLImage2d<?> cLImage2d2, int n2, int n3, int n4, int n5, int n6, int n7, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n8 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n8 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, 0L);
        CLCommandQueue.copy2NIO(this.ibB, n4, n5, 0L);
        CLCommandQueue.copy2NIO(this.ibC, n6, n7, 1L);
        int n9 = this.cl.clEnqueueCopyImage(this.ID, cLImage2d.ID, cLImage2d2.ID, this.ibA, this.ibB, this.ibC, n8, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n9 != 0) {
            throw CLException.newException(n9, "can not enqueue copy-image " + cLImage2d + " to " + cLImage2d2 + " with srcOrigin: " + this.toStr(n2, n3) + " dstOrigin: " + this.toStr(n4, n5) + " range:  " + this.toStr(n6, n7) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyImage(CLImage3d<?> cLImage3d, CLImage3d<?> cLImage3d2) {
        return this.putCopyImage(cLImage3d, cLImage3d2, null);
    }

    public CLCommandQueue putCopyImage(CLImage3d<?> cLImage3d, CLImage3d<?> cLImage3d2, CLEventList cLEventList) {
        return this.putCopyImage(cLImage3d, cLImage3d2, 0, 0, 0, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, null, cLEventList);
    }

    public CLCommandQueue putCopyImage(CLImage3d<?> cLImage3d, CLImage3d<?> cLImage3d2, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putCopyImage(cLImage3d, cLImage3d2, 0, 0, 0, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, cLEventList, cLEventList2);
    }

    public CLCommandQueue putCopyImage(CLImage3d<?> cLImage3d, CLImage3d<?> cLImage3d2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return this.putCopyImage(cLImage3d, cLImage3d2, n2, n3, n4, n5, n6, n7, n8, n9, n10, null, null);
    }

    public CLCommandQueue putCopyImage(CLImage<?> cLImage, CLImage<?> cLImage2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n11 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n11 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, n4);
        CLCommandQueue.copy2NIO(this.ibB, n5, n6, n7);
        CLCommandQueue.copy2NIO(this.ibC, n8, n9, n10);
        int n12 = this.cl.clEnqueueCopyImage(this.ID, cLImage.ID, cLImage2.ID, this.ibA, this.ibB, this.ibC, n11, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n12 != 0) {
            throw CLException.newException(n12, "can not enqueue copy-image " + cLImage + " to " + cLImage2 + " with srcOrigin: " + this.toStr(n2, n3, n4) + " dstOrigin: " + this.toStr(n5, n6, n7) + " range:  " + this.toStr(n8, n9, n10) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage2d<?> cLImage2d) {
        return this.putCopyBufferToImage(cLBuffer, cLImage2d, null);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage2d<?> cLImage2d, CLEventList cLEventList) {
        return this.putCopyBufferToImage(cLBuffer, cLImage2d, 0L, 0, 0, cLImage2d.width, cLImage2d.height, null, cLEventList);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage2d<?> cLImage2d, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putCopyBufferToImage(cLBuffer, cLImage2d, 0L, 0, 0, cLImage2d.width, cLImage2d.height, cLEventList, cLEventList2);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage2d<?> cLImage2d, long l2, int n2, int n3, int n4, int n5) {
        return this.putCopyBufferToImage(cLBuffer, cLImage2d, l2, n2, n3, n4, n5, null, null);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage2d<?> cLImage2d, long l2, int n2, int n3, int n4, int n5, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n6 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n6 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, 0L);
        CLCommandQueue.copy2NIO(this.ibB, n4, n5, 1L);
        int n7 = this.cl.clEnqueueCopyBufferToImage(this.ID, cLBuffer.ID, cLImage2d.ID, l2, this.ibA, this.ibB, n6, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n7 != 0) {
            throw CLException.newException(n7, "can not enqueue a copy from " + cLBuffer + " to " + cLImage2d + " with srcOffset: " + l2 + " dstOrigin: " + this.toStr(n2, n3) + " range:  " + this.toStr(n4, n5) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage3d<?> cLImage3d) {
        return this.putCopyBufferToImage(cLBuffer, cLImage3d, null);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage3d<?> cLImage3d, CLEventList cLEventList) {
        return this.putCopyBufferToImage(cLBuffer, cLImage3d, 0L, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, null, cLEventList);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage3d<?> cLImage3d, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putCopyBufferToImage(cLBuffer, cLImage3d, 0L, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, cLEventList, cLEventList2);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage3d<?> cLImage3d, long l2, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.putCopyBufferToImage(cLBuffer, cLImage3d, l2, n2, n3, n4, n5, n6, n7, null, null);
    }

    public CLCommandQueue putCopyBufferToImage(CLBuffer<?> cLBuffer, CLImage3d<?> cLImage3d, long l2, int n2, int n3, int n4, int n5, int n6, int n7, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n8 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n8 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, n4);
        CLCommandQueue.copy2NIO(this.ibB, n5, n6, n7);
        int n9 = this.cl.clEnqueueCopyBufferToImage(this.ID, cLBuffer.ID, cLImage3d.ID, l2, this.ibA, this.ibB, n8, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n9 != 0) {
            throw CLException.newException(n9, "can not enqueue a copy from " + cLBuffer + " to " + cLImage3d + " with srcOffset: " + l2 + " dstOrigin: " + this.toStr(n2, n3, n4) + " range:  " + this.toStr(n5, n6, n4) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> cLImage2d, CLBuffer<?> cLBuffer) {
        return this.putCopyImageToBuffer(cLImage2d, cLBuffer, null);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> cLImage2d, CLBuffer<?> cLBuffer, CLEventList cLEventList) {
        return this.putCopyImageToBuffer(cLImage2d, cLBuffer, 0, 0, cLImage2d.width, cLImage2d.height, 0L, null, cLEventList);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> cLImage2d, CLBuffer<?> cLBuffer, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putCopyImageToBuffer(cLImage2d, cLBuffer, 0, 0, cLImage2d.width, cLImage2d.height, 0L, cLEventList, cLEventList2);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> cLImage2d, CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, long l2) {
        return this.putCopyImageToBuffer(cLImage2d, cLBuffer, n2, n3, n4, n5, l2, null, null);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage2d<?> cLImage2d, CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, long l2, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n6 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n6 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, 0L);
        CLCommandQueue.copy2NIO(this.ibB, n4, n5, 1L);
        int n7 = this.cl.clEnqueueCopyImageToBuffer(this.ID, cLImage2d.ID, cLBuffer.ID, this.ibA, this.ibB, l2, n6, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n7 != 0) {
            throw CLException.newException(n7, "can not enqueue a copy from " + cLImage2d + " to " + cLBuffer + " with srcOrigin: " + this.toStr(n2, n3) + " range: " + this.toStr(n4, n5) + " dstOffset: " + l2 + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> cLImage3d, CLBuffer<?> cLBuffer) {
        return this.putCopyImageToBuffer(cLImage3d, cLBuffer, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, 0L, null, null);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> cLImage3d, CLBuffer<?> cLBuffer, CLEventList cLEventList) {
        return this.putCopyImageToBuffer(cLImage3d, cLBuffer, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, 0L, null, cLEventList);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> cLImage3d, CLBuffer<?> cLBuffer, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putCopyImageToBuffer(cLImage3d, cLBuffer, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, 0L, cLEventList, cLEventList2);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> cLImage3d, CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        return this.putCopyImageToBuffer(cLImage3d, cLBuffer, n2, n3, n4, n5, n6, n7, l2, null, null);
    }

    public CLCommandQueue putCopyImageToBuffer(CLImage3d<?> cLImage3d, CLBuffer<?> cLBuffer, int n2, int n3, int n4, int n5, int n6, int n7, long l2, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n8 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n8 = cLEventList.size;
        }
        CLCommandQueue.copy2NIO(this.ibA, n2, n3, n4);
        CLCommandQueue.copy2NIO(this.ibB, n5, n6, n7);
        int n9 = this.cl.clEnqueueCopyImageToBuffer(this.ID, cLImage3d.ID, cLBuffer.ID, this.ibA, this.ibB, l2, n8, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs);
        if (n9 != 0) {
            throw CLException.newException(n9, "can not enqueue a copy from " + cLImage3d + " to " + cLBuffer + " with srcOrigin: " + this.toStr(n2, n3, n4) + " range: " + this.toStr(n5, n6, n7) + " dstOffset: " + l2 + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> cLBuffer, CLMemory.Map map, boolean bl) {
        return this.putMapBuffer(cLBuffer, map, bl, null);
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> cLBuffer, CLMemory.Map map, boolean bl, CLEventList cLEventList) {
        return this.putMapBuffer(cLBuffer, map, 0L, cLBuffer.getCLSize(), bl, null, cLEventList);
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> cLBuffer, CLMemory.Map map, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putMapBuffer(cLBuffer, map, 0L, cLBuffer.getCLSize(), bl, cLEventList, cLEventList2);
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> cLBuffer, CLMemory.Map map, long l2, long l3, boolean bl) {
        return this.putMapBuffer(cLBuffer, map, l2, l3, bl, null, null);
    }

    public ByteBuffer putMapBuffer(CLBuffer<?> cLBuffer, CLMemory.Map map, long l2, long l3, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n2 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n2 = cLEventList.size;
        }
        IntBuffer intBuffer = this.pbA;
        ByteBuffer byteBuffer = this.cl.clEnqueueMapBuffer(this.ID, cLBuffer.ID, CLUtil.clBoolean(bl), map.FLAGS, l2, l3, n2, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs, intBuffer);
        if (intBuffer.get(0) != 0) {
            throw CLException.newException(intBuffer.get(0), "can not map " + cLBuffer + " with: " + (Object)((Object)map) + " offset: " + l2 + " lenght: " + l3 + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return byteBuffer;
    }

    public ByteBuffer putMapImage(CLImage2d<?> cLImage2d, CLMemory.Map map, boolean bl) {
        return this.putMapImage(cLImage2d, map, bl, null);
    }

    public ByteBuffer putMapImage(CLImage2d<?> cLImage2d, CLMemory.Map map, boolean bl, CLEventList cLEventList) {
        return this.putMapImage(cLImage2d, map, 0, 0, cLImage2d.width, cLImage2d.height, bl, null, cLEventList);
    }

    public ByteBuffer putMapImage(CLImage2d<?> cLImage2d, CLMemory.Map map, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putMapImage(cLImage2d, map, 0, 0, cLImage2d.width, cLImage2d.height, bl, cLEventList, cLEventList2);
    }

    public ByteBuffer putMapImage(CLImage2d<?> cLImage2d, CLMemory.Map map, int n2, int n3, int n4, int n5, boolean bl) {
        return this.putMapImage(cLImage2d, map, n2, n3, n4, n5, bl, null, null);
    }

    public ByteBuffer putMapImage(CLImage2d<?> cLImage2d, CLMemory.Map map, int n2, int n3, int n4, int n5, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putMapImage(cLImage2d, map, n2, n3, n4, n5, bl, cLEventList, cLEventList2, null, null);
    }

    public ByteBuffer putMapImage(CLImage2d<?> cLImage2d, CLMemory.Map map, int n2, int n3, int n4, int n5, boolean bl, CLEventList cLEventList, CLEventList cLEventList2, long[] lArray, long[] lArray2) {
        PointerBuffer pointerBuffer = null;
        int n6 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n6 = cLEventList.size;
        }
        IntBuffer intBuffer = this.pbA;
        CLCommandQueue.copy2NIO(this.ibB, n2, n3, 0L);
        CLCommandQueue.copy2NIO(this.ibC, n4, n5, 1L);
        PointerBuffer pointerBuffer2 = PointerBuffer.allocateDirect(1);
        PointerBuffer pointerBuffer3 = PointerBuffer.allocateDirect(1);
        ByteBuffer byteBuffer = this.cl.clEnqueueMapImage(this.ID, cLImage2d.ID, CLUtil.clBoolean(bl), map.FLAGS, this.ibB, this.ibC, pointerBuffer2, pointerBuffer3, n6, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs, intBuffer);
        if (intBuffer.get(0) != 0) {
            throw CLException.newException(intBuffer.get(0), "can not map " + cLImage2d + " with: " + (Object)((Object)map) + " offset: " + this.toStr(n2, n3) + " range: " + this.toStr(n4, n5) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (null != lArray) {
            lArray[0] = pointerBuffer2.get(0);
        }
        if (null != lArray2) {
            lArray2[0] = pointerBuffer3.get(0);
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return byteBuffer;
    }

    public ByteBuffer putMapImage(CLImage3d<?> cLImage3d, CLMemory.Map map, boolean bl) {
        return this.putMapImage(cLImage3d, map, bl, null);
    }

    public ByteBuffer putMapImage(CLImage3d<?> cLImage3d, CLMemory.Map map, boolean bl, CLEventList cLEventList) {
        return this.putMapImage(cLImage3d, map, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, bl, null, cLEventList);
    }

    public ByteBuffer putMapImage(CLImage3d<?> cLImage3d, CLMemory.Map map, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        return this.putMapImage(cLImage3d, map, 0, 0, 0, cLImage3d.width, cLImage3d.height, cLImage3d.depth, bl, cLEventList, cLEventList2);
    }

    public ByteBuffer putMapImage(CLImage3d<?> cLImage3d, CLMemory.Map map, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        return this.putMapImage(cLImage3d, map, n2, n3, n4, n5, n6, n7, bl, null, null);
    }

    public ByteBuffer putMapImage(CLImage3d<?> cLImage3d, CLMemory.Map map, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        int n8 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n8 = cLEventList.size;
        }
        IntBuffer intBuffer = this.pbA;
        CLCommandQueue.copy2NIO(this.ibB, n2, n3, n4);
        CLCommandQueue.copy2NIO(this.ibC, n5, n6, n7);
        ByteBuffer byteBuffer = this.cl.clEnqueueMapImage(this.ID, cLImage3d.ID, CLUtil.clBoolean(bl), map.FLAGS, this.ibB, this.ibC, null, null, n8, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs, intBuffer);
        if (intBuffer.get(0) != 0) {
            throw CLException.newException(intBuffer.get(0), "can not map " + cLImage3d + " with: " + (Object)((Object)map) + " offset: " + this.toStr(n2, n3, n4) + " range: " + this.toStr(n5, n6, n7) + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return byteBuffer;
    }

    public CLCommandQueue putUnmapMemory(CLMemory<?> cLMemory, Buffer buffer) {
        return this.putUnmapMemory(cLMemory, buffer, null, null);
    }

    public CLCommandQueue putUnmapMemory(CLMemory<?> cLMemory, Buffer buffer, CLEventList cLEventList) {
        return this.putUnmapMemory(cLMemory, buffer, null, cLEventList);
    }

    public CLCommandQueue putUnmapMemory(CLMemory<?> cLMemory, Buffer buffer, CLEventList cLEventList, CLEventList cLEventList2) {
        int n2;
        PointerBuffer pointerBuffer = null;
        int n3 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n3 = cLEventList.size;
        }
        if ((n2 = this.cl.clEnqueueUnmapMemObject(this.ID, cLMemory.ID, buffer, n3, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs)) != 0) {
            throw CLException.newException(n2, "can not unmap " + cLMemory + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putMarker(CLEventList cLEventList) {
        int n2 = this.cl.clEnqueueMarker(this.ID, cLEventList.IDs);
        if (n2 != 0) {
            throw CLException.newException(n2, "can not enqueue marker " + cLEventList);
        }
        cLEventList.createEvent(this.context);
        return this;
    }

    public CLCommandQueue putWaitForEvent(CLEventList cLEventList, int n2, boolean bl) {
        if (bl) {
            cLEventList.waitForEvent(n2);
        } else {
            PointerBuffer pointerBuffer = cLEventList.getEventBuffer(n2);
            int n3 = this.cl.clEnqueueWaitForEvents(this.ID, 1, pointerBuffer);
            if (n3 != 0) {
                throw CLException.newException(n3, "can not " + (bl ? "blocking" : "") + " wait for event #" + n2 + " in " + cLEventList);
            }
        }
        return this;
    }

    public CLCommandQueue putWaitForEvents(CLEventList cLEventList, boolean bl) {
        if (bl) {
            cLEventList.waitForEvents();
        } else {
            int n2 = this.cl.clEnqueueWaitForEvents(this.ID, cLEventList.size, cLEventList.IDsView);
            if (n2 != 0) {
                throw CLException.newException(n2, "can not " + (bl ? "blocking" : "") + " wait for events " + cLEventList);
            }
        }
        return this;
    }

    public CLCommandQueue putBarrier() {
        int n2 = this.cl.clEnqueueBarrier(this.ID);
        CLException.checkForError(n2, "can not enqueue Barrier");
        return this;
    }

    public CLCommandQueue putTask(CLKernel cLKernel) {
        this.putTask(cLKernel, null, null);
        return this;
    }

    public CLCommandQueue putTask(CLKernel cLKernel, CLEventList cLEventList) {
        this.putTask(cLKernel, null, cLEventList);
        return this;
    }

    public CLCommandQueue putTask(CLKernel cLKernel, CLEventList cLEventList, CLEventList cLEventList2) {
        int n2;
        PointerBuffer pointerBuffer = null;
        int n3 = 0;
        if (cLEventList != null) {
            pointerBuffer = cLEventList.IDsView;
            n3 = cLEventList.size;
        }
        if ((n2 = this.cl.clEnqueueTask(this.ID, cLKernel.ID, n3, pointerBuffer, cLEventList2 == null ? null : cLEventList2.IDs)) != 0) {
            CLException.checkForError(n2, "can not enqueue Task: " + cLKernel + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue put1DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4) {
        this.put1DRangeKernel(cLKernel, l2, l3, l4, null, null);
        return this;
    }

    public CLCommandQueue put1DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4, CLEventList cLEventList) {
        this.put1DRangeKernel(cLKernel, l2, l3, l4, null, cLEventList);
        return this;
    }

    public CLCommandQueue put1DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        PointerBuffer pointerBuffer2 = null;
        PointerBuffer pointerBuffer3 = null;
        if (l2 != 0L) {
            pointerBuffer = CLCommandQueue.copy2NIO(this.ibA, l2);
        }
        if (l3 != 0L) {
            pointerBuffer2 = CLCommandQueue.copy2NIO(this.ibB, l3);
        }
        if (l4 != 0L) {
            pointerBuffer3 = CLCommandQueue.copy2NIO(this.ibC, l4);
        }
        this.putNDRangeKernel(cLKernel, 1, pointerBuffer, pointerBuffer2, pointerBuffer3, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue put2DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4, long l5, long l6, long l7) {
        this.put2DRangeKernel(cLKernel, l2, l3, l4, l5, l6, l7, null, null);
        return this;
    }

    public CLCommandQueue put2DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4, long l5, long l6, long l7, CLEventList cLEventList) {
        this.put2DRangeKernel(cLKernel, l2, l3, l4, l5, l6, l7, null, cLEventList);
        return this;
    }

    public CLCommandQueue put2DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4, long l5, long l6, long l7, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        PointerBuffer pointerBuffer2 = null;
        PointerBuffer pointerBuffer3 = null;
        if (l2 != 0L || l3 != 0L) {
            pointerBuffer = CLCommandQueue.copy2NIO(this.ibA, l2, l3);
        }
        if (l4 != 0L || l5 != 0L) {
            pointerBuffer2 = CLCommandQueue.copy2NIO(this.ibB, l4, l5);
        }
        if (l6 != 0L || l7 != 0L) {
            pointerBuffer3 = CLCommandQueue.copy2NIO(this.ibC, l6, l7);
        }
        this.putNDRangeKernel(cLKernel, 2, pointerBuffer, pointerBuffer2, pointerBuffer3, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue put3DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
        this.put3DRangeKernel(cLKernel, l2, l3, l4, l5, l6, l7, l8, l9, l10, null, null);
        return this;
    }

    public CLCommandQueue put3DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, CLEventList cLEventList) {
        this.put3DRangeKernel(cLKernel, l2, l3, l4, l5, l6, l7, l8, l9, l10, null, cLEventList);
        return this;
    }

    public CLCommandQueue put3DRangeKernel(CLKernel cLKernel, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, CLEventList cLEventList, CLEventList cLEventList2) {
        PointerBuffer pointerBuffer = null;
        PointerBuffer pointerBuffer2 = null;
        PointerBuffer pointerBuffer3 = null;
        if (l2 != 0L || l3 != 0L || l4 != 0L) {
            pointerBuffer = CLCommandQueue.copy2NIO(this.ibA, l2, l3, l4);
        }
        if (l5 != 0L || l6 != 0L || l7 != 0L) {
            pointerBuffer2 = CLCommandQueue.copy2NIO(this.ibB, l5, l6, l7);
        }
        if (l8 != 0L || l9 != 0L || l10 != 0L) {
            pointerBuffer3 = CLCommandQueue.copy2NIO(this.ibC, l8, l9, l10);
        }
        this.putNDRangeKernel(cLKernel, 3, pointerBuffer, pointerBuffer2, pointerBuffer3, cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putNDRangeKernel(CLKernel cLKernel, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3) {
        this.putNDRangeKernel(cLKernel, n2, pointerBuffer, pointerBuffer2, pointerBuffer3, null, null);
        return this;
    }

    public CLCommandQueue putNDRangeKernel(CLKernel cLKernel, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, CLEventList cLEventList) {
        this.putNDRangeKernel(cLKernel, n2, pointerBuffer, pointerBuffer2, pointerBuffer3, null, cLEventList);
        return this;
    }

    public CLCommandQueue putNDRangeKernel(CLKernel cLKernel, int n2, PointerBuffer pointerBuffer, PointerBuffer pointerBuffer2, PointerBuffer pointerBuffer3, CLEventList cLEventList, CLEventList cLEventList2) {
        int n3;
        PointerBuffer pointerBuffer4 = null;
        int n4 = 0;
        if (cLEventList != null) {
            pointerBuffer4 = cLEventList.IDsView;
            n4 = cLEventList.size;
        }
        if ((n3 = this.cl.clEnqueueNDRangeKernel(this.ID, cLKernel.ID, n2, pointerBuffer, pointerBuffer2, pointerBuffer3, n4, pointerBuffer4, cLEventList2 == null ? null : cLEventList2.IDs)) != 0) {
            throw CLException.newException(n3, "can not enqueue " + n2 + "DRange " + cLKernel + "\n with gwo: " + CLCommandQueue.toStr(pointerBuffer) + " gws: " + CLCommandQueue.toStr(pointerBuffer2) + " lws: " + CLCommandQueue.toStr(pointerBuffer3) + " " + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putAcquireGLObject(CLGLObject cLGLObject) {
        this.putAcquireGLObject(cLGLObject, null, null);
        return this;
    }

    public CLCommandQueue putAcquireGLObject(CLGLObject cLGLObject, CLEventList cLEventList) {
        this.putAcquireGLObject(cLGLObject, null, cLEventList);
        return this;
    }

    public CLCommandQueue putAcquireGLObject(CLGLObject cLGLObject, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putAcquireGLObjects(CLCommandQueue.copy2NIO(this.ibA, cLGLObject.getID()), cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putAcquireGLObjects(CLGLObject cLGLObject, CLGLObject cLGLObject2, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putAcquireGLObjects(CLCommandQueue.copy2NIO(this.ibA, cLGLObject.getID(), cLGLObject2.getID()), cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putAcquireGLObjects(CLGLObject cLGLObject, CLGLObject cLGLObject2, CLGLObject cLGLObject3, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putAcquireGLObjects(CLCommandQueue.copy2NIO(this.ibA, cLGLObject.getID(), cLGLObject2.getID(), cLGLObject3.getID()), cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putAcquireGLObjects(PointerBuffer pointerBuffer, CLEventList cLEventList, CLEventList cLEventList2) {
        int n2;
        PointerBuffer pointerBuffer2 = null;
        int n3 = 0;
        if (cLEventList != null) {
            pointerBuffer2 = cLEventList.IDsView;
            n3 = cLEventList.size;
        }
        if ((n2 = this.cl.clEnqueueAcquireGLObjects(this.ID, pointerBuffer.remaining(), pointerBuffer, n3, pointerBuffer2, cLEventList2 == null ? null : cLEventList2.IDs)) != 0) {
            throw CLException.newException(n2, "can not aquire " + pointerBuffer + " with " + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue putReleaseGLObject(CLGLObject cLGLObject) {
        this.putReleaseGLObject(cLGLObject, null);
        return this;
    }

    public CLCommandQueue putReleaseGLObject(CLGLObject cLGLObject, CLEventList cLEventList) {
        this.putReleaseGLObject(cLGLObject, null, cLEventList);
        return this;
    }

    public CLCommandQueue putReleaseGLObject(CLGLObject cLGLObject, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putReleaseGLObjects(CLCommandQueue.copy2NIO(this.ibA, cLGLObject.getID()), cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putReleaseGLObjects(CLGLObject cLGLObject, CLGLObject cLGLObject2, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putReleaseGLObjects(CLCommandQueue.copy2NIO(this.ibA, cLGLObject.getID(), cLGLObject2.getID()), cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putReleaseGLObjects(CLGLObject cLGLObject, CLGLObject cLGLObject2, CLGLObject cLGLObject3, CLEventList cLEventList, CLEventList cLEventList2) {
        this.putReleaseGLObjects(CLCommandQueue.copy2NIO(this.ibA, cLGLObject.getID(), cLGLObject2.getID(), cLGLObject3.getID()), cLEventList, cLEventList2);
        return this;
    }

    public CLCommandQueue putReleaseGLObjects(PointerBuffer pointerBuffer, CLEventList cLEventList, CLEventList cLEventList2) {
        int n2;
        PointerBuffer pointerBuffer2 = null;
        int n3 = 0;
        if (cLEventList != null) {
            pointerBuffer2 = cLEventList.IDsView;
            n3 = cLEventList.size;
        }
        if ((n2 = this.cl.clEnqueueReleaseGLObjects(this.ID, pointerBuffer.remaining(), pointerBuffer, n3, pointerBuffer2, cLEventList2 == null ? null : cLEventList2.IDs)) != 0) {
            throw CLException.newException(n2, "can not release " + pointerBuffer + "with " + CLCommandQueue.toStr(cLEventList, cLEventList2));
        }
        if (cLEventList2 != null) {
            cLEventList2.createEvent(this.context);
        }
        return this;
    }

    public CLCommandQueue finish() {
        int n2 = this.cl.clFinish(this.ID);
        CLException.checkForError(n2, "can not finish command queue");
        return this;
    }

    public CLCommandQueue flush() {
        int n2 = this.cl.clFlush(this.ID);
        CLException.checkForError(n2, "can not flush command queue");
        return this;
    }

    public boolean isProfilingEnabled() {
        return ((long)Mode.PROFILING_MODE.QUEUE_MODE & this.properties) != 0L;
    }

    public boolean isOutOfOrderModeEnabled() {
        return ((long)Mode.OUT_OF_ORDER_MODE.QUEUE_MODE & this.properties) != 0L;
    }

    @Override
    public void release() {
        super.release();
        int n2 = this.cl.clReleaseCommandQueue(this.ID);
        this.context.onCommandQueueReleased(this.device, this);
        if (n2 != 0) {
            throw CLException.newException(n2, "can not release " + this);
        }
    }

    private static PointerBuffer copy2NIO(PointerBuffer pointerBuffer, long l2) {
        return (PointerBuffer)pointerBuffer.put(2, l2).position(2);
    }

    private static PointerBuffer copy2NIO(PointerBuffer pointerBuffer, long l2, long l3) {
        return (PointerBuffer)((PointerBuffer)pointerBuffer.position(1)).put(l2).put(l3).position(1);
    }

    private static PointerBuffer copy2NIO(PointerBuffer pointerBuffer, long l2, long l3, long l4) {
        return (PointerBuffer)((PointerBuffer)pointerBuffer.rewind()).put(l2).put(l3).put(l4).rewind();
    }

    private static String toStr(PointerBuffer pointerBuffer) {
        if (pointerBuffer == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (int i2 = pointerBuffer.position(); i2 < pointerBuffer.capacity(); ++i2) {
            stringBuilder.append(pointerBuffer.get(i2));
            if (i2 == pointerBuffer.capacity() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append('}').toString();
    }

    private static String toStr(CLEventList cLEventList, CLEventList cLEventList2) {
        return "\ncond.: " + cLEventList + " events: " + cLEventList2;
    }

    private String toStr(Integer ... integerArray) {
        return Arrays.asList(integerArray).toString();
    }

    private String bufferRectToString(String string, CLBuffer<?> cLBuffer, long l2, long l3, long l4, long l5, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, CLEventList cLEventList, CLEventList cLEventList2) {
        return "can not enqueue " + string + "-buffer-rect: " + cLBuffer + "\n with rowPitch: " + l2 + " slicePitch: " + l3 + " hostRowPitch: " + l4 + " hostSlicePitch: " + l5 + "\n origin: " + this.toStr(n2, n3, n4) + " hostPos: " + this.toStr(n5, n6, n7) + " range: " + this.toStr(n8, n9, n10) + CLCommandQueue.toStr(cLEventList, cLEventList2);
    }

    public CLDevice getDevice() {
        return this.device;
    }

    public EnumSet<Mode> getProperties() {
        return Mode.valuesOf(this.properties);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getProperties() + " on " + this.getDevice();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLCommandQueue cLCommandQueue = (CLCommandQueue)object;
        if (this.ID != cLCommandQueue.ID) {
            return false;
        }
        if (!(this.context == cLCommandQueue.context || this.context != null && this.context.equals(cLCommandQueue.context))) {
            return false;
        }
        return this.device == cLCommandQueue.device || this.device != null && this.device.equals(cLCommandQueue.device);
    }

    public int hashCode() {
        int n2 = 3;
        n2 = 89 * n2 + (int)(this.ID ^ this.ID >>> 32);
        n2 = 89 * n2 + (this.context != null ? this.context.hashCode() : 0);
        n2 = 89 * n2 + (this.device != null ? this.device.hashCode() : 0);
        return n2;
    }

    public static enum Mode {
        OUT_OF_ORDER_MODE(1),
        PROFILING_MODE(2);

        public final int QUEUE_MODE;

        private Mode(int n3) {
            this.QUEUE_MODE = n3;
        }

        public static Mode valueOf(int n2) {
            switch (n2) {
                case 1: {
                    return OUT_OF_ORDER_MODE;
                }
                case 2: {
                    return PROFILING_MODE;
                }
            }
            return null;
        }

        public static EnumSet<Mode> valuesOf(long l2) {
            Mode[] modeArray;
            ArrayList<Mode> arrayList = new ArrayList<Mode>();
            for (Mode mode : modeArray = Mode.values()) {
                if (((long)mode.QUEUE_MODE & l2) == 0L) continue;
                arrayList.add(mode);
            }
            if (arrayList.isEmpty()) {
                return EnumSet.noneOf(Mode.class);
            }
            return EnumSet.copyOf(arrayList);
        }
    }
}

