/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLSubBuffer;
import com.jogamp.opencl.llb.CL;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CLBuffer<B extends Buffer>
extends CLMemory<B> {
    private List<CLSubBuffer<B>> childs;

    protected CLBuffer(CLContext cLContext, long l2, long l3, int n2) {
        this(cLContext, null, l2, l3, n2);
    }

    protected CLBuffer(CLContext cLContext, B b2, long l2, long l3, int n2) {
        super(cLContext, b2, l2, l3, n2);
    }

    static CLBuffer<?> create(CLContext cLContext, int n2, int n3) {
        if (CLBuffer.isHostPointerFlag(n3)) {
            throw new IllegalArgumentException("no host pointer defined");
        }
        CL cL = cLContext.getPlatform().getCLBinding();
        int[] nArray = new int[1];
        long l2 = cL.clCreateBuffer(cLContext.ID, n3, n2, null, nArray, 0);
        CLException.checkForError(nArray[0], "can not create cl buffer");
        return new CLBuffer(cLContext, n2, l2, n3);
    }

    static <B extends Buffer> CLBuffer<B> create(CLContext cLContext, B b2, int n2) {
        if (!b2.isDirect()) {
            throw new IllegalArgumentException("buffer is not direct");
        }
        Buffer buffer = null;
        if (CLBuffer.isHostPointerFlag(n2)) {
            buffer = b2;
        }
        CL cL = cLContext.getPlatform().getCLBinding();
        int[] nArray = new int[1];
        int n3 = Buffers.sizeOfBufferElem(b2) * b2.capacity();
        long l2 = cL.clCreateBuffer(cLContext.ID, n2, n3, buffer, nArray, 0);
        CLException.checkForError(nArray[0], "can not create cl buffer");
        return new CLBuffer<B>(cLContext, b2, n3, l2, n2);
    }

    public CLSubBuffer<B> createSubBuffer(int n2, int n3, CLMemory.Mem ... memArray) {
        Buffer buffer;
        if (this.buffer != null) {
            buffer = Buffers.slice(this.buffer, n2, n3);
            int n4 = Buffers.sizeOfBufferElem(this.buffer);
            n2 *= n4;
            n3 *= n4;
        } else {
            buffer = null;
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(2);
        pointerBuffer.put(0, n2);
        pointerBuffer.put(1, n3);
        int n5 = CLMemory.Mem.flagsToInt(memArray);
        CL cL = this.getPlatform().getCLBinding();
        int[] nArray = new int[1];
        long l2 = cL.clCreateSubBuffer(this.ID, n5, 4640, pointerBuffer.getBuffer(), nArray, 0);
        CLException.checkForError(nArray[0], "can not create sub buffer");
        CLSubBuffer<Buffer> cLSubBuffer = new CLSubBuffer<Buffer>(this, n2, n3, buffer, l2, n5);
        if (this.childs == null) {
            this.childs = new ArrayList<CLSubBuffer<B>>();
        }
        this.childs.add(cLSubBuffer);
        return cLSubBuffer;
    }

    @Override
    public void release() {
        if (this.childs != null) {
            while (!this.childs.isEmpty()) {
                this.childs.get(0).release();
            }
        }
        super.release();
    }

    void onReleaseSubBuffer(CLSubBuffer<?> cLSubBuffer) {
        this.childs.remove(cLSubBuffer);
    }

    public List<CLSubBuffer<B>> getSubBuffers() {
        if (this.childs == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.childs);
    }

    public boolean isSubBuffer() {
        return false;
    }

    @Override
    public <T extends Buffer> CLBuffer<T> cloneWith(T t) {
        return new CLBuffer<T>(this.context, t, this.size, this.ID, this.FLAGS);
    }
}

