/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class WAVData {
    public final ByteBuffer data;
    public final int format;
    public final int size;
    public final int freq;
    public final boolean loop;

    public WAVData(ByteBuffer byteBuffer, int n2, int n3, int n4, boolean bl) {
        this.data = byteBuffer;
        this.format = n2;
        this.size = n3;
        this.freq = n4;
        this.loop = bl;
    }

    public static WAVData loadFromStream(InputStream inputStream, int n2, int n3, int n4, int n5, ByteOrder byteOrder, boolean bl, int n6) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n7 = 4352;
        if (n4 == 8 && n3 == 1) {
            n7 = 4352;
        } else if (n4 == 16 && n3 == 1) {
            n7 = 4353;
        } else if (n4 == 8 && n3 == 2) {
            n7 = 4354;
        } else if (n4 == 16 && n3 == 2) {
            n7 = 4355;
        }
        ByteBuffer byteBuffer = IOUtil.copyStream2ByteBuffer(inputStream, n2);
        if (n6 == 0) {
            n6 = byteBuffer.limit();
        }
        if (n4 == 16 && ByteOrder.nativeOrder() != byteOrder) {
            int n8 = byteBuffer.remaining();
            for (int i2 = 0; i2 < n8; i2 += 2) {
                byte by = byteBuffer.get(i2);
                byte by2 = byteBuffer.get(i2 + 1);
                byteBuffer.put(i2, by2);
                byteBuffer.put(i2 + 1, by);
            }
        }
        WAVData wAVData = new WAVData(byteBuffer, n7, n6, n5, bl);
        inputStream.close();
        return wAVData;
    }
}

