/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.AL;
import java.nio.ByteBuffer;

public class Buffer {
    public static final int FORMAT_MONO8 = 4352;
    public static final int FORMAT_MONO16 = 4353;
    public static final int FORMAT_STEREO8 = 4354;
    public static final int FORMAT_STEREO16 = 4355;
    final int bufferID;
    private ByteBuffer data;
    private final boolean isConfigured = false;
    private final AL al;

    Buffer(AL aL, int n2) {
        this.bufferID = n2;
        this.al = aL;
    }

    public void configure(ByteBuffer byteBuffer, int n2, int n3) {
        this.data = byteBuffer;
        this.al.alBufferData(this.bufferID, n2, byteBuffer, byteBuffer.capacity(), n3);
    }

    public void delete() {
        this.data = null;
        this.al.alDeleteBuffers(1, new int[]{this.bufferID}, 0);
    }

    public int getBitDepth() {
        int[] nArray = new int[1];
        this.al.alGetBufferi(this.bufferID, 8194, nArray, 0);
        return nArray[0];
    }

    public int getNumChannels() {
        int[] nArray = new int[1];
        this.al.alGetBufferi(this.bufferID, 8195, nArray, 0);
        return nArray[0];
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getFrequency() {
        int[] nArray = new int[1];
        this.al.alGetBufferi(this.bufferID, 8193, nArray, 0);
        return nArray[0];
    }

    public int getSize() {
        int[] nArray = new int[1];
        this.al.alGetBufferi(this.bufferID, 8196, nArray, 0);
        return nArray[0];
    }
}

