/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.oculusvr.ovrPoseStatef;
import com.jogamp.oculusvr.ovrPosef;
import com.jogamp.oculusvr.ovrSensorData;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrTrackingState {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrTrackingState_size = new int[]{200, 200, 200, 200, 200, 200, 200, 200, 200, 200};
    private static final int[] HeadPose_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] HeadPose_size = new int[]{88, 88, 88, 88, 88, 88, 88, 88, 88, 88};
    private static final int[] CameraPose_offset = new int[]{88, 88, 88, 88, 88, 88, 88, 88, 88, 88};
    private static final int[] CameraPose_size = new int[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] LeveledCameraPose_offset = new int[]{116, 116, 116, 116, 116, 116, 116, 116, 116, 116};
    private static final int[] LeveledCameraPose_size = new int[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] RawSensorData_offset = new int[]{144, 144, 144, 144, 144, 144, 144, 144, 144, 144};
    private static final int[] RawSensorData_size = new int[]{44, 44, 44, 44, 44, 44, 44, 44, 44, 44};
    private static final int[] StatusFlags_offset = new int[]{188, 188, 188, 188, 188, 188, 188, 188, 188, 188};
    private static final int[] LastCameraFrameCounter_offset = new int[]{192, 192, 192, 192, 192, 192, 192, 192, 192, 192};
    private static final int[] Pad_offset = new int[]{196, 196, 196, 196, 196, 196, 196, 196, 196, 196};

    public static int size() {
        return ovrTrackingState_size[mdIdx];
    }

    public static ovrTrackingState create() {
        return ovrTrackingState.create(Buffers.newDirectByteBuffer(ovrTrackingState.size()));
    }

    public static ovrTrackingState create(ByteBuffer byteBuffer) {
        return new ovrTrackingState(byteBuffer);
    }

    ovrTrackingState(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrTrackingState.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public ovrPoseStatef getHeadPose() {
        return ovrPoseStatef.create(this.accessor.slice(HeadPose_offset[mdIdx], HeadPose_size[mdIdx]));
    }

    public ovrPosef getCameraPose() {
        return ovrPosef.create(this.accessor.slice(CameraPose_offset[mdIdx], CameraPose_size[mdIdx]));
    }

    public ovrPosef getLeveledCameraPose() {
        return ovrPosef.create(this.accessor.slice(LeveledCameraPose_offset[mdIdx], LeveledCameraPose_size[mdIdx]));
    }

    public ovrSensorData getRawSensorData() {
        return ovrSensorData.create(this.accessor.slice(RawSensorData_offset[mdIdx], RawSensorData_size[mdIdx]));
    }

    public ovrTrackingState setStatusFlags(int n2) {
        this.accessor.setIntAt(StatusFlags_offset[mdIdx], n2, this.md.intSizeInBytes());
        return this;
    }

    public int getStatusFlags() {
        return this.accessor.getIntAt(StatusFlags_offset[mdIdx], this.md.intSizeInBytes());
    }

    public ovrTrackingState setLastCameraFrameCounter(int n2) {
        this.accessor.setIntAt(LastCameraFrameCounter_offset[mdIdx], n2);
        return this;
    }

    public int getLastCameraFrameCounter() {
        return this.accessor.getIntAt(LastCameraFrameCounter_offset[mdIdx]);
    }

    public ovrTrackingState setPad(int n2) {
        this.accessor.setIntAt(Pad_offset[mdIdx], n2);
        return this;
    }

    public int getPad() {
        return this.accessor.getIntAt(Pad_offset[mdIdx]);
    }
}

