/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.oculusvr.ovrSizei;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrRenderAPIConfigHeader {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrRenderAPIConfigHeader_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] API_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] BackBufferSize_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] BackBufferSize_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] Multisample_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    public static int size() {
        return ovrRenderAPIConfigHeader_size[mdIdx];
    }

    public static ovrRenderAPIConfigHeader create() {
        return ovrRenderAPIConfigHeader.create(Buffers.newDirectByteBuffer(ovrRenderAPIConfigHeader.size()));
    }

    public static ovrRenderAPIConfigHeader create(ByteBuffer byteBuffer) {
        return new ovrRenderAPIConfigHeader(byteBuffer);
    }

    ovrRenderAPIConfigHeader(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrRenderAPIConfigHeader.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public ovrRenderAPIConfigHeader setAPI(int n2) {
        this.accessor.setIntAt(API_offset[mdIdx], n2);
        return this;
    }

    public int getAPI() {
        return this.accessor.getIntAt(API_offset[mdIdx]);
    }

    public ovrSizei getBackBufferSize() {
        return ovrSizei.create(this.accessor.slice(BackBufferSize_offset[mdIdx], BackBufferSize_size[mdIdx]));
    }

    public ovrRenderAPIConfigHeader setMultisample(int n2) {
        this.accessor.setIntAt(Multisample_offset[mdIdx], n2, this.md.intSizeInBytes());
        return this;
    }

    public int getMultisample() {
        return this.accessor.getIntAt(Multisample_offset[mdIdx], this.md.intSizeInBytes());
    }
}

