/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrMatrix4f {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrMatrix4f_size = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    private static final int[] M_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] M_size = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};

    public static int size() {
        return ovrMatrix4f_size[mdIdx];
    }

    public static ovrMatrix4f create() {
        return ovrMatrix4f.create(Buffers.newDirectByteBuffer(ovrMatrix4f.size()));
    }

    public static ovrMatrix4f create(ByteBuffer byteBuffer) {
        return new ovrMatrix4f(byteBuffer);
    }

    ovrMatrix4f(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrMatrix4f.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public static final int getMArrayLength() {
        return 16;
    }

    public ovrMatrix4f setM(int n2, float[] fArray) {
        if (n2 + fArray.length > 16) {
            throw new IndexOutOfBoundsException("offset " + n2 + " + val.length " + fArray.length + " > array-length " + 16);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (64 > M_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal 64 > size " + M_size[mdIdx] + ", elemSize " + 4 + " * " + 16);
        }
        int n3 = M_offset[mdIdx];
        int n4 = n3 + 64;
        if (n4 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n4 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n3 + ", elemSize " + 4 + " * " + 16);
        }
        this.accessor.setFloatsAt(n3 += 4 * n2, fArray);
        return this;
    }

    public FloatBuffer getM() {
        return this.accessor.slice(M_offset[mdIdx], 64).asFloatBuffer();
    }

    public float[] getM(int n2, float[] fArray) {
        if (n2 + fArray.length > 16) {
            throw new IndexOutOfBoundsException("offset " + n2 + " + result.length " + fArray.length + " > array-length " + 16);
        }
        return this.accessor.getFloatsAt(M_offset[mdIdx] + 4 * n2, fArray);
    }
}

