/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.SurfaceSize;
import com.jogamp.newt.Display;
import java.util.Comparator;

public class MonitorMode
implements Comparable<MonitorMode> {
    public static final Comparator<MonitorMode> monitorModeComparator = new Comparator<MonitorMode>(){

        @Override
        public int compare(MonitorMode monitorMode, MonitorMode monitorMode2) {
            return monitorMode.compareTo(monitorMode2);
        }
    };
    public static final Comparator<MonitorMode> monitorModeComparatorInv = new Comparator<MonitorMode>(){

        @Override
        public int compare(MonitorMode monitorMode, MonitorMode monitorMode2) {
            return monitorMode2.compareTo(monitorMode);
        }
    };
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    public static final int FLAG_INTERLACE = 1;
    public static final int FLAG_DOUBLESCAN = 2;
    private final int nativeId;
    private final SizeAndRRate sizeAndRRate;
    private final int rotation;
    private final int hashCode;

    public static boolean isRotationValid(int n2) {
        return n2 == 0 || n2 == 90 || n2 == 180 || n2 == 270;
    }

    public MonitorMode(int n2, SizeAndRRate sizeAndRRate, int n3) {
        if (!MonitorMode.isRotationValid(n3)) {
            throw new RuntimeException("invalid rotation: " + n3);
        }
        this.nativeId = n2;
        this.sizeAndRRate = sizeAndRRate;
        this.rotation = n3;
        this.hashCode = this.getHashCode();
    }

    public MonitorMode(SurfaceSize surfaceSize, float f2, int n2, int n3) {
        this(0, new SizeAndRRate(surfaceSize, f2, n2), n3);
    }

    public final int getId() {
        return this.nativeId;
    }

    public final SizeAndRRate getSizeAndRRate() {
        return this.sizeAndRRate;
    }

    public final SurfaceSize getSurfaceSize() {
        return this.sizeAndRRate.surfaceSize;
    }

    public final float getRefreshRate() {
        return this.sizeAndRRate.refreshRate;
    }

    public final int getFlags() {
        return this.sizeAndRRate.flags;
    }

    public final int getRotation() {
        return this.rotation;
    }

    public final int getRotatedWidth() {
        return this.getRotatedWH(true);
    }

    public final int getRotatedHeight() {
        return this.getRotatedWH(false);
    }

    public final String toString() {
        return "[Id " + Display.toHexString(this.nativeId) + ", " + this.sizeAndRRate + ", " + this.rotation + " degr]";
    }

    @Override
    public int compareTo(MonitorMode monitorMode) {
        int n2 = this.sizeAndRRate.compareTo(monitorMode.sizeAndRRate);
        if (0 != n2) {
            return n2;
        }
        int n3 = 360 - this.rotation;
        int n4 = 360 - monitorMode.rotation;
        if (n3 > n4) {
            return 1;
        }
        if (n3 < n4) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonitorMode) {
            MonitorMode monitorMode = (MonitorMode)object;
            return monitorMode.nativeId == this.nativeId && monitorMode.sizeAndRRate.equals(this.sizeAndRRate) && monitorMode.rotation == this.rotation;
        }
        return false;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    private final int getHashCode() {
        int n2 = 31 + this.getId();
        n2 = (n2 << 5) - n2 + this.sizeAndRRate.hashCode();
        n2 = (n2 << 5) - n2 + this.getRotation();
        return n2;
    }

    private final int getRotatedWH(boolean bl) {
        boolean bl2;
        DimensionImmutable dimensionImmutable = this.sizeAndRRate.surfaceSize.getResolution();
        boolean bl3 = bl2 = 90 == this.rotation || 270 == this.rotation;
        if (bl && bl2 || !bl && !bl2) {
            return dimensionImmutable.getHeight();
        }
        return dimensionImmutable.getWidth();
    }

    public static class SizeAndRRate
    implements Comparable<SizeAndRRate> {
        public final SurfaceSize surfaceSize;
        public final int flags;
        public final float refreshRate;
        public final int hashCode;
        private static final String STR_INTERLACE = "Interlace";
        private static final String STR_DOUBLESCAN = "DoubleScan";
        private static final String STR_SEP = ", ";

        public SizeAndRRate(SurfaceSize surfaceSize, float f2, int n2) {
            if (null == surfaceSize) {
                throw new IllegalArgumentException("surfaceSize must be set (" + surfaceSize + ")");
            }
            this.surfaceSize = surfaceSize;
            this.flags = n2;
            this.refreshRate = f2;
            this.hashCode = this.getHashCode();
        }

        public static final StringBuilder flags2String(int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (0 != (n2 & 1)) {
                stringBuilder.append(STR_INTERLACE);
                bl = true;
            }
            if (0 != (n2 & 2)) {
                if (bl) {
                    stringBuilder.append(STR_SEP);
                }
                stringBuilder.append(STR_DOUBLESCAN);
                bl = true;
            }
            return stringBuilder;
        }

        public final String toString() {
            return this.surfaceSize + " @ " + this.refreshRate + " Hz, flags [" + SizeAndRRate.flags2String(this.flags).toString() + "]";
        }

        @Override
        public int compareTo(SizeAndRRate sizeAndRRate) {
            int n2;
            int n3 = this.surfaceSize.compareTo(sizeAndRRate.surfaceSize);
            if (0 != n3) {
                return n3;
            }
            int n4 = 0 == this.flags ? Integer.MAX_VALUE : this.flags;
            int n5 = n2 = 0 == sizeAndRRate.flags ? Integer.MAX_VALUE : sizeAndRRate.flags;
            if (n4 == n2) {
                float f2 = this.refreshRate - sizeAndRRate.refreshRate;
                if (Math.abs(f2) < 0.01f) {
                    return 0;
                }
                if (f2 > 0.01f) {
                    return 1;
                }
                return -1;
            }
            if (n4 > n2) {
                return 1;
            }
            if (n4 < n2) {
                return -1;
            }
            return 0;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SizeAndRRate) {
                SizeAndRRate sizeAndRRate = (SizeAndRRate)object;
                return this.surfaceSize.equals(sizeAndRRate.surfaceSize) && this.flags == sizeAndRRate.flags && this.refreshRate == sizeAndRRate.refreshRate;
            }
            return false;
        }

        public final int hashCode() {
            return this.hashCode;
        }

        private final int getHashCode() {
            int n2 = 31 + this.surfaceSize.hashCode();
            n2 = (n2 << 5) - n2 + this.flags;
            n2 = (n2 << 5) - n2 + (int)(this.refreshRate * 100.0f);
            return n2;
        }
    }
}

