/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.nativewindow.util.RectangleImmutable;
import java.util.List;

public class Rectangle
implements Cloneable,
RectangleImmutable {
    int x;
    int y;
    int width;
    int height;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public Rectangle(RectangleImmutable rectangleImmutable) {
        this.set(rectangleImmutable);
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public final Rectangle set(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        return this;
    }

    public final Rectangle set(RectangleImmutable rectangleImmutable) {
        this.x = rectangleImmutable.getX();
        this.y = rectangleImmutable.getY();
        this.width = rectangleImmutable.getWidth();
        this.height = rectangleImmutable.getHeight();
        return this;
    }

    public final Rectangle setX(int n2) {
        this.x = n2;
        return this;
    }

    public final Rectangle setY(int n2) {
        this.y = n2;
        return this;
    }

    public final Rectangle setWidth(int n2) {
        this.width = n2;
        return this;
    }

    public final Rectangle setHeight(int n2) {
        this.height = n2;
        return this;
    }

    @Override
    public final Rectangle union(RectangleImmutable rectangleImmutable) {
        return this.union(rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getX() + rectangleImmutable.getWidth() - 1, rectangleImmutable.getY() + rectangleImmutable.getHeight() - 1);
    }

    @Override
    public final Rectangle union(int n2, int n3, int n4, int n5) {
        int n6 = Math.min(this.x, n2);
        int n7 = Math.min(this.y, n3);
        int n8 = Math.max(this.x + this.width - 1, n4);
        int n9 = Math.max(this.y + this.height - 1, n5);
        return new Rectangle(n6, n7, n8 - n6 + 1, n9 - n7 + 1);
    }

    @Override
    public final Rectangle union(List<RectangleImmutable> list) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            RectangleImmutable rectangleImmutable = list.get(i2);
            n2 = Math.min(n2, rectangleImmutable.getX());
            n4 = Math.max(n4, rectangleImmutable.getX() + rectangleImmutable.getWidth());
            n3 = Math.min(n3, rectangleImmutable.getY());
            n5 = Math.max(n5, rectangleImmutable.getY() + rectangleImmutable.getHeight());
        }
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    @Override
    public final Rectangle intersection(RectangleImmutable rectangleImmutable) {
        return this.intersection(rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getX() + rectangleImmutable.getWidth() - 1, rectangleImmutable.getY() + rectangleImmutable.getHeight() - 1);
    }

    @Override
    public final Rectangle intersection(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = Math.max(this.x, n2);
        int n11 = Math.max(this.y, n3);
        int n12 = Math.min(this.x + this.width - 1, n4);
        int n13 = Math.min(this.y + this.height - 1, n5);
        if (n12 < n10) {
            n9 = 0;
            n8 = 0;
        } else {
            n9 = n10;
            n8 = n12 - n10 + 1;
        }
        if (n13 < n11) {
            n7 = 0;
            n6 = 0;
        } else {
            n7 = n11;
            n6 = n13 - n11 + 1;
        }
        return new Rectangle(n9, n7, n8, n6);
    }

    @Override
    public final float coverage(RectangleImmutable rectangleImmutable) {
        Rectangle rectangle = this.intersection(rectangleImmutable);
        float f2 = rectangle.getWidth() * rectangle.getHeight();
        float f3 = this.width * this.height;
        return f2 / f3;
    }

    @Override
    public final boolean contains(RectangleImmutable rectangleImmutable) {
        int n2 = this.x + this.width - 1;
        int n3 = this.y + this.height - 1;
        int n4 = rectangleImmutable.getX();
        int n5 = rectangleImmutable.getY();
        int n6 = n4 + rectangleImmutable.getWidth() - 1;
        int n7 = n5 + rectangleImmutable.getHeight() - 1;
        return n4 >= this.x && n5 >= this.y && n6 <= n2 && n7 <= n3;
    }

    public final Rectangle scale(int n2, int n3) {
        this.x *= n2;
        this.y *= n3;
        this.width *= n2;
        this.height *= n3;
        return this;
    }

    public final Rectangle scale(float f2, float f3) {
        this.x = (int)((float)this.x * f2 + 0.5f);
        this.y = (int)((float)this.y * f3 + 0.5f);
        this.width = (int)((float)this.width * f2 + 0.5f);
        this.height = (int)((float)this.height * f3 + 0.5f);
        return this;
    }

    public final Rectangle scaleInv(int n2, int n3) {
        this.x /= n2;
        this.y /= n3;
        this.width /= n2;
        this.height /= n3;
        return this;
    }

    public final Rectangle scaleInv(float f2, float f3) {
        this.x = (int)((float)this.x / f2 + 0.5f);
        this.y = (int)((float)this.y / f3 + 0.5f);
        this.width = (int)((float)this.width / f2 + 0.5f);
        this.height = (int)((float)this.height / f3 + 0.5f);
        return this;
    }

    @Override
    public int compareTo(RectangleImmutable rectangleImmutable) {
        int n2 = this.width * this.height;
        int n3 = rectangleImmutable.getWidth() * rectangleImmutable.getHeight();
        if (n2 > n3) {
            return 1;
        }
        if (n2 < n3) {
            return -1;
        }
        n2 = this.x * this.y;
        n3 = rectangleImmutable.getX() * rectangleImmutable.getY();
        if (n2 > n3) {
            return 1;
        }
        if (n2 < n3) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.y == rectangle.y && this.x == rectangle.x && this.height == rectangle.height && this.width == rectangle.width;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = this.x + this.height;
        int n3 = this.width + this.y;
        int n4 = n2 * (n2 + 1) / 2 + this.x;
        int n5 = n3 * (n3 + 1) / 2 + this.y;
        int n6 = n4 + n5;
        return n6 * (n6 + 1) / 2 + n5;
    }

    public String toString() {
        return "[ " + this.x + " / " + this.y + "  " + this.width + " x " + this.height + " ]";
    }
}

