/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.Bitstream;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelRectangle;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PixelFormatUtil {
    private static boolean DEBUG = false;

    public static final int find(PixelFormat.CType cType, PixelFormat.CType[] cTypeArray, boolean bl) {
        int n2;
        for (n2 = cTypeArray.length - 1; n2 >= 0 && cTypeArray[n2] != cType; --n2) {
        }
        if (0 > n2 && bl && 1 == cTypeArray.length && cTypeArray[0] == PixelFormat.CType.Y && (PixelFormat.CType.R == cType || PixelFormat.CType.G == cType || PixelFormat.CType.B == cType)) {
            return 0;
        }
        return n2;
    }

    public static int getShiftedI32(int n2, byte[] byArray, int n3) {
        if (n2 <= 4) {
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n4 |= (0xFF & byArray[n3 + i2]) << 8 * i2;
            }
            return n4;
        }
        throw new UnsupportedOperationException(n2 + " bytesPerPixel too big, i.e. > 4");
    }

    public static long getShiftedI64(int n2, byte[] byArray, int n3) {
        if (n2 <= 8) {
            long l2 = 0L;
            for (int i2 = 0; i2 < n2; ++i2) {
                l2 |= (long)((0xFF & byArray[n3 + i2]) << 8 * i2);
            }
            return l2;
        }
        throw new UnsupportedOperationException(n2 + " bytesPerPixel too big, i.e. > 8");
    }

    public static int getShiftedI32(int n2, ByteBuffer byteBuffer, boolean bl) {
        if (n2 <= 4) {
            int n3 = 0;
            if (bl) {
                int n4 = byteBuffer.position();
                for (int i2 = 0; i2 < n2; ++i2) {
                    n3 |= (0xFF & byteBuffer.get(n4 + i2)) << 8 * i2;
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    n3 |= (0xFF & byteBuffer.get()) << 8 * i3;
                }
            }
            return n3;
        }
        throw new UnsupportedOperationException(n2 + " bytesPerPixel too big, i.e. > 4");
    }

    public static long getShiftedI64(int n2, ByteBuffer byteBuffer, boolean bl) {
        if (n2 <= 8) {
            long l2 = 0L;
            if (bl) {
                int n3 = byteBuffer.position();
                for (int i2 = 0; i2 < n2; ++i2) {
                    l2 |= (long)((0xFF & byteBuffer.get(n3 + i2)) << 8 * i2);
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    l2 |= (long)((0xFF & byteBuffer.get()) << 8 * i3);
                }
            }
            return l2;
        }
        throw new UnsupportedOperationException(n2 + " bytesPerPixel too big, i.e. > 8");
    }

    public static PixelFormat getReversed(PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case RGB565: {
                return PixelFormat.BGR565;
            }
            case BGR565: {
                return PixelFormat.RGB565;
            }
            case RGBA5551: {
                return PixelFormat.ABGR1555;
            }
            case ABGR1555: {
                return PixelFormat.RGBA5551;
            }
            case RGB888: {
                return PixelFormat.BGR888;
            }
            case BGR888: {
                return PixelFormat.RGB888;
            }
            case RGBA8888: {
                return PixelFormat.ABGR8888;
            }
            case ABGR8888: {
                return PixelFormat.RGBA8888;
            }
            case ARGB8888: {
                return PixelFormat.BGRA8888;
            }
            case BGRA8888: {
                return PixelFormat.ABGR8888;
            }
        }
        return pixelFormat;
    }

    public static int convertToInt32(PixelFormat pixelFormat, byte by, byte by2, byte by3, byte by4) {
        switch (pixelFormat) {
            case LUMINANCE: {
                byte by5 = (byte)(((0xFF & by) + (0xFF & by2) + (0xFF & by3)) / 3 * by4);
                return 0xFF000000 | (0xFF & by5) << 16 | (0xFF & by5) << 8 | 0xFF & by5;
            }
            case RGB888: {
                return 0xFF000000 | (0xFF & by3) << 16 | (0xFF & by2) << 8 | 0xFF & by;
            }
            case BGR888: {
                return 0xFF000000 | (0xFF & by) << 16 | (0xFF & by2) << 8 | 0xFF & by3;
            }
            case RGBA8888: {
                return (0xFF & by4) << 24 | (0xFF & by3) << 16 | (0xFF & by2) << 8 | 0xFF & by;
            }
            case ABGR8888: {
                return (0xFF & by) << 24 | (0xFF & by2) << 16 | (0xFF & by3) << 8 | 0xFF & by4;
            }
            case ARGB8888: {
                return (0xFF & by3) << 24 | (0xFF & by2) << 16 | (0xFF & by) << 8 | 0xFF & by4;
            }
            case BGRA8888: {
                return (0xFF & by4) << 24 | (0xFF & by) << 16 | (0xFF & by2) << 8 | 0xFF & by3;
            }
        }
        throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat));
    }

    public static int convertToInt32(PixelFormat pixelFormat, PixelFormat pixelFormat2, ByteBuffer byteBuffer, int n2) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        switch (pixelFormat2) {
            case LUMINANCE: {
                by3 = by4 = byteBuffer.get(n2++);
                by2 = by4;
                by = -1;
                break;
            }
            case RGB888: {
                by4 = byteBuffer.get(n2++);
                by3 = byteBuffer.get(n2++);
                by2 = byteBuffer.get(n2++);
                by = -1;
                break;
            }
            case BGR888: {
                by2 = byteBuffer.get(n2++);
                by3 = byteBuffer.get(n2++);
                by4 = byteBuffer.get(n2++);
                by = -1;
                break;
            }
            case RGBA8888: {
                by4 = byteBuffer.get(n2++);
                by3 = byteBuffer.get(n2++);
                by2 = byteBuffer.get(n2++);
                by = byteBuffer.get(n2++);
                break;
            }
            case ABGR8888: {
                by = byteBuffer.get(n2++);
                by2 = byteBuffer.get(n2++);
                by3 = byteBuffer.get(n2++);
                by4 = byteBuffer.get(n2++);
                break;
            }
            case ARGB8888: {
                by = byteBuffer.get(n2++);
                by4 = byteBuffer.get(n2++);
                by3 = byteBuffer.get(n2++);
                by2 = byteBuffer.get(n2++);
                break;
            }
            case BGRA8888: {
                by2 = byteBuffer.get(n2++);
                by3 = byteBuffer.get(n2++);
                by4 = byteBuffer.get(n2++);
                by = byteBuffer.get(n2++);
                break;
            }
            default: {
                throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat2));
            }
        }
        return PixelFormatUtil.convertToInt32(pixelFormat, by4, by3, by2, by);
    }

    public static int convertToInt32(PixelFormat pixelFormat, PixelFormat pixelFormat2, int n2) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        switch (pixelFormat2) {
            case LUMINANCE: {
                by3 = by4 = (byte)n2;
                by2 = by4;
                by = -1;
                break;
            }
            case RGB888: {
                by4 = (byte)n2;
                by3 = (byte)(n2 >>> 8);
                by2 = (byte)(n2 >>> 16);
                by = -1;
                break;
            }
            case BGR888: {
                by2 = (byte)n2;
                by3 = (byte)(n2 >>> 8);
                by4 = (byte)(n2 >>> 16);
                by = -1;
                break;
            }
            case RGBA8888: {
                by4 = (byte)n2;
                by3 = (byte)(n2 >>> 8);
                by2 = (byte)(n2 >>> 16);
                by = (byte)(n2 >>> 24);
                break;
            }
            case ABGR8888: {
                by = (byte)n2;
                by2 = (byte)(n2 >>> 8);
                by3 = (byte)(n2 >>> 16);
                by4 = (byte)(n2 >>> 24);
                break;
            }
            case ARGB8888: {
                by = (byte)n2;
                by4 = (byte)(n2 >>> 8);
                by3 = (byte)(n2 >>> 16);
                by2 = (byte)(n2 >>> 24);
                break;
            }
            case BGRA8888: {
                by2 = (byte)n2;
                by3 = (byte)(n2 >>> 8);
                by4 = (byte)(n2 >>> 16);
                by = (byte)(n2 >>> 24);
                break;
            }
            default: {
                throw new InternalError("Unhandled format " + (Object)((Object)pixelFormat2));
            }
        }
        return PixelFormatUtil.convertToInt32(pixelFormat, by4, by3, by2, by);
    }

    public static PixelRectangle convert(PixelRectangle pixelRectangle, PixelFormat pixelFormat, int n2, boolean bl, boolean bl2) {
        int n3 = pixelRectangle.getSize().getWidth();
        int n4 = pixelRectangle.getSize().getHeight();
        int n5 = pixelFormat.comp.bytesPerPixel();
        int n6 = 0 != n2 ? n2 : n5 * n3;
        int n7 = n6 * n4;
        ByteBuffer byteBuffer = bl2 ? Buffers.newDirectByteBuffer(n7) : ByteBuffer.allocate(n7).order(pixelRectangle.getPixels().order());
        PixelFormatUtil.convert(pixelRectangle, byteBuffer, pixelFormat, bl, n6);
        return new PixelRectangle.GenericPixelRect(pixelFormat, pixelRectangle.getSize(), n6, bl, byteBuffer);
    }

    public static void convert(PixelRectangle pixelRectangle, ByteBuffer byteBuffer, PixelFormat pixelFormat, boolean bl, int n2) throws IllegalStateException {
        PixelFormatUtil.convert(pixelRectangle.getSize().getWidth(), pixelRectangle.getSize().getHeight(), pixelRectangle.getPixels(), pixelRectangle.getPixelformat(), pixelRectangle.isGLOriented(), pixelRectangle.getStride(), byteBuffer, pixelFormat, bl, n2);
    }

    public static void convert(int n2, int n3, ByteBuffer byteBuffer, PixelFormat pixelFormat, boolean bl, int n4, ByteBuffer byteBuffer2, PixelFormat pixelFormat2, boolean bl2, int n5) throws IllegalStateException, IllegalArgumentException {
        boolean bl3;
        PixelFormat.Composition composition = pixelFormat.comp;
        PixelFormat.Composition composition2 = pixelFormat2.comp;
        int n6 = composition.bytesPerPixel();
        int n7 = composition2.bytesPerPixel();
        if (0 != n4) {
            if (n4 < n6 * n2) {
                throw new IllegalArgumentException(String.format("Invalid %s stride %d, must be greater than bytesPerPixel %d * width %d", "source", n4, n6, n2));
            }
        } else {
            n4 = n6 * n2;
        }
        if (0 != n5) {
            if (n5 < n7 * n2) {
                throw new IllegalArgumentException(String.format("Invalid %s stride %d, must be greater than bytesPerPixel %d * width %d", "destination", n5, n7, n2));
            }
        } else {
            n5 = n7 * n2;
        }
        int n8 = composition2.bitStride();
        boolean bl4 = bl != bl2;
        boolean bl5 = bl3 = composition.equals(composition2) && 0 == n8 % 8;
        if (DEBUG) {
            System.err.println("XXX: size " + n2 + "x" + n3 + ", fast_copy " + bl3);
            System.err.println("XXX: SRC fmt " + (Object)((Object)pixelFormat) + ", " + composition + ", stride " + n4 + ", isGLOrient " + bl);
            System.err.println("XXX: DST fmt " + (Object)((Object)pixelFormat2) + ", " + composition2 + ", stride " + n5 + ", isGLOrient " + bl2);
        }
        if (bl3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n9 = bl4 ? (n3 - 1 - i2) * n4 : i2 * n4;
                int n10 = n5 * i2;
                for (int i3 = 0; i3 < n2; ++i3) {
                    byteBuffer2.put(n10 + 0, byteBuffer.get(n9 + 0));
                    if (2 <= n7) {
                        byteBuffer2.put(n10 + 1, byteBuffer.get(n9 + 1));
                        if (3 <= n7) {
                            byteBuffer2.put(n10 + 2, byteBuffer.get(n9 + 2));
                            if (4 <= n7) {
                                byteBuffer2.put(n10 + 3, byteBuffer.get(n9 + 3));
                            }
                        }
                    }
                    n9 += n6;
                    n10 += n7;
                }
            }
        } else {
            ComponentMap componentMap = new ComponentMap(pixelFormat.comp, pixelFormat2.comp);
            Bitstream.ByteBufferStream byteBufferStream = new Bitstream.ByteBufferStream(byteBuffer);
            Bitstream<ByteBuffer> bitstream = new Bitstream<ByteBuffer>(byteBufferStream, false);
            bitstream.setThrowIOExceptionOnEOF(true);
            Bitstream.ByteBufferStream byteBufferStream2 = new Bitstream.ByteBufferStream(byteBuffer2);
            Bitstream<ByteBuffer> bitstream2 = new Bitstream<ByteBuffer>(byteBufferStream2, true);
            bitstream2.setThrowIOExceptionOnEOF(true);
            if (DEBUG) {
                System.err.println("XXX: cmap.dst2src " + Arrays.toString(componentMap.dst2src));
                System.err.println("XXX: cmap.src2dst " + Arrays.toString(componentMap.src2dst));
                System.err.println("XXX: cmap.srcRGBA " + Arrays.toString(componentMap.srcRGBA));
                System.err.println("XXX: srcBitStream " + bitstream);
                System.err.println("XXX: dstBitStream " + bitstream2);
            }
            try {
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n11 = bl4 ? (n3 - 1 - i4) * n4 * 8 : i4 * n4 * 8;
                    bitstream.position(n11);
                    for (int i5 = 0; i5 < n2; ++i5) {
                        PixelFormatUtil.convert(componentMap, composition2, bitstream2, composition, bitstream);
                    }
                    bitstream2.skip(n5 * 8 - n8 * n2);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (DEBUG) {
                System.err.println("XXX: srcBitStream " + bitstream);
                System.err.println("XXX: dstBitStream " + bitstream2);
            }
        }
    }

    public static void convert(ComponentMap componentMap, PixelFormat.Composition composition, Bitstream<ByteBuffer> bitstream, PixelFormat.Composition composition2, Bitstream<ByteBuffer> bitstream2) throws IllegalStateException, IOException {
        int n2;
        int n3 = composition2.componentCount();
        int n4 = composition.componentCount();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n4];
        int[] nArray3 = composition2.componentBitCount();
        int[] nArray4 = composition2.componentBitMask();
        int[] nArray5 = composition.componentBitCount();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = bitstream2.readBits31(nArray3[n2]) & nArray4[n2];
        }
        bitstream2.skip(composition2.bitStride() - composition2.bitsPerPixel());
        for (n2 = 0; n2 < n4; ++n2) {
            nArray2[n2] = composition.defaultValue(n2, false);
        }
        if (1 == n4 && PixelFormat.CType.Y == composition.componentOrder()[0] && componentMap.hasSrcRGB) {
            n2 = nArray[componentMap.srcRGBA[0]];
            int n5 = nArray[componentMap.srcRGBA[1]];
            int n6 = nArray[componentMap.srcRGBA[2]];
            float f2 = composition2.toFloat(n2, componentMap.srcRGBA[0], false);
            float f3 = composition2.toFloat(n5, componentMap.srcRGBA[1], false);
            float f4 = composition2.toFloat(n6, componentMap.srcRGBA[2], false);
            int n7 = 1;
            float f5 = 1.0f;
            float f6 = (f2 + f3 + f4) * f5 / 3.0f;
            int n8 = composition.fromFloat(f6, 0, false);
            bitstream.writeBits31(nArray5[0], n8);
            bitstream.skip(composition.bitStride() - composition.bitsPerPixel());
            if (DEBUG && bitstream2.position() <= 32L) {
                System.err.printf("convert: rgb[a] -> Y: rgb 0x%02X 0x%02X 0x%02X 0x%02X -> %f %f %f %f -> %f -> dstC 0 0x%08X (%d bits: %s)%n", n2, n5, n6, n7, Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), n8, nArray5[0], Bitstream.toBinString(true, n8, nArray5[0]));
            }
            return;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n9 = componentMap.dst2src[n2];
            if (0 <= n9) {
                float f7 = composition2.toFloat(nArray[n9], n9, false);
                int n10 = composition.fromFloat(f7, n2, false);
                bitstream.writeBits31(nArray5[n2], n10);
                if (!DEBUG || bitstream2.position() > 32L) continue;
                System.err.printf("convert: srcC %d: 0x%08X -> %f -> dstC %d 0x%08X (%d bits: %s)%n", n9, nArray[n9], Float.valueOf(f7), n2, n10, nArray5[n2], Bitstream.toBinString(true, n10, nArray5[n2]));
                continue;
            }
            bitstream.writeBits31(nArray5[n2], nArray2[n2]);
            if (!DEBUG || bitstream2.position() > 32L) continue;
            System.err.printf("convert: srcC %d: undef -> dstC %d 0x%08X (%d bits: %s)%n", n9, n2, nArray2[n2], nArray5[n2], Bitstream.toBinString(true, nArray2[n2], nArray5[n2]));
        }
        bitstream.skip(composition.bitStride() - composition.bitsPerPixel());
    }

    public static class ComponentMap {
        final int[] dst2src;
        final int[] src2dst;
        final int[] srcRGBA;
        final boolean hasSrcRGB;

        public ComponentMap(PixelFormat.Composition composition, PixelFormat.Composition composition2) {
            int n2;
            int n3 = composition.componentCount();
            int n4 = composition2.componentCount();
            PixelFormat.CType[] cTypeArray = composition.componentOrder();
            PixelFormat.CType[] cTypeArray2 = composition2.componentOrder();
            this.dst2src = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                this.dst2src[n2] = PixelFormatUtil.find(cTypeArray2[n2], cTypeArray, true);
            }
            this.src2dst = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.src2dst[n2] = PixelFormatUtil.find(cTypeArray[n2], cTypeArray2, true);
            }
            this.srcRGBA = new int[4];
            this.srcRGBA[0] = PixelFormatUtil.find(PixelFormat.CType.R, cTypeArray, false);
            this.srcRGBA[1] = PixelFormatUtil.find(PixelFormat.CType.G, cTypeArray, false);
            this.srcRGBA[2] = PixelFormatUtil.find(PixelFormat.CType.B, cTypeArray, false);
            this.srcRGBA[3] = PixelFormatUtil.find(PixelFormat.CType.A, cTypeArray, false);
            this.hasSrcRGB = 0 <= this.srcRGBA[0] && 0 <= this.srcRGBA[1] && 0 <= this.srcRGBA[2];
        }
    }
}

