/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.javafx;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.macosx.MacOSXGraphicsDevice;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.sun.javafx.tk.TKStage;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import javafx.application.Platform;
import javafx.stage.Window;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class JFXAccessor {
    private static final boolean DEBUG;
    private static final boolean jfxAvailable;
    private static final Method fxUserThreadGetter;
    private static final Method tkStageGetter;
    private static final Method glassWindowGetter;
    private static final Method nativeWindowGetter;
    private static final String nwt;
    private static final boolean isOSX;
    private static final boolean isIOS;
    private static final boolean isWindows;
    private static final boolean isX11;

    public static boolean isJFXAvailable() {
        return jfxAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnJFXThread(boolean bl, Runnable runnable) {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            if (JFXAccessor.isJFXThreadOrHasJFXThreadStopped()) {
                runnable.run();
            } else if (!bl) {
                Platform.runLater((Runnable)runnable);
            } else {
                RunnableTask runnableTask = new RunnableTask(runnable, object, true, null);
                Platform.runLater((Runnable)runnableTask);
                try {
                    while (runnableTask.isInQueue()) {
                        object.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                Throwable throwable = runnableTask.getThrowable();
                if (null != throwable) {
                    if (throwable instanceof NativeWindowException) {
                        throw (NativeWindowException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    public static Thread getJFXThread() throws NativeWindowException {
        try {
            return (Thread)fxUserThreadGetter.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new NativeWindowException("Error getting JFX-Thread", throwable);
        }
    }

    public static String getJFXThreadName() {
        Thread thread2 = JFXAccessor.getJFXThread();
        return null != thread2 ? thread2.getName() : null;
    }

    public static boolean hasJFXThreadStopped() {
        Thread thread2 = JFXAccessor.getJFXThread();
        return null == thread2 || !thread2.isAlive();
    }

    public static boolean isJFXThread() {
        Thread thread2 = JFXAccessor.getJFXThread();
        return Thread.currentThread() == thread2;
    }

    public static boolean isJFXThreadOrHasJFXThreadStopped() {
        Thread thread2 = JFXAccessor.getJFXThread();
        return null == thread2 || !thread2.isAlive() || Thread.currentThread() == thread2;
    }

    public static AbstractGraphicsDevice getDevice(Window window) throws NativeWindowException, UnsupportedOperationException {
        if (isX11) {
            String string = null;
            long l2 = X11Util.openDisplay(string);
            if (0L == l2) {
                throw new NativeWindowException("Error creating display: " + string);
            }
            return new X11GraphicsDevice(l2, 0, true);
        }
        if (isWindows) {
            return new WindowsGraphicsDevice(0);
        }
        if (isOSX) {
            return new MacOSXGraphicsDevice(0);
        }
        throw new UnsupportedOperationException("n/a for this windowing system: " + nwt);
    }

    public static AbstractGraphicsScreen getScreen(AbstractGraphicsDevice abstractGraphicsDevice, int n2) {
        return NativeWindowFactory.createScreen(abstractGraphicsDevice, n2);
    }

    public static int getNativeVisualID(AbstractGraphicsDevice abstractGraphicsDevice, long l2) {
        if (isX11) {
            return X11Lib.GetVisualIDFromWindow(abstractGraphicsDevice.getHandle(), l2);
        }
        if (isWindows || isOSX) {
            return 0;
        }
        throw new UnsupportedOperationException("n/a for this windowing system: " + nwt);
    }

    public static long getWindowHandle(final Window window) throws NativeWindowException {
        final long[] lArray = new long[]{0L};
        JFXAccessor.runOnJFXThread(true, new Runnable(){

            @Override
            public void run() {
                try {
                    TKStage tKStage = (TKStage)tkStageGetter.invoke((Object)window, new Object[0]);
                    if (null != tKStage) {
                        Object object = glassWindowGetter.invoke((Object)tKStage, new Object[0]);
                        if (null != object) {
                            Object object2 = nativeWindowGetter.invoke(object, new Object[0]);
                            lArray[0] = (Long)object2;
                        } else if (DEBUG) {
                            System.err.println(Thread.currentThread().getName() + " - Info: JFXAccessor null GlassWindow");
                        }
                    } else if (DEBUG) {
                        System.err.println(Thread.currentThread().getName() + " - Info: JFXAccessor null TKStage");
                    }
                }
                catch (Throwable throwable) {
                    throw new NativeWindowException("Error getting Window handle", throwable);
                }
            }
        });
        return lArray[0];
    }

    static {
        final boolean[] blArray = new boolean[]{true};
        Method[] methodArray = SecurityUtil.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                Method[] methodArray;
                block4: {
                    NativeWindowFactory.initSingleton();
                    methodArray = new Method[]{null, null, null, null};
                    try {
                        int n2 = 0;
                        blArray[0] = Debug.debug("JFX");
                        Class<?> clazz = ReflectionUtil.getClass("com.sun.javafx.tk.Toolkit", false, JFXAccessor.class.getClassLoader());
                        methodArray[n2] = clazz.getDeclaredMethod("getFxUserThread", new Class[0]);
                        methodArray[n2++].setAccessible(true);
                        Class<?> clazz2 = ReflectionUtil.getClass("javafx.stage.Window", false, JFXAccessor.class.getClassLoader());
                        Class<?> clazz3 = ReflectionUtil.getClass("com.sun.javafx.tk.quantum.WindowStage", false, JFXAccessor.class.getClassLoader());
                        Class<?> clazz4 = ReflectionUtil.getClass("com.sun.glass.ui.Window", false, JFXAccessor.class.getClassLoader());
                        try {
                            methodArray[n2] = clazz2.getDeclaredMethod("getPeer", new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            methodArray[n2] = clazz2.getDeclaredMethod("impl_getPeer", new Class[0]);
                        }
                        methodArray[n2++].setAccessible(true);
                        methodArray[n2] = clazz3.getDeclaredMethod("getPlatformWindow", new Class[0]);
                        methodArray[n2++].setAccessible(true);
                        methodArray[n2] = clazz4.getDeclaredMethod("getNativeWindow", new Class[0]);
                        methodArray[n2++].setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        if (!blArray[0]) break block4;
                        ExceptionUtils.dumpThrowable("jfx-init", throwable);
                    }
                }
                return methodArray;
            }
        });
        int n2 = 0;
        fxUserThreadGetter = methodArray[n2++];
        tkStageGetter = methodArray[n2++];
        glassWindowGetter = methodArray[n2++];
        nativeWindowGetter = methodArray[n2++];
        jfxAvailable = null != fxUserThreadGetter && null != tkStageGetter && null != glassWindowGetter && null != nativeWindowGetter;
        nwt = NativeWindowFactory.getNativeWindowType(false);
        isOSX = ".macosx" == nwt;
        isIOS = ".ios" == nwt;
        isWindows = ".windows" == nwt;
        isX11 = ".x11" == nwt;
        DEBUG = blArray[0];
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - Info: JFXAccessor.<init> available " + jfxAvailable + ", nwt " + nwt + "( x11 " + isX11 + ", win " + isWindows + ", osx " + isOSX + ")");
        }
    }
}

