/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowException;
import java.util.List;
import jogamp.nativewindow.Debug;

public class DefaultCapabilitiesChooser
implements CapabilitiesChooser {
    private static final boolean DEBUG;
    private static final int NO_SCORE = -9999999;
    private static final int COLOR_MISMATCH_PENALTY_SCALE = 36;

    @Override
    public int chooseCapabilities(CapabilitiesImmutable capabilitiesImmutable, List<? extends CapabilitiesImmutable> list, int n2) {
        int n3;
        int n4;
        int n5;
        if (DEBUG) {
            System.err.println("Desired: " + capabilitiesImmutable);
            for (n5 = 0; n5 < list.size(); ++n5) {
                System.err.println("Available " + n5 + ": " + list.get(n5));
            }
            System.err.println("Window system's recommended choice: " + n2);
        }
        n5 = list.size();
        if (n2 >= 0 && n2 < n5 && null != list.get(n2)) {
            if (DEBUG) {
                System.err.println("Choosing window system's recommended choice of " + n2);
                System.err.println(list.get(n2));
            }
            return n2;
        }
        int[] nArray = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = -9999999;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            CapabilitiesImmutable capabilitiesImmutable2 = list.get(n4);
            if (capabilitiesImmutable2 == null || capabilitiesImmutable.isOnscreen() && !capabilitiesImmutable2.isOnscreen()) continue;
            n3 = 0;
            nArray[n4] = n3 += 36 * (capabilitiesImmutable2.getRedBits() + capabilitiesImmutable2.getGreenBits() + capabilitiesImmutable2.getBlueBits() + capabilitiesImmutable2.getAlphaBits() - (capabilitiesImmutable.getRedBits() + capabilitiesImmutable.getGreenBits() + capabilitiesImmutable.getBlueBits() + capabilitiesImmutable.getAlphaBits()));
        }
        if (DEBUG) {
            System.err.print("Scores: [");
            for (n4 = 0; n4 < n5; ++n4) {
                if (n4 > 0) {
                    System.err.print(",");
                }
                System.err.print(" " + nArray[n4]);
            }
            System.err.println(" ]");
        }
        n4 = -9999999;
        int n6 = -1;
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = nArray[n3];
            if (n7 == -9999999 || n4 != -9999999 && (Math.abs(n7) >= Math.abs(n4) || DefaultCapabilitiesChooser.sign(n4) >= 0 && DefaultCapabilitiesChooser.sign(n7) <= 0)) continue;
            n4 = n7;
            n6 = n3;
        }
        if (n6 < 0) {
            throw new NativeWindowException("Unable to select one of the provided Capabilities");
        }
        if (DEBUG) {
            System.err.println("Chosen index: " + n6);
            System.err.println("Chosen capabilities:");
            System.err.println(list.get(n6));
        }
        return n6;
    }

    private static int sign(int n2) {
        if (n2 < 0) {
            return -1;
        }
        return 1;
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined("nativewindow.debug.CapabilitiesChooser", true);
    }
}

