/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.VisualIDHolder;
import java.util.ArrayList;
import java.util.List;

public class CapabilitiesFilter {
    protected CapabilitiesFilter() {
    }

    public static <C extends CapabilitiesImmutable> ArrayList<C> removeMatching(ArrayList<C> arrayList, List<Test<C>> list) {
        ArrayList<CapabilitiesImmutable> arrayList2 = new ArrayList<CapabilitiesImmutable>();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            CapabilitiesImmutable capabilitiesImmutable = (CapabilitiesImmutable)arrayList.get(n2);
            boolean bl = false;
            for (int i2 = 0; !bl && i2 < list.size(); ++i2) {
                if (!list.get(i2).match(capabilitiesImmutable)) continue;
                arrayList2.add((CapabilitiesImmutable)arrayList.remove(n2));
                bl = true;
            }
            if (bl) continue;
            ++n2;
        }
        return arrayList2;
    }

    public static <C extends CapabilitiesImmutable> ArrayList<C> removeUnmatchingNativeVisualID(ArrayList<C> arrayList, int n2) {
        if (0 == n2) {
            return new ArrayList();
        }
        ArrayList<Test<C>> arrayList2 = new ArrayList<Test<C>>();
        arrayList2.add(new TestUnmatchedNativeVisualID(n2));
        return CapabilitiesFilter.removeMatching(arrayList, arrayList2);
    }

    public static <C extends CapabilitiesImmutable> ArrayList<C> removeMoreColorComps(ArrayList<C> arrayList, int n2) {
        ArrayList<Test<C>> arrayList2 = new ArrayList<Test<C>>();
        arrayList2.add(new TestMoreColorCompBits(n2));
        return CapabilitiesFilter.removeMatching(arrayList, arrayList2);
    }

    public static <C extends CapabilitiesImmutable> ArrayList<C> removeMoreColorCompsAndUnmatchingNativeVisualID(ArrayList<C> arrayList, int n2, int n3) {
        ArrayList<Test<C>> arrayList2 = new ArrayList<Test<C>>();
        arrayList2.add(new TestMoreColorCompBits(n2));
        if (0 != n3) {
            arrayList2.add(new TestUnmatchedNativeVisualID(n3));
        }
        return CapabilitiesFilter.removeMatching(arrayList, arrayList2);
    }

    public static interface Test<C extends CapabilitiesImmutable> {
        public boolean match(C var1);
    }

    public static class TestUnmatchedNativeVisualID<C extends CapabilitiesImmutable>
    implements Test<C> {
        final int requiredNativeVisualID;

        public TestUnmatchedNativeVisualID(int n2) {
            this.requiredNativeVisualID = n2;
        }

        @Override
        public final boolean match(C c2) {
            return c2.getVisualID(VisualIDHolder.VIDType.NATIVE) != this.requiredNativeVisualID;
        }
    }

    public static class TestMoreColorCompBits<C extends CapabilitiesImmutable>
    implements Test<C> {
        final int maxColorCompBits;

        public TestMoreColorCompBits(int n2) {
            this.maxColorCompBits = n2;
        }

        @Override
        public final boolean match(C c2) {
            return c2.getRedBits() > this.maxColorCompBits || c2.getGreenBits() > this.maxColorCompBits || c2.getBlueBits() > this.maxColorCompBits || c2.getAlphaBits() > this.maxColorCompBits;
        }
    }

    public static class TestLessColorCompBits<C extends CapabilitiesImmutable>
    implements Test<C> {
        final int minColorCompBits;

        public TestLessColorCompBits(int n2) {
            this.minColorCompBits = n2;
        }

        @Override
        public final boolean match(C c2) {
            return c2.getRedBits() < this.minColorCompBits || c2.getGreenBits() < this.minColorCompBits || c2.getBlueBits() < this.minColorCompBits || c2.getAlphaBits() < this.minColorCompBits;
        }
    }
}

