/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.locks;

import com.jogamp.common.util.locks.Lock;
import java.io.File;
import jogamp.common.util.locks.SingletonInstanceFileLock;
import jogamp.common.util.locks.SingletonInstanceServerSocket;

public abstract class SingletonInstance
implements Lock {
    protected static final boolean DEBUG = true;
    private final long poll_ms;
    private boolean locked = false;

    public static SingletonInstance createFileLock(long l2, String string) {
        return new SingletonInstanceFileLock(l2, string);
    }

    public static SingletonInstance createFileLock(long l2, File file) {
        return new SingletonInstanceFileLock(l2, file);
    }

    public static SingletonInstance createServerSocket(long l2, int n2) {
        return new SingletonInstanceServerSocket(l2, n2);
    }

    protected SingletonInstance(long l2) {
        this.poll_ms = Math.max(10L, l2);
    }

    public final long getPollPeriod() {
        return this.poll_ms;
    }

    public abstract String getName();

    public final String toString() {
        return this.getName();
    }

    @Override
    public synchronized void lock() throws RuntimeException {
        try {
            while (!this.tryLock(TIMEOUT)) {
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException(runtimeException);
        }
    }

    @Override
    public synchronized boolean tryLock(long l2) throws RuntimeException {
        long l3;
        if (this.locked) {
            return true;
        }
        long l4 = System.currentTimeMillis();
        int n2 = 0;
        try {
            do {
                l3 = System.currentTimeMillis();
                this.locked = this.tryLockImpl();
                if (this.locked) {
                    long l5 = System.currentTimeMillis();
                    System.err.println(this.infoPrefix(l5) + " +++ " + this.getName() + " - Locked within " + (l5 - l4) + " ms, " + (n2 + 1) + " attempts");
                    return true;
                }
                if (0 == n2) {
                    System.err.println(this.infoPrefix(System.currentTimeMillis()) + " III " + this.getName() + " - Wait for lock");
                }
                Thread.sleep(this.poll_ms);
                ++n2;
            } while (0L < (l2 -= System.currentTimeMillis() - l3));
        }
        catch (InterruptedException interruptedException) {
            long l6 = System.currentTimeMillis();
            throw new RuntimeException(this.infoPrefix(l6) + " EEE (1) " + this.getName() + " - couldn't get lock within " + (l6 - l4) + " ms, " + n2 + " attempts", interruptedException);
        }
        l3 = System.currentTimeMillis();
        System.err.println(this.infoPrefix(l3) + " +++ EEE (2) " + this.getName() + " - couldn't get lock within " + (l3 - l4) + " ms, " + n2 + " attempts");
        return false;
    }

    protected abstract boolean tryLockImpl();

    @Override
    public void unlock() throws RuntimeException {
        long l2 = System.currentTimeMillis();
        if (this.locked) {
            this.locked = !this.unlockImpl();
            long l3 = System.currentTimeMillis();
            System.err.println(this.infoPrefix(l3) + " --- " + this.getName() + " - Unlock " + (this.locked ? "failed" : "ok") + " within " + (l3 - l2) + " ms");
        }
    }

    protected abstract boolean unlockImpl();

    @Override
    public synchronized boolean isLocked() {
        return this.locked;
    }

    protected String infoPrefix(long l2) {
        return "SLOCK [T " + Thread.currentThread().getName() + " @ " + l2 + " ms";
    }

    protected String infoPrefix() {
        return this.infoPrefix(System.currentTimeMillis());
    }
}

