/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jogamp.common.Debug;

public class JarUtil {
    private static final boolean DEBUG = Debug.debug("JarUtil");
    private static final int BUFFER_SIZE = 4096;
    private static Resolver resolver;

    public static void setResolver(Resolver resolver) throws IllegalArgumentException, IllegalStateException, SecurityException {
        if (resolver == null) {
            throw new IllegalArgumentException("Null Resolver passed");
        }
        if (JarUtil.resolver != null) {
            throw new IllegalStateException("Resolver already set!");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        JarUtil.resolver = resolver;
    }

    public static boolean hasJarUri(String string, ClassLoader classLoader) {
        try {
            return null != JarUtil.getJarUri(string, classLoader);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Uri getJarUri(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        Uri uri;
        if (null == string || null == classLoader) {
            throw new IllegalArgumentException("null arguments: clazzBinName " + string + ", cl " + classLoader);
        }
        URL uRL = IOUtil.getClassURL(string, classLoader);
        String string2 = uRL.getProtocol();
        if (!(null == resolver || string2.equals("jar") || string2.equals("file") || string2.equals("http") || string2.equals("https"))) {
            URL uRL2 = resolver.resolve(uRL);
            uri = Uri.valueOf(uRL2);
            if (DEBUG) {
                System.err.println("getJarUri Resolver: " + uRL + "\n\t-> " + uRL2 + "\n\t-> " + uri);
            }
        } else {
            uri = Uri.valueOf(uRL);
            if (DEBUG) {
                System.err.println("getJarUri Default " + uRL + "\n\t-> " + uri);
            }
        }
        if (!uri.isJarScheme()) {
            throw new IllegalArgumentException("Uri is not using scheme jar: <" + uri + ">");
        }
        if (DEBUG) {
            System.err.println("getJarUri res: " + string + " -> " + uRL + " -> " + uri);
        }
        return uri;
    }

    public static Uri.Encoded getJarBasename(Uri uri) throws IllegalArgumentException {
        if (null == uri) {
            throw new IllegalArgumentException("Uri is null");
        }
        if (!uri.isJarScheme()) {
            throw new IllegalArgumentException("Uri is not using scheme jar: <" + uri + ">");
        }
        Uri.Encoded encoded = uri.schemeSpecificPart;
        int n2 = encoded.lastIndexOf(33);
        if (0 > n2) {
            throw new IllegalArgumentException("Uri does not contain jar uri terminator '!', in <" + uri + ">");
        }
        encoded = encoded.substring(0, n2);
        n2 = encoded.lastIndexOf(47);
        if (0 > n2 && 0 > (n2 = encoded.lastIndexOf(58))) {
            throw new IllegalArgumentException("Uri does not contain protocol terminator ':', in <" + uri + ">");
        }
        if (0 >= (encoded = encoded.substring(n2 + 1)).lastIndexOf(".jar")) {
            throw new IllegalArgumentException("No Jar name in <" + uri + ">");
        }
        if (DEBUG) {
            System.err.println("getJarName res: " + encoded);
        }
        return encoded;
    }

    public static Uri.Encoded getJarBasename(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        return JarUtil.getJarBasename(JarUtil.getJarUri(string, classLoader));
    }

    public static Uri.Encoded getJarEntry(Uri uri) {
        if (null == uri) {
            throw new IllegalArgumentException("Uri is null");
        }
        if (!uri.isJarScheme()) {
            throw new IllegalArgumentException("Uri is not a using scheme jar: <" + uri + ">");
        }
        Uri.Encoded encoded = uri.schemeSpecificPart;
        int n2 = encoded.lastIndexOf(33);
        if (0 <= n2) {
            Uri.Encoded encoded2 = encoded.substring(n2 + 1);
            if (DEBUG) {
                System.err.println("getJarEntry res: " + uri + " -> " + encoded + " -> " + n2 + " -> " + encoded2);
            }
            return encoded2;
        }
        throw new IllegalArgumentException("JAR Uri does not contain jar uri terminator '!', uri <" + uri + ">");
    }

    public static Uri getJarFileUri(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        if (null == string || null == classLoader) {
            throw new IllegalArgumentException("null arguments: clazzBinName " + string + ", cl " + classLoader);
        }
        Uri uri = JarUtil.getJarUri(string, classLoader).getContainedUri();
        Uri uri2 = Uri.cast("jar:" + uri.toString() + "!/");
        if (DEBUG) {
            System.err.println("getJarFileUri res: " + uri2);
        }
        return uri2;
    }

    public static Uri getJarFileUri(Uri uri, Uri.Encoded encoded) throws IllegalArgumentException, URISyntaxException {
        if (null == uri || null == encoded) {
            throw new IllegalArgumentException("null arguments: baseUri " + uri + ", jarFileName " + encoded);
        }
        return Uri.cast("jar:" + uri.toString() + encoded + "!/");
    }

    public static Uri getJarFileUri(Uri uri) throws IllegalArgumentException, URISyntaxException {
        if (null == uri) {
            throw new IllegalArgumentException("jarSubUri is null");
        }
        return Uri.cast("jar:" + uri.toString() + "!/");
    }

    public static Uri getJarFileUri(Uri.Encoded encoded) throws IllegalArgumentException, URISyntaxException {
        if (null == encoded) {
            throw new IllegalArgumentException("jarSubUriS is null");
        }
        return Uri.cast("jar:" + encoded + "!/");
    }

    public static Uri getJarEntryUri(Uri uri, Uri.Encoded encoded) throws IllegalArgumentException, URISyntaxException {
        if (null == encoded) {
            throw new IllegalArgumentException("jarEntry is null");
        }
        return Uri.cast(uri.toString() + encoded);
    }

    public static JarFile getJarFile(String string, ClassLoader classLoader) throws IOException, IllegalArgumentException, URISyntaxException {
        return JarUtil.getJarFile(JarUtil.getJarFileUri(string, classLoader));
    }

    public static JarFile getJarFile(Uri uri) throws IOException, IllegalArgumentException, URISyntaxException {
        URLConnection uRLConnection;
        if (null == uri) {
            throw new IllegalArgumentException("null jarFileUri");
        }
        if (DEBUG) {
            System.err.println("getJarFile.0: " + uri.toString());
        }
        URL uRL = uri.toURL();
        if (DEBUG) {
            System.err.println("getJarFile.1: " + uRL.toString());
        }
        if ((uRLConnection = uRL.openConnection()) instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            if (DEBUG) {
                System.err.println("getJarFile res: " + jarFile.getName());
            }
            return jarFile;
        }
        if (DEBUG) {
            System.err.println("getJarFile res: NULL");
        }
        return null;
    }

    public static Uri getRelativeOf(Class<?> clazz, Uri.Encoded encoded, Uri.Encoded encoded2) throws IllegalArgumentException, IOException, URISyntaxException {
        Uri uri;
        ClassLoader classLoader = clazz.getClassLoader();
        Uri uri2 = JarUtil.getJarUri(clazz.getName(), classLoader);
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: (classFromJavaJar " + clazz + ", classJarUri " + uri2 + ", cutOffInclSubDir " + encoded + ", relResPath " + encoded2 + "): ");
        }
        if (null == (uri = uri2.getContainedUri())) {
            throw new IllegalArgumentException("JarSubUri is null of: " + uri2);
        }
        Uri.Encoded encoded3 = uri.getDirectory().getEncoded();
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: uri " + uri.toString() + " -> " + encoded3);
        }
        Uri.Encoded encoded4 = encoded3.endsWith(encoded.get()) ? encoded3.concat(encoded2) : encoded3.concat(encoded).concat(encoded2);
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: ...  -> " + encoded4);
        }
        Uri uri3 = JarUtil.getJarFileUri(encoded4);
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: fin " + uri3);
        }
        return uri3;
    }

    public static Map<String, String> getNativeLibNames(JarFile jarFile) {
        if (DEBUG) {
            System.err.println("JarUtil: getNativeLibNames: " + jarFile);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            String string2 = NativeLibrary.isValidNativeLibraryName(string, false);
            if (null == string2) continue;
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int extract(File file, Map<String, String> map, JarFile jarFile, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (DEBUG) {
            System.err.println("JarUtil: extract: " + jarFile.getName() + " -> " + file + ", extractNativeLibraries " + bl + " (" + string + "), extractClassFiles " + bl2 + ", extractOtherFiles " + bl3);
        }
        int n2 = 0;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            boolean bl4;
            boolean bl5;
            boolean bl6;
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            String string3 = NativeLibrary.isValidNativeLibraryName(string2, false);
            boolean bl7 = bl6 = null != string3;
            if (bl6) {
                if (!bl) {
                    if (!DEBUG) continue;
                    System.err.println("JarUtil: JarEntry : " + string2 + " native-lib skipped, skip all native libs");
                    continue;
                }
                if (null != string) {
                    String string4;
                    String string5;
                    try {
                        string5 = IOUtil.slashify(string, false, true);
                        string4 = IOUtil.getDirname(string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new IOException(uRISyntaxException);
                    }
                    if (!string5.equals(string4)) {
                        if (!DEBUG) continue;
                        System.err.println("JarUtil: JarEntry : " + string2 + " native-lib skipped, not in path: " + string5);
                        continue;
                    }
                }
            }
            if ((bl5 = string2.endsWith(".class")) && !bl2) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string2 + " class-file skipped");
                continue;
            }
            if (!(bl6 || bl5 || bl3)) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string2 + " other-file skipped");
                continue;
            }
            boolean bl8 = string2.endsWith("/");
            boolean bl9 = bl4 = string2.indexOf(47) == -1 && string2.indexOf(File.separatorChar) == -1;
            if (DEBUG) {
                System.err.println("JarUtil: JarEntry : isNativeLib " + bl6 + ", isClassFile " + bl5 + ", isDir " + bl8 + ", isRootEntry " + bl4);
            }
            File file2 = new File(file, string2);
            if (bl8) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR: " + string2 + " -> " + file2);
                }
                file2.mkdirs();
                continue;
            }
            File file3 = new File(file2.getParent());
            if (!file3.exists()) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR (parent): " + string2 + " -> " + file3);
                }
                file3.mkdirs();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n3 = -1;
            try {
                n3 = IOUtil.copyStream2Stream(4096, bufferedInputStream, bufferedOutputStream, -1);
            }
            finally {
                ((InputStream)bufferedInputStream).close();
                ((OutputStream)bufferedOutputStream).close();
            }
            boolean bl10 = false;
            if (n3 > 0) {
                ++n2;
                if (bl6 && (bl4 || !map.containsKey(string3))) {
                    map.put(string3, file2.getAbsolutePath());
                    bl10 = true;
                    JarUtil.fixNativeLibAttribs(file2);
                }
            }
            if (!DEBUG) continue;
            System.err.println("JarUtil: EXTRACT[" + n2 + "]: [" + string3 + " -> ] " + string2 + " -> " + file2 + ": " + n3 + " bytes, addedAsNativeLib: " + bl10);
        }
        return n2;
    }

    private static final void fixNativeLibAttribs(File file) {
        block4: {
            if (Platform.OSType.MACOS == Platform.getOSType() || Platform.OSType.IOS == Platform.getOSType()) {
                String string = file.getAbsolutePath();
                try {
                    JarUtil.fixNativeLibAttribs(string);
                    if (DEBUG) {
                        System.err.println("JarUtil.fixNativeLibAttribs: " + string + " - OK");
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    System.err.println("JarUtil.fixNativeLibAttribs: " + string + " - " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
                }
            }
        }
    }

    private static native boolean fixNativeLibAttribs(String var0);

    public static final void validateCertificates(Certificate[] certificateArray, JarFile jarFile) throws IOException, SecurityException {
        if (DEBUG) {
            System.err.println("JarUtil: validateCertificates: " + jarFile.getName());
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Null certificates passed");
        }
        byte[] byArray = new byte[1024];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/")) continue;
            JarUtil.validateCertificate(certificateArray, jarFile, jarEntry, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void validateCertificate(Certificate[] certificateArray, JarFile jarFile, JarEntry jarEntry, byte[] byArray) throws IOException, SecurityException {
        if (DEBUG) {
            System.err.println("JarUtil: validate JarEntry : " + jarEntry.getName());
        }
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            while (inputStream.read(byArray) > 0) {
            }
        }
        Certificate[] certificateArray2 = jarEntry.getCertificates();
        if (certificateArray2 == null || certificateArray2.length == 0) {
            throw new SecurityException("no certificate for " + jarEntry.getName() + " in " + jarFile.getName());
        }
        if (!SecurityUtil.equals(certificateArray, certificateArray2)) {
            throw new SecurityException("certificates not equal for " + jarEntry.getName() + " in " + jarFile.getName());
        }
    }

    public static interface Resolver {
        public URL resolve(URL var1);
    }
}

