/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import jogamp.common.Debug;

public class Bitstream<T> {
    private static final boolean DEBUG = Debug.debug("Bitstream");
    public static final int EOS = -1;
    private ByteStream<T> bytes;
    private int bitBuffer;
    private int bitsDataMark;
    private int bitCount;
    private int bitsCountMark;
    private boolean outputMode;
    private boolean throwIOExceptionOnEOF;
    private static final boolean useFastPathStream = true;
    private static final boolean useFastPathTypes = true;
    private static final String strZeroPadding = "0000000000000000000000000000000000000000000000000000000000000000";

    public Bitstream(ByteStream<T> byteStream, boolean bl) throws IllegalArgumentException {
        this.bytes = byteStream;
        this.outputMode = bl;
        this.resetLocal();
        this.validateMode();
        this.throwIOExceptionOnEOF = false;
    }

    private final void resetLocal() {
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.bitsDataMark = 0;
        this.bitsCountMark = -1;
    }

    private final void validateMode() throws IllegalArgumentException {
        if (!this.canInput() && !this.canOutput()) {
            throw new IllegalArgumentException("stream can neither input nor output: " + this);
        }
        if (this.outputMode && !this.canOutput()) {
            throw new IllegalArgumentException("stream cannot output as requested: " + this);
        }
        if (!this.outputMode && !this.canInput()) {
            throw new IllegalArgumentException("stream cannot input as requested: " + this);
        }
    }

    public final void setThrowIOExceptionOnEOF(boolean bl) {
        this.throwIOExceptionOnEOF = bl;
    }

    public final boolean getThrowIOExceptionOnEOF() {
        return this.throwIOExceptionOnEOF;
    }

    public final void setStream(T t, boolean bl) throws IllegalArgumentException, IOException {
        if (null != this.bytes && this.outputMode) {
            this.flush();
        }
        this.bytes.setStream(t);
        this.outputMode = bl;
        this.resetLocal();
        this.validateMode();
    }

    public final ByteStream<T> getStream() {
        return this.bytes;
    }

    public final T getSubStream() {
        return this.bytes.getStream();
    }

    public final void close() throws IOException {
        if (null != this.bytes && this.outputMode) {
            this.flush();
        }
        this.bytes.close();
        this.bytes = null;
        this.resetLocal();
    }

    public final int flush() throws IllegalStateException, IOException {
        if (!this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        this.bytes.flush();
        if (0 != this.bitCount) {
            int n2 = this.bytes.write((byte)this.bitBuffer);
            this.bitBuffer = 0;
            this.bitCount = 0;
            if (-1 == n2) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
        }
        return 0;
    }

    public final boolean canInput() {
        return null != this.bytes ? this.bytes.canInput() : false;
    }

    public final boolean canOutput() {
        return null != this.bytes ? this.bytes.canOutput() : false;
    }

    public final void mark(int n2) throws IllegalStateException {
        if (this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        this.bytes.mark(n2);
        this.bitsDataMark = this.bitBuffer;
        this.bitsCountMark = this.bitCount;
    }

    public final void reset() throws IllegalStateException, IOException {
        if (this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (0 > this.bitsCountMark) {
            throw new IllegalStateException("markpos not set: " + this);
        }
        this.bytes.reset();
        this.bitBuffer = this.bitsDataMark;
        this.bitCount = this.bitsCountMark;
    }

    public final int getBitCount() {
        return this.bitCount;
    }

    public final int getLastBitPos() {
        return 7 - this.bitCount;
    }

    public final int getBitPosition() {
        if (0 == this.bitCount) {
            return 0;
        }
        return 8 - this.bitCount;
    }

    public final int getBitBuffer() {
        return this.bitBuffer;
    }

    public final long position() {
        if (null == this.bytes) {
            return -1L;
        }
        if (0 == this.bitCount) {
            return this.bytes.position() << 3;
        }
        long l2 = this.bytes.position() - (long)(this.outputMode ? 0 : 1);
        return (l2 << 3) + 8L - (long)this.bitCount;
    }

    public final long position(long l2) throws UnsupportedOperationException, IllegalArgumentException, IllegalStateException, IOException {
        if (0L > l2) {
            throw new IllegalArgumentException("new position not positive: " + l2);
        }
        this.bytes.position(0L);
        this.resetLocal();
        if (l2 > this.skip(l2)) {
            return -1L;
        }
        return l2;
    }

    public final int readBit(boolean bl) throws UnsupportedOperationException, IllegalStateException, IOException {
        if (this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (0 < this.bitCount) {
            --this.bitCount;
            if (bl) {
                return this.bitBuffer >>> this.bitCount & 1;
            }
            return this.bitBuffer >>> 7 - this.bitCount & 1;
        }
        this.bitBuffer = this.bytes.read();
        if (-1 == this.bitBuffer) {
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        this.bitCount = 7;
        if (bl) {
            return this.bitBuffer >>> 7;
        }
        return this.bitBuffer & 1;
    }

    public final int writeBit(boolean bl, int n2) throws IllegalStateException, IOException {
        if (!this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        if (0 < this.bitCount) {
            --this.bitCount;
            this.bitBuffer = bl ? (this.bitBuffer |= (1 & n2) << this.bitCount) : (this.bitBuffer |= (1 & n2) << 7 - this.bitCount);
            if (0 == this.bitCount) {
                int n3 = this.bytes.write((byte)this.bitBuffer);
                if (this.throwIOExceptionOnEOF && -1 == n3) {
                    throw new IOException("EOS " + this);
                }
                return n3;
            }
        } else {
            this.bitCount = 7;
            this.bitBuffer = bl ? (1 & n2) << 7 : 1 & n2;
        }
        return this.bitBuffer;
    }

    public long skip(long l2) throws IllegalStateException, IOException {
        if (null == this.bytes) {
            throw new IllegalStateException("closed: " + this);
        }
        if (DEBUG) {
            System.err.println("Bitstream.skip.0: " + l2 + " - " + this.toStringImpl());
        }
        if (l2 > 0L) {
            int n2;
            long l3;
            long l4;
            long l5;
            long l6;
            if (l2 <= (long)this.bitCount) {
                this.bitCount -= (int)l2;
                if (DEBUG) {
                    System.err.println("Bitstream.skip.F_N1: " + l2 + " - " + this.toStringImpl());
                }
                return l2;
            }
            if (this.outputMode) {
                if (0 < this.bitCount && -1 == this.bytes.write((byte)this.bitBuffer)) {
                    return 0L;
                }
                this.bitBuffer = 0;
            }
            if ((l6 = ((l5 = this.bytes.skip(l4 = (l3 = l2 - (long)this.bitCount) >>> 3)) << 3) + (long)(n2 = (int)(l3 - (l4 << 3))) + (long)this.bitCount) < l2) {
                this.bitCount = 0;
                this.bitBuffer = 0;
                if (DEBUG) {
                    System.err.println("Bitstream.skip.F_EOS: " + l2 + " - " + this.toStringImpl());
                }
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return l6;
            }
            this.bitCount = 8 - n2 & 7;
            int n3 = 0;
            if (!this.outputMode && 0 < this.bitCount) {
                this.bitBuffer = this.bytes.read();
                if (-1 == this.bitBuffer) {
                    n3 = this.bitCount;
                    this.bitCount = 0;
                }
            }
            if (DEBUG) {
                System.err.println("Bitstream.skip.F_N2: " + l2 + ", notReadBits " + n3 + " - " + this.toStringImpl());
            }
            return l6 - (long)n3;
        }
        return 0L;
    }

    public int readBits31(int n2) throws IllegalArgumentException, IOException {
        int n3;
        int n4;
        int n5;
        if (31 < n2) {
            throw new IllegalArgumentException("n > 31: " + n2);
        }
        if (this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in input-mode: " + this);
        }
        if (0 == n2) {
            return 0;
        }
        int n6 = n2;
        int n7 = Math.min(n2, this.bitCount);
        if (0 < n7) {
            n5 = (1 << n7) - 1;
            n4 = 7 - this.bitCount + 1;
            this.bitCount -= n7;
            n3 = n5 & this.bitBuffer >>> n4;
            if (0 == (n6 -= n7)) {
                return n3;
            }
        } else {
            n3 = 0;
        }
        assert (0 == this.bitCount);
        n5 = n7;
        do {
            this.bitBuffer = this.bytes.read();
            if (-1 == this.bitBuffer) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
            n4 = Math.min(n6, 8);
            int n8 = (1 << n4) - 1;
            this.bitCount = 8 - n4;
            n3 |= (n8 & this.bitBuffer) << n5;
            n5 += n4;
        } while (0 < (n6 -= n4));
        return n3;
    }

    public int writeBits31(int n2, int n3) throws IllegalStateException, IllegalArgumentException, IOException {
        if (31 < n2) {
            throw new IllegalArgumentException("n > 31: " + n2);
        }
        if (!this.outputMode || null == this.bytes) {
            throw new IllegalStateException("not in output-mode: " + this);
        }
        if (0 < n2) {
            int n4;
            int n5;
            int n6 = n2;
            int n7 = Math.min(n2, this.bitCount);
            if (0 < n7) {
                n5 = (1 << n7) - 1;
                n4 = 7 - this.bitCount + 1;
                this.bitCount -= n7;
                n6 -= n7;
                this.bitBuffer |= (n5 & n3) << n4;
                if (0 == this.bitCount && -1 == this.bytes.write((byte)this.bitBuffer)) {
                    if (this.throwIOExceptionOnEOF) {
                        throw new IOException("EOS " + this);
                    }
                    return -1;
                }
                if (0 == n6) {
                    return n3;
                }
            }
            assert (0 == this.bitCount);
            n5 = n7;
            do {
                n4 = Math.min(n6, 8);
                int n8 = (1 << n4) - 1;
                this.bitCount = 8 - n4;
                n6 -= n4;
                this.bitBuffer = n8 & n3 >>> n5;
                n5 += n4;
                if (0 != this.bitCount || -1 != this.bytes.write((byte)this.bitBuffer)) continue;
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            } while (0 < n6);
        }
        return n3;
    }

    public final int readUInt8() throws IllegalStateException, IOException {
        if (0 == this.bitCount) {
            if (this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n2 = this.bytes.read();
            if (this.throwIOExceptionOnEOF && -1 == n2) {
                throw new IOException("EOS " + this);
            }
            return n2;
        }
        return this.readBits31(8);
    }

    public final int writeInt8(byte by) throws IllegalStateException, IOException {
        if (0 == this.bitCount) {
            if (!this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            int n2 = this.bytes.write(by);
            if (this.throwIOExceptionOnEOF && -1 == n2) {
                throw new IOException("EOS " + this);
            }
            return n2;
        }
        return this.writeBits31(8, by);
    }

    public final int readUInt16(boolean bl) throws IllegalStateException, IOException {
        if (0 == this.bitCount) {
            int n2;
            if (this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n3 = this.bytes.read();
            int n4 = n2 = -1 != n3 ? this.bytes.read() : -1;
            if (-1 == n2) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1;
            }
            if (bl) {
                return n3 << 8 | n2;
            }
            return n2 << 8 | n3;
        }
        int n5 = this.readBits31(16);
        if (-1 == n5) {
            return -1;
        }
        if (bl) {
            int n6 = 0xFF & n5 >>> 8;
            int n7 = 0xFF & n5;
            return n7 << 8 | n6;
        }
        return n5;
    }

    public static final int readUInt16(boolean bl, byte[] byArray, int n2) throws IndexOutOfBoundsException {
        Bitstream.checkBounds(byArray, n2, 2);
        int n3 = byArray[n2] & 0xFF;
        int n4 = byArray[n2 + 1] & 0xFF;
        if (bl) {
            return n3 << 8 | n4;
        }
        return n4 << 8 | n3;
    }

    public final int writeInt16(boolean bl, short s) throws IllegalStateException, IOException {
        if (0 == this.bitCount) {
            byte by;
            byte by2;
            if (!this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            byte by3 = (byte)(0xFF & s >>> 8);
            byte by4 = (byte)(0xFF & s);
            if (bl) {
                by2 = by3;
                by = by4;
            } else {
                by2 = by4;
                by = by3;
            }
            if (-1 != this.bytes.write(by2) && -1 != this.bytes.write(by)) {
                return s;
            }
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        if (bl) {
            int n2 = 0xFF & s >>> 8;
            int n3 = 0xFF & s;
            return this.writeBits31(16, n3 << 8 | n2);
        }
        return this.writeBits31(16, s);
    }

    public final long readUInt32(boolean bl) throws IllegalStateException, IOException {
        int n2;
        if (0 == this.bitCount) {
            int n3;
            if (this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in input-mode: " + this);
            }
            int n4 = this.bytes.read();
            int n5 = -1 != n4 ? this.bytes.read() : -1;
            int n6 = -1 != n5 ? this.bytes.read() : -1;
            int n7 = n3 = -1 != n6 ? this.bytes.read() : -1;
            if (-1 == n3) {
                if (this.throwIOExceptionOnEOF) {
                    throw new IOException("EOS " + this);
                }
                return -1L;
            }
            if (bl) {
                return 0xFFFFFFFFL & (long)(n4 << 24 | n5 << 16 | n6 << 8 | n3);
            }
            return 0xFFFFFFFFL & (long)(n3 << 24 | n6 << 16 | n5 << 8 | n4);
        }
        int n8 = this.readBits31(16);
        int n9 = n2 = -1 != n8 ? this.readBits31(16) : -1;
        if (-1 == n2) {
            return -1L;
        }
        if (bl) {
            int n10 = 0xFF & n2 >>> 8;
            int n11 = 0xFF & n2;
            int n12 = 0xFF & n8 >>> 8;
            int n13 = 0xFF & n8;
            return 0xFFFFFFFFL & (long)(n13 << 24 | n12 << 16 | n11 << 8 | n10);
        }
        return 0xFFFFFFFFL & (long)(n2 << 16 | n8);
    }

    public static final long readUInt32(boolean bl, byte[] byArray, int n2) throws IndexOutOfBoundsException {
        Bitstream.checkBounds(byArray, n2, 4);
        byte by = byArray[n2];
        byte by2 = byArray[n2 + 1];
        byte by3 = byArray[n2 + 2];
        byte by4 = byArray[n2 + 3];
        if (bl) {
            return 0xFFFFFFFFL & (long)(by << 24 | by2 << 16 | by3 << 8 | by4);
        }
        return 0xFFFFFFFFL & (long)(by4 << 24 | by3 << 16 | by2 << 8 | by);
    }

    public final int writeInt32(boolean bl, int n2) throws IllegalStateException, IOException {
        if (0 == this.bitCount) {
            byte by;
            byte by2;
            byte by3;
            byte by4;
            if (!this.outputMode || null == this.bytes) {
                throw new IllegalStateException("not in output-mode: " + this);
            }
            byte by5 = (byte)(0xFF & n2 >>> 24);
            byte by6 = (byte)(0xFF & n2 >>> 16);
            byte by7 = (byte)(0xFF & n2 >>> 8);
            byte by8 = (byte)(0xFF & n2);
            if (bl) {
                by4 = by5;
                by3 = by6;
                by2 = by7;
                by = by8;
            } else {
                by4 = by8;
                by3 = by7;
                by2 = by6;
                by = by5;
            }
            if (-1 != this.bytes.write(by4) && -1 != this.bytes.write(by3) && -1 != this.bytes.write(by2) && -1 != this.bytes.write(by)) {
                return n2;
            }
            if (this.throwIOExceptionOnEOF) {
                throw new IOException("EOS " + this);
            }
            return -1;
        }
        if (bl) {
            int n3 = 0xFF & n2 >>> 24;
            int n4 = 0xFF & n2 >>> 16;
            int n5 = 0xFF & n2 >>> 8;
            int n6 = 0xFF & n2;
            if (-1 != this.writeBits31(16, n4 << 8 | n3) && -1 != this.writeBits31(16, n6 << 8 | n5)) {
                return n2;
            }
            return -1;
        }
        int n7 = 0xFFFF & n2 >>> 16;
        int n8 = 0xFFFF & n2;
        if (-1 != this.writeBits31(16, n8) && -1 != this.writeBits31(16, n7)) {
            return n2;
        }
        return -1;
    }

    public static final long toUInt32Long(int n2) {
        return 0xFFFFFFFFL & (long)n2;
    }

    public static final int toUInt32Int(int n2) {
        return Bitstream.uint32LongToInt(Bitstream.toUInt32Long(n2));
    }

    public static final int uint32LongToInt(long l2) {
        if (Integer.MAX_VALUE >= l2) {
            return (int)l2;
        }
        return -1;
    }

    public String toString() {
        return String.format("Bitstream[%s]", this.toStringImpl());
    }

    protected String toStringImpl() {
        long l2;
        String string;
        if (null == this.bytes) {
            string = "closed";
            l2 = -1L;
        } else {
            string = this.outputMode ? "output" : "input";
            l2 = this.bytes.position();
        }
        return String.format((Locale)null, "%s, pos %d [byteP %d, bitCnt %d], bitbuf %s", string, this.position(), l2, this.bitCount, Bitstream.toHexBinString(true, this.bitBuffer, 8));
    }

    public static String toBinString(boolean bl, int n2, int n3) {
        if (0 == n3) {
            return "";
        }
        if (bl) {
            int n4 = (int)((1L << n3) - 1L);
            String string = Integer.toBinaryString(n4 & n2);
            return strZeroPadding.substring(0, n3 - string.length()) + string;
        }
        char[] cArray = new char[32];
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2] = 0 != (n2 & 1 << i2) ? 49 : 48;
        }
        String string = new String(cArray, 0, n3);
        return string + strZeroPadding.substring(0, n3 - string.length());
    }

    public static String toHexBinString(boolean bl, int n2, int n3) {
        int n4 = 0 == n3 ? 2 : (n3 + 3) / 4;
        return String.format((Locale)null, "[0x%0" + n4 + "X, msbFirst %b, %s]", n2, bl, Bitstream.toBinString(bl, n2, n3));
    }

    public static final String toHexBinString(boolean bl, byte[] byArray, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = 0xFF & byArray[n2 + i2];
            stringBuilder.append(Bitstream.toHexBinString(bl, n4, 8)).append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final String toHexBinString(boolean bl, ByteBuffer byteBuffer, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = 0xFF & byteBuffer.get(n2 + i2);
            stringBuilder.append(Bitstream.toHexBinString(bl, n4, 8)).append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static void checkBounds(byte[] byArray, int n2, int n3) throws IndexOutOfBoundsException {
        if (n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("Buffer of size " + byArray.length + " cannot hold offset " + n2 + " + remaining " + n3);
        }
    }

    public static interface ByteStream<T> {
        public void setStream(T var1);

        public T getStream();

        public void close() throws IOException;

        public void flush() throws IOException;

        public boolean canInput();

        public boolean canOutput();

        public long position();

        public long position(long var1) throws UnsupportedOperationException, IllegalArgumentException;

        public long skip(long var1) throws IOException;

        public void mark(int var1) throws UnsupportedOperationException;

        public void reset() throws UnsupportedOperationException, IllegalStateException, IOException;

        public int read() throws UnsupportedOperationException, IOException;

        public int write(byte var1) throws UnsupportedOperationException, IOException;
    }

    public static class ByteOutputStream
    implements ByteStream<OutputStream> {
        private BufferedOutputStream media;
        private long pos = 0L;

        public ByteOutputStream(OutputStream outputStream) {
            this.setStream(outputStream);
        }

        @Override
        public void setStream(OutputStream outputStream) {
            this.media = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : (null != outputStream ? new BufferedOutputStream(outputStream) : null);
            this.pos = 0L;
        }

        @Override
        public void close() throws IOException {
            if (null != this.media) {
                this.media.close();
                this.media = null;
            }
        }

        @Override
        public void flush() throws IOException {
            if (null != this.media) {
                this.media.flush();
            }
        }

        @Override
        public boolean canInput() {
            return false;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long position(long l2) throws UnsupportedOperationException, IllegalArgumentException {
            throw new UnsupportedOperationException("N/a for " + this.getClass().getCanonicalName());
        }

        @Override
        public long skip(long l2) throws IOException {
            long l3;
            for (l3 = l2; l3 > 0L; --l3) {
                this.media.write(0);
            }
            long l4 = l2 - l3;
            this.pos += l4;
            return l4;
        }

        @Override
        public OutputStream getStream() {
            return this.media;
        }

        @Override
        public void mark(int n2) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public void reset() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public int read() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not allowed with output stream");
        }

        @Override
        public int write(byte by) throws IOException {
            int n2 = 0xFF & by;
            this.media.write(n2);
            if (DEBUG) {
                System.err.println("u8[" + this.pos + "] <- " + Bitstream.toHexBinString(true, n2, 8));
            }
            ++this.pos;
            return n2;
        }
    }

    public static class ByteInputStream
    implements ByteStream<InputStream> {
        private BufferedInputStream media;
        private long pos;
        private long posMark;

        public ByteInputStream(InputStream inputStream) {
            this.setStream(inputStream);
        }

        @Override
        public void setStream(InputStream inputStream) {
            this.media = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : (null != inputStream ? new BufferedInputStream(inputStream) : null);
            this.pos = 0L;
            this.posMark = -1L;
        }

        @Override
        public InputStream getStream() {
            return this.media;
        }

        @Override
        public void close() throws IOException {
            if (null != this.media) {
                this.media.close();
                this.media = null;
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return false;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long position(long l2) throws UnsupportedOperationException, IllegalArgumentException {
            throw new UnsupportedOperationException("N/a for " + this.getClass().getCanonicalName());
        }

        @Override
        public long skip(long l2) throws IOException {
            long l3 = this.media.skip(l2);
            this.pos += l3;
            return l3;
        }

        @Override
        public void mark(int n2) {
            this.media.mark(n2);
            this.posMark = this.pos;
        }

        @Override
        public void reset() throws IllegalStateException, IOException {
            if (0L > this.posMark) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.media.reset();
            this.pos = this.posMark;
        }

        @Override
        public int read() throws IOException {
            int n2 = this.media.read();
            if (DEBUG) {
                if (-1 != n2) {
                    System.err.println("u8[" + this.pos + "] -> " + Bitstream.toHexBinString(true, n2, 8));
                } else {
                    System.err.println("u8[" + this.pos + "] -> EOS");
                }
            }
            if (-1 != n2) {
                ++this.pos;
            }
            return n2;
        }

        @Override
        public int write(byte by) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not allowed with input stream");
        }
    }

    public static class ByteBufferStream
    implements ByteStream<ByteBuffer> {
        private ByteBuffer media;
        private int pos;
        private int posMark;

        public ByteBufferStream(ByteBuffer byteBuffer) {
            this.setStream(byteBuffer);
        }

        @Override
        public void setStream(ByteBuffer byteBuffer) {
            this.media = byteBuffer;
            this.pos = 0;
            this.posMark = -1;
        }

        @Override
        public ByteBuffer getStream() {
            return this.media;
        }

        @Override
        public void close() {
            this.media = null;
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long position(long l2) throws UnsupportedOperationException, IllegalArgumentException {
            if (l2 >= (long)this.media.limit()) {
                return -1L;
            }
            this.media.position((int)l2);
            this.pos = (int)l2;
            if (this.posMark > this.pos) {
                this.posMark = -1;
            }
            return this.pos;
        }

        @Override
        public long skip(long l2) {
            long l3;
            if (l2 >= 0L) {
                int n2 = this.media.limit() - this.pos;
                l3 = Math.min(n2, (int)l2);
            } else {
                int n3 = (int)l2 * -1;
                l3 = -1 * Math.min(this.pos, n3);
            }
            this.pos = (int)((long)this.pos + l3);
            return l3;
        }

        @Override
        public void mark(int n2) {
            this.posMark = this.pos;
        }

        @Override
        public void reset() throws IllegalStateException {
            if (0 > this.posMark) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.media.position(this.posMark);
            this.pos = this.posMark;
        }

        @Override
        public int read() {
            int n2 = this.media.limit() > this.pos ? 0xFF & this.media.get(this.pos++) : -1;
            if (DEBUG) {
                if (-1 != n2) {
                    System.err.println("u8[" + (this.pos - 1) + "] -> " + Bitstream.toHexBinString(true, n2, 8));
                } else {
                    System.err.println("u8[" + (this.pos - 0) + "] -> EOS");
                }
            }
            return n2;
        }

        @Override
        public int write(byte by) {
            int n2;
            if (this.media.limit() > this.pos) {
                this.media.put(this.pos++, by);
                n2 = 0xFF & by;
            } else {
                n2 = -1;
            }
            if (DEBUG) {
                if (-1 != n2) {
                    System.err.println("u8[" + (this.pos - 1) + "] <- " + Bitstream.toHexBinString(true, n2, 8));
                } else {
                    System.err.println("u8[" + (this.pos - 0) + "] <- EOS");
                }
            }
            return n2;
        }
    }

    public static class ByteArrayStream
    implements ByteStream<byte[]> {
        private byte[] media;
        private int pos;
        private int posMark;

        public ByteArrayStream(byte[] byArray) {
            this.setStream(byArray);
        }

        @Override
        public void setStream(byte[] byArray) {
            this.media = byArray;
            this.pos = 0;
            this.posMark = -1;
        }

        @Override
        public byte[] getStream() {
            return this.media;
        }

        @Override
        public void close() {
            this.media = null;
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public long position(long l2) throws UnsupportedOperationException, IllegalArgumentException {
            if (l2 >= (long)this.media.length) {
                return -1L;
            }
            this.pos = (int)l2;
            if (this.posMark > this.pos) {
                this.posMark = -1;
            }
            return this.pos;
        }

        @Override
        public long skip(long l2) {
            long l3;
            if (l2 >= 0L) {
                int n2 = this.media.length - this.pos;
                l3 = Math.min(n2, (int)l2);
            } else {
                int n3 = (int)l2 * -1;
                l3 = -1 * Math.min(this.pos, n3);
            }
            this.pos = (int)((long)this.pos + l3);
            return l3;
        }

        @Override
        public void mark(int n2) {
            this.posMark = this.pos;
        }

        @Override
        public void reset() throws IllegalStateException {
            if (0 > this.posMark) {
                throw new IllegalStateException("markpos not set");
            }
            if (DEBUG) {
                System.err.println("rewind: " + this.pos + " -> " + this.posMark);
            }
            this.pos = this.posMark;
        }

        @Override
        public int read() {
            int n2 = this.media.length > this.pos ? 0xFF & this.media[this.pos++] : -1;
            if (DEBUG) {
                if (-1 != n2) {
                    System.err.println("u8[" + (this.pos - 1) + "] -> " + Bitstream.toHexBinString(true, n2, 8));
                } else {
                    System.err.println("u8[" + (this.pos - 0) + "] -> EOS");
                }
            }
            return n2;
        }

        @Override
        public int write(byte by) {
            int n2;
            if (this.media.length > this.pos) {
                this.media[this.pos++] = by;
                n2 = 0xFF & by;
            } else {
                n2 = -1;
            }
            if (DEBUG) {
                if (-1 != n2) {
                    System.err.println("u8[" + (this.pos - 1) + "] <- " + Bitstream.toHexBinString(true, n2, 8));
                } else {
                    System.err.println("u8[" + (this.pos - 0) + "] <- EOS");
                }
            }
            return n2;
        }
    }
}

