/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayHashSet<E>
implements Cloneable,
Collection<E>,
List<E> {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final HashMap<E, E> map;
    private final ArrayList<E> data;
    private final boolean supportNullValue;

    public ArrayHashSet(boolean bl, int n2, float f2) {
        this.map = new HashMap(n2, f2);
        this.data = new ArrayList(n2);
        this.supportNullValue = bl;
    }

    public ArrayHashSet(ArrayHashSet<E> arrayHashSet) {
        this.map = new HashMap<E, E>(arrayHashSet.map);
        this.data = new ArrayList<E>(arrayHashSet.data);
        this.supportNullValue = arrayHashSet.supportNullValue;
    }

    public final boolean supportsNullValue() {
        return this.supportNullValue;
    }

    public final Object clone() {
        return new ArrayHashSet<E>(this);
    }

    public final ArrayList<E> getData() {
        return this.data;
    }

    public final HashMap<E, E> getMap() {
        return this.map;
    }

    public final String toString() {
        return this.data.toString();
    }

    @Override
    public final void clear() {
        this.data.clear();
        this.map.clear();
    }

    @Override
    public final boolean add(E e2) throws NullPointerException {
        if (!this.supportNullValue) {
            ArrayHashSet.checkNull(e2);
        }
        if (!this.map.containsKey(e2)) {
            if (null != this.map.put(e2, e2)) {
                throw new InternalError("Already existing, but checked before: " + e2);
            }
            if (!this.data.add(e2)) {
                throw new InternalError("Couldn't add element: " + e2);
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(Object object) throws NullPointerException {
        if (this.supportNullValue) {
            if (this.map.containsKey(object)) {
                this.map.remove(object);
                if (!this.data.remove(object)) {
                    throw new InternalError("Couldn't remove prev mapped element: " + object);
                }
                return true;
            }
        } else {
            ArrayHashSet.checkNull(object);
            if (null != this.map.remove(object)) {
                if (!this.data.remove(object)) {
                    throw new InternalError("Couldn't remove prev mapped element: " + object);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e2 : collection) {
            bl |= this.add(e2);
        }
        return bl;
    }

    @Override
    public final boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (collection.contains(obj)) continue;
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof ArrayHashSet)) {
            return false;
        }
        return this.data.equals(((ArrayHashSet)object).data);
    }

    @Override
    public final int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        return this.data.toArray(TArray);
    }

    @Override
    public final E get(int n2) {
        return this.data.get(n2);
    }

    @Override
    public final int indexOf(Object object) {
        return this.data.indexOf(object);
    }

    @Override
    public final void add(int n2, E e2) throws IllegalArgumentException, NullPointerException {
        if (!this.supportNullValue) {
            ArrayHashSet.checkNull(e2);
        }
        if (this.map.containsKey(e2)) {
            throw new IllegalArgumentException("Element " + e2 + " is already contained");
        }
        if (null != this.map.put(e2, e2)) {
            throw new InternalError("Already existing, but checked before: " + e2);
        }
        this.data.add(n2, e2);
    }

    @Override
    public final boolean addAll(int n2, Collection<? extends E> collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final E set(int n2, E e2) {
        E e3 = this.remove(n2);
        if (null != e3) {
            this.add(n2, e2);
        }
        return e3;
    }

    @Override
    public final E remove(int n2) {
        E e2 = this.get(n2);
        if (null != e2 && this.remove(e2)) {
            return e2;
        }
        return null;
    }

    @Override
    public final int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.data.listIterator();
    }

    @Override
    public final ListIterator<E> listIterator(int n2) {
        return this.data.listIterator(n2);
    }

    @Override
    public final List<E> subList(int n2, int n3) {
        return this.data.subList(n2, n3);
    }

    public final ArrayList<E> toArrayList() {
        return new ArrayList<E>(this.data);
    }

    public final E get(Object object) {
        return this.map.get(object);
    }

    public final E getOrAdd(E e2) throws NullPointerException {
        if (this.supportNullValue) {
            if (this.map.containsKey(e2)) {
                return this.map.get(e2);
            }
        } else {
            ArrayHashSet.checkNull(e2);
            E e3 = this.map.get(e2);
            if (null != e3) {
                return e3;
            }
        }
        if (!this.add(e2)) {
            throw new InternalError("Element not mapped, but contained in list: " + e2);
        }
        return e2;
    }

    public final boolean containsSafe(Object object) {
        return this.data.contains(object);
    }

    private static final void checkNull(Object object) throws NullPointerException {
        if (null == object) {
            throw new NullPointerException("Null element not supported");
        }
    }
}

