/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class StructAccessor {
    private final ByteBuffer bb;

    public StructAccessor(ByteBuffer byteBuffer) {
        this.bb = byteBuffer.order(ByteOrder.nativeOrder());
    }

    public final ByteBuffer getBuffer() {
        return this.bb;
    }

    public final ByteBuffer slice(int n2, int n3) {
        this.bb.position(n2);
        this.bb.limit(n2 + n3);
        ByteBuffer byteBuffer = this.bb.slice().order(this.bb.order());
        this.bb.position(0);
        this.bb.limit(this.bb.capacity());
        return byteBuffer;
    }

    public final byte getByteAt(int n2) {
        return this.bb.get(n2);
    }

    public final void setByteAt(int n2, byte by) {
        this.bb.put(n2, by);
    }

    public final boolean getBooleanAt(int n2) {
        return 0 != this.bb.get(n2);
    }

    public final void setBooleanAt(int n2, boolean bl) {
        this.bb.put(n2, bl ? (byte)1 : 0);
    }

    public final char getCharAt(int n2) {
        return this.bb.getChar(n2);
    }

    public final void setCharAt(int n2, char c2) {
        this.bb.putChar(n2, c2);
    }

    public final short getShortAt(int n2) {
        return this.bb.getShort(n2);
    }

    public final void setShortAt(int n2, short s) {
        this.bb.putShort(n2, s);
    }

    public final int getIntAt(int n2) {
        return this.bb.getInt(n2);
    }

    public final void setIntAt(int n2, int n3) {
        this.bb.putInt(n2, n3);
    }

    public final int getIntAt(int n2, int n3) {
        switch (n3) {
            case 2: {
                return this.bb.getShort(n2) & 0xFFFF;
            }
            case 4: {
                return this.bb.getInt(n2);
            }
            case 8: {
                return (int)(this.bb.getLong(n2) & 0xFFFFFFFFL);
            }
        }
        throw new InternalError("invalid nativeSizeInBytes " + n3);
    }

    public final void setIntAt(int n2, int n3, int n4) {
        switch (n4) {
            case 2: {
                this.bb.putShort(n2, (short)(n3 & 0xFFFF));
                break;
            }
            case 4: {
                this.bb.putInt(n2, n3);
                break;
            }
            case 8: {
                this.bb.putLong(n2, (long)n3 & 0xFFFFFFFFL);
                break;
            }
            default: {
                throw new InternalError("invalid nativeSizeInBytes " + n4);
            }
        }
    }

    public final float getFloatAt(int n2) {
        return this.bb.getFloat(n2);
    }

    public final void setFloatAt(int n2, float f2) {
        this.bb.putFloat(n2, f2);
    }

    public final double getDoubleAt(int n2) {
        return this.bb.getDouble(n2);
    }

    public final void setDoubleAt(int n2, double d2) {
        this.bb.putDouble(n2, d2);
    }

    public final long getLongAt(int n2) {
        return this.bb.getLong(n2);
    }

    public final void setLongAt(int n2, long l2) {
        this.bb.putLong(n2, l2);
    }

    public final long getLongAt(int n2, int n3) {
        switch (n3) {
            case 4: {
                return (long)this.bb.getInt(n2) & 0xFFFFFFFFL;
            }
            case 8: {
                return this.bb.getLong(n2);
            }
        }
        throw new InternalError("invalid nativeSizeInBytes " + n3);
    }

    public final void setLongAt(int n2, long l2, int n3) {
        switch (n3) {
            case 4: {
                this.bb.putInt(n2, (int)(l2 & 0xFFFFFFFFL));
                break;
            }
            case 8: {
                this.bb.putLong(n2, l2);
                break;
            }
            default: {
                throw new InternalError("invalid nativeSizeInBytes " + n3);
            }
        }
    }

    public final void setBytesAt(int n2, byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.bb.put(n2++, byArray[i2]);
        }
    }

    public final byte[] getBytesAt(int n2, byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = this.bb.get(n2++);
        }
        return byArray;
    }

    public final void setBooleansAt(int n2, boolean[] blArray) {
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            this.bb.put(n2++, blArray[i2] ? (byte)1 : 0);
        }
    }

    public final boolean[] getBooleansAt(int n2, boolean[] blArray) {
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            blArray[i2] = 0 != this.bb.get(n2++);
        }
        return blArray;
    }

    public final void setCharsAt(int n2, char[] cArray) {
        int n3 = 0;
        while (n3 < cArray.length) {
            this.bb.putChar(n2, cArray[n3]);
            ++n3;
            n2 += 2;
        }
    }

    public final char[] getCharsAt(int n2, char[] cArray) {
        int n3 = 0;
        while (n3 < cArray.length) {
            cArray[n3] = this.bb.getChar(n2);
            ++n3;
            n2 += 2;
        }
        return cArray;
    }

    public final void setShortsAt(int n2, short[] sArray) {
        int n3 = 0;
        while (n3 < sArray.length) {
            this.bb.putShort(n2, sArray[n3]);
            ++n3;
            n2 += 2;
        }
    }

    public final short[] getShortsAt(int n2, short[] sArray) {
        int n3 = 0;
        while (n3 < sArray.length) {
            sArray[n3] = this.bb.getShort(n2);
            ++n3;
            n2 += 2;
        }
        return sArray;
    }

    public final void setIntsAt(int n2, int[] nArray) {
        int n3 = 0;
        while (n3 < nArray.length) {
            this.bb.putInt(n2, nArray[n3]);
            ++n3;
            n2 += 4;
        }
    }

    public final int[] getIntsAt(int n2, int[] nArray) {
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = this.bb.getInt(n2);
            ++n3;
            n2 += 4;
        }
        return nArray;
    }

    public final void setFloatsAt(int n2, float[] fArray) {
        int n3 = 0;
        while (n3 < fArray.length) {
            this.bb.putFloat(n2, fArray[n3]);
            ++n3;
            n2 += 4;
        }
    }

    public final float[] getFloatsAt(int n2, float[] fArray) {
        int n3 = 0;
        while (n3 < fArray.length) {
            fArray[n3] = this.bb.getFloat(n2);
            ++n3;
            n2 += 4;
        }
        return fArray;
    }

    public final void setDoublesAt(int n2, double[] dArray) {
        int n3 = 0;
        while (n3 < dArray.length) {
            this.bb.putDouble(n2, dArray[n3]);
            ++n3;
            n2 += 8;
        }
    }

    public final double[] getDoublesAt(int n2, double[] dArray) {
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = this.bb.getDouble(n2);
            ++n3;
            n2 += 8;
        }
        return dArray;
    }

    public final void setLongsAt(int n2, long[] lArray) {
        int n3 = 0;
        while (n3 < lArray.length) {
            this.bb.putLong(n2, lArray[n3]);
            ++n3;
            n2 += 8;
        }
    }

    public final long[] getLongsAt(int n2, long[] lArray) {
        int n3 = 0;
        while (n3 < lArray.length) {
            lArray[n3] = this.bb.getLong(n2);
            ++n3;
            n2 += 8;
        }
        return lArray;
    }
}

