/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.UnsafeUtil;
import com.jogamp.common.util.ValueConv;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.security.PrivilegedAction;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class Buffers {
    static final boolean DEBUG = Debug.debug("Buffers");
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    protected Buffers() {
    }

    public static ByteBuffer newDirectByteBuffer(int n2) {
        return Buffers.nativeOrder(ByteBuffer.allocateDirect(n2));
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n2, int n3) {
        return (ByteBuffer)Buffers.newDirectByteBuffer(n3).put(byArray, n2, n3).rewind();
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n2) {
        return Buffers.newDirectByteBuffer(byArray, n2, byArray.length - n2);
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray) {
        return Buffers.newDirectByteBuffer(byArray, 0);
    }

    public static DoubleBuffer newDirectDoubleBuffer(int n2) {
        return Buffers.newDirectByteBuffer(n2 * 8).asDoubleBuffer();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n2, int n3) {
        return (DoubleBuffer)Buffers.newDirectDoubleBuffer(n3).put(dArray, n2, n3).rewind();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n2) {
        return Buffers.newDirectDoubleBuffer(dArray, n2, dArray.length - n2);
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray) {
        return Buffers.newDirectDoubleBuffer(dArray, 0);
    }

    public static FloatBuffer newDirectFloatBuffer(int n2) {
        return Buffers.newDirectByteBuffer(n2 * 4).asFloatBuffer();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n2, int n3) {
        return (FloatBuffer)Buffers.newDirectFloatBuffer(n3).put(fArray, n2, n3).rewind();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n2) {
        return Buffers.newDirectFloatBuffer(fArray, n2, fArray.length - n2);
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray) {
        return Buffers.newDirectFloatBuffer(fArray, 0);
    }

    public static IntBuffer newDirectIntBuffer(int n2) {
        return Buffers.newDirectByteBuffer(n2 * 4).asIntBuffer();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n2, int n3) {
        return (IntBuffer)Buffers.newDirectIntBuffer(n3).put(nArray, n2, n3).rewind();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n2) {
        return Buffers.newDirectIntBuffer(nArray, n2, nArray.length - n2);
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray) {
        return Buffers.newDirectIntBuffer(nArray, 0);
    }

    public static LongBuffer newDirectLongBuffer(int n2) {
        return Buffers.newDirectByteBuffer(n2 * 8).asLongBuffer();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n2, int n3) {
        return (LongBuffer)Buffers.newDirectLongBuffer(n3).put(lArray, n2, n3).rewind();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n2) {
        return Buffers.newDirectLongBuffer(lArray, n2, lArray.length - n2);
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray) {
        return Buffers.newDirectLongBuffer(lArray, 0);
    }

    public static ShortBuffer newDirectShortBuffer(int n2) {
        return Buffers.newDirectByteBuffer(n2 * 2).asShortBuffer();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n2, int n3) {
        return (ShortBuffer)Buffers.newDirectShortBuffer(n3).put(sArray, n2, n3).rewind();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n2) {
        return Buffers.newDirectShortBuffer(sArray, n2, sArray.length - n2);
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray) {
        return Buffers.newDirectShortBuffer(sArray, 0);
    }

    public static CharBuffer newDirectCharBuffer(int n2) {
        return Buffers.newDirectByteBuffer(n2 * 2).asCharBuffer();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n2, int n3) {
        return (CharBuffer)Buffers.newDirectCharBuffer(n3).put(cArray, n2, n3).rewind();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n2) {
        return Buffers.newDirectCharBuffer(cArray, n2, cArray.length - n2);
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray) {
        return Buffers.newDirectCharBuffer(cArray, 0);
    }

    public static <B extends Buffer> B slice(B b2) {
        if (b2 instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)b2;
            return (B)byteBuffer.slice().order(byteBuffer.order());
        }
        if (b2 instanceof IntBuffer) {
            return (B)((IntBuffer)b2).slice();
        }
        if (b2 instanceof ShortBuffer) {
            return (B)((ShortBuffer)b2).slice();
        }
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).slice();
        }
        if (b2 instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b2).slice();
        }
        if (b2 instanceof LongBuffer) {
            return (B)((LongBuffer)b2).slice();
        }
        if (b2 instanceof CharBuffer) {
            return (B)((CharBuffer)b2).slice();
        }
        throw new IllegalArgumentException("unexpected buffer type: " + b2.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B extends Buffer> B slice(B b2, int n2, int n3) {
        int n4 = b2.position();
        int n5 = b2.limit();
        B b3 = null;
        try {
            b2.position(n2).limit(n2 + n3);
            b3 = Buffers.slice(b2);
        }
        finally {
            b2.position(n4).limit(n5);
        }
        return b3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FloatBuffer slice2Float(Buffer buffer, int n2, int n3) {
        FloatBuffer floatBuffer;
        block8: {
            int n4;
            int n5;
            if (null != buffer) {
                n5 = buffer.position();
                n4 = buffer.limit();
            } else {
                n5 = 0;
                n4 = 0;
            }
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n2 * 4);
                    byteBuffer.limit((n2 + n3) * 4);
                    floatBuffer = byteBuffer.slice().order(byteBuffer.order()).asFloatBuffer();
                    break block8;
                }
                if (buffer instanceof FloatBuffer) {
                    FloatBuffer floatBuffer2 = (FloatBuffer)buffer;
                    floatBuffer2.position(n2);
                    floatBuffer2.limit(n2 + n3);
                    floatBuffer = floatBuffer2.slice();
                    break block8;
                }
                throw new InternalError("Buffer not ByteBuffer, nor FloarBuffer, nor backing array given");
            }
            finally {
                if (null != buffer) {
                    buffer.position(n5).limit(n4);
                }
            }
        }
        floatBuffer.mark();
        return floatBuffer;
    }

    public static final FloatBuffer slice2Float(float[] fArray, int n2, int n3) {
        return (FloatBuffer)FloatBuffer.wrap(fArray, n2, n3).mark();
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static int sizeOfBufferElem(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof ByteBuffer) {
            return 1;
        }
        if (object instanceof IntBuffer) {
            return 4;
        }
        if (object instanceof ShortBuffer) {
            return 2;
        }
        if (object instanceof FloatBuffer) {
            return 4;
        }
        if (object instanceof DoubleBuffer) {
            return 8;
        }
        if (object instanceof LongBuffer) {
            return 8;
        }
        if (object instanceof CharBuffer) {
            return 2;
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).elementSize();
        }
        throw new RuntimeException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int remainingElem(Object object) throws IllegalArgumentException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).remaining();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).remaining();
        }
        throw new IllegalArgumentException("Unsupported anonymous buffer type: " + object.getClass().getCanonicalName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int remainingBytes(Object object) throws IllegalArgumentException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n2 = ((Buffer)object).remaining();
            if (object instanceof ByteBuffer) {
                return n2;
            }
            if (object instanceof FloatBuffer) {
                return n2 * 4;
            }
            if (object instanceof IntBuffer) {
                return n2 * 4;
            }
            if (object instanceof ShortBuffer) {
                return n2 * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n2 * 8;
            }
            if (object instanceof LongBuffer) {
                return n2 * 8;
            }
            if (!(object instanceof CharBuffer)) throw new InternalError("Unsupported Buffer type: " + object.getClass().getCanonicalName());
            return n2 * 2;
        }
        if (!(object instanceof NativeBuffer)) throw new IllegalArgumentException("Unsupported anonymous buffer type: " + object.getClass().getCanonicalName());
        NativeBuffer nativeBuffer = (NativeBuffer)object;
        return nativeBuffer.remaining() * nativeBuffer.elementSize();
    }

    public static boolean isDirect(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).isDirect();
        }
        if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).isDirect();
        }
        throw new IllegalArgumentException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n2 = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return n2;
            }
            if (object instanceof FloatBuffer) {
                return n2 * 4;
            }
            if (object instanceof IntBuffer) {
                return n2 * 4;
            }
            if (object instanceof ShortBuffer) {
                return n2 * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n2 * 8;
            }
            if (object instanceof LongBuffer) {
                return n2 * 8;
            }
            if (object instanceof CharBuffer) {
                return n2 * 2;
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.position() * nativeBuffer.elementSize();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static Object getArray(Object object) throws UnsupportedOperationException, IllegalArgumentException {
        if (object == null) {
            return null;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).array();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).array();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n2 = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return ((ByteBuffer)object).arrayOffset() + n2;
            }
            if (object instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)object).arrayOffset() + n2);
            }
            if (object instanceof IntBuffer) {
                return 4 * (((IntBuffer)object).arrayOffset() + n2);
            }
            if (object instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)object).arrayOffset() + n2);
            }
            if (object instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)object).arrayOffset() + n2);
            }
            if (object instanceof LongBuffer) {
                return 8 * (((LongBuffer)object).arrayOffset() + n2);
            }
            if (object instanceof CharBuffer) {
                return 2 * (((CharBuffer)object).arrayOffset() + n2);
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.elementSize() * (nativeBuffer.arrayOffset() + nativeBuffer.position());
        }
        throw new IllegalArgumentException("Unknown buffer type " + object.getClass().getName());
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.position();
        ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        byteBuffer.position(n2);
        return byteBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return Buffers.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return Buffers.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return Buffers.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        int n2 = floatBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(floatBuffer.remaining() * 4);
        byteBuffer.asFloatBuffer().put(floatBuffer);
        byteBuffer.rewind();
        floatBuffer.position(n2);
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(intBuffer.remaining() * 4);
        byteBuffer.asIntBuffer().put(intBuffer);
        byteBuffer.rewind();
        intBuffer.position(n2);
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        int n2 = shortBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(shortBuffer.remaining() * 2);
        byteBuffer.asShortBuffer().put(shortBuffer);
        byteBuffer.rewind();
        shortBuffer.position(n2);
        return byteBuffer;
    }

    public static float[] getFloatArray(double[] dArray, int n2, float[] fArray, int n3, int n4) {
        if (0 > n4) {
            n4 = dArray.length - n2;
        }
        if (n4 > dArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n4 + ") greater than remaining source bytes [len " + dArray.length + ", offset " + n2 + "]");
        }
        if (null == fArray) {
            fArray = new float[n4];
            n3 = 0;
        }
        if (n4 > fArray.length - n3) {
            throw new IllegalArgumentException("payload (" + n4 + ") greater than remaining dest bytes [len " + fArray.length + ", offset " + n3 + "]");
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            fArray[n3 + i2] = (float)dArray[n2 + i2];
        }
        return fArray;
    }

    public static FloatBuffer getFloatBuffer(DoubleBuffer doubleBuffer, FloatBuffer floatBuffer) {
        if (null == floatBuffer) {
            floatBuffer = Buffers.newDirectFloatBuffer(doubleBuffer.remaining());
        }
        if (floatBuffer.remaining() < doubleBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + doubleBuffer.remaining() + ") is greater than remaining dest bytes: " + floatBuffer.remaining());
        }
        while (doubleBuffer.hasRemaining()) {
            floatBuffer.put((float)doubleBuffer.get());
        }
        return floatBuffer;
    }

    public static double[] getDoubleArray(float[] fArray, int n2, double[] dArray, int n3, int n4) {
        if (0 > n4) {
            n4 = fArray.length - n2;
        }
        if (n4 > fArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n4 + ") greater than remaining source bytes [len " + fArray.length + ", offset " + n2 + "]");
        }
        if (null == dArray) {
            dArray = new double[n4];
            n3 = 0;
        }
        if (n4 > dArray.length - n3) {
            throw new IllegalArgumentException("payload (" + n4 + ") greater than remaining dest bytes [len " + dArray.length + ", offset " + n3 + "]");
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            dArray[n3 + i2] = fArray[n2 + i2];
        }
        return dArray;
    }

    public static DoubleBuffer getDoubleBuffer(FloatBuffer floatBuffer, DoubleBuffer doubleBuffer) {
        if (null == doubleBuffer) {
            doubleBuffer = Buffers.newDirectDoubleBuffer(floatBuffer.remaining());
        }
        if (doubleBuffer.remaining() < floatBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + floatBuffer.remaining() + ") is greater than remaining dest bytes: " + doubleBuffer.remaining());
        }
        while (floatBuffer.hasRemaining()) {
            doubleBuffer.put(floatBuffer.get());
        }
        return doubleBuffer;
    }

    public static <B extends Buffer> B put(B b2, Buffer buffer) {
        if (b2 instanceof ByteBuffer && buffer instanceof ByteBuffer) {
            return (B)((ByteBuffer)b2).put((ByteBuffer)buffer);
        }
        if (b2 instanceof ShortBuffer && buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)b2).put((ShortBuffer)buffer);
        }
        if (b2 instanceof IntBuffer && buffer instanceof IntBuffer) {
            return (B)((IntBuffer)b2).put((IntBuffer)buffer);
        }
        if (b2 instanceof FloatBuffer && buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put((FloatBuffer)buffer);
        }
        if (b2 instanceof LongBuffer && buffer instanceof LongBuffer) {
            return (B)((LongBuffer)b2).put((LongBuffer)buffer);
        }
        if (b2 instanceof DoubleBuffer && buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b2).put((DoubleBuffer)buffer);
        }
        if (b2 instanceof CharBuffer && buffer instanceof CharBuffer) {
            return (B)((CharBuffer)b2).put((CharBuffer)buffer);
        }
        throw new IllegalArgumentException("Incompatible Buffer classes: dest = " + b2.getClass().getName() + ", src = " + buffer.getClass().getName());
    }

    public static <B extends Buffer> B putb(B b2, byte by) {
        if (b2 instanceof ByteBuffer) {
            return (B)((ByteBuffer)b2).put(by);
        }
        if (b2 instanceof ShortBuffer) {
            return (B)((ShortBuffer)b2).put(by);
        }
        if (b2 instanceof IntBuffer) {
            return (B)((IntBuffer)b2).put(by);
        }
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put(by);
        }
        if (b2 instanceof LongBuffer) {
            return (B)((LongBuffer)b2).put(by);
        }
        if (b2 instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b2).put(by);
        }
        if (b2 instanceof CharBuffer) {
            return (B)((CharBuffer)b2).put((char)by);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b2);
    }

    public static <B extends Buffer> B puts(B b2, short s) {
        if (b2 instanceof ShortBuffer) {
            return (B)((ShortBuffer)b2).put(s);
        }
        if (b2 instanceof IntBuffer) {
            return (B)((IntBuffer)b2).put(s);
        }
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put(s);
        }
        if (b2 instanceof LongBuffer) {
            return (B)((LongBuffer)b2).put(s);
        }
        if (b2 instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b2).put(s);
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + b2);
    }

    public static <B extends Buffer> B puti(B b2, int n2) {
        if (b2 instanceof IntBuffer) {
            return (B)((IntBuffer)b2).put(n2);
        }
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put(n2);
        }
        if (b2 instanceof LongBuffer) {
            return (B)((LongBuffer)b2).put(n2);
        }
        if (b2 instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b2).put(n2);
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + b2);
    }

    public static <B extends Buffer> B putf(B b2, float f2) {
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put(f2);
        }
        if (b2 instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b2).put(f2);
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b2);
    }

    public static <B extends Buffer> B putd(B b2, double d2) {
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put((float)d2);
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + b2);
    }

    public static <B extends Buffer> B putNb(B b2, boolean bl, byte by, boolean bl2) {
        if (b2 instanceof ByteBuffer) {
            return (B)((ByteBuffer)b2).put(by);
        }
        if (b2 instanceof ShortBuffer) {
            return (B)((ShortBuffer)b2).put(ValueConv.byte_to_short(by, bl2, bl));
        }
        if (b2 instanceof IntBuffer) {
            return (B)((IntBuffer)b2).put(ValueConv.byte_to_int(by, bl2, bl));
        }
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put(ValueConv.byte_to_float(by, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b2);
    }

    public static <B extends Buffer> B putNs(B b2, boolean bl, short s, boolean bl2) {
        if (b2 instanceof ByteBuffer) {
            return (B)((ByteBuffer)b2).put(ValueConv.short_to_byte(s, bl2, bl));
        }
        if (b2 instanceof ShortBuffer) {
            return (B)((ShortBuffer)b2).put(s);
        }
        if (b2 instanceof IntBuffer) {
            return (B)((IntBuffer)b2).put(ValueConv.short_to_int(s, bl2, bl));
        }
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put(ValueConv.short_to_float(s, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b2);
    }

    public static <B extends Buffer> B putNi(B b2, boolean bl, int n2, boolean bl2) {
        if (b2 instanceof ByteBuffer) {
            return (B)((ByteBuffer)b2).put(ValueConv.int_to_byte(n2, bl2, bl));
        }
        if (b2 instanceof ShortBuffer) {
            return (B)((ShortBuffer)b2).put(ValueConv.int_to_short(n2, bl2, bl));
        }
        if (b2 instanceof IntBuffer) {
            return (B)((IntBuffer)b2).put(n2);
        }
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put(ValueConv.int_to_float(n2, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b2);
    }

    public static <B extends Buffer> B putNf(B b2, boolean bl, float f2) {
        if (b2 instanceof ByteBuffer) {
            return (B)((ByteBuffer)b2).put(ValueConv.float_to_byte(f2, bl));
        }
        if (b2 instanceof ShortBuffer) {
            return (B)((ShortBuffer)b2).put(ValueConv.float_to_short(f2, bl));
        }
        if (b2 instanceof IntBuffer) {
            return (B)((IntBuffer)b2).put(ValueConv.float_to_int(f2, bl));
        }
        if (b2 instanceof FloatBuffer) {
            return (B)((FloatBuffer)b2).put(f2);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b2);
    }

    public static void rangeCheck(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        if (byArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException("Required " + n3 + " elements in array, only had " + (byArray.length - n2));
        }
    }

    public static void rangeCheck(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return;
        }
        if (cArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException("Required " + n3 + " elements in array, only had " + (cArray.length - n2));
        }
    }

    public static void rangeCheck(short[] sArray, int n2, int n3) {
        if (sArray == null) {
            return;
        }
        if (sArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException("Required " + n3 + " elements in array, only had " + (sArray.length - n2));
        }
    }

    public static void rangeCheck(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return;
        }
        if (nArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException("Required " + n3 + " elements in array, only had " + (nArray.length - n2));
        }
    }

    public static void rangeCheck(long[] lArray, int n2, int n3) {
        if (lArray == null) {
            return;
        }
        if (lArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException("Required " + n3 + " elements in array, only had " + (lArray.length - n2));
        }
    }

    public static void rangeCheck(float[] fArray, int n2, int n3) {
        if (fArray == null) {
            return;
        }
        if (fArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException("Required " + n3 + " elements in array, only had " + (fArray.length - n2));
        }
    }

    public static void rangeCheck(double[] dArray, int n2, int n3) {
        if (dArray == null) {
            return;
        }
        if (dArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException("Required " + n3 + " elements in array, only had " + (dArray.length - n2));
        }
    }

    public static void rangeCheck(Buffer buffer, int n2) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n2) {
            throw new IndexOutOfBoundsException("Required " + n2 + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Object object, int n2) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (object == null) {
            return;
        }
        int n3 = Buffers.remainingBytes(object);
        if (n3 < n2) {
            throw new IndexOutOfBoundsException("Required " + n2 + " remaining bytes in buffer, only had " + n3);
        }
    }

    public static StringBuilder toString(StringBuilder stringBuilder, String string, Buffer buffer) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(buffer.getClass().getSimpleName());
        stringBuilder.append("[pos ").append(buffer.position()).append(", lim ").append(buffer.limit()).append(", cap ").append(buffer.capacity());
        stringBuilder.append(", remaining ").append(buffer.remaining());
        stringBuilder.append("; array ").append(buffer.hasArray()).append(", direct ").append(buffer.isDirect());
        stringBuilder.append(", r/w ").append(!buffer.isReadOnly()).append(": ");
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            for (int i2 = 0; i2 < byteBuffer.limit(); ++i2) {
                if (0 < i2) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(byteBuffer.get(i2));
                    continue;
                }
                stringBuilder.append(String.format(string, byteBuffer.get(i2)));
            }
        } else if (buffer instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            for (int i3 = 0; i3 < floatBuffer.limit(); ++i3) {
                if (0 < i3) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(floatBuffer.get(i3));
                    continue;
                }
                stringBuilder.append(String.format(string, Float.valueOf(floatBuffer.get(i3))));
            }
        } else if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            for (int i4 = 0; i4 < intBuffer.limit(); ++i4) {
                if (0 < i4) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(intBuffer.get(i4));
                    continue;
                }
                stringBuilder.append(String.format(string, intBuffer.get(i4)));
            }
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            for (int i5 = 0; i5 < shortBuffer.limit(); ++i5) {
                if (0 < i5) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(shortBuffer.get(i5));
                    continue;
                }
                stringBuilder.append(String.format(string, shortBuffer.get(i5)));
            }
        } else if (buffer instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)buffer;
            for (int i6 = 0; i6 < doubleBuffer.limit(); ++i6) {
                if (0 < i6) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(doubleBuffer.get(i6));
                    continue;
                }
                stringBuilder.append(String.format(string, doubleBuffer.get(i6)));
            }
        } else if (buffer instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)buffer;
            for (int i7 = 0; i7 < longBuffer.limit(); ++i7) {
                if (0 < i7) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(longBuffer.get(i7));
                    continue;
                }
                stringBuilder.append(String.format(string, longBuffer.get(i7)));
            }
        } else if (buffer instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)buffer;
            for (int i8 = 0; i8 < charBuffer.limit(); ++i8) {
                if (0 < i8) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(charBuffer.get(i8));
                    continue;
                }
                stringBuilder.append(String.format(string, Character.valueOf(charBuffer.get(i8))));
            }
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public static class Cleaner {
        private static final Method mbbCleaner;
        private static final Method cClean;
        private static volatile boolean cleanerError;

        public static boolean clean(ByteBuffer byteBuffer) {
            if (cleanerError || !byteBuffer.isDirect()) {
                return false;
            }
            try {
                if (PlatformPropsImpl.JAVA_9) {
                    UnsafeUtil.invokeCleaner(byteBuffer);
                } else {
                    cClean.invoke(mbbCleaner.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
                }
                return true;
            }
            catch (Throwable throwable) {
                cleanerError = true;
                if (DEBUG) {
                    ExceptionUtils.dumpThrowable("Buffers", throwable);
                }
                return false;
            }
        }

        static {
            boolean bl;
            final Method[] methodArray = new Method[]{null};
            final Method[] methodArray2 = new Method[]{null};
            if (SecurityUtil.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        if (PlatformPropsImpl.JAVA_9) {
                            return UnsafeUtil.hasInvokeCleaner();
                        }
                        methodArray[0] = ReflectionUtil.getMethod("sun.nio.ch.DirectBuffer", "cleaner", null, Buffers.class.getClassLoader());
                        methodArray[0].setAccessible(true);
                        Class<?> clazz = methodArray[0].getReturnType();
                        methodArray2[0] = clazz.getMethod("clean", new Class[0]);
                        methodArray2[0].setAccessible(true);
                        return Boolean.TRUE;
                    }
                    catch (Throwable throwable) {
                        if (DEBUG) {
                            ExceptionUtils.dumpThrowable("Buffers", throwable);
                        }
                        return Boolean.FALSE;
                    }
                }
            }).booleanValue()) {
                mbbCleaner = methodArray[0];
                cClean = methodArray2[0];
                bl = PlatformPropsImpl.JAVA_9 || null != mbbCleaner && null != cClean;
            } else {
                mbbCleaner = null;
                cClean = null;
                bl = false;
            }
            boolean bl2 = cleanerError = !bl;
            if (DEBUG) {
                System.err.print("Buffers.Cleaner.init: hasCleaner: " + bl + ", cleanerError " + cleanerError);
                if (null != mbbCleaner) {
                    System.err.print(", using Cleaner class: " + mbbCleaner.getReturnType().getName());
                }
                System.err.println();
            }
        }
    }
}

