/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.g723;

import com.ibm.media.codec.audio.g723.DecoderData;
import com.ibm.media.codec.audio.g723.G723Tables;
import com.ibm.media.codec.audio.g723.LINEDEF;
import com.ibm.media.codec.audio.g723.PFDEF;
import com.ibm.media.codec.audio.g723.SFSDEF;

public final class G723Dec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997, 1998.";
    private DecoderData decoderData;
    private final float[] decode_OutputBuffer = new float[240];
    private final float[] decode_QntLpc = new float[40];
    private final float[] decode_AcbkCont = new float[60];
    private final float[] decode_LspVect = new float[10];
    private final LINEDEF decode_Line = new LINEDEF();
    private final PFDEF[] decode_Pf = new PFDEF[]{new PFDEF(), new PFDEF(), new PFDEF(), new PFDEF()};
    private final int[] decode_flag = new int[1];
    private final int[] decode_Ftyp = new int[1];
    private final float[] decode_SyntIir = new float[250];
    private final float[] decode_PostFir = new float[250];
    private final float[] decode_PostIir = new float[250];
    private final int[] Line_Unpk_index = new int[1];
    private final int[] Line_Unpk_BitStream = new int[192];
    private final float[] Gen_Trn_TmpBuf = new float[60];
    float[] Decod_Acbk_RezBuf = new float[67];
    private final float[] lspArrayP = new float[6];
    private final float[] lspArrayQ = new float[6];
    private final float[] lspParamLsp = new float[10];
    private static final float[] fLspDcTable = G723Tables.fLspDcTable;
    private static final float[] fBand0Tb8 = G723Tables.fBand0Tb8;
    private static final float[] fBand1Tb8 = G723Tables.fBand1Tb8;
    private static final float[] fBand2Tb8 = G723Tables.fBand2Tb8;
    private static final float[][] fBandQntTable = new float[][]{fBand0Tb8, fBand1Tb8, fBand2Tb8};
    private static final float[] fAcbkGainTable085 = G723Tables.fAcbkGainTable085;
    private static final float[] fAcbkGainTable170 = G723Tables.fAcbkGainTable170;
    private static final float[][] AcbkGainTablePtr = new float[][]{fAcbkGainTable085, fAcbkGainTable170};
    private static final float[] FcbkGainTable = G723Tables.FcbkGainTable;
    private static final float[] CosFunction = G723Tables.CosFunction;
    private static final int[][] CombinatorialTable = G723Tables.CombinatorialTable;
    private static final int[][] fBandInfoTable = new int[][]{{0, 3}, {3, 3}, {6, 4}};
    private static final int[] MaxPosTable = new int[]{593775, 142506, 593775, 142506};
    private static final boolean INCLUDE_POST_FILTER = true;
    private static final int Rate63 = 0;
    private static final short CRC = 0;
    private static final int LpcOrder = 10;
    private static final int SubFrames = 4;
    private static final int Frame = 240;
    private static final int LpcFrame = 180;
    private static final int SubFrLen = 60;
    private static final int LspQntBands = 3;
    private static final int LspCbSize = 256;
    private static final int LspCbBits = 8;
    private static final float BandExpFactor = 0.994f;
    private static final float LspPredictor = 0.375f;
    private static final float LspPredictor2 = 0.71875f;
    private static final int ClPitchOrd = 5;
    private static final int PITCH_INDEX = 2;
    private static final int Pstep = 1;
    private static final int PitchMin = 18;
    private static final int PitchMax = 145;
    private static final int HIGH_RATE_BITSTREAM = 0;
    private static final int LOW_RATE_BITSTREAM = 1;
    private static final int SID_BITSTREAM = 2;
    private static final int UNTRANSMITTED_BITSTREAM = 3;
    private static final int G723_OK = 0;
    private static final int G723_ERR = 1;
    private static final int G723_RATE_MISMATCH = 2;
    private static final int G723_ILLEGAL_BITSTREAM = 3;
    private static final int G723_ILLEGAL_PARAMETER = 4;
    private static final int G723_VAD_BITSTREAM = 5;
    private static final int SILENCE_FRAME = 0;
    private static final int VOICE_FRAME = 1;
    private static final int SID_FRAME = 2;
    private static final int NumOfGainLev = 24;
    private static final int MaxPulseNum = 6;
    private static final int Sgrid = 2;
    private static final int DECODER_OUTPUT_SIZE = 240;
    private static final int NUM_OF_BLOCKS = 4;
    private static final int ErrMaxNum = 3;
    private static final float ALPHA = 0.0625f;
    private static final float FLT_MIN = Float.MIN_NORMAL;
    private static final float SHRT_MIN = -32767.0f;
    private static final float SHRT_MAX = 32767.0f;

    protected final void decoderOpen() {
        this.decoderData = new DecoderData();
        this.decoderReset();
    }

    protected final void decoderReset() {
        int i2 = 0;
        while (i2 < 10) {
            this.decoderData.PrevLsp[i2] = fLspDcTable[i2];
            this.decoderData.PostIirDl[i2] = 0.0f;
            this.decoderData.PostFirDl[i2] = 0.0f;
            this.decoderData.SyntIirDl[i2] = 0.0f;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.decoderData.PrevExc.length) {
            this.decoderData.PrevExc[i2] = 0.0f;
            ++i2;
        }
        this.decoderData.Ecount = 0;
        this.decoderData.InterGain = 0.0f;
        this.decoderData.InterIndx = 0;
        this.decoderData.Park = 0.0f;
        this.decoderData.Rseed = 0;
        this.decoderData.Gain = 1.0f;
        this.decoderData.BlockIndex = 0;
        this.decoderData.BlockCount = 0;
        this.decoderData.WrkRate = 0;
        this.decoderData.UsePf = true;
        i2 = 0;
        while (i2 < 10) {
            this.decoderData.PrevLsp[i2] = fLspDcTable[i2];
            ++i2;
        }
    }

    protected final void decodeFrame(byte[] bits_input, int indexInp, byte[] outBuffer, int indexOut) {
        float[] OutputBuffer;
        float[] DataBuff = OutputBuffer = this.decode_OutputBuffer;
        float SfGain = 0.0f;
        float[] QntLpc = this.decode_QntLpc;
        float[] AcbkCont = this.decode_AcbkCont;
        float[] LspVect = this.decode_LspVect;
        LINEDEF Line2 = this.decode_Line;
        PFDEF[] Pf = this.decode_Pf;
        int[] flag = this.decode_flag;
        int[] Ftyp = this.decode_Ftyp;
        float[] SyntIir = this.decode_SyntIir;
        float[] PostFir = this.decode_PostFir;
        float[] PostIir = this.decode_PostIir;
        if (this.decoderData.BlockIndex == 0) {
            this.decoderData.BlockCount = 0;
            System.arraycopy(this.decoderData.PrevExc, 960, this.decoderData.PrevExc, 0, 145);
        }
        int PrevExcIndex = this.decoderData.BlockIndex * 240 + 145;
        float[] PrevExc = this.decoderData.PrevExc;
        ++this.decoderData.BlockCount;
        this.decoderData.BlockIndex = this.decoderData.BlockCount % 4;
        int i2 = 0;
        while (i2 < 10) {
            SyntIir[10 - i2 - 1] = this.decoderData.SyntIirDl[i2];
            PostFir[10 - i2 - 1] = this.decoderData.PostFirDl[i2];
            PostIir[10 - i2 - 1] = this.decoderData.PostIirDl[i2];
            ++i2;
        }
        this.Line_Unpk(bits_input, indexInp, Ftyp, (short)0, flag, Line2);
        this.decoderData.Ecount = Line2.Crc != 0 ? ++this.decoderData.Ecount : 0;
        if (this.decoderData.Ecount > 3) {
            this.decoderData.Ecount = 3;
        }
        this.Lsp_Inq(LspVect, this.decoderData.PrevLsp, Line2.LspId, Line2.Crc);
        this.Lsp_Int(QntLpc, LspVect, this.decoderData.PrevLsp);
        if (this.decoderData.Ecount == 0) {
            i2 = Line2.Sfs[2].Mamp + Line2.Sfs[3].Mamp >> 1;
            this.decoderData.InterGain = FcbkGainTable[i2];
        } else {
            this.decoderData.InterGain *= 0.75f;
        }
        if (this.decoderData.Ecount == 0) {
            i2 = 0;
            while (i2 < 4) {
                this.Fcbk_Unpk(PrevExc, PrevExcIndex + 60 * i2, Line2.Sfs[i2], Line2.Olp[i2 >> 1], i2);
                this.Decod_Acbk(AcbkCont, PrevExc, PrevExcIndex + 60 * i2 - 145, Line2.Olp[i2 >> 1], Line2.Sfs[i2].AcLg, Line2.Sfs[i2].AcGn, this.decoderData.WrkRate);
                int j2 = 0;
                while (j2 < 60) {
                    int n2 = PrevExcIndex + i2 * 60 + j2;
                    PrevExc[n2] = PrevExc[n2] + AcbkCont[j2];
                    ++j2;
                }
                ++i2;
            }
            System.arraycopy(PrevExc, PrevExcIndex, DataBuff, 0, 240);
            if (this.decoderData.UsePf) {
                i2 = 0;
                while (i2 < 4) {
                    this.Comp_Lpf(PrevExc, PrevExcIndex - 145, Line2.Olp[i2 >> 1], i2, Pf[i2]);
                    ++i2;
                }
            }
            if (this.decoderData.UsePf) {
                i2 = 0;
                while (i2 < 4) {
                    this.Filt_Lpf(DataBuff, PrevExc, PrevExcIndex - 145, Pf[i2], i2);
                    ++i2;
                }
            }
        }
        float[] Dpnt = DataBuff;
        int indexDpnt = 0;
        i2 = 0;
        while (i2 < 4) {
            this.Synt(Dpnt, indexDpnt, QntLpc, i2 * 10, SyntIir, 10 + i2 * 60 - 1);
            if (this.decoderData.UsePf) {
                SfGain = this.Spf(Dpnt, indexDpnt, QntLpc, i2 * 10, PostFir, 10 + i2 * 60 - 1, PostIir, 10 + i2 * 60 - 1);
                this.Scale(Dpnt, indexDpnt, SfGain);
            }
            indexDpnt += 60;
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            this.decoderData.SyntIirDl[i2] = SyntIir[250 - i2 - 1];
            this.decoderData.PostFirDl[i2] = PostFir[250 - i2 - 1];
            this.decoderData.PostIirDl[i2] = PostIir[250 - i2 - 1];
            ++i2;
        }
        this.Fl2Sh(DataBuff, 240, outBuffer, indexOut);
    }

    private final void Fcbk_Unpk(float[] ExcBuf, int ExcBufIndex, SFSDEF Sfs, int pitch, int SfrNum) {
        switch (this.decoderData.WrkRate) {
            case 0: {
                int PlsNum = SfrNum == 0 || SfrNum == 2 ? 6 : 5;
                int i2 = ExcBufIndex;
                while (i2 < ExcBufIndex + 60) {
                    ExcBuf[i2] = 0.0f;
                    ++i2;
                }
                if (Sfs.Ppos >= MaxPosTable[SfrNum]) {
                    return;
                }
                int j2 = 6 - PlsNum;
                long CombCounter = Sfs.Ppos;
                i2 = 0;
                while (i2 < 30) {
                    if (CombCounter < (long)CombinatorialTable[j2][i2]) {
                        ExcBuf[Sfs.Grid + 2 * i2 + ExcBufIndex] = (Sfs.Pamp & 1 << 6 - ++j2) != 0 ? -FcbkGainTable[Sfs.Mamp] : FcbkGainTable[Sfs.Mamp];
                        if (j2 == 6) {
                            break;
                        }
                    } else {
                        CombCounter -= (long)CombinatorialTable[j2][i2];
                    }
                    ++i2;
                }
                if (Sfs.Tran != 1) break;
                this.Gen_Trn(ExcBuf, ExcBuf, ExcBufIndex, pitch);
            }
        }
    }

    private final void Comp_Lpf(float[] DecExc, int DecExcIndex, int pitch, int SfrNum, PFDEF Pf) {
        float DecExc1;
        float DecExc0;
        float Lcr0 = 0.0f;
        float Lcr1 = 0.0f;
        float Lcr2 = 0.0f;
        float Lcr3 = 0.0f;
        float Lcr4 = 0.0f;
        Pf.Indx = 0;
        Pf.Gain = 0.0f;
        Pf.ScGn = 1.0f;
        int Bindx = this.Find_B(DecExc, DecExcIndex, pitch, SfrNum);
        int Findx = this.Find_F(DecExc, DecExcIndex, pitch, SfrNum);
        if (Bindx == 0 && Findx == 0) {
            return;
        }
        int DecExcPointer = DecExcIndex + 145 + SfrNum * 60;
        int j2 = 0;
        while (j2 < 60) {
            DecExc0 = DecExc[DecExcPointer + j2];
            DecExc1 = DecExc[DecExcPointer + j2 + 1];
            Lcr0 += DecExc0 * DecExc0 + DecExc1 * DecExc1;
            j2 += 2;
        }
        DecExcPointer = DecExcIndex + 145 + SfrNum * 60;
        if (Bindx != 0) {
            j2 = 0;
            while (j2 < 60) {
                DecExc0 = DecExc[DecExcPointer + Bindx + j2];
                DecExc1 = DecExc[DecExcPointer + Bindx + j2 + 1];
                Lcr1 += DecExc[DecExcPointer + j2] * DecExc0 + DecExc[DecExcPointer + j2 + 1] * DecExc1;
                Lcr2 += DecExc0 * DecExc0 + DecExc1 * DecExc1;
                j2 += 2;
            }
        }
        DecExcPointer = DecExcIndex + 145 + SfrNum * 60;
        if (Findx != 0) {
            j2 = 0;
            while (j2 < 60) {
                DecExc0 = DecExc[DecExcPointer + Findx + j2];
                DecExc1 = DecExc[DecExcPointer + Findx + j2 + 1];
                Lcr3 += DecExc[DecExcPointer + j2] * DecExc0 + DecExc[DecExcPointer + j2 + 1] * DecExc1;
                Lcr4 += DecExc0 * DecExc0 + DecExc1 * DecExc1;
                j2 += 2;
            }
        }
        if ((float)Bindx != 0.0f && (float)Findx == 0.0f) {
            this.Get_Ind(Bindx, Lcr0, Lcr1, Lcr2, Pf);
        }
        if ((float)Bindx == 0.0f && (float)Findx != 0.0f) {
            this.Get_Ind(Findx, Lcr0, Lcr3, Lcr4, Pf);
        }
        if (Bindx != 0 && Findx != 0) {
            if (Lcr1 * Lcr1 * Lcr4 > Lcr3 * Lcr3 * Lcr2) {
                this.Get_Ind(Bindx, Lcr0, Lcr1, Lcr2, Pf);
            } else {
                this.Get_Ind(Findx, Lcr0, Lcr3, Lcr4, Pf);
            }
        }
    }

    private final int Find_B(float[] DecExc, int DecExcIndex, int pitch, int SfrNum) {
        int Indx = 0;
        int DecExcPointer = DecExcIndex + 145 + SfrNum * 60;
        float BestCorr = 0.0f;
        float corr6 = 0.0f;
        float corr5 = 0.0f;
        float corr4 = 0.0f;
        float corr3 = 0.0f;
        float corr2 = 0.0f;
        float corr1 = 0.0f;
        float corr0 = 0.0f;
        if (pitch > 142) {
            pitch = 142;
        }
        int DecExcCrossPointer = DecExcPointer - (pitch - 3);
        int j2 = 0;
        while (j2 < 60) {
            float DecExcPointer_j = DecExc[DecExcPointer + j2];
            corr0 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2];
            corr1 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 - 1];
            corr2 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 - 2];
            corr3 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 - 3];
            corr4 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 - 4];
            corr5 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 - 5];
            corr6 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 - 6];
            ++j2;
        }
        if (corr0 > BestCorr) {
            BestCorr = corr0;
            Indx = -(pitch - 3);
        }
        if (corr1 > BestCorr) {
            BestCorr = corr1;
            Indx = -(pitch - 2);
        }
        if (corr2 > BestCorr) {
            BestCorr = corr2;
            Indx = -(pitch - 1);
        }
        if (corr3 > BestCorr) {
            BestCorr = corr3;
            Indx = -pitch;
        }
        if (corr4 > BestCorr) {
            BestCorr = corr4;
            Indx = -(pitch + 1);
        }
        if (corr5 > BestCorr) {
            BestCorr = corr5;
            Indx = -(pitch + 2);
        }
        if (corr6 > BestCorr) {
            BestCorr = corr6;
            Indx = -(pitch + 3);
        }
        return Indx;
    }

    private final int Find_F(float[] DecExc, int DecExcIndex, int pitch, int SfrNum) {
        int Indx = 0;
        int max = 240 - SfrNum * 60 - 60;
        int DecExcPointer = DecExcIndex + 145 + SfrNum * 60;
        if (pitch > 142) {
            pitch = 142;
        }
        float BestCorr = 0.0f;
        if (max > pitch + 3) {
            float corr0 = 0.0f;
            float corr1 = 0.0f;
            float corr2 = 0.0f;
            float corr3 = 0.0f;
            float corr4 = 0.0f;
            float corr5 = 0.0f;
            float corr6 = 0.0f;
            int DecExcCrossPointer = DecExcPointer + (pitch - 3);
            int j2 = 0;
            while (j2 < 60) {
                float DecExcPointer_j = DecExc[DecExcPointer + j2];
                corr0 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2];
                corr1 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 + 1];
                corr2 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 + 2];
                corr3 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 + 3];
                corr4 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 + 4];
                corr5 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 + 5];
                corr6 += DecExcPointer_j * DecExc[DecExcCrossPointer + j2 + 6];
                ++j2;
            }
            if (corr0 > BestCorr) {
                BestCorr = corr0;
                Indx = pitch - 3;
            }
            if (corr1 > BestCorr) {
                BestCorr = corr1;
                Indx = pitch - 2;
            }
            if (corr2 > BestCorr) {
                BestCorr = corr2;
                Indx = pitch - 1;
            }
            if (corr3 > BestCorr) {
                BestCorr = corr3;
                Indx = pitch;
            }
            if (corr4 > BestCorr) {
                BestCorr = corr4;
                Indx = pitch + 1;
            }
            if (corr5 > BestCorr) {
                BestCorr = corr5;
                Indx = pitch + 2;
            }
            if (corr6 > BestCorr) {
                BestCorr = corr6;
                Indx = pitch + 3;
            }
        } else {
            int i2 = pitch - 3;
            while (i2 <= max) {
                int DecExcCrossPointer = DecExcPointer + i2;
                float corr = 0.0f;
                int j2 = 0;
                while (j2 < 60) {
                    corr += DecExc[DecExcPointer + j2] * DecExc[DecExcCrossPointer + j2];
                    ++j2;
                }
                if (corr > BestCorr) {
                    BestCorr = corr;
                    Indx = i2;
                }
                ++i2;
            }
        }
        return Indx;
    }

    private final void Get_Ind(int Ind, float Ten, float Ccr, float Enr, PFDEF Pf) {
        float LpfConstTable_WrkRate;
        Pf.Indx = Ind;
        float f2 = LpfConstTable_WrkRate = this.decoderData.WrkRate == 0 ? 0.1875f : 0.25f;
        if (Ccr * Ccr > 0.25f * Ten * Enr) {
            Pf.Gain = Ccr >= Enr ? LpfConstTable_WrkRate : LpfConstTable_WrkRate * Ccr / Enr;
            float denom = Ten + 2.0f * Pf.Gain * Ccr + Pf.Gain * Pf.Gain * Enr;
            Pf.ScGn = denom < Float.MIN_NORMAL ? 0.0f : (float)Math.sqrt(Ten / denom);
        } else {
            Pf.Gain = 0.0f;
            Pf.ScGn = 1.0f;
        }
        Pf.Gain *= Pf.ScGn;
    }

    private final void Filt_Lpf(float[] ExcBuf, float[] DecExc, int DecExcIndex, PFDEF Pf, int SfrNum) {
        float ScGn = Pf.ScGn;
        float Gain = Pf.Gain;
        int Indx = Pf.Indx;
        int ExcBufIndex = SfrNum * 60;
        int DecExcIndex1 = DecExcIndex + 145 + SfrNum * 60;
        int DecExcIndex2 = DecExcIndex + 145 + SfrNum * 60 + Indx;
        int i2 = 0;
        while (i2 < 60) {
            ExcBuf[ExcBufIndex + i2] = DecExc[DecExcIndex1 + i2] * ScGn + DecExc[DecExcIndex2 + i2] * Gain;
            ++i2;
        }
    }

    private final void Fl2Sh(float[] BufF, int Len, byte[] outBuffer, int indexOut) {
        int j2 = 0;
        int i2 = 0;
        while (i2 < Len) {
            float sample = BufF[i2];
            if (sample < -32767.0f) {
                sample = -32767.0f;
            } else if (sample > 32767.0f) {
                sample = 32767.0f;
            }
            int TempInt = (int)sample;
            outBuffer[indexOut + j2] = (byte)(TempInt & 0xFF);
            outBuffer[indexOut + j2 + 1] = (byte)(TempInt >> 8);
            j2 += 2;
            ++i2;
        }
    }

    private final float Rand(int[] p) {
        int Temp2 = p[0];
        Temp2 &= 0xFFFF;
        Temp2 = Temp2 * 521 + 259;
        p[0] = (short)Temp2;
        return (float)((short)Temp2) * 3.0517578E-5f;
    }

    private final void Scale(float[] signal, int indexSignal, float SfGain) {
        float AlphaGain = 0.0625f * SfGain;
        float local_Gain = this.decoderData.Gain;
        int iEnd = 60 + indexSignal;
        int i2 = indexSignal;
        while (i2 < iEnd) {
            local_Gain = 0.9375f * local_Gain + AlphaGain;
            int n2 = i2++;
            signal[n2] = signal[n2] * (local_Gain * 1.0625f);
        }
        this.decoderData.Gain = local_Gain;
    }

    private final void Synt(float[] signal, int indexSig, float[] Lpc, int indexLpc, float[] iir, int indexIir) {
        float Lpc0 = Lpc[indexLpc + 0];
        float Lpc1 = Lpc[indexLpc + 1];
        float Lpc2 = Lpc[indexLpc + 2];
        float Lpc3 = Lpc[indexLpc + 3];
        float Lpc4 = Lpc[indexLpc + 4];
        float Lpc5 = Lpc[indexLpc + 5];
        float Lpc6 = Lpc[indexLpc + 6];
        float Lpc7 = Lpc[indexLpc + 7];
        float Lpc8 = Lpc[indexLpc + 8];
        float Lpc9 = Lpc[indexLpc + 9];
        int iEnd = 60 + indexSig;
        int i2 = indexSig;
        while (i2 < iEnd) {
            float SigFilt;
            signal[i2] = SigFilt = signal[i2] + Lpc0 * iir[indexIir - 0] + Lpc1 * iir[indexIir - 1] + Lpc2 * iir[indexIir - 2] + Lpc3 * iir[indexIir - 3] + Lpc4 * iir[indexIir - 4] + Lpc5 * iir[indexIir - 5] + Lpc6 * iir[indexIir - 6] + Lpc7 * iir[indexIir - 7] + Lpc8 * iir[indexIir - 8] + Lpc9 * iir[indexIir - 9];
            iir[++indexIir] = SigFilt;
            ++i2;
        }
    }

    private final float Spf(float[] SyntSig, int idxSyntSig, float[] Lpc, int indexLpc, float[] fir, int idxFir, float[] iir, int idxIir) {
        float[] FirCoef = new float[10];
        float[] IirCoef = new float[10];
        float pole = 1.0f;
        float zero = 1.0f;
        int i2 = 0;
        while (i2 < 10) {
            IirCoef[i2] = (pole *= 0.75f) * Lpc[i2 + indexLpc];
            FirCoef[i2] = (zero *= 0.65f) * Lpc[i2 + indexLpc];
            ++i2;
        }
        float corr = 0.0f;
        float enr = 0.0f;
        enr = SyntSig[idxSyntSig] * SyntSig[idxSyntSig];
        int loopStart = idxSyntSig;
        int loopEnd = loopStart + 60;
        i2 = loopStart + 1;
        while (i2 < loopEnd) {
            float tmpValue = SyntSig[i2];
            corr += tmpValue * SyntSig[i2 - 1];
            enr += tmpValue * tmpValue;
            ++i2;
        }
        float TmpPark = (double)enr != 0.0 ? corr / enr : 0.0f;
        float energy = enr;
        this.decoderData.Park = 0.75f * this.decoderData.Park + 0.25f * TmpPark;
        float IirCoef0 = IirCoef[0];
        float IirCoef1 = IirCoef[1];
        float IirCoef2 = IirCoef[2];
        float IirCoef3 = IirCoef[3];
        float IirCoef4 = IirCoef[4];
        float IirCoef5 = IirCoef[5];
        float IirCoef6 = IirCoef[6];
        float IirCoef7 = IirCoef[7];
        float IirCoef8 = IirCoef[8];
        float IirCoef9 = IirCoef[9];
        float FirCoef0 = FirCoef[0];
        float FirCoef1 = FirCoef[1];
        float FirCoef2 = FirCoef[2];
        float FirCoef3 = FirCoef[3];
        float FirCoef4 = FirCoef[4];
        float FirCoef5 = FirCoef[5];
        float FirCoef6 = FirCoef[6];
        float FirCoef7 = FirCoef[7];
        float FirCoef8 = FirCoef[8];
        float FirCoef9 = FirCoef[9];
        float PostFilteredEnergy = 0.0f;
        int loopEnd2 = idxSyntSig + 60;
        float localPark = this.decoderData.Park;
        i2 = idxSyntSig;
        while (i2 < loopEnd2) {
            float tmp;
            float FiltSig = SyntSig[i2] + IirCoef0 * iir[idxIir] - FirCoef0 * fir[idxFir] + IirCoef1 * iir[idxIir - 1] - FirCoef1 * fir[idxFir - 1] + IirCoef2 * iir[idxIir - 2] - FirCoef2 * fir[idxFir - 2] + IirCoef3 * iir[idxIir - 3] - FirCoef3 * fir[idxFir - 3] + IirCoef4 * iir[idxIir - 4] - FirCoef4 * fir[idxFir - 4] + IirCoef5 * iir[idxIir - 5] - FirCoef5 * fir[idxFir - 5] + IirCoef6 * iir[idxIir - 6] - FirCoef6 * fir[idxFir - 6] + IirCoef7 * iir[idxIir - 7] - FirCoef7 * fir[idxFir - 7] + IirCoef8 * iir[idxIir - 8] - FirCoef8 * fir[idxFir - 8] + IirCoef9 * iir[idxIir - 9] - FirCoef9 * fir[idxFir - 9];
            fir[++idxFir] = SyntSig[i2];
            iir[++idxIir] = FiltSig;
            SyntSig[i2] = tmp = FiltSig - 0.25f * iir[idxIir - 1] * localPark;
            PostFilteredEnergy += tmp * tmp;
            ++i2;
        }
        if ((double)PostFilteredEnergy != 0.0) {
            return (float)Math.sqrt(energy / PostFilteredEnergy);
        }
        return 1.0f;
    }

    private final void Line_Unpk(byte[] Vinp, int indexInp, int[] Ftyp, short Crc, int[] flag, LINEDEF Line2) {
        int[] BitStream = this.Line_Unpk_BitStream;
        int Bound_AcGn = 0;
        int[] index = this.Line_Unpk_index;
        index[0] = 0;
        Line2.Crc = Crc;
        flag[0] = 0;
        if (Crc != 0) {
            return;
        }
        int i2 = 0;
        while (i2 < 192) {
            BitStream[i2] = Vinp[indexInp + (i2 >> 3)] >> (i2 & 7) & 1;
            ++i2;
        }
        short frame_info = (short)this.Ser2Par(BitStream, index, 2);
        if (frame_info == 3 || frame_info == 2) {
            Line2.Crc = 1;
            flag[0] = 5;
            return;
        }
        if (frame_info == 3) {
            Ftyp[0] = 0;
            Line2.LspId = 0;
            return;
        }
        Line2.LspId = this.Ser2Par(BitStream, index, 24);
        if (frame_info == 2) {
            Line2.Sfs[0].Mamp = (short)this.Ser2Par(BitStream, index, 6);
            Ftyp[0] = 2;
            return;
        }
        Ftyp[0] = 1;
        int Temp2 = this.Ser2Par(BitStream, index, 7);
        if (Temp2 > 123) {
            flag[0] = 3;
            Line2.Crc = 1;
            return;
        }
        Line2.Olp[0] = (short)Temp2 + 18;
        Line2.Sfs[1].AcLg = (short)this.Ser2Par(BitStream, index, 2);
        Temp2 = this.Ser2Par(BitStream, index, 7);
        if (Temp2 > 123) {
            flag[0] = 3;
            Line2.Crc = 1;
            return;
        }
        Line2.Olp[1] = (short)Temp2 + 18;
        Line2.Sfs[3].AcLg = (short)this.Ser2Par(BitStream, index, 2);
        Line2.Sfs[0].AcLg = 1;
        Line2.Sfs[2].AcLg = 1;
        i2 = 0;
        while (i2 < 4) {
            Temp2 = this.Ser2Par(BitStream, index, 12);
            Line2.Sfs[i2].Tran = 0;
            Bound_AcGn = 170;
            if (this.decoderData.WrkRate == 0 && Line2.Olp[i2 >> 1] < 58) {
                Line2.Sfs[i2].Tran = (short)(Temp2 >> 11);
                Temp2 = (int)((long)Temp2 & 0x7FFL);
                Bound_AcGn = 85;
            }
            Line2.Sfs[i2].AcGn = (short)(Temp2 / 24);
            if (Line2.Sfs[i2].AcGn >= Bound_AcGn) {
                flag[0] = 3;
                Line2.Crc = 1;
                return;
            }
            Line2.Sfs[i2].Mamp = (short)(Temp2 % 24);
            ++i2;
        }
        i2 = 0;
        while (i2 < 4) {
            int n2 = index[0];
            index[0] = n2 + 1;
            Line2.Sfs[i2].Grid = BitStream[n2];
            ++i2;
        }
        if (this.decoderData.WrkRate == 0) {
            if (frame_info != 0) {
                flag[0] = 2;
                Line2.Crc = 1;
                return;
            }
        } else {
            flag[0] = 2;
            Line2.Crc = 1;
            return;
        }
        index[0] = index[0] + 1;
        Temp2 = this.Ser2Par(BitStream, index, 13);
        Line2.Sfs[0].Ppos = Temp2 / 90 / 9;
        Line2.Sfs[1].Ppos = Temp2 / 90 % 9;
        Line2.Sfs[2].Ppos = Temp2 % 90 / 9;
        Line2.Sfs[3].Ppos = Temp2 % 90 % 9;
        Line2.Sfs[0].Ppos = (Line2.Sfs[0].Ppos << 16) + this.Ser2Par(BitStream, index, 16);
        Line2.Sfs[1].Ppos = (Line2.Sfs[1].Ppos << 14) + this.Ser2Par(BitStream, index, 14);
        Line2.Sfs[2].Ppos = (Line2.Sfs[2].Ppos << 16) + this.Ser2Par(BitStream, index, 16);
        Line2.Sfs[3].Ppos = (Line2.Sfs[3].Ppos << 14) + this.Ser2Par(BitStream, index, 14);
        Line2.Sfs[0].Pamp = (short)this.Ser2Par(BitStream, index, 6);
        Line2.Sfs[1].Pamp = (short)this.Ser2Par(BitStream, index, 5);
        Line2.Sfs[2].Pamp = (short)this.Ser2Par(BitStream, index, 6);
        Line2.Sfs[3].Pamp = (short)this.Ser2Par(BitStream, index, 5);
    }

    private final int Ser2Par(int[] Pnt, int[] idxPnt, int Count) {
        int Rez = 0;
        int index = idxPnt[0];
        int i2 = 0;
        while (i2 < Count) {
            Rez += Pnt[index++] << i2;
            ++i2;
        }
        idxPnt[0] = index;
        return Rez;
    }

    private final void Gen_Trn(float[] DstBuf, float[] SrcBuf, int index, int period) {
        float[] TmpBuf = this.Gen_Trn_TmpBuf;
        int k2 = period;
        System.arraycopy(SrcBuf, index, TmpBuf, 0, 60);
        System.arraycopy(SrcBuf, index, DstBuf, index, 60);
        k2 = period;
        while (k2 < 60) {
            int i2 = k2;
            while (i2 < 60) {
                int n2 = i2 + index;
                DstBuf[n2] = DstBuf[n2] + TmpBuf[i2 - k2];
                ++i2;
            }
            k2 += period;
        }
    }

    private final void Get_Rez(float[] ResBuf, float[] PrevExc, int idxPrevExc, int Lag) {
        int j2;
        int idxTemp = idxPrevExc + 145 - Lag - 2 - 3;
        if (idxTemp >= 0) {
            ResBuf[0] = PrevExc[idxTemp];
            ResBuf[1] = PrevExc[idxTemp + 1];
            ResBuf[2] = PrevExc[idxTemp + 2];
        }
        ResBuf[3] = PrevExc[idxTemp + 3];
        ResBuf[4] = PrevExc[idxTemp + 4];
        int MaxHarm = 61 / Lag;
        int index = 5;
        idxTemp = idxPrevExc + 145 - Lag;
        int loopEnd = idxTemp + Lag;
        int i2 = 0;
        while (i2 < MaxHarm) {
            j2 = idxTemp;
            while (j2 < loopEnd) {
                ResBuf[index] = PrevExc[j2];
                ++j2;
                ++index;
            }
            ++i2;
        }
        int size = 62 - index + 2 + 3;
        idxTemp = idxPrevExc + 145 - Lag;
        loopEnd = idxTemp + size;
        j2 = idxTemp;
        while (j2 < loopEnd) {
            ResBuf[index] = PrevExc[j2];
            ++j2;
            ++index;
        }
    }

    private final void Decod_Acbk(float[] CurExc, float[] PrevExc, int idxPrevExc, int pitch, int Lid, int Gid, int WrkRate) {
        float[] RezBuf = this.Decod_Acbk_RezBuf;
        int idxsPnt = 0;
        int idxRezBufPointer = 3;
        this.Get_Rez(RezBuf, PrevExc, idxPrevExc, pitch - 1 + Lid);
        float[] RezBufPointer = RezBuf;
        int i2 = 0;
        if (this.decoderData.WrkRate == 0) {
            if (pitch >= 58) {
                i2 = 1;
            }
        } else {
            i2 = 1;
        }
        float[] sPnt = AcbkGainTablePtr[i2];
        float sPnt0 = sPnt[(idxsPnt += Gid * 20) + 0];
        float sPnt1 = sPnt[idxsPnt + 1];
        float sPnt2 = sPnt[idxsPnt + 2];
        float sPnt3 = sPnt[idxsPnt + 3];
        float sPnt4 = sPnt[idxsPnt + 4];
        i2 = 0;
        while (i2 < 60) {
            CurExc[i2] = RezBufPointer[i2 + 3 + 0] * sPnt0 + RezBufPointer[i2 + 3 + 1] * sPnt1 + RezBufPointer[i2 + 3 + 2] * sPnt2 + RezBufPointer[i2 + 3 + 3] * sPnt3 + RezBufPointer[i2 + 3 + 4] * sPnt4;
            ++i2;
        }
    }

    private final void Lsp_Inq(float[] Lsp, float[] PrevLsp, int packed_indexes, int packet_loss) {
        int j2;
        float prediction_gain;
        float stability_band;
        if (packet_loss == 0) {
            stability_band = 2.0f;
            prediction_gain = 0.375f;
        } else {
            packed_indexes = 0;
            stability_band = 4.0f;
            prediction_gain = 0.71875f;
        }
        int i2 = 2;
        while (i2 >= 0) {
            int index = packed_indexes & 0xFF;
            packed_indexes >>= 8;
            float[] LspQntPnt = fBandQntTable[i2];
            j2 = 0;
            while (j2 < fBandInfoTable[i2][1]) {
                Lsp[G723Dec.fBandInfoTable[i2][0] + j2] = LspQntPnt[index * fBandInfoTable[i2][1] + j2];
                ++j2;
            }
            --i2;
        }
        j2 = 0;
        while (j2 < 10) {
            int n2 = j2;
            Lsp[n2] = Lsp[n2] + (PrevLsp[j2] - fLspDcTable[j2]) * prediction_gain;
            int n3 = j2;
            Lsp[n3] = Lsp[n3] + fLspDcTable[j2];
            ++j2;
        }
        i2 = 0;
        while (i2 < 10) {
            if (Lsp[0] < 3.0f) {
                Lsp[0] = 3.0f;
            }
            if (Lsp[9] > 252.0f) {
                Lsp[9] = 252.0f;
            }
            j2 = 1;
            while (j2 < 10) {
                float bandwidth = stability_band + Lsp[j2 - 1] - Lsp[j2];
                if (bandwidth > 0.0f) {
                    int n4 = j2 - 1;
                    Lsp[n4] = Lsp[n4] - (bandwidth *= 0.5f);
                    int n5 = j2;
                    Lsp[n5] = Lsp[n5] + bandwidth;
                }
                ++j2;
            }
            boolean stability_test = false;
            j2 = 1;
            while (j2 < 10) {
                if ((double)(Lsp[j2] - Lsp[j2 - 1]) < (double)stability_band - 0.03125) {
                    stability_test = true;
                }
                ++j2;
            }
            if (!stability_test) break;
            ++i2;
        }
    }

    private final void Lsp_Int(float[] QntLpc, float[] CurrLsp, float[] PrevLsp) {
        int i2 = 0;
        while (i2 < 4) {
            float weight1 = (float)(3 - i2) * 0.25f;
            float weight2 = 1.0f - weight1;
            int j2 = 0;
            while (j2 < 10) {
                this.lspParamLsp[j2] = weight1 * PrevLsp[j2] + weight2 * CurrLsp[j2];
                ++j2;
            }
            this.LsptoA();
            System.arraycopy(this.lspParamLsp, 0, QntLpc, 10 * i2, 10);
            ++i2;
        }
        System.arraycopy(CurrLsp, 0, PrevLsp, 0, 10);
    }

    private final void LsptoA() {
        int j2;
        float[] P = this.lspArrayP;
        float[] Q = this.lspArrayQ;
        float[] Lsp = this.lspParamLsp;
        int i2 = 0;
        while (i2 < 10) {
            j2 = (int)Lsp[i2];
            float cos1 = CosFunction[j2];
            float cos2 = CosFunction[j2 + 1];
            Lsp[i2] = ((Lsp[i2] - (float)j2) * cos2 + ((float)(j2 + 1) - Lsp[i2]) * cos1) * -2.0f;
            ++i2;
        }
        P[0] = 1.0f;
        P[1] = Lsp[0] + Lsp[2];
        P[2] = 2.0f + Lsp[0] * Lsp[2];
        Q[0] = 1.0f;
        Q[1] = Lsp[1] + Lsp[3];
        Q[2] = 2.0f + Lsp[1] * Lsp[3];
        i2 = 2;
        while (i2 < 5) {
            P[i2 + 1] = Lsp[2 * i2 + 0] * P[i2] + 2.0f * P[i2 - 1];
            Q[i2 + 1] = Lsp[2 * i2 + 1] * Q[i2] + 2.0f * Q[i2 - 1];
            j2 = i2;
            while (j2 >= 2) {
                int n2 = j2;
                P[n2] = P[n2] + (Lsp[2 * i2 + 0] * P[j2 - 1] + P[j2 - 2]);
                int n3 = j2;
                Q[n3] = Q[n3] + (Lsp[2 * i2 + 1] * Q[j2 - 1] + Q[j2 - 2]);
                --j2;
            }
            P[1] = P[1] + Lsp[2 * i2 + 0];
            Q[1] = Q[1] + Lsp[2 * i2 + 1];
            ++i2;
        }
        i2 = 0;
        while (i2 < 5) {
            Lsp[i2] = -(P[i2] + P[i2 + 1] - Q[i2] + Q[i2 + 1]) * 0.5f;
            Lsp[9 - i2] = -(P[i2] + P[i2 + 1] + Q[i2] - Q[i2 + 1]) * 0.5f;
            ++i2;
        }
    }
}

