/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Node;
import bsh.ParserTreeConstants;
import bsh.Token;

class SimpleNode
implements Node {
    public static SimpleNode JAVACODE = new SimpleNode(-1){

        public String getSourceFile() {
            return "<Called from Java Code>";
        }

        public int getLineNumber() {
            return -1;
        }

        public String getText() {
            return "<Compiled Java Code>";
        }
    };
    protected Node parent;
    protected Node[] children;
    protected int id;
    Token firstToken;
    Token lastToken;
    String sourceFile;

    public SimpleNode(int n2) {
        this.id = n2;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n2) {
        if (this.children == null) {
            this.children = new Node[n2 + 1];
        } else if (n2 >= this.children.length) {
            Node[] nodeArray = new Node[n2 + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n2] = node;
    }

    public Node jjtGetChild(int n2) {
        return this.children[n2];
    }

    public SimpleNode getChild(int n2) {
        return (SimpleNode)this.jjtGetChild(n2);
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n2 = 0;
            while (n2 < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n2];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n2;
            }
        }
    }

    public void prune() {
        this.jjtSetParent(null);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        throw new InterpreterError("Unimplemented or inappropriate for " + this.getClass().getName());
    }

    public void setSourceFile(String string) {
        this.sourceFile = string;
    }

    public String getSourceFile() {
        if (this.sourceFile == null) {
            if (this.parent != null) {
                return ((SimpleNode)this.parent).getSourceFile();
            }
            return "<unknown file>";
        }
        return this.sourceFile;
    }

    public int getLineNumber() {
        return this.firstToken.beginLine;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        Token token = this.firstToken;
        while (token != null) {
            stringBuffer.append(token.image);
            if (!token.image.equals(".")) {
                stringBuffer.append(" ");
            }
            if (token == this.lastToken || token.image.equals("{") || token.image.equals(";")) break;
            token = token.next;
        }
        return stringBuffer.toString();
    }
}

