/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.ReflectManager;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Reflect {
    Reflect() {
    }

    public static Object invokeObjectMethod(Object object, String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws ReflectError, EvalError, InvocationTargetException {
        if (object instanceof This && !This.isExposedThisMethod(string)) {
            return ((This)object).invokeMethod(string, objectArray, interpreter, callStack, simpleNode, false);
        }
        try {
            BshClassManager bshClassManager = interpreter == null ? null : interpreter.getClassManager();
            Class<?> clazz = object.getClass();
            Method method = Reflect.resolveExpectedJavaMethod(bshClassManager, clazz, object, string, objectArray, false);
            return Reflect.invokeMethod(method, object, objectArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(simpleNode, callStack);
        }
    }

    public static Object invokeStaticMethod(BshClassManager bshClassManager, Class clazz, String string, Object[] objectArray) throws ReflectError, UtilEvalError, InvocationTargetException {
        Interpreter.debug("invoke static Method");
        Method method = Reflect.resolveExpectedJavaMethod(bshClassManager, clazz, null, string, objectArray, true);
        return Reflect.invokeMethod(method, null, objectArray);
    }

    static Object invokeMethod(Method method, Object object, Object[] objectArray) throws ReflectError, InvocationTargetException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Reflect.logInvokeMethod("Invoking method (entry): ", method, objectArray);
        Object[] objectArray2 = new Object[objectArray.length];
        Class<?>[] classArray = method.getParameterTypes();
        try {
            int n2 = 0;
            while (n2 < objectArray.length) {
                objectArray2[n2] = Types.castObject(objectArray[n2], classArray[n2], 1);
                ++n2;
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("illegal argument type in method invocation: " + utilEvalError);
        }
        objectArray2 = Primitive.unwrap(objectArray2);
        Reflect.logInvokeMethod("Invoking method (after massaging values): ", method, objectArray2);
        try {
            Object object2 = method.invoke(object, objectArray2);
            if (object2 == null) {
                object2 = Primitive.NULL;
            }
            Class<?> clazz = method.getReturnType();
            return Primitive.wrap(object2, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Cannot access method " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " in '" + method.getDeclaringClass() + "' :" + illegalAccessException);
        }
    }

    public static Object getIndex(Object object, int n2) throws ReflectError, UtilTargetError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("getIndex: " + object + ", index=" + n2);
        }
        try {
            Object object2 = Array.get(object, n2);
            return Primitive.wrap(object2, object.getClass().getComponentType());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new UtilTargetError(arrayIndexOutOfBoundsException);
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static void setIndex(Object object, int n2, Object object2) throws ReflectError, UtilTargetError {
        try {
            object2 = Primitive.unwrap(object2);
            Array.set(object, n2, object2);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new UtilTargetError(arrayStoreException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UtilTargetError(new ArrayStoreException(illegalArgumentException.toString()));
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static Object getStaticFieldValue(Class clazz, String string) throws UtilEvalError, ReflectError {
        return Reflect.getFieldValue(clazz, null, string, true);
    }

    public static Object getObjectFieldValue(Object object, String string) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            return ((This)object).namespace.getVariable(string);
        }
        try {
            return Reflect.getFieldValue(object.getClass(), object, string, false);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertyGetter(object.getClass(), string)) {
                return Reflect.getObjectProperty(object, string);
            }
            throw reflectError;
        }
    }

    static LHS getLHSStaticField(Class clazz, String string) throws UtilEvalError, ReflectError {
        Field field = Reflect.resolveExpectedJavaField(clazz, string, true);
        return new LHS(field);
    }

    static LHS getLHSObjectField(Object object, String string) throws UtilEvalError, ReflectError {
        if (object instanceof This) {
            boolean bl = false;
            return new LHS(((This)object).namespace, string, bl);
        }
        try {
            Field field = Reflect.resolveExpectedJavaField(object.getClass(), string, false);
            return new LHS(object, field);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertySetter(object.getClass(), string)) {
                return new LHS(object, string);
            }
            throw reflectError;
        }
    }

    private static Object getFieldValue(Class clazz, Object object, String string, boolean bl) throws UtilEvalError, ReflectError {
        try {
            Field field = Reflect.resolveExpectedJavaField(clazz, string, bl);
            Object object2 = field.get(object);
            Class<?> clazz2 = field.getType();
            return Primitive.wrap(object2, clazz2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ReflectError("???" + string + " is not a static field.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Can't access field: " + string);
        }
    }

    protected static Field resolveJavaField(Class clazz, String string, boolean bl) throws UtilEvalError {
        try {
            return Reflect.resolveExpectedJavaField(clazz, string, bl);
        }
        catch (ReflectError reflectError) {
            return null;
        }
    }

    protected static Field resolveExpectedJavaField(Class clazz, String string, boolean bl) throws UtilEvalError, ReflectError {
        Field field;
        try {
            field = Capabilities.haveAccessibility() ? Reflect.findAccessibleField(clazz, string) : clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectError("No such field: " + string);
        }
        catch (SecurityException securityException) {
            throw new UtilTargetError("Security Exception while searching fields of: " + clazz, securityException);
        }
        if (bl && !Modifier.isStatic(field.getModifiers())) {
            throw new UtilEvalError("Can't reach instance field: " + string + " from static context: " + clazz.getName());
        }
        return field;
    }

    /*
     * Unable to fully structure code
     */
    private static Field findAccessibleField(Class var0, String var1_1) throws UtilEvalError, NoSuchFieldException {
        try {
            var2_2 = var0.getField(var1_1);
            ReflectManager.RMSetAccessible(var2_2);
            return var2_2;
        }
        catch (NoSuchFieldException var3_4) {
            ** while (var0 != null)
        }
lbl-1000:
        // 1 sources

        {
            try {
                var2_3 = var0.getDeclaredField(var1_1);
                ReflectManager.RMSetAccessible(var2_3);
                return var2_3;
            }
            catch (NoSuchFieldException var3_5) {
                var0 = var0.getSuperclass();
            }
            continue;
        }
lbl16:
        // 1 sources

        throw new NoSuchFieldException(var1_1);
    }

    protected static Method resolveExpectedJavaMethod(BshClassManager bshClassManager, Class clazz, Object object, String string, Object[] objectArray, boolean bl) throws ReflectError, UtilEvalError {
        if (object == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Attempt to invoke method " + string + " on null value"));
        }
        Class[] classArray = Types.getTypes(objectArray);
        Method method = Reflect.resolveJavaMethod(bshClassManager, clazz, string, classArray, bl);
        if (method == null) {
            throw new ReflectError((bl ? "Static method " : "Method ") + StringUtil.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
        }
        return method;
    }

    protected static Method resolveJavaMethod(BshClassManager bshClassManager, Class clazz, String string, Class[] classArray, boolean bl) throws UtilEvalError {
        if (clazz == null) {
            throw new InterpreterError("null class");
        }
        Method method = null;
        if (bshClassManager == null) {
            Interpreter.debug("resolveJavaMethod UNOPTIMIZED lookup");
        } else {
            method = bshClassManager.getResolvedMethod(clazz, string, classArray, bl);
        }
        if (method == null) {
            boolean bl2 = !Capabilities.haveAccessibility();
            try {
                method = Reflect.findOverloadedMethod(clazz, string, classArray, bl2);
            }
            catch (SecurityException securityException) {
                throw new UtilTargetError("Security Exception while searching methods of: " + clazz, securityException);
            }
            Reflect.checkFoundStaticMethod(method, bl, clazz);
            if (method != null && !bl2) {
                try {
                    ReflectManager.RMSetAccessible(method);
                }
                catch (UtilEvalError utilEvalError) {
                    // empty catch block
                }
            }
            if (method != null && bshClassManager != null) {
                bshClassManager.cacheResolvedMethod(clazz, classArray, method);
            }
        }
        return method;
    }

    private static Method findOverloadedMethod(Class clazz, String string, Class[] classArray, boolean bl) {
        if (Interpreter.DEBUG) {
            Interpreter.debug("Searching for method: " + StringUtil.methodString(string, classArray) + " in '" + clazz.getName() + "'");
        }
        Method[] methodArray = Reflect.getCandidateMethods(clazz, string, classArray.length, bl);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific method: " + string);
        }
        Method method = Reflect.findMostSpecificMethod(classArray, methodArray);
        return method;
    }

    static Method[] getCandidateMethods(Class clazz, String string, int n2, boolean bl) {
        Vector vector = Reflect.gatherMethodsRecursive(clazz, string, n2, bl, null);
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static Vector gatherMethodsRecursive(Class clazz, String string, int n2, boolean bl, Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        if (bl) {
            if (Reflect.isPublic(clazz)) {
                Reflect.addCandidates(clazz.getMethods(), string, n2, bl, vector);
            }
        } else {
            Reflect.addCandidates(clazz.getDeclaredMethods(), string, n2, bl, vector);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n3 = 0;
        while (n3 < classArray.length) {
            Reflect.gatherMethodsRecursive(classArray[n3], string, n2, bl, vector);
            ++n3;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Reflect.gatherMethodsRecursive(clazz2, string, n2, bl, vector);
        }
        return vector;
    }

    private static Vector addCandidates(Method[] methodArray, String string, int n2, boolean bl, Vector vector) {
        int n3 = 0;
        while (n3 < methodArray.length) {
            Method method = methodArray[n3];
            if (method.getName().equals(string) && method.getParameterTypes().length == n2 && (!bl || Reflect.isPublic(method))) {
                vector.add(method);
            }
            ++n3;
        }
        return vector;
    }

    static Object constructObject(Class clazz, Object[] objectArray) throws ReflectError, InvocationTargetException {
        Constructor[] constructorArray;
        if (clazz.isInterface()) {
            throw new ReflectError("Can't create instance of an interface: " + clazz);
        }
        Object var2_2 = null;
        Class[] classArray = Types.getTypes(objectArray);
        Constructor constructor = null;
        Constructor[] constructorArray2 = constructorArray = Capabilities.haveAccessibility() ? clazz.getDeclaredConstructors() : clazz.getConstructors();
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific constructor: " + clazz);
        }
        if ((constructor = Reflect.findMostSpecificConstructor(classArray, constructorArray)) == null) {
            throw Reflect.cantFindConstructor(clazz, classArray);
        }
        if (!Reflect.isPublic(constructor)) {
            try {
                ReflectManager.RMSetAccessible(constructor);
            }
            catch (UtilEvalError utilEvalError) {
                // empty catch block
            }
        }
        objectArray = Primitive.unwrap(objectArray);
        try {
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectError("The class " + clazz + " is abstract ");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("We don't have permission to create an instance.Use setAccessibility(true) to enable access.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectError("The number of arguments was wrong");
        }
        if (var2_2 == null) {
            throw new ReflectError("Couldn't construct the object");
        }
        return var2_2;
    }

    static Constructor findMostSpecificConstructor(Class[] classArray, Constructor[] constructorArray) {
        int n2 = Reflect.findMostSpecificConstructorIndex(classArray, constructorArray);
        return n2 == -1 ? null : constructorArray[n2];
    }

    static int findMostSpecificConstructorIndex(Class[] classArray, Constructor[] constructorArray) {
        Class[][] classArray2 = new Class[constructorArray.length][];
        int n2 = 0;
        while (n2 < classArray2.length) {
            classArray2[n2] = constructorArray[n2].getParameterTypes();
            ++n2;
        }
        return Reflect.findMostSpecificSignature(classArray, classArray2);
    }

    static Method findMostSpecificMethod(Class[] classArray, Method[] methodArray) {
        Class[][] classArray2 = new Class[methodArray.length][];
        int n2 = 0;
        while (n2 < methodArray.length) {
            classArray2[n2] = methodArray[n2].getParameterTypes();
            ++n2;
        }
        int n3 = Reflect.findMostSpecificSignature(classArray, classArray2);
        return n3 == -1 ? null : methodArray[n3];
    }

    static int findMostSpecificSignature(Class[] classArray, Class[][] classArray2) {
        int n2 = 1;
        while (n2 <= 4) {
            Class[] classArray3 = null;
            int n3 = -1;
            int n4 = 0;
            while (n4 < classArray2.length) {
                Class[] classArray4 = classArray2[n4];
                if (Types.isSignatureAssignable(classArray, classArray4, n2) && (classArray3 == null || Types.isSignatureAssignable(classArray4, classArray3, 1))) {
                    classArray3 = classArray4;
                    n3 = n4;
                }
                ++n4;
            }
            if (classArray3 != null) {
                return n3;
            }
            ++n2;
        }
        return -1;
    }

    private static String accessorName(String string, String string2) {
        return string + String.valueOf(Character.toUpperCase(string2.charAt(0))) + string2.substring(1);
    }

    public static boolean hasObjectPropertyGetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("get", string);
        try {
            clazz.getMethod(string2, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string2 = Reflect.accessorName("is", string);
            try {
                Method method = clazz.getMethod(string2, new Class[0]);
                return method.getReturnType() == Boolean.TYPE;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return false;
            }
        }
    }

    public static boolean hasObjectPropertySetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("set", string);
        Method[] methodArray = clazz.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (methodArray[n2].getName().equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Object getObjectProperty(Object object, String string) throws UtilEvalError, ReflectError {
        String string2;
        Object[] objectArray = new Object[]{};
        Interpreter.debug("property access: ");
        Method method = null;
        Exception exception = null;
        Exception exception2 = null;
        try {
            string2 = Reflect.accessorName("get", string);
            method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string2, objectArray, false);
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        if (method == null) {
            try {
                string2 = Reflect.accessorName("is", string);
                method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string2, objectArray, false);
                if (method.getReturnType() != Boolean.TYPE) {
                    method = null;
                }
            }
            catch (Exception exception4) {
                exception2 = exception4;
            }
        }
        if (method == null) {
            throw new ReflectError("Error in property getter: " + exception + (exception2 != null ? " : " + exception2 : ""));
        }
        try {
            return Reflect.invokeMethod(method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static void setObjectProperty(Object object, String string, Object object2) throws ReflectError, UtilEvalError {
        String string2 = Reflect.accessorName("set", string);
        Object[] objectArray = new Object[]{object2};
        Interpreter.debug("property access: ");
        try {
            Method method = Reflect.resolveExpectedJavaMethod(null, object.getClass(), object, string2, objectArray, false);
            Reflect.invokeMethod(method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static String normalizeClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(Reflect.getArrayBaseType(clazz).getName() + " ");
            int n2 = 0;
            while (n2 < Reflect.getArrayDimensions(clazz)) {
                stringBuffer.append("[]");
                ++n2;
            }
        }
        catch (ReflectError reflectError) {}
        return stringBuffer.toString();
    }

    public static int getArrayDimensions(Class clazz) {
        if (!clazz.isArray()) {
            return 0;
        }
        return clazz.getName().lastIndexOf(91) + 1;
    }

    public static Class getArrayBaseType(Class clazz) throws ReflectError {
        if (!clazz.isArray()) {
            throw new ReflectError("The class is not an array.");
        }
        return clazz.getComponentType();
    }

    public static Object invokeCompiledCommand(Class clazz, Object[] objectArray, Interpreter interpreter, CallStack callStack) throws UtilEvalError {
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = interpreter;
        objectArray2[1] = callStack;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        BshClassManager bshClassManager = interpreter.getClassManager();
        try {
            return Reflect.invokeStaticMethod(bshClassManager, clazz, "invoke", objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Error in compiled command: " + invocationTargetException.getTargetException());
        }
        catch (ReflectError reflectError) {
            throw new UtilEvalError("Error invoking compiled command: " + reflectError);
        }
    }

    private static void logInvokeMethod(String string, Method method, Object[] objectArray) {
        if (Interpreter.DEBUG) {
            Interpreter.debug(string + method + " with args:");
            int n2 = 0;
            while (n2 < objectArray.length) {
                Interpreter.debug("args[" + n2 + "] = " + objectArray[n2] + " type = " + objectArray[n2].getClass());
                ++n2;
            }
        }
    }

    private static void checkFoundStaticMethod(Method method, boolean bl, Class clazz) throws UtilEvalError {
        if (method != null && bl && !Reflect.isStatic(method)) {
            throw new UtilEvalError("Cannot reach instance method: " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " from static context: " + clazz.getName());
        }
    }

    private static ReflectError cantFindConstructor(Class clazz, Class[] classArray) {
        if (classArray.length == 0) {
            return new ReflectError("Can't find default constructor for: " + clazz);
        }
        return new ReflectError("Can't find constructor: " + StringUtil.methodString(clazz.getName(), classArray) + " in class: " + clazz.getName());
    }

    private static boolean isPublic(Class clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    private static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static boolean isPublic(Constructor constructor) {
        return Modifier.isPublic(constructor.getModifiers());
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }
}

