; specify the cell library with the pads
celllibrary pads4u.jelib

; create a cell called "padframe"
cell padframe
views lay

; place cell "tool-PadFrame" in the center (it is the "core" cell)
core tool-PadFrame

; set the alignment of the pads (specifying input and output port names)
align PAD_in          dvddL dvddR
align PAD_out         dvddL dvddR
align PAD_io          dvddL dvddR
align PAD_vdd         dvddL dvddR
align PAD_gnd         dvddL dvddR
align PAD_dvdd        dvddL dvddR
align PAD_dgnd        dvddL dvddR
align PAD_flwout      dvddL dvddR
align PAD_corner      dvddL dvddR
align PAD_halfSpacer  dvddL dvddR
align PAD_spacer      dvddL dvddR
align PAD_raw         dvddL dvddR

; place the top edge of pads, starting with upper-left
place PAD_corner
place PAD_gnd gnd_in=gnd
place PAD_vdd m1m2=vdd

; place the right edge of pads, going down
rotate c
place PAD_corner
place PAD_in out=pulse export in=probePulse
place PAD_spacer

; place the bottom edge of pads, going left
rotate c
place PAD_corner
place PAD_out in=out1 export outbar=probeOut1
place PAD_out in=out2 export outbar=probeOut2

; place the left edge of pads, going up
rotate c
place PAD_corner
place PAD_in out=in1 export in=probeIn1
place PAD_in out=in2 export in=probeIn2
